/* Miscellaneous functions for bounds checking.
   Written by Richard W.M. Jones <rjones@orchestream.com>.
   Copyright (C) 1995 Richard W.M. Jones.

This file is part of the bounds checking patches for GNU CC. The main
body of code used at run time can be found in the `bounds/' subdirectory.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* [RWMJ] <- this identifier ensures this file gets packed by my script. */

#ifndef _C_BOUNDS_H
#define _C_BOUNDS_H

void	bounds_external_declaration PROTO((tree, int));
void	bounds_build_static_constructors PROTO((void));
void	bounds_frig_decl_initial PROTO((tree));
void	bounds_expand_decl_cleanup PROTO((tree));
tree	bounds_cancel_address_expr PROTO((tree));
tree	bounds_build_reference PROTO((tree));
tree	bounds_build_array_reference PROTO((tree, tree));
int	bounds_can_test_array_reference_now PROTO((tree, tree));
tree	bounds_build_ptr_plus_int PROTO((enum tree_code, tree, tree, tree));
tree	bounds_build_ptr_diff PROTO((tree, tree, tree));
tree	bounds_build_comparison PROTO((enum tree_code, tree, tree, tree));
tree	bounds_build_inc_or_dec PROTO((enum tree_code, tree, tree, tree));
tree	bounds_build_invert_truthvalue PROTO((tree));
tree	bounds_build_truthvalue_conversion PROTO((tree));
tree	bounds_build_component_indirect_ref PROTO((tree, tree));
void	bounds_build_args PROTO((void));
void	bounds_delete_redundant_calls PROTO((tree));
int	bounds_is_deletable_fn_p PROTO((char *));
void    bounds_note_call_for_deletion PROTO((rtx, rtx, char *, tree));
void	bounds_convert_funcname PROTO((tree *function, tree *params));

extern int bounds_checking_enabled;
extern int bounds_disable_field_check;
extern int bounds_in_static_decl;

#endif /* _C_BOUNDS_H */
