/* scanf.c (emx+gcc) */

/* As this program tests a lot of borderline cases and cases of
   `undefined behavior' of scanf(), GCC displays many warning
   messages.  Ignore them. */

#include <stdio.h>
#include <string.h>


int main (void)
{
  int r, n1, n2, n3;
  int i1, i2;
  char c1, c2, s1[100];
  double d1;

  r = sscanf ("", "");
  printf ("%d\n", r);

  r = sscanf ("a", "");
  printf ("%d\n", r);

  r = sscanf ("", "a");
  printf ("%d\n", r);

  r = sscanf ("a", "b");
  printf ("%d\n", r);

  n1 = n2 = n3 = 42;
  r = sscanf ("a%b", "%na%n%%b%n", &n1, &n2, &n3);
  printf ("%d %d %d %d\n", r, n1, n2, n3);

  n1 = n2 = 42;
  r = sscanf ("ab", "a%nc%n", &n1, &n2);
  printf ("%d %d %d\n", r, n1, n2);

  i1 = n1 = 42;
  r = sscanf ("0", "%d%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0x", "%dx%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0", "%i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("08", "%i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("07", "%i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0x", "%i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0xz", "%i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0xa", "%i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0xabcdefghij", "%i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0x12", "%d%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("099", "%x%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0x", "%x%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0x9a", "%x%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("ab", "%d%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = i2 = n1 = n2 = 42;
  r = sscanf ("1 2", "%d%n%d%n", &i1, &n1, &i2, &n2);
  printf ("%d %d %d %d %d\n", r, i1, n1, i2, n2);

  i1 = i2 = n1 = n2 = 42;
  r = sscanf ("1 2", "%d%n  %d%n", &i1, &n1, &i2, &n2);
  printf ("%d %d %d %d %d\n", r, i1, n1, i2, n2);

  i1 = i2 = n1 = n2 = 42;
  r = sscanf ("1 2", " %d %n %d %n ", &i1, &n1, &i2, &n2);
  printf ("%d %d %d %d %d\n", r, i1, n1, i2, n2);

  i1 = n1 = 42;
  r = sscanf ("0x123", "%6i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0x123", "%5i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0x123", "%4i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0x123", "%3i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0x123", "%2i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = n1 = 42;
  r = sscanf ("0x123", "%1i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  /* Note: zero field width is not allowed by ANSI X3.159-1989. */

  i1 = n1 = 42;
  r = sscanf ("0x123", "%0i%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  i1 = i2 = n1 = n2 = 42;
  r = sscanf ("17", "%d%n%d%n", &i1, &n1, &i2, &n2);
  printf ("%d %d %d %d %d\n", r, i1, n1, i2, n2);

  memset (s1, 0, sizeof (s1)); n1 = 42;
  r = sscanf (" abc", "%c%n", s1, &n1);
  printf ("%d |%s| %d\n", r, s1, n1);

  /* Note: zero field width is not allowed by ANSI X3.159-1989. */

  memset (s1, 0, sizeof (s1)); n1 = 42;
  r = sscanf (" abc", "%0c%n", s1, &n1);
  printf ("%d |%s| %d\n", r, s1, n1);

  memset (s1, 0, sizeof (s1)); n1 = 42;
  r = sscanf (" abc", "%4c%n", s1, &n1);
  printf ("%d |%s| %d\n", r, s1, n1);

  memset (s1, 0, sizeof (s1)); n1 = 42;
  r = sscanf (" abc", "%5c%n", s1, &n1);
  printf ("%d |%s| %d\n", r, s1, n1);

  memset (s1, 0, sizeof (s1)); n1 = 42;
  r = sscanf ("", "%c%n", s1, &n1);
  printf ("%d |%s| %d\n", r, s1, n1);

  memset (s1, 0, sizeof (s1)); n1 = 42;
  r = sscanf ("  abc  ", "%s%n", s1, &n1);
  printf ("%d |%s| %d\n", r, s1, n1);

  memset (s1, 0, sizeof (s1)); n1 = 42;
  r = sscanf ("  abc  x", "%[^x]%n", s1, &n1);
  printf ("%d |%s| %d\n", r, s1, n1);

  memset (s1, 0, sizeof (s1)); n1 = 42;
  r = sscanf ("  abc x", "%s%c%c%n", s1, &c1, &c2, &n1);
  printf ("%d |%s|%c|%c| %d\n", r, s1, c1, c2, n1);

  d1 = 42.0; n1 = 42;
  r = sscanf ("12.5e3", "%lf%n", &d1, &n1);
  printf ("%d %1.5e %d\n", r, d1, n1);

  d1 = 42.0; n1 = 42;
  r = sscanf ("12.5e", "%lf%n", &d1, &n1);
  printf ("%d %1.5e %d\n", r, d1, n1);

  i1 = n1 = 42;
  r = sscanf ("  ", "%d%n", &i1, &n1);
  printf ("%d %d %d\n", r, i1, n1);

  n1 = 42;
  r = sscanf ("", " %n", &n1);
  printf ("%d %d\n", r, n1);

  n1 = 42;
  r = sscanf ("  x", " %n", &n1);
  printf ("%d %d\n", r, n1);

  n1 = 42;
  r = sscanf ("  ", " %n", &n1);
  printf ("%d %d\n", r, n1);

  i1 = i2 = 42;
  r = sscanf ("16 17", "%*d%d", &i1, &i2);
  printf ("%d %d %d\n", r, i1, i2);

  strcpy (s1, "abc");
  r = sscanf ("xyz", "%c", s1);
  printf ("%d |%s|\n", r, s1);

  strcpy (s1, "abc");
  r = sscanf ("xyz", "%2c", s1);
  printf ("%d |%s|\n", r, s1);

  strcpy (s1, "abc");
  r = sscanf ("xy ", "%s", s1);
  printf ("%d |%s|\n", r, s1);

  strcpy (s1, "abc");
  r = sscanf ("xy ", "%1s", s1);
  printf ("%d |%s|\n", r, s1);

  i1 = 42;
  r = sscanf ("1", "%dA", &i1);
  printf ("%d %d\n", r, i1);

  memset (s1, 0, sizeof (s1)); n1 = 42;
  r = sscanf ("abcde", "%[a-d]%n", s1, &n1);
  printf ("%d |%s| %d\n", r, s1, n1);

  memset (s1, 0, sizeof (s1)); n1 = 42;
  r = sscanf ("edcba", "%[b-e]%n", s1, &n1);
  printf ("%d |%s| %d\n", r, s1, n1);

  d1 = 42.0; n1 = 42;
  r = sscanf ("inf", "%lf%n", &d1, &n1);
  printf ("%d %g %d\n", r, d1, n1);

  d1 = 42.0; n1 = 42;
  r = sscanf ("infx", "%lf%n", &d1, &n1);
  printf ("%d %g %d\n", r, d1, n1);

  d1 = 42.0; n1 = 42;
  r = sscanf ("-infinityx", "%lf%n", &d1, &n1);
  printf ("%d %g %d\n", r, d1, n1);

  d1 = 42.0; n1 = 42;
  r = sscanf ("infix", "%lf%n", &d1, &n1);
  printf ("%d %g %d\n", r, d1, n1);

  d1 = 42.0; n1 = 42;
  r = sscanf ("nan", "%lf%n", &d1, &n1);
  printf ("%d %g %d\n", r, d1, n1);

  d1 = 42.0; n1 = 42;
  r = sscanf ("nanx", "%lf%n", &d1, &n1);
  printf ("%d %g %d\n", r, d1, n1);

  d1 = 42.0; n1 = 42;
  r = sscanf ("nan(ab_3c)x", "%lf%n", &d1, &n1);
  printf ("%d %g %d\n", r, d1, n1);

  d1 = 42.0; n1 = 42;
  r = sscanf ("nan(/)x", "%lf%n", &d1, &n1);
  printf ("%d %g %d\n", r, d1, n1);

  d1 = 42.0; n1 = 42;
  r = sscanf ("nan(abc", "%lf%n", &d1, &n1);
  printf ("%d %g %d\n", r, d1, n1);

  strcpy (s1, "xxx"); n1 = 42; n2 = 42;
  r = sscanf ("17 abc", "%d %[^a]", &n1, s1, &n2);
  printf ("%d %d |%s| %d\n", r, n1, s1, n2);

  strcpy (s1, "xxx"); n1 = 42;
  r = sscanf ("A-A-BC", "%[-A]%n", s1, &n1);
  printf ("%d |%s| %d\n", r, s1, n1);

  strcpy (s1, "xxx"); n1 = 42;
  r = sscanf ("A-A-BC", "%[A-]%n", s1, &n1);
  printf ("%d |%s| %d\n", r, s1, n1);

  return 0;
}
