
TERMCAP(5)                 UNIX Programmer's Manual                 TERMCAP(5)

NNAAMMEE
     tteerrmmccaapp - terminal capability data base

SSYYNNOOPPSSIISS
     tteerrmmccaapp

DDEESSCCRRIIPPTTIIOONN
     The TTeerrmmccaapp file is a data base describing terminals, used, for example,
     by vi(1) and curses(3).  Terminals are described in tteerrmmccaapp by giving a
     set of capabilities that they have and by describing how operations are
     performed.  Padding requirements and initialization sequences are includ-
     ed in tteerrmmccaapp.

     Entries in tteerrmmccaapp consist of a number of `:'-separated fields.  The
     first entry for each terminal gives the names that are known for the ter-
     minal, separated by `|' characters.  The first name given is the most
     common abbreviation for the terminal.  The last name given should be a
     long name fully identifying the terminal, and all others are understood
     as synonyms for the terminal name.  All names but the last should be in
     lower case and contain no blanks; the last name may well contain upper
     case characters and blanks for readability.

     Terminal names (except for the last, verbose entry) should be chosen us-
     ing the following conventions.  The particular piece of hardware making
     up the terminal should have a root name chosen, thus ``hp2621'' This name
     should not contain hyphens.  Modes that the hardware can be in or user
     preferences should be indicated by appending a hyphen and an indicator of
     the mode.  Therefore, a ``vt100'' in 132-column mode would be
     ``vt100-w''. The following suffixes should be used where possible:

           SSuuffffiixx    MMeeaanniinngg                                       EExxaammppllee
           -w        Wide mode (more than 80 columns)              vt100-w
           -am       With automatic margins (usually default)      vt100-am
           -nam      Without automatic margins                     vt100-nam
           -_n        Number of lines on the
           -na       No arrow keys (leave them in local)           concept100-na
           -_n_p       Number of pages of memory                     concept100-4p
           -rv       Reverse video                                 concept100-rv

CCAAPPAABBIILLIITTIIEESS
     The characters in the The _N_o_t_e_s function field in the table have the fol-
     lowing meanings (more than one may apply to a capability):

           N    indicates numeric parameter(s)
           P    indicates that padding may be specified
           *    indicates that padding may be based on the number of lines affected
           o    indicates capability is obsolete

     ``Obsolete'' capabilities have no _t_e_r_m_i_n_f_o equivalents, since they were
     considered useless, or are subsumed by other capabilities.  New software
     should not rely on them at all.

     NNaammee      TTyyppee      NNootteess     DDeessccrriippttiioonn
     functions
     ae        str       (P)       End alternate character set.
     AL        str       (NP*)     Add" _n new blank lines
     al        str       (P*)      Add new blank line.
     am        bool                Terminal has automatic margins.
     as        str       (P)       Start alternate character set.
     bc        str       (o)       Backspace if not. ^^HH.


     bl        str       (P)       Audible signal (bell).
     bs        bool      (o)       Terminal can backspace with ^^HH.
     bt        str       (P)       Back tab.
     bw        bool                llee (backspace) wraps from column 0 to last
                                   column.
     CC        str                 Terminal settable command character in
                                   prototype.
     cd        str       (P*)      Clear to end of display.
     ce        str       (P)       Clear to end of line.
     ch        str       (NP)      Set cursor column (horizontal position).
     cl        str       (P*)      Clear screen and home cursor.
     CM        str       (NP)      Memory-relative cursor addressing.
     cm        str       (NP)      Screen-relative cursor motion.
     co        num                 Number of columns in a line (See _B_U_G_S sec-
                                   tion below).
     cr        str       (P)       Carriage return.
     cs        str       (NP)      Change scrolling region (VT100).
     ct        str       (P)       Clear all tab stops.
     cv        str       (NP)      Set cursor row (vertical position).
     da        bool                Display may be retained above the screen.
     dB        num       (o)       Milliseconds of bbss delay needed (default
                                   0).
     db        bool                Display may be retained below the screen.
     DC        str       (NP*)     Delete _n characters.
     dC        num       (o)       Milliseconds of ccrr delay needed (default
                                   0).
     dc        str       (P*)      Delete character.
     dF        num       (o)       Milliseconds of ffff delay needed (default
                                   0).
     DL        str       (NP*)     Delete _n lines.
     dl        str       (P*)      Delete line.
     dm        str                 Enter delete mode.
     dN        num       (o)       Milliseconds of nnll delay needed (default
                                   0).
     DO        str       (NP*)     Move cursor down: _n lines.
     do        str                 Down one line.
     ds        str                 Disable status line.
     dT        num       (o)       Milliseconds of horizontal tab delay needed
                                   (default 0).
     dV        num       (o)       Milliseconds of vertical tab delay needed
                                   (default 0).
     ec        str       (NP)      Erase _n characters.
     ed        str                 End delete mode.
     ei        str                 End insert mode.
     eo        bool                Can erase overstrikes with a blank.
     EP        bool      (o)       Even parity.
     es        bool                Escape can be used on the status line.
     ff        str       (P*)      Hardcopy terminal page eject.
     fs        str                 Return from status line.
     gn        bool                Generic line type, for example dialup,
                                   switch).
     hc        bool                Hardcopy terminal.
     HD        bool      (o)       Half-duplex.
     hd        str                 Half-line down (forward 1/2 linefeed).
     ho        str       (P)       Home cursor.
     hs        bool                Has extra ``status line''.
     hu        str                 Half-line up (reverse 1/2 linefeed).
     hz        bool                Cannot print ``~'' (Hazeltine).
     i1-i3     str                 Terminal initialization strings (terminfo
                                   only)
     IC        str       (NP*)     Insert _n blank characters.
     ic        str       (P*)      Insert character.
     if        str                 Name of file containing initialization
                                   string.


     im        str                 Enter insert mode.
     in        bool                Insert mode distinguishes nulls.
     iP        str                 Pathname of program for initialization
                                   (terminfo only).
     ip        str       (P*)      Insert pad after character inserted.
     is        str                 Terminal initialization string (tteerrmmccaapp on-
                                   ly).
     it        num                 Tabs initially every _n positions.
     K1        str                 Sent by keypad upper left.
     K2        str                 Sent by keypad upper right.
     K3        str                 Sent by keypad center.
     K4        str                 Sent by keypad lower left.
     K5        str                 Sent by keypad lower right.
     k0-k9     str                 Sent by function keys 0-9.
     kA        str                 Sent by insert-line key.
     ka        str                 Sent by clear-all-tabs key.
     kb        str                 Sent by backspace key.
     kC        str                 Sent by clear-screen or erase key.
     kD        str                 Sent by delete-character key.
     kd        str                 Sent by down-arrow key.
     kE        str                 Sent by clear-to-end-of-line key.
     ke        str                 Out of ``keypad transmit'' mode.
     kF        str                 Sent by scroll-forward/down key.
     kH        str                 Sent by home-down key.
     kh        str                 Sent by home key.
     kI        str                 Sent by insert-character or enter-insert-
                                   mode key.
     kL        str                 Sent by delete-line key.
     kl        str                 Sent by left-arrow key.
     kM        str                 Sent by insert key while in insert mode.
     km        bool                Has a ``meta'' key (shift, sets parity
                                   bit).
     kN        str                 Sent by next-page key.
     kn        num       (o)       Number of function (kk00- kk99) keys (default
                                   0).
     ko        str       (o)       Termcap entries for other non-function
                                   keys.
     kP        str                 Sent by previous-page key.
     kR        str                 Sent by scroll-backward/up key.
     kr        str                 Sent by right-arrow key.
     kS        str                 Sent by clear-to-end-of-screen key.
     ks        str                 Put terminal in ``keypad transmit'' mode.
     kT        str                 Sent by set-tab key.
     kt        str                 Sent by clear-tab key.
     ku        str                 Sent by up-arrow key.
     l0-l9     str                 Labels on function keys if not ``f_n''.
     LC        bool      (o)       Lower-case only.
     LE        str       (NP)      Move cursor left _n positions.
     le        str       (P)       Move cursor left one position.
     li        num                 Number of lines on screen or page (See _B_U_G_S
                                   section below)
     ll        str                 Last line, first column
     lm        num                 Lines of memory if > llii (0 means varies).
     ma        str       (o)       Arrow key map (used by vi version 2 only).
     mb        str                 Turn on blinking attribute.
     md        str                 Turn on bold (extra bright) attribute.
     me        str                 Turn off all attributes.
     mh        str                 Turn on half-bright attribute.
     mi        bool                Safe to move while in insert mode.
     mk        str                 Turn on blank attribute (characters
                                   invisible).
     ml        str       (o)       Memory lock on above cursor.
     mm        str                 Turn on ``meta mode'' (8th bit).
     mo        str                 Turn off ``meta mode''.


     mp        str                 Turn on protected attribute.
     mr        str                 Turn on reverse-video attibute.
     ms        bool                Safe to move in standout modes.
     mu        str       (o)       Memory unlock (turn off memory lock).
     nc        bool      (o)       No correctly-working ccrr (Datamedia 2500,
                                   Hazeltine 2000).
     nd        str                 Non-destructive space (cursor right).
     NL        bool      (o)       \\nn is newline, not line feed.
     nl        str       (o)       Newline character if not \\nn.
     ns        bool      (o)       Terminal is a CRT but doesn't scroll.
     nw        str       (P)       Newline (behaves like ccrr followed by ddoo ))..
     OP        bool      (o)       Odd parity.
     os        bool                Terminal overstrikes.
     pb        num                 Lowest baud where delays are required.
     pc        str                 Pad character (default NUL ).
     pf        str                 Turn off the printer.
     pk        str                 Program function key _n to type string _s
                                   (terminfo only).
     pl        str                 Program function key _n to execute string _s
                                   (terminfo only).
     pO        str       (N)       Turn on the printer for _n bytes.
     po        str                 Turn on the printer.
     ps        str                 Print contents of the screen.
     pt        bool      (o)       Has hardware tabs (may need to be set with
                                   iiss ))..
     px        str                 Program function key _n to transmit string _s
                                   (terminfo only).
     r1-r3     str                 Reset terminal completely to sane modes
                                   (terminfo only).
     rc        str       (P)       Restore cursor to position of last sscc.
     rf        str                 Name of file containing reset codes.
     RI        str       (NP)      Move cursor right _n positions.
     rp        str       (NP*)     Repeat character _c _n times.
     rs        str                 Reset terminal completely to sane modes
                                   (tteerrmmccaapp only).
     sa        str       (NP)      Define the video attributes.
     sc        str       (P)       Save cursor position.
     se        str                 End standout mode.
     SF        str       (NP*)     Scroll forward _n lines.
     sf        str       (P)       Scroll text up.
     sg        num                 Number of garbage chars left by ssoo or ssee
                                   (default 0).
     so        str                 Begin standout mode.
     SR        str       (NP*)     Scroll backward _n lines.
     sr        str       (P)       Scroll text down.
     st        str                 Set a tab in all rows, current column.
     ta        str       (P)       Tab to next 8-position hardware tab stop.
     tc        str                 Entry of similar terminal - must be last.
     te        str                 String to end programs that use tteerrmmccaapp.
     ti        str                 String to begin programs that use tteerrmmccaapp.
     ts        str       (N)       Go to status line, column _n.
     UC        bool      (o)       Upper-case only.
     uc        str                 Underscore one character and move past it.
     ue        str                 End underscore mode.
     ug        num                 Number of garbage chars left by uuss or uuee
                                   (default 0).
     ul        bool                Underline character overstrikes.
     UP        str       (NP*)     Move cursor up _n lines.
     up        str                 Upline (cursor up).
     us        str                 Start underscore mode.
     vb        str                 Visible bell (must not move cursor).
     ve        str                 Make cursor appear normal (undo vvss/ vvii).
     vi        str                 Make cursor invisible.
     vs        str                 Make cursor very visible.
     vt        num                 Virtual terminal number (not supported on

                                   all systems).
     wi        str       (N)       Set current window.
     ws        num                 Number of columns in status line.
     xb        bool                Beehive (f1= ESC, f2=^^CC).
     xn        bool                Newline ignored after 80 cols (Concept).
     xo        bool                Terminal uses xoff/xon (DC3/DC1) handshak-
                                   ing.
     xr        bool      (o)       Return acts like ccee ccrr nnll (Delta Data).
     xs        bool                Standout not erased by overwriting
                                   (Hewlett-Packard).
     xt        bool                Tabs ruin, magic char (Teleray 1061).
     xx        bool      (o)       Tektronix 4025 insert-line.

   AA SSaammppllee EEnnttrryy
     The following entry, which describes the Concept-100, is among the more
     complex entries in the tteerrmmccaapp file as of this writing.

     ca|concept100|c100|concept|c104|concept100-4p|HDS Concept-100:\
             :al=3*\E^R:am:bl=^G:cd=16*\E^C:ce=16\E^U:cl=2*^L:cm=\Ea%+ %+ :\
             :co#80:.cr=9^M:db:dc=16\E^A:dl=3*\E^B:do=^J:ei=\E\200:eo:im=\E^P:in:\
             :ip=16*:is=\EU\Ef\E7\E5\E8\El\ENH\EK\E\200\Eo&\200\Eo\47\E:k1=\E5:\
             :k2=\E6:k3=\E7:kb=^h:kd=\E<:ke=\Ex:kh=\E?:kl=\E>:kr=\E=:ks=\EX:\
             :ku=\E;:le=^H:li#24:mb=\EC:me=\EN\200:mh=\EE:mi:mk=\EH:mp=\EI:\
             :mr=\ED:nd=\E=:pb#9600:rp=0.2*\Er%.%+ :se=\Ed\Ee:sf=^J:so=\EE\ED:\
             :.ta=8\t:te=\Ev    \200\200\200\200\200\200\Ep\r\n:\
             :ti=\EU\Ev  8p\Ep\r:ue=\Eg:ul:up=\E;:us=\EG:\
             :vb=\Ek\200\200\200\200\200\200\200\200\200\200\200\200\200\200\EK:\
             :ve=\Ew:vs=\EW:vt#8:xn:\
             :bs:cr=^M:dC#9:dT#8:nl=^J:ta=^I:pt:

     Entries may continue onto multiple lines by giving a \ as the last char-
     acter of a line, and empty fields may be included for readability (here
     between the last field on a line and the first field on the next).  Com-
     ments may be included on lines beginning with ``#''.

   TTyyppeess ooff CCaappaabbiilliittiieess
     Capabilities in tteerrmmccaapp are of three types: Boolean capabilities, which
     indicate particular features that the terminal has; numeric capabilities,
     giving the size of the display or the size of other attributes; and
     string capabilities, which give character sequences that can be used to
     perform particular terminal operations.  All capabilities have two-letter
     codes.  For instance, the fact that the Concept has _a_u_t_o_m_a_t_i_c _m_a_r_g_i_n_s (an
     automatic return and linefeed when the end of a line is reached) is indi-
     cated by the Boolean capability aamm. Hence the description of the Concept
     includes aamm.

     Numeric capabilities are followed by the character `#' then the value.
     In the example above ccoo, which indicates the number of columns the dis-
     play has, gives the value `80' for the Concept.

     Finally, string-valued capabilities, such as ccee (clear-to-end-of-line se-
     quence) are given by the two-letter code, an `=', then a string ending at
     the next following `:'.  A delay in milliseconds may appear after the `='
     in such a capability, which causes padding characters to be supplied by
     tputs after the remainder of the string is sent to provide this delay.
     The delay can be either a number, such as `20', or a number followed by
     an `*', such as `3*'.  An `*' indicates that the padding required is pro-
     portional to the number of lines affected by the operation, and the
     amount given is the per-affected-line padding required.  (In the case of
     insert-character, the factor is still the number of _l_i_n_e_s affected; this
     is always 1 unless the terminal has iinn and the software uses it.)  When
     an `*' is specified, it is sometimes useful to give a delay of the form
     `3.5' to specify a delay per line to tenths of milliseconds.  (Only one
     decimal place is allowed.)


     A number of escape sequences are provided in the string-valued capabili-
     ties for easy encoding of control characters there.  \\EE maps to an ESC
     character, ^^XX maps to a control-X for any appropriate X, and the se-
     quences \\nn \\rr \\tt \\bb \\ff map to linefeed, return, tab, backspace, and form-
     feed, respectively.  Finally, characters may be given as three octal dig-
     its after a \\, and the characters ^^ and \\ may be given as \\^^ and \\\\. If
     it is necessary to place a :: in a capability it must be escaped in octal
     as \\007722. If it is necessary to place a NUL character in a string capabil-
     ity it must be encoded as \\220000. (The routines that deal with tteerrmmccaapp use
     C strings and strip the high bits of the output very late, so that a \\220000
     comes out as a \\000000 would.)

     Sometimes individual capabilities must be commented out.  To do this, put
     a period before the capability name.  For example, see the first ccrr and
     ttaa in the example above.

   PPrreeppaarriinngg DDeessccrriippttiioonnss
     The most effective way to prepare a terminal description is by imitating
     the description of a similar terminal in tteerrmmccaapp and to build up a de-
     scription gradually, using partial descriptions with vi to check that
     they are correct.  Be aware that a very unusual terminal may expose defi-
     ciencies in the ability of the tteerrmmccaapp file to describe it or bugs in vi.
      To easily test a new terminal description you are working on you can put
     it in your home directory in a file called _._t_e_r_m_c_a_p and programs will
     look there before looking in _/_u_s_r_/_s_h_a_r_e_/_m_i_s_c_/_t_e_r_m_c_a_p. You can also set
     the environment variable TERMPATH to a list of absolute file pathnames
     (separated by spaces or colons), one of which contains the description
     you are working on, and programs will search them in the order listed,
     and nowhere else.  See termcap(3).  The TERMCAP environment variable is
     usually set to the tteerrmmccaapp entry itself to avoid reading files when
     starting up a program.

     To get the padding for insert-line right (if the terminal manufacturer
     did not document it), a severe test is to use vi to edit _/_e_t_c_/_p_a_s_s_w_d at
     9600 baud, delete roughly 16 lines from the middle of the screen, then
     hit the `u' key several times quickly.  If the display messes up, more
     padding is usually needed.  A similar test can be used for insert-
     character.

   BBaassiicc CCaappaabbiilliittiieess
     The number of columns on each line of the display is given by the ccoo nu-
     meric capability.  If the display is a CRT, then the number of lines on
     the screen is given by the llii capability.  If the display wraps around to
     the beginning of the next line when the cursor reaches the right margin,
     then it should have the aamm capability.  If the terminal can clear its
     screen, the code to do this is given by the ccll string capability.  If the
     terminal overstrikes (rather than clearing the position when a character
     is overwritten), it should have the ooss capability.  If the terminal is a
     printing terminal, with no soft copy unit, give it both hhcc and ooss. (ooss
     applies to storage scope terminals, such as the Tektronix 4010 series, as
     well as to hard copy and APL terminals.)  If there is a code to move the
     cursor to the left edge of the current row, give this as ccrr. (Normally
     this will be carriage-return, ^^MM.) If there is a code to produce an audi-
     ble signal (bell, beep, etc. ) , give this as bbll.

     If there is a code (such as backspace) to move the cursor one position to
     the left, that capability should be given as llee. Similarly, codes to move
     to the right, up, and down should be given as nndd, uupp, and ddoo, respective-
     ly.  These _l_o_c_a_l _c_u_r_s_o_r _m_o_t_i_o_n_s should not alter the text they pass over;
     for example, you would not normally use ``nd= '' unless the terminal has
     the ooss capability, because the space would erase the character moved
     over.

     A very important point here is that the local cursor motions encoded in
     tteerrmmccaapp have undefined behavior at the left and top edges of a CRT dis-
     play.  Programs should never attempt to backspace around the left edge,
     unless bbww is given, and never attempt to go up off the top using local
     cursor motions.

     In order to scroll text up, a program goes to the bottom left corner of
     the screen and sends the ssff (index) string.  To scroll text down, a pro-
     gram goes to the top left corner of the screen and sends the ssrr (reverse
     index) string.  The strings ssff and ssrr have undefined behavior when not on
     their respective corners of the screen.  Parameterized versions of the
     scrolling sequences are SSFF and SSRR, which have the same semantics as ssff
     and ssrr except that they take one parameter and scroll that many lines.
     They also have undefined behavior except at the appropriate corner of the
     screen.

     The aamm capability tells whether the cursor sticks at the right edge of
     the screen when text is output there, but this does not necessarily apply
     to nndd from the last column.  Leftward local motion is defined from the
     left edge only when bbww is given; then an llee from the left edge will move
     to the right edge of the previous row.  This is useful for drawing a box
     around the edge of the screen, for example.  If the terminal has switch-
     selectable automatic margins, the tteerrmmccaapp description usually assumes
     that this feature is on, _i_._e., aamm. If the terminal has a command that
     moves to the first column of the next line, that command can be given as
     nnww (newline).  It is permissible for this to clear the remainder of the
     current line, so if the terminal has no correctly-working CR and LF it
     may still be possible to craft a working nnww out of one or both of them.

     These capabilities suffice to describe hardcopy and ``glass-tty'' termi-
     nals.  Thus the Teletype model 33 is described as

           T3|tty33|33|tty|Teletype model 33:\
                   :bl=^G:co#72:cr=^M:do=^J:hc:os:

     and the Lear Siegler ADM-3 is described as

           l3|adm3|3|LSI ADM-3:\
           :am:bl=^G:cl=^Z:co#80:cr=^M:do=^J:le=^H:li#24:sf=^J:

   PPaarraammeetteerriizzeedd SSttrriinnggss
     Cursor addressing and other strings requiring parameters are described by
     a parameterized string capability, with printf(3)-like  escapes %%xx in it,
     while other characters are passed through unchanged.  For example, to ad-
     dress the cursor the ccmm capability is given, using two parameters: the
     row and column to move to.  (Rows and columns are numbered from zero and
     refer to the physical screen visible to the user, not to any unseen memo-
     ry.  If the terminal has memory-relative cursor addressing, that can be
     indicated by an analogous CCMM capability.)

     The %% encodings have the following meanings:

     %%       output `%'
     %d       output value as in printf %d
     %2       output value as in printf %2d
     %3       output value as in printf %3d
     %.       output value as in printf %c
     %+_x      add _x to value, then do %.
     %>_x_y     if value > _x then add _y, no output
     %r       reverse order of two parameters, no output
     %i       increment by one, no output
     %n       exclusive-or all parameters with 0140 (Datamedia 2500)
     %B       BCD (16*(value/10)) + (value%10), no output
     %D       Reverse coding (value - 2*(value%16)), no output (Delta Data).

     Consider the Hewlett-Packard 2645, which, to get to row 3 and column 12,
     needs to be sent ``\E&a12c03Y'' padded for 6 milliseconds.  Note that the
     order of the row and column coordinates is reversed here and that the row
     and column are sent as two-digit integers.  Thus its ccmm capability is
     ``cm=6\E&%r%2c%2Y''.

     The Datamedia 2500 needs the current row and column sent encoded in bina-
     ry using ``%.''. Terminals that use ``%.'' need to be able to backspace
     the cursor (llee) and to move the cursor up one line on the screen (uupp).
     This is necessary because it is not always safe to transmit \\nn, ^^DD, and
     \\rr, as the system may change or discard them.  (Programs using tteerrmmccaapp
     must set terminal modes so that tabs are not expanded, so \\tt is safe to
     send.  This turns out to be essential for the Ann Arbor 4080.)

     A final example is the Lear Siegler ADM-3a, which offsets row and column
     by a blank character, thus ``cm=\E=%+ %+ ''.

     Row or column absolute cursor addressing can be given as single parameter
     capabilities cchh (horizontal position absolute) and ccvv (vertical position
     absolute).  Sometimes these are shorter than the more general two-
     parameter sequence (as with the Hewlett-Packard 2645) and can be used in
     preference to ccmm. If there are parameterized local motions (_e_._g., move _n
     positions to the right) these can be given as DDOO, LLEE, RRII, and UUPP with a
     single parameter indicating how many positions to move.  These are pri-
     marily useful if the terminal does not have ccmm, such as the Tektronix
     4025.

   CCuurrssoorr MMoottiioonnss

     If the terminal has a fast way to home the cursor (to the very upper left
     corner of the screen), this can be given as hhoo. Similarly, a fast way of
     getting to the lower left-hand corner can be given as llll; this may in-
     volve going up with uupp from the home position, but a program should never
     do this itself (unless llll does), because it can make no assumption about
     the effect of moving up from the home position.  Note that the home posi-
     tion is the same as cursor address (0,0): to the top left corner of the
     screen, not of memory.  (Therefore, the ``\EH'' sequence on Hewlett-
     Packard terminals cannot be used for hhoo.)

   AArreeaa CClleeaarrss
     If the terminal can clear from the current position to the end of the
     line, leaving the cursor where it is, this should be given as ccee. If the
     terminal can clear from the current position to the end of the display,
     this should be given as ccdd. ccdd must only be invoked from the first column
     of a line.  (Therefore, it can be simulated by a request to delete a
     large number of lines, if a true ccdd is not available.)

   IInnsseerrtt//DDeelleettee LLiinnee
     If the terminal can open a new blank line before the line containing the
     cursor, this should be given as aall; this must be invoked only from the
     first position of a line.  The cursor must then appear at the left of the
     newly blank line.  If the terminal can delete the line that the cursor is
     on, this should be given as ddll; this must only be used from the first po-
     sition on the line to be deleted.  Versions of aall and ddll which take a
     single parameter and insert or delete that many lines can be given as AALL
     and DDLL. If the terminal has a settable scrolling region (like the VT100),
     the command to set this can be described with the ccss capability, which
     takes two parameters: the top and bottom lines of the scrolling region.
     The cursor position is, alas, undefined after using this command.  It is
     possible to get the effect of insert or delete line using this command --
     the sscc and rrcc (save and restore cursor) commands are also useful.  In-
     serting lines at the top or bottom of the screen can also be done using
     ssrr or ssff on many terminals without a true insert/delete line, and is of-
     ten faster even on terminals with those features.

     If the terminal has the ability to define a window as part of memory
     which all commands affect, it should be given as the parameterized string
     wwii. The four parameters are the starting and ending lines in memory and
     the starting and ending columns in memory, in that order.  (This terminfo
     capability is described for completeness.  It is unlikely that any
     tteerrmmccaapp- using program will support it.)

     If the terminal can retain display memory above the screen, then the ddaa
     capability should be given; if display memory can be retained below, then
     ddbb should be given.  These indicate that deleting a line or scrolling may
     bring non-blank lines up from below or that scrolling back with ssrr may
     bring down non-blank lines.

   IInnsseerrtt//DDeelleettee CChhaarraacctteerr
     There are two basic kinds of intelligent terminals with respect to in-
     sert/delete character that can be described using tteerrmmccaapp. The most com-
     mon insert/delete character operations affect only the characters on the
     current line and shift characters off the end of the line rigidly.  Other
     terminals, such as the Concept-100 and the Perkin Elmer Owl, make a dis-
     tinction between typed and untyped blanks on the screen, shifting upon an
     insert or delete only to an untyped blank on the screen which is either
     eliminated or expanded to two untyped blanks.  You can determine the kind
     of terminal you have by clearing the screen then typing text separated by
     cursor motions.  Type ``abc    def'' using local cursor motions (not
     spaces) between the ``abc'' and the ``def''. Then position the cursor be-
     fore the ``abc'' and put the terminal in insert mode.  If typing charac-
     ters causes the rest of the line to shift rigidly and characters to fall
     off the end, then your terminal does not distinguish between blanks and
     untyped positions.  If the ``abc'' shifts over to the ``def'' which then
     move together around the end of the current line and onto the next as you
     insert, then you have the second type of terminal and should give the ca-
     pability iinn, which stands for ``insert null''. While these are two logi-
     cally separate attributes (one line _v_s. multi-line insert mode, and spe-
     cial treatment of untyped spaces), we have seen no terminals whose insert
     mode cannot be described with the single attribute.

     TTeerrmmccaapp can describe both terminals that have an insert mode and termi-
     nals that send a simple sequence to open a blank position on the current
     line.  Give as iimm the sequence to get into insert mode.  Give as eeii the
     sequence to leave insert mode.  Now give as iicc any sequence that needs to
     be sent just before each character to be inserted.  Most terminals with a
     true insert mode will not give iicc; terminals that use a sequence to open
     a screen position should give it here.  (If your terminal has both, in-
     sert mode is usually preferable to iicc. Do not give both unless the termi-
     nal actually requires both to be used in combination.)  If post-insert
     padding is needed, give this as a number of milliseconds in iipp (a string
     option).  Any other sequence that may need to be sent after insertion of
     a single character can also be given in iipp. If your terminal needs to be
     placed into an `insert mode' and needs a special code preceding each in-
     serted character, then both iimm/ eeii and iicc can be given, and both will be
     used.  The IICC capability, with one parameter _n, will repeat the effects
     of iicc _n times.

     It is occasionally necessary to move around while in insert mode to
     delete characters on the same line (_e_._g., if there is a tab after the in-
     sertion position).  If your terminal allows motion while in insert mode,
     you can give the capability mmii to speed up inserting in this case.  Omit-
     ting mmii will affect only speed.  Some terminals (notably Datamedia's)
     must not have mmii because of the way their insert mode works.

     Finally, you can specify ddcc to delete a single character, DDCC with one pa-
     rameter _n to delete _n characters, and delete mode by giving ddmm and eedd to
     enter and exit delete mode (which is any mode the terminal needs to be
     placed in for ddcc to work).

   HHiigghhlliigghhttiinngg,, UUnnddeerrlliinniinngg,, aanndd VViissiibbllee BBeellllss
     If your terminal has one or more kinds of display attributes, these can
     be represented in a number of different ways.  You should choose one dis-
     play form as _s_t_a_n_d_o_u_t _m_o_d_e, representing a good high-contrast, easy-on-
     the-eyes format for highlighting error messages and other attention get-
     ters.  (If you have a choice, reverse video plus half-bright is good, or
     reverse video alone.)  The sequences to enter and exit standout mode are
     given as ssoo and ssee, respectively.  If the code to change into or out of
     standout mode leaves one or even two blank spaces or garbage characters
     on the screen, as the TVI 912 and Teleray 1061 do, then ssgg should be giv-
     en to tell how many characters are left.

     Codes to begin underlining and end underlining can be given as uuss and uuee,
     respectively.  Underline mode change garbage is specified by uugg, similar
     to ssgg. If the terminal has a code to underline the current character and
     move the cursor one position to the right, such as the Microterm Mime,
     this can be given as uucc.

     Other capabilities to enter various highlighting modes include mmbb (blink-
     ing), mmdd (bold or extra bright), mmhh (dim or half-bright), mmkk (blanking or
     invisible text), mmpp (protected), mmrr (reverse video), mmee (turn off _a_l_l at-
     tribute modes), aass (enter alternate character set mode), and aaee (exit al-
     ternate character set mode).  Turning on any of these modes singly may or
     may not turn off other modes.

     If there is a sequence to set arbitrary combinations of mode, this should
     be given as ssaa (set attributes), taking 9 parameters.  Each parameter is
     either 0 or 1, as the corresponding attributes is on or off.  The 9 pa-
     rameters are, in order: standout, underline, reverse, blink, dim, bold,
     blank, protect, and alternate character set.  Not all modes need be sup-
     ported by ssaa, only those for which corresponding attribute commands ex-
     ist.  (It is unlikely that a tteerrmmccaapp-using program will support this ca-
     pability, which is defined for compatibility with terminfo.)

     Terminals with the ``magic cookie'' glitches (ssgg and uugg), rather than
     maintaining extra attribute bits for each character cell, instead deposit
     special ``cookies'', or ``garbage characters ,,'' when they receive mode-
     setting sequences, which affect the display algorithm.

     Some terminals, such as the Hewlett-Packard 2621, automatically leave
     standout mode when they move to a new line or when the cursor is ad-
     dressed.  Programs using standout mode should exit standout mode on such
     terminals before moving the cursor or sending a newline.  On terminals
     where this is not a problem, the mmss capability should be present to say
     that this overhead is unnecessary.

     If the terminal has a way of flashing the screen to indicate an error
     quietly (a bell replacement), this can be given as vvbb; it must not move
     the cursor.

     If the cursor needs to be made more visible than normal when it is not on
     the bottom line (to change, for example, a non-blinking underline into an
     easier-to-find block or blinking underline), give this sequence as vvss. If
     there is a way to make the cursor completely invisible, give that as vvii.
     The capability vvee, which undoes the effects of both of these modes,
     should also be given.

     If your terminal correctly displays underlined characters (with no spe-
     cial codes needed) even though it does not overstrike, then you should
     give the capability uull. If overstrikes are erasable with a blank, this
     should be indicated by giving eeoo.

   KKeeyyppaadd
     If the terminal has a keypad that transmits codes when the keys are
     pressed, this information can be given.  Note that it is not possible to
     handle terminals where the keypad only works in local mode (this applies,
     for example, to the unshifted Hewlett-Packard 2621 keys).  If the keypad
     can be set to transmit or not transmit, give these codes as kkss and kkee.
     Otherwise the keypad is assumed to always transmit.  The codes sent by
     the left-arrow, right-arrow, up-arrow, down-arrow, and home keys can be
     given as kkll, kkrr, kkuu, kkdd, and kkhh, respectively.  If there are function
     keys such as f0, f1, ..., f9, the codes they send can be given as kk00, kk11,
     kk99. If these keys have labels other than the default f0 through f9, the
     labels can be given as ll00, ll11, ll99. The codes transmitted by certain other
     special keys can be given: kkHH (home down), kkbb (backspace), kkaa (clear all
     tabs), kktt (clear the tab stop in this column), kkCC (clear screen or
     erase), kkDD (delete character), kkLL (delete line), kkMM (exit insert mode),
     kkEE (clear to end of line), kkSS (clear to end of screen), kkII (insert char-
     acter or enter insert mode), kkAA (insert line), kkNN (next page), kkPP (previ-
     ous page), kkFF (scroll forward/down), kkRR (scroll backward/up), and kkTT (set
     a tab stop in this column).  In addition, if the keypad has a 3 by 3 ar-
     ray of keys including the four arrow keys, then the other five keys can
     be given as KK11, KK22, KK33, KK44, and KK55. These keys are useful when the ef-
     fects of a 3 by 3 directional pad are needed.  The obsolete kkoo capability
     formerly used to describe ``other'' function keys has been completely
     supplanted by the above capabilities.

     The mmaa entry is also used to indicate arrow keys on terminals that have
     single-character arrow keys.  It is obsolete but still in use in version
     2 of vvii which must be run on some minicomputers due to memory limita-
     tions.  This field is redundant with kkll, kkrr, kkuu, kkdd, and kkhh. It consists
     of groups of two characters.  In each group, the first character is what
     an arrow key sends, and the second character is the corresponding vvii com-
     mand.  These commands are _h for kkll, _j for kkdd, _k for kkuu, _l for kkrr, and _H
     for kkhh. For example, the Mime would have ``ma=^Hh^Kj^Zk^Xl'' indicating
     arrow keys left (^H), down (^K), up (^Z), and right (^X).  (There is no
     home key on the Mime.)

   TTaabbss aanndd IInniittiiaalliizzaattiioonn
     If the terminal needs to be in a special mode when running a program that
     uses these capabilities, the codes to enter and exit this mode can be
     given as ttii and ttee. This arises, for example, from terminals like the
     Concept with more than one page of memory.  If the terminal has only mem-
     ory-relative cursor addressing and not screen-relative cursor addressing,
     a screen-sized window must be fixed into the display for cursor address-
     ing to work properly.  This is also used for the Tektronix 4025, where ttii
     sets the command character to be the one used by tteerrmmccaapp.

     Other capabilities include iiss, an initialization string for the terminal,
     and iiff, the name of a file containing long initialization strings.  These
     strings are expected to set the terminal into modes consistent with the
     rest of the tteerrmmccaapp description.  They are normally sent to the terminal
     by the tset program each time the user logs in.  They will be printed in
     the following order: iiss; setting tabs using cctt and sstt; and finally iiff.
     (Terminfo uses ii11--ii22 instead of iiss and runs the program iiPP and prints ii33
     after the other initializations.)  A pair of sequences that does a harder
     reset from a totally unknown state can be analogously given as rrss and iiff.
     These strings are output by the reset program, which is used when the
     terminal gets into a wedged state.  (Terminfo uses rr11--rr33 instead of rrss.)
     Commands are normally placed in rrss and rrff only if they produce annoying
     effects on the screen and are not necessary when logging in.  For exam-
     ple, the command to set the VT100 into 80-column mode would normally be
     part of iiss, but it causes an annoying glitch of the screen and is not
     normally needed since the terminal is usually already in 80-column mode.

     If the terminal has hardware tabs, the command to advance to the next tab
     stop can be given as ttaa (usually ^^II). A ``backtab'' command which moves
     leftward to the previous tab stop can be given as bbtt. By convention, if
     the terminal driver modes indicate that tab stops are being expanded by
     the computer rather than being sent to the terminal, programs should not
     use ttaa or bbtt even if they are present, since the user may not have the
     tab stops properly set.  If the terminal has hardware tabs that are ini-
     tially set every _n positions when the terminal is powered up, then the
     numeric parameter iitt is given, showing the number of positions between
     tab stops.  This is normally used by the tset command to determine
     whether to set the driver mode for hardware tab expansion, and whether to
     set the tab stops.  If the terminal has tab stops that can be saved in
     nonvolatile memory, the tteerrmmccaapp description can assume that they are
     properly set.

     If there are commands to set and clear tab stops, they can be given as cctt
     (clear all tab stops) and sstt (set a tab stop in the current column of ev-
     ery row).  If a more complex sequence is needed to set the tabs than can
     be described by this, the sequence can be placed in iiss or iiff.

   DDeellaayyss
     Certain capabilities control padding in the terminal driver.  These are
     primarily needed by hardcopy terminals and are used by the tset program
     to set terminal driver modes appropriately.  Delays embedded in the capa-
     bilities ccrr, ssff, llee, ffff, and ttaa will cause the appropriate delay bits to
     be set in the terminal driver.  If ppbb (padding baud rate) is given, these
     values can be ignored at baud rates below the value of ppbb. For 4.2BSD
     tset,  the delays are given as numeric capabilities ddCC, ddNN, ddBB, ddFF, and
     ddTT instead.

   MMiisscceellllaanneeoouuss
     If the terminal requires other than a NUL (zero) character as a pad, this
     can be given as ppcc. Only the first character of the ppcc string is used.

     If the terminal has commands to save and restore the position of the cur-
     sor, give them as sscc and rrcc.

     If the terminal has an extra ``status line'' that is not normally used by
     software, this fact can be indicated.  If the status line is viewed as an
     extra line below the bottom line, then the capability hhss should be given.
     Special strings to go to a position in the status line and to return from
     the status line can be given as ttss and ffss. (fs must leave the cursor po-
     sition in the same place that it was before ttss. If necessary, the sscc and
     rrcc strings can be included in ttss and ffss to get this effect.)  The capa-
     bility ttss takes one parameter, which is the column number of the status
     line to which the cursor is to be moved.  If escape sequences and other
     special commands such as tab work while in the status line, the flag eess
     can be given.  A string that turns off the status line (or otherwise
     erases its contents) should be given as ddss. The status line is normally
     assumed to be the same width as the rest of the screen, _i_._e., ccoo. If the
     status line is a different width (possibly because the terminal does not
     allow an entire line to be loaded), then its width in columns can be in-
     dicated with the numeric parameter wwss.

     If the terminal can move up or down half a line, this can be indicated
     with hhuu (half-line up) and hhdd (half-line down).  This is primarily useful
     for superscripts and subscripts on hardcopy terminals.  If a hardcopy
     terminal can eject to the next page (form feed), give this as ffff (usually
     ^^LL).

     If there is a command to repeat a given character a given number of times
     (to save time transmitting a large number of identical characters), this
     can be indicated with the parameterized string rrpp. The first parameter is
     the character to be repeated and the second is the number of times to re-
     peat it.  (This is a terminfo feature that is unlikely to be supported by
     a program that uses tteerrmmccaapp.)

     If the terminal has a settable command character, such as the Tektronix
     4025, this can be indicated with CCCC. A prototype command character is
     chosen which is used in all capabilities.  This character is given in the
     CCCC capability to identify it.  The following convention is supported on
     some UNIX systems: The environment is to be searched for a CC variable,
     and if found, all occurrences of the prototype character are replaced by
     the character in the environment variable.  This use of the CC environ-
     ment variable is a very bad idea, as it conflicts with make(1).

     Terminal descriptions that do not represent a specific kind of known ter-
     minal, such as _s_w_i_t_c_h, _d_i_a_l_u_p, _p_a_t_c_h, and network,  should include the ggnn
     (generic) capability so that programs can complain that they do not know
     how to talk to the terminal.  (This capability does not apply to _v_i_r_t_u_a_l
     terminal descriptions for which the escape sequences are known.)

     If the terminal uses xoff/xon (DC3/DC1) handshaking for flow control,
     give xxoo. Padding information should still be included so that routines
     can make better decisions about costs, but actual pad characters will not
     be transmitted.

     If the terminal has a ``meta key'' which acts as a shift key, setting the
     8th bit of any character transmitted, then this fact can be indicated
     with kkmm. Otherwise, software will assume that the 8th bit is parity and
     it will usually be cleared.  If strings exist to turn this ``meta mode''
     on and off, they can be given as mmmm and mmoo.

     If the terminal has more lines of memory than will fit on the screen at
     once, the number of lines of memory can be indicated with llmm. An explicit
     value of 0 indicates that the number of lines is not fixed, but that
     there is still more memory than fits on the screen.

     If the terminal is one of those supported by the UNIX system virtual ter-
     minal protocol, the terminal number can be given as vvtt.

     Media copy strings which control an auxiliary printer connected to the
     terminal can be given as ppss: print the contents of the screen; ppff: turn
     off the printer; and ppoo: turn on the printer.  When the printer is on,
     all text sent to the terminal will be sent to the printer.  It is unde-
     fined whether the text is also displayed on the terminal screen when the
     printer is on.  A variation ppOO takes one parameter and leaves the printer
     on for as many characters as the value of the parameter, then turns the
     printer off.  The parameter should not exceed 255.  All text, including
     ppff, is transparently passed to the printer while ppOO is in effect.

     Strings to program function keys can be given as ppkk, ppll, and ppxx. Each of
     these strings takes two parameters: the function key number to program
     (from 0 to 9) and the string to program it with.  Function key numbers
     out of this range may program undefined keys in a terminal-dependent man-
     ner.  The differences among the capabilities are that ppkk causes pressing
     the given key to be the same as the user typing the given string; ppll
     causes the string to be executed by the terminal in local mode; and ppxx
     causes the string to be transmitted to the computer.  Unfortunately, due
     to lack of a definition for string parameters in tteerrmmccaapp, only terminfo
     supports these capabilities.

   GGlliittcchheess aanndd BBrraaiinnddaammaaggee
     Hazeltine terminals, which do not allow `~' characters to be displayed,
     should indicate hhzz.

     The nncc capability, now obsolete, formerly indicated Datamedia terminals,
     which echo \\rr \\nn for carriage return then ignore a following linefeed.

     Terminals that ignore a linefeed immediately after an aamm wrap, such as
     the Concept, should indicate xxnn.

     If ccee is required to get rid of standout (instead of merely writing nor-
     mal text on top of it), xxss should be given.

     Teleray terminals, where tabs turn all characters moved over to blanks,
     should indicate xxtt (destructive tabs).  This glitch is also taken to mean
     that it is not possible to position the cursor on top of a magic cookie,
     and that to erase standout mode it is necessary to use delete and insert
     line.

     The Beehive Superbee, which is unable to correctly transmit the ESC or ^^CC
     characters, has xxbb, indicating that the ``f1'' key is used for ESC and
     ``f2'' for ^C.  (Only certain Superbees have this problem, depending on
     the ROM.)

     Other specific terminal problems may be corrected by adding more capabil-
     ities of the form xx _x.

   SSiimmiillaarr TTeerrmmiinnaallss
     If there are two very similar terminals, one can be defined as being just
     like the other with certain exceptions.  The string capability ttcc can be
     given with the name of the similar terminal.  This capability must be
     _l_a_s_t, and the combined length of the entries must not exceed 1024.  The
     capabilities given before ttcc override those in the terminal type invoked
     by ttcc. A capability can be canceled by placing xxxx@@ to the left of the ttcc
     invocation, where xxxx is the capability.  For example, the entry

           hn|2621-nl:ks@:ke@:tc=2621:

     defines a ``2621-nl'' that does not have the kkss or kkee capabilities, hence
     does not turn on the function key labels when in visual mode.  This is
     useful for different modes for a terminal, or for different user prefer-
     ences.

FFIILLEESS
     /usr/share/misc/termcap     File containing terminal descriptions.
     /usr/share/misc/termcap.db  Hash database file containing terminal de-
                                 scriptions (see cap_mkdb(1)).

SSEEEE AALLSSOO
     ex(1),  cap_mkdb(1),  more(1),  tset(1),  ul(1),  vi(1),  curses(3),
     printf(3),  termcap(3),  term(7)

CCAAVVEEAATTSS AANNDD BBUUGGSS
     The _N_o_t_e: tteerrmmccaapp functions were replaced by terminfo in AT&T System V
     UNIX Release 2.0.  The transition will be relatively painless if capabil-
     ities flagged as ``obsolete'' are avoided.

     Lines and columns are now stored by the kernel as well as in the termcap
     entry.  Most programs now use the kernel information primarily; the in-
     formation in this file is used only if the kernel does not have any in-
     formation.

     Vi allows only 256 characters for string capabilities, and the routines
     in termlib(3) do not check for overflow of this buffer.  The total length
     of a single entry (excluding only escaped newlines) may not exceed 1024.

     Not all programs support all entries.

HHIISSTTOORRYY
     The tteerrmmccaapp file format appeared in 3BSD.

3rd Berkeley Distribution        March 6, 1993                              14


















