#include special.inc
* -- defines for use with CD player
#define LOGICAL 0
#define NUMERIC 1
#define STRING 2

#define TRACK_BUTTONS 1
#define PLAY_BUTTON 2
#define PAUSE_BUTTON 3
#define FWD_BUTTON 4
#define BKP_BUTTON 5

#define SPTR_WAIT 3 && system clock icon

#include msg.inc && values for OS/2 Message Options MB_*

* -- set window size and title
setwin ( 6,5, 6,54 )
system (7001, 'OnCmd CD Audio Player' )


set fullread on

* -- initialize variables
cd = 'cdaudio'
da = 'cdaudio'
track = 1
last_track = 1
play = .f.
pause = .f.
fwd = .f.
bkp = .f.
voldn = .f.
volup = .f.
volum = .f.
quitnow = .f.
volumelevel = 0
bytes = 0
playing = .f.


* -- try to initialize CD
if .not. initcd()
	quit
endif

* -- Go to the first track.
cdseek( cdstatus( 'position track 1', NUMERIC ) )

* -- Timer interrupt every second please.
set timer to 0
tmr( 'timer()', seconds(), date(), -1, -1 )

* -- main processing loop
f = 1
do while .t.

	pointer() && restore the mouse pointer icon to SPTR_ARROW default
	read save from f
	pointer( SPTR_WAIT )	
	
	f = lastfield()

	do case

        case quitnow        && QUIT
            quit

        case volum          && set VOLUME
                run - /w /b /n AMPM.exe
                showgets()
                volum = .f.

		case pause        && PAUSE cd
			if playing
				cdplay( .f. )
			else
				cdplay( .t. )
			endif
			pause = .f.

		case play         && PLAY cd
			cdplay( .t. )
			play = .f.

		case fwd          && skip FORWARD
			cdseek( cdstatus( 'position ', NUMERIC ) + 3000 )
			fwd = .f.

		case bkp          && skip BACKWARD
			cdseek( cdstatus( 'position ', NUMERIC ) - 3000 )
			bkp = .f.

		case f = TRACK_BUTTONS
			cdseek( cdstatus( 'position track ' + str(track), NUMERIC ) )

	endcase

enddo		 				
	

* -- initialize CD
func initcd
public	dev
private	p, n, t
	
* -- check for CD device
	dev = mci( 'sysinfo', cd, 'installname' )
	if empty(dev)
		msgbox( 'Cannot find a CD', str(ferror()), MB_ERROR )
		return .f.
	endif

	@0,1	say dev font 'Tms Rmn',8 color 'n/p'
	
	if .not. cdstatus( 'media present', LOGICAL )
		msgbox( 'No CD, or not an audio CD', str(ferror()), MB_ERROR )
		return .f.
	endif

* -- Query the tracking information...

	bytes = cdstatus( 'length', NUMERIC )	
	n =  cdstatus( 'number of tracks', NUMERIC )

	if n < 1
		msgbox( 'Problem finding the number of tracks' , str(ferror()), MB_ERROR )
		return .f.
	endif
		
* -- set prompt for tracks
	p = '@*H '
	for t = 1 to n
		if t > 1
			p = p + ';'
		endif	
		p = p + str( t )
	next

    volumelevel = val( left( mci( 'status', cd, 'volume' ), 3 ) )
    setvol( 0 )

* -- get buttons for CD player
	@1,1 get track pict p font 'Courier',8 size 1.2,2.8

	@3,1 get play pict '@* Play' size 1.5,6
	@3,8 get pause pict '@* Pause' size 1.5,6
	@3,15 get fwd pict '@* Forward' size 1.5,9
	@3,25 get bkp pict '@* Backward' size 1.5,9
    @3,35 get volum pict '@* Volume' size 1.5,10
    @3,46 get quitnow pict '@* Quit' size 1.5,6

    pointer(SPTR_WAIT)

    return .t.

* -- check status of CD
func cdstatus
para kw, ret
private s, e
	
	s = mci( 'status', cd, kw )
	do case
		case ret = LOGICAL
			return s = 'TRUE'
	
		case ret = NUMERIC
			return val( s )
	endcase
	
	return s

* -- routine to skip to next/previous track
func cdseek
para off
	if playing
		mci ( 'play', cd, 'from ' + str(off), .f. )
	else
		mci ( 'seek', cd, 'to ' + str(off), .f. )
	endif

	showpos( off )

* -- routine to check the current track
func chktrack
	track = cdstatus( 'current track', NUMERIC )
	if track <> last_track
		showget( TRACK_BUTTONS )
		last_track = track
	endif

* -- routine to show play time
func showpos
para n
    @0,9
    @0,9 say ltrim( trans( n, '@, 9999999999' ) ) font 'Tms Rmn',8

* -- routine to turn on/off cd
func cdplay
para on
	if on
		mci( 'play', cd, .f., .f. )
		set timer to 2
		playing = .t.
	else	
		mci( 'pause' )
		set timer to 0
		playing = .f.
	endif
			

* -- routine to display current track info
func timer
private pos
	if playing
		pos = cdstatus( 'position', NUMERIC )
		chktrack()
		showpos( pos )
	endif


* -- routine to set volume for the cd
func setvol
para factor
     volumelevel =  volumelevel + factor
     if( volumelevel > 100 )
            tone( 1000, 100 )
            tone( 500, 100 )
            volumelevel = 100
     endif
     if( volumelevel < 0 )
            tone( 1000, 100 )
            tone( 500, 100 )
            volumelevel = 0
     endif
     mcierror = mci( 'set', cd, 'audio volume all ' + str(floor(volumelevel)) )
     if .not. empty(mcierror)
         msgbox( 'Volume set error', mcierror )
     endif
return .t.

* -- END
