/* REXX PROGRAM */
/* CONTACT CONNECTION INSTALLATION PROGRAM */
SAY "INSTALLATION PROGRAM FOR CONTACT CONNECTION DEMO"
SAY ""
/* You may optionally specify the destination path for the program as an argument. */
/* If you do not specify the destination path you will be prompted to enter a path. */
PARSE SOURCE os processor cmd
srcdrive = FILESPEC("drive",cmd)
srcpath = FILESPEC("path",cmd)
src = srcdrive||srcpath
minHardDiskSize = 2800000

arg destpath
"@echo off"

call RxFuncAdd 'SysMkDir', 'RexxUtil', 'SysMkDir'
call RxFuncAdd 'SysDriveInfo', 'RexxUtil', 'SysDriveInfo'
driveInfo = SysDriveInfo(srcdrive)
driveSize = SUBWORD(driveInfo, 3, 1)
DO FOREVER
	IF destpath = "" THEN DO
		IF driveSize > minHardDiskSize THEN DO
			tempsrc = STRIP(src, 'T', '\')
			SAY "If you would like to run the demonstration from "tempsrc
			SAY "without copying the files to a new directory simply press Enter without"
			SAY "typing anything.  Otherwise enter the full directory path (including drive)"
			SAY "where where you would like the demonstration program to be installed."
			SAY '(We suggest "C:\CCDEMO").'
			END
		ELSE DO
			SAY "Enter the full directory path (including drive) where you would like the"
			SAY "demonstration program installed.  If you press Enter without typing anything"
			SAY 'it will be installed in the "C:\CCDEMO" directory.'
			END
		SAY "If you would like to abort this installation type QUIT and press Enter."
		PULL destpath
		IF destpath = "QUIT" THEN EXIT
		IF driveSize > minHardDiskSize THEN DO
			IF destpath = "" THEN DO
				destpath = src
				SIGNAL MAKE_ICON
				END
			END
		ELSE DO
			IF destpath = "" THEN destpath = "C:\CCDEMO"
			END
		END
	rc = SysMkDir(destpath)
	IF rc == 0 THEN LEAVE
	SAY ""
	SAY "ERROR: Unable to make the directory "destpath"."
	IF rc == 3 THEN say "The path was not found."
	IF rc == 5 THEN say "Either it already exists or you do not have access to the directory."
	SAY "Enter a new path."
	SAY ""
	destpath = ""
	END

/* Copy the files */
SAY ""
SAY "Now copying files..."
/* If the source drive is not big enough to hold the entire program (i.e. a floppy) ask for disk 2. */
IF driveSize <= minHardDiskSize THEN DO
	"copy "src"*.* "destpath"/v"
	SAY ""
	SAY "Insert the disk Labeled Disk 2 and press Enter."
	PULL response
	SAY ""
	SAY "Now copying files..."
	"copy "src"*.* "destpath"/v"
	"erase "destpath"\install.cmd 2>nul"
	"erase "destpath"\upgrade.cmd 2>nul"
	END
ELSE DO
	"copy "src"contacts.exe "destpath"/v"
	"copy "src"contacts.hlp "destpath"/v"
	"copy "src"cic*.dll "destpath"/v"
	"copy "src"*.hdr "destpath"/v"
	/* "copy "src"*.db* "destpath"/v" */
	"copy "src"readme.txt "destpath"/v"
	SAY ""
	END

MAKE_ICON:
/* Create the Contact Connection Icon. */
call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject'
if SysCreateObject('WPProgram', 'Contact Connection Demo', '<WP_DESKTOP>', 'EXENAME='destpath'\contacts.exe;STARTUPDIR='destpath, 'replace') == 0 then SAY 'Unable to create the Contact Connection icon.  You should add it manually after the installation program finishes.'

/* Make sub directories */
"md "destpath"\NOTES 2>nul"
"md "destpath"\FILES 2>nul"
"md "destpath"\TEMPLATE 2>nul"

SAY ""
SAY "DONE INSTALLING THE CONTACT CONNECTION DEMO."
SAY "To use the program double click on the 'Contact Connection Demo' icon on your desktop."
SAY ""
EXIT
