/* REXX INSTALLATION FOR MYSQL 3.22.19b
 * by Antony T Curtis <antony.curtis@olcs.net>
  */

'@ECHO OFF'

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

PARSE ARG arg '[' bootstrap ']'

folder.name = 'MySQL/2^3.22.26a'
basedir = directory()

bindir = basedir||'\bin';
dlldir = basedir||'\dll';
datadir = basedir||'\data';
bookdir = basedir||'\book';
resdir = basedir||'\share';
mdata = datadir||'\mysql';
dlfound = "";

IF bootstrap >< "bootstrap" THEN DO

  rc = SysSearchPath('PATH','EMX.EXE');
  IF rc = '' THEN DO
    SAY "EMX Run Time Libraries not found!"
    SAY "Please install EMX 0.9d Runtime before installing MySQL/2"
    EXIT
  END

  emxpath = filespec('path',rc)
  emxpath = left(emxpath, length(emxpath)-1);
  emxpath = filespec('drive',rc) || filespec('path',emxpath)
  emxdll = emxpath||'dll'

  rc = SysFileTree(emxdll||'\pthrdrtl.dll','test','F');
  IF test.0<>1 THEN DO
    CALL LineOut "STDERR:", "Installing Pthreads Runtime Library..."
    rc = SysCopyObject(dlldir||'\pthrdrtl.dll',emxdll)
    IF rc = 0 THEN DO
      SAY "Error installing Pthreads runtime!"
      SAY "Target " emxdll
      EXIT
    END
  END
  ELSE DO
    CALL LineOut "STDERR:", emxdll||"\pthrdrtl.dll already installed"
    dlfound = dlfound||emxdll||"\pthrdrtl.dll "
  END

  rc = SysFileTree(emxdll||'\gnureadl.dll','test','F');
  IF test.0<>1 THEN DO
    CALL LineOut "STDERR:", "Installing GNU Readline Library..."
    rc = SysCopyObject(dlldir||'\gnureadl.dll',emxdll)
    IF rc = 0 THEN DO
      SAY "Error installing readline runtime!"
      SAY "Target " emxdll
      EXIT
    END
  END
  ELSE DO
    CALL LineOut "STDERR:", emxdll||"\gnureadl.dll already installed"
    dlfound = dlfound||emxdll||"\gnureadl.dll "
  END

  rc = SysFileTree(emxdll||'\mysqldll.dll','test','F');
  IF test.0<>1 THEN DO
    CALL LineOut "STDERR:", "Installing mySQL client Library..."
    rc = SysCopyObject(dlldir||'\mysqldll.dll',emxdll)
    IF rc = 0 THEN DO
      SAY "Error installing client runtime!"
      SAY "Target " emxdll
      EXIT
    END
  END 
  ELSE DO
    CALL LineOut "STDERR:", emxdll||"\mysqldll.dll already installed"
    dlfound = dlfound||emxdll||"\mysqldll.dll "
  END

  /* Create database directories mysql & test */
  CALL LineOut "STDERR:", "Creating data directories..."
  rc = SysMkDir(datadir);
  rc = SysMkDir(datadir||'\mysql');
  rc = SysMkDir(datadir||'\test');

  CALL LineOut "STDERR:", "Bootstrapping database"
  'hostname | install.cmd [bootstrap] | '||bindir||'\MYSQLD.EXE --bootstrap --skip-grant-tables --basedir='||basedir||' --datadir='||datadir

  folder.objid = Translate(folder.name, '__!', '^ /')
  folder.name  = Translate(folder.name, '0A'x, '^')
  folder.icon  = ""
  servericon   = ""
  clienticon   = ""
  shutdnicon   = ""
  reloadicon   = ""
  bookicon     = ""
  createicon   = ""
  dropicon     = ""

  CALL LineOut "STDERR:", "Finding WPS Icons..."

  rc = STREAM(resdir||'\mySQL-Folder.ico','c','query exists')
  IF rc \= '' THEN folder.icon = ';ICONFILE='||rc

  rc = STREAM(resdir||'\mySQL-StartServer.ico','c','query exists')
  IF rc \= '' THEN servericon = ';ICONFILE='||rc

  rc = STREAM(resdir||'\mySQL-ShutdownServer.ico','c','query exists')
  IF rc \= '' THEN shutdnicon = ';ICONFILE='||rc

  rc = STREAM(resdir||'\mySQL-Client.ico','c','query exists')
  IF rc \= '' THEN clienticon = ';ICONFILE='||rc

  rc = STREAM(resdir||'\mySQL-Manual.ico','c','query exists')
  IF rc \= '' THEN bookicon = ';ICONFILE='||rc

  rc = STREAM(resdir||'\mySQL-ReloadGrantTables.ico','c','query exists')
  IF rc \= '' THEN reloadicon = ';ICONFILE='||rc

  rc = STREAM(resdir||'\mySQL-CreateDatabase.ico','c','query exists')
  IF rc \= '' THEN createicon = ';ICONFILE='||rc

  rc = STREAM(resdir||'\mySQL-DropDatabase.ico','c','query exists')
  IF rc \= '' THEN dropicon = ';ICONFILE='||rc

  CALL LineOut "STDERR:", "Creating WPS Objects..."

  rc = SysCreateObject(	'WPFolder', ,
			folder.name, ,
			'<WP_DESKTOP>', ,
			'OBJECTID=<'||folder.objid||'>;ICONVIEW=FLOWED,NORMAL;ICONFONT=8.Helv;OPEN=ICON'||folder.icon, ,
			'ReplaceIfExists')

  rc = SysCreateObject(	'WPProgram', ,
			'MySQL Server', ,
			'<'folder.objid'>', ,
			'OBJECTID=<MYSQL_SERVER>;EXENAME='||bindir||'\MYSQLD.EXE;PARAMETERS=--basedir='||basedir||' --datadir='||datadir||';STARTUPDIR='||basedir||servericon, ,
			'ReplaceIfExists')

  rc = SysCreateObject(	'WPProgram', ,
			'Shutdown Server', ,
			'<'folder.objid'>', ,
			'OBJECTID=<MYSQL_SHUTDOWN>;EXENAME='||bindir||'\MYSQLADMIN.EXE;PARAMETERS=shutdown;MINIMIZED=YES;STARTUPDIR='||basedir||shutdnicon, ,
			'ReplaceIfExists')

  rc = SysCreateObject(	'WPProgram', ,
			'Reload Grant tables', ,
			'<'folder.objid'>', ,
			'OBJECTID=<MYSQL_RELOAD>;EXENAME='||bindir||'\MYSQLADMIN.EXE;PARAMETERS=reload;MINIMIZED=YES;STARTUPDIR='||basedir||reloadicon, ,
			'ReplaceIfExists')

  rc = SysCreateObject(	'WPProgram', ,
			'MySQL Client', ,
			'<'folder.objid'>', ,
			'OBJECTID=<MYSQL_CLIENT>;EXENAME='||bindir||'\MYSQL.EXE;PARAMETERS=[Database for console];STARTUPDIR='||basedir||clienticon, ,
			'ReplaceIfExists')

  rc = SysCreateObject(	'WPProgram', ,
			'Create Database', ,
			'<'folder.objid'>', ,
			'OBJECTID=<MYSQL_CREATDB>;EXENAME='||bindir||'\MYSQLADMIN.EXE;PARAMETERS=create [Database to create];STARTUPDIR='||basedir||createicon, ,
			'ReplaceIfExists')

  rc = SysCreateObject(	'WPProgram', ,
			'Delete Database', ,
			'<'folder.objid'>', ,
			'OBJECTID=<MYSQL_DELETDB>;EXENAME='||bindir||'\MYSQLADMIN.EXE;PARAMETERS=drop [Database to create];STARTUPDIR='||basedir||dropicon, ,
			'ReplaceIfExists')

  rc = SysCreateObject(	'WPProgram', ,
			'MySQL Manual', ,
			'<'folder.objid'>', ,
			'OBJECTID=<MYSQL_MANUAL>;EXENAME=VIEW.EXE;PARAMETERS=MySQL;STARTUPDIR='||bookdir||bookicon||';', ,
			'ReplaceIfExists')

  rc = SysCreateObject(	'WPProgram', ,
			'README FIRST', ,
			'<'folder.objid'>', ,
			'OBJECTID=<MYSQL_README>;EXENAME=E.EXE;PARAMETERS='||basedir||'\README.1ST;',
			'ReplaceIfExists')

  CALL LineOut "STDERR:", "Checking database files"
  'bin\isamchk.exe -es data/mysql/db'
  'bin\isamchk.exe -es data/mysql/host'
  'bin\isamchk.exe -es data/mysql/user'
  'bin\isamchk.exe -es data/mysql/func'
  'bin\isamchk.exe -es data/mysql/tables_priv'
  'bin\isamchk.exe -es data/mysql/columns_priv'


END
ELSE DO

  PARSE PULL hostname
  IF hostname >< "" THEN
    CALL LineOut "STDERR:", "Found hostname as "||hostname
  ELSE DO
    CALL LineOut "STDERR:", "Using default hostname"
    hostname="localhost"
  END

  SAY "use mysql;"

  rc = SysFileTree(mdata||'\db.frm','test','F');
  IF test.0 <> 1 THEN DO
    CALL LineOut "STDERR:", "Creating db table"
    rc=    "CREATE TABLE db ("
    rc=rc||"  Host char(60) DEFAULT '' NOT NULL,"
    rc=rc||"  Db char(32) DEFAULT '' NOT NULL,"
    rc=rc||"  User char(16) DEFAULT '' NOT NULL,"
    rc=rc||"  Select_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Insert_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Update_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Delete_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Create_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Drop_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Grant_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  References_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Index_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Alter_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  PRIMARY KEY Host (Host,Db,User),"
    rc=rc||"  KEY User (User)"
    rc=rc||");"

    SAY rc
    SAY "INSERT INTO db VALUES ('%','test','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');"
    SAY "INSERT INTO db VALUES ('%','test\_%','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');"
  END

  rc = SysFileTree(mdata||'\host.frm','test','F');
  IF test.0 <> 1 THEN DO
    CALL LineOut "STDERR:", "Creating host table"
    rc=    "CREATE TABLE host ("
    rc=rc||"  Host char(60) DEFAULT '' NOT NULL,"
    rc=rc||"  Db char(32) DEFAULT '' NOT NULL,"
    rc=rc||"  Select_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Insert_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Update_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Delete_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Create_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Drop_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Grant_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  References_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Index_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Alter_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  PRIMARY KEY Host (Host,Db)"
    rc=rc||");"

    SAY rc
  END

  rc = SysFileTree(mdata||'\user.frm','test','F');
  IF test.0 <> 1 THEN DO
    CALL LineOut "STDERR:", "Creating user table"
    rc=    "CREATE TABLE user ("
    rc=rc||"  Host char(60) DEFAULT '' NOT NULL,"
    rc=rc||"  User char(16) DEFAULT '' NOT NULL,"
    rc=rc||"  Password char(16) DEFAULT '' NOT NULL,"
    rc=rc||"  Select_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Insert_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Update_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Delete_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Create_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Drop_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Reload_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Shutdown_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Process_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  File_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Grant_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  References_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Index_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  Alter_priv enum('N','Y') DEFAULT 'N' NOT NULL,"
    rc=rc||"  PRIMARY KEY Host (Host,User)"
    rc=rc||");"

    SAY rc

    SAY "INSERT INTO user VALUES ('localhost','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');"
    SAY "INSERT INTO user VALUES ('"||hostname||"','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');"

    SAY "REPLACE INTO user VALUES ('localhost','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');"
    SAY "REPLACE INTO user VALUES ('"||hostname||"','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');"
    
    SAY "INSERT INTO user VALUES ('localhost','','','N','N','N','N','N','N','N','N','N','N','N','N','N','N');"
    SAY "INSERT INTO user VALUES ('"||hostname||"','','','N','N','N','N','N','N','N','N','N','N','N','N','N','N');"
  END

  rc = SysFileTree(mdata||'\func.frm','test','F');
  IF test.0 <> 1 THEN DO
   CALL LineOut "STDERR:", "Creating func table"
   rc=    "CREATE TABLE func ("
   rc=rc||"  name char(64) DEFAULT '' NOT NULL,"
   rc=rc||"  ret tinyint(1) DEFAULT '0' NOT NULL,"
   rc=rc||"  dl char(128) DEFAULT '' NOT NULL,"
   rc=rc||"  type enum ('function','aggregate') NOT NULL,"
   rc=rc||"  PRIMARY KEY (name)"
   rc=rc||");"

   SAY rc
  END

  rc = SysFileTree(mdata||'\tables_priv.frm','test','F');
  IF test.0 <> 1 THEN DO
    CALL LineOut "STDERR:", "Creating tables_priv table"
    rc=    "CREATE TABLE tables_priv ("
    rc=rc||"  Host char(60) DEFAULT '' NOT NULL,"
    rc=rc||"  Db char(60) DEFAULT '' NOT NULL,"
    rc=rc||"  User char(16) DEFAULT '' NOT NULL,"
    rc=rc||"  Table_name char(60) DEFAULT '' NOT NULL,"
    rc=rc||"  Grantor char(77) DEFAULT '' NOT NULL,"
    rc=rc||"  Timestamp timestamp(14),"
    rc=rc||"  Table_priv set('Select','Insert','Update','Delete','Create','Drop','Grant','References','Index','Alter') DEFAULT '' NOT NULL,"
    rc=rc||"  Column_priv set('Select','Insert','Update','References') DEFAULT '' NOT NULL,"
    rc=rc||"  PRIMARY KEY (Host,Db,User,Table_name),"
    rc=rc||"  KEY Grantor (Grantor)"
    rc=rc||");"

    SAY rc
  END

  rc = SysFileTree(mdata||'\columns_priv.frm','test','F');
  IF test.0 <> 1 THEN DO
    CALL LineOut "STDERR:", "Creating column_priv table"
    rc=    "CREATE TABLE columns_priv ("
    rc=rc||"  Host char(60) DEFAULT '' NOT NULL,"
    rc=rc||"  Db char(60) DEFAULT '' NOT NULL,"
    rc=rc||"  User char(16) DEFAULT '' NOT NULL,"
    rc=rc||"  Table_name char(60) DEFAULT '' NOT NULL,"
    rc=rc||"  Column_name char(60) DEFAULT '' NOT NULL,"
    rc=rc||"  Timestamp timestamp(14),"
    rc=rc||"  Column_priv set('Select','Insert','Update','References') DEFAULT '' NOT NULL,"
    rc=rc||"  PRIMARY KEY (Host,Db,User,Table_name,Column_name)"
    rc=rc||");"

    SAY rc
  END

  CALL SysSleep 1
  SAY ""
  CALL LineOut "STDERR:", "Bootstrap complete"
  CALL SysSleep 1
  EXIT
END

SAY ""
SAY "Please ensure enough file handles are available for mySQL"
SAY "If not already done, please add the following to your CONFIG.SYS and reboot."
SAY "SET EMXOPT=-c -n -h1024"
SAY ""
IF dlfound >< "" THEN DO
  SAY "Please check that these dlls are current:"
  SAY "   "||dlfound
  SAY ""
END
SAY "PLEASE REMEMBER TO SET A PASSWORD FOR THE MySQL root USER !"
SAY "This is done with:"
SAY bindir||"\mysqladmin -u root password 'new-password'"
SAY "See the manual for more instructions."
EXIT

