/* install.cmd
 *
 * installation script for mSQL 2.x (OS/2)
 * installs all executables, libraries, headers and documentation in the
 * appropriate directory structure; creates an WPS folder with the files.
 *
 * syntax:  install [directory]
 * where 'directory' is a destination, e.g. C:\PUBLIC\MSQL
 * default: \public\mSQL
 *
 * (c) 1997 by Dirk Ohme
 *     1998 Yuri Dario <mc6530@mclink.it>
 */

/*---| includes |-------------------------------------------------------------*/
call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
call SysLoadFuncs

/*---| parameters |-----------------------------------------------------------*/
parse arg destDir
if destDir = "/?" | destDir = "-?" | destDir = "-h"
then do
  say "Usage: install [directory]"
  say
  say "where 'directory' is the place to install the files"
  exit
end
if destDir = ""
then do
  destDir = "\public\mSQL2"				/* standard installation directory */
end
if "" = filespec("Drive", destDir)
then do
  destDir = filespec("Drive", directory())||destDir	/* drive of actual directory = drive for installation */
end

/*---| replace '/' with '\' in path |-----------------------------------------*/
destDir = translate(destDir, "\\", "/")

/*---| set viewer and system editor |-----------------------------------------*/
editor = SysSearchPath("PATH", "e.exe")
viewer = SysSearchPath("PATH", "view.exe")

/*---| set source directory |-------------------------------------------------*/
sourceDir = directory()||"\"
if 0 < pos("msql-", sourceDir)
then do
  sourceDir = delstr(sourceDir, pos("\", sourceDir, pos("msql-", sourceDir)))
end
call directory(sourceDir)

/*---| intro |----------------------------------------------------------------*/
say
say "Starting install of mSQL 2.x for OS/2 software,"
say "using SOURCE='"sourceDir"' and DESTINATION='"destDir"'"

/*---| create directories |---------------------------------------------------*/
say "  creation of destination directories"
no=pos("\", destDir, 2)
do until no = 0
  say "   * "delstr(destDir, pos("\", destDir, no))
  call SysMkDir delstr(destDir, pos("\", destDir, no))
  no=pos("\", destDir, (no+1))
end
say "   * "destDir
call SysMkDir destDir
call SysMkDir destDir'\BIN'
call SysMkDir destDir'\DEMOS'
call SysMkDir destDir'\DOC'
call SysMkDir destDir'\INCLUDE'
call SysMkDir destDir'\LIB'
call SysMkDir destDir'\MSQLDB'
call SysMkDir destDir'\MSQLDB\.tmp'

/*---| bind icons to objects |------------------------------------------------*/
say "  bind icons to objects"
call SysSetIcon destDir || "\bin\lite.exe",        "icons\tool.ico"
call SysSetIcon destDir || "\bin\msql.exe",        "icons\msql.ico"
call SysSetIcon destDir || "\bin\msql2d.exe",      "icons\msql2d.ico"
call SysSetIcon destDir || "\bin\msqladmin.exe",   "icons\msqladmin.ico"
call SysSetIcon destDir || "\bin\msqldump.exe",    "icons\msqldump.ico"
call SysSetIcon destDir || "\bin\w3-auth.exe",     "icons\www.ico"
call SysSetIcon destDir || "\bin\w3-msql.exe",     "icons\www.ico"
call SysSetIcon destDir || "\bin\relshow.exe",     "icons\relshow.ico"

/*---| copy files |-----------------------------------------------------------*/
say "  copy files to destination"
'@copy /b bin\*                     'destDir'\bin\*      > nul'
'@copy /b include\*                 'destDir'\include\*  > nul'
'@copy /b lib\*                     'destDir'\lib\*      > nul'

/* overwrite dbstart.cmd and dbstop.cmd with installation values: */
'@echo @echo off                                       >  'destDir'\bin\dbStart.cmd'
'@echo set emxopt=-h256                                >> 'destDir'\bin\dbStart.cmd'
'@echo rem set msql_debug=general:query:error:         >> 'destDir'\bin\dbStart.cmd'
'@echo start /c /min /b "mSQL 2.0 for OS/2 Warp" 'destDir'\bin\msql2d            >> 'destDir'\bin\dbStart.cmd'
call SysSetIcon destDir"\bin\dbStart.cmd",         "icons\db_start.ico"
'@echo 'destDir'\bin\msqladmin shutdown                >  'destDir'\bin\dbStop.cmd'
call SysSetIcon destDir"\bin\dbStop.cmd",          "icons\db_stop.ico"

/*---| create configuration files |-------------------------------------------*/
say "  creating configuration files"
'@echo [general]                                       >  'destDir'\msql.conf'
'@echo inst_dir='destDir'                              >> 'destDir'\msql.conf'
'@echo admin_user=%USER%                               >> 'destDir'\msql.conf'
'@echo msql_user=%USER%                                >> 'destDir'\msql.conf'
'@echo pid_file='destDir'\bin\msql2.pid                >> 'destDir'\msql.conf'
'@echo tcp_port=1114                                   >> 'destDir'\msql.conf'
'@echo unix_port=\socket\msql2d.sock                   >> 'destDir'\msql.conf'
'@echo #timeout=10                                     >> 'destDir'\msql.conf'
'@echo [system]                                        >> 'destDir'\msql.conf'
'@echo host_lookup=false                               >> 'destDir'\msql.conf'
'@echo remote_access=true                              >> 'destDir'\msql.conf'
'@echo local_access=true                               >> 'destDir'\msql.conf'
'@echo msync_timer=30                                  >> 'destDir'\msql.conf'
'@echo [w3-msql]                                       >> 'destDir'\msql.conf'
'@echo #auth_host=localhost                            >> 'destDir'\msql.conf'
'@echo footer = false                                  >> 'destDir'\msql.conf'
'@echo.                                                >> 'destDir'\msql.conf'

'@echo database=test                                   >  'destDir'\msql.acl'
'@echo read=*                                          >> 'destDir'\msql.acl'
'@echo write=*                                         >> 'destDir'\msql.acl'
'@echo host=*                                          >> 'destDir'\msql.acl'
'@echo access=local,remote                             >> 'destDir'\msql.acl'
'@echo option=rfc931                                   >> 'destDir'\msql.acl'
'@echo.                                                >> 'destDir'\msql.acl'
'@echo database=*                                      >> 'destDir'\msql.acl'
'@echo read=*                                          >> 'destDir'\msql.acl'
'@echo write=%USER%                                    >> 'destDir'\msql.acl'
'@echo host=*                                          >> 'destDir'\msql.acl'
'@echo access=local,remote                             >> 'destDir'\msql.acl'
'@echo option=rfc931                                   >> 'destDir'\msql.acl'
'@echo.                                                >> 'destDir'\msql.acl'

/*---| create workplace shell objects |---------------------------------------*/
say "  creation of WPS folder 'mSQL-2'"
if SysCreateObject("WPFolder", "mSQL-2", "<WP_DESKTOP>",,
                   "OBJECTID=<WP_mSQL2>", "update")
then do
  say "   * folder created"
  if SysCreateObject("WPProgram", "Start Server", "<WP_mSQL2>",,
                     "EXENAME="destDir"\bin\dbStart.cmd",,
                     "update")
  then do
    say "   * msql2d (Start)"
  end
  if SysCreateObject("WPProgram", "Stop Server", "<WP_mSQL2>",,
                     "EXENAME="destDir"\bin\dbStop.cmd",,
                     "update")
  then do
    say "   * msql2d (Stop)"
  end
  if SysCreateObject("WPProgram", "local Monitor", "<WP_mSQL2>",,
                     "EXENAME="destDir"\bin\msql.exe;PARAMETERS=[database to use?]",,
                     "update")
  then do
    say "   * msql (local)"
  end
  if SysCreateObject("WPProgram", "remote Monitor", "<WP_mSQL2>",,
                     "EXENAME="destDir"\bin\msql.exe;PARAMETERS=-h [host?] [database to use?]",,
                     "update")
  then do
    say "   * msql (remote)"
  end
  if SysCreateObject("WPProgram", "Server Reload", "<WP_mSQL2>",,
                     "EXENAME="destDir"\bin\msqladmin.exe;PARAMETERS=reload",,
                     "update")
  then do
    say "   * msqladmin reload"
  end
  if SysCreateObject("WPProgram", "Create DB", "<WP_mSQL2>",,
                     "EXENAME="destDir"\bin\msqladmin.exe;PARAMETERS=create [database?]",,
                     "update")
  then do
    say "   * msqladm create"
  end
  if SysCreateObject("WPProgram", "Drop DB", "<WP_mSQL2>",,
                     "EXENAME="destDir"\bin\msqladmin.exe;PARAMETERS=drop [database?]",,
                     "update")
  then do
    say "   * msqladm drop"
  end
  if SysCreateObject("WPProgram", "Dump", "<WP_mSQL2>",,
                     "EXENAME="destDir"\bin\msqldump.exe;PARAMETERS=[database?]",,
                     "update")
  then do
    say "   * msqldump.exe"
  end
  if SysCreateObject("WPProgram", "Relations", "<WP_mSQL2>",,
                     "EXENAME="destDir"\bin\relshow.exe;PARAMETERS=[database?] [table?] [index?]",,
                     "update")
  then do
    say "   * relshow.exe"
  end
  if SysCreateObject("WPProgram", "Access Control List", "<WP_mSQL2>",,
                     "EXENAME="editor";PARAMETERS="destDir"\mSQL.acl",,
                     "update")
  then do
    say "   * mSQL.acl"
  end
  if SysCreateObject("WPProgram", "Configuration", "<WP_mSQL2>",,
                     "EXENAME="editor";PARAMETERS="destDir"\bin\mSQL.conf",,
                     "update")
  then do
    say "   * mSQL.conf"
  end
end

/*---| Save installation directory |------------------------------------------*/
call SysIni 'USER', 'MSQL2', 'INST_DIR', destDir

/*---| done |-----------------------------------------------------------------*/
say "done."
say ''
say ''
say '       DO NOT FORGET'
say '       ============='
say ''
say '1.  Move w3-msql.exe (updated version) to your cgi-bin directory.'
say '2.  To work properly with mSQL on your desktop append your config.sys or'
say '    startup.cmd with "SET USER=msqldba" (example)'
say '3.  Change the mSQL configuration: "msql_admin=msqldba"'
say ''

/*============================================================================*/
