Unit SSLeay32;
(* Copyright (C) 1995-1998 Eric Young (eay@cryptsoft.com)
  All rights reserved.

  This package is an SSL implementation written
  by Eric Young (eay@cryptsoft.com).
  The implementation was written so as to conform with Netscapes SSL.

  This library is free for commercial and non-commercial use as long as
  the following conditions are aheared to.  The following conditions
  apply to all code found in this distribution, be it the RC4, RSA,
  lhash, DES, etc., code; not just the SSL code.  The SSL documentation
  included with this distribution is covered by the same copyright terms
  except that the holder is Tim Hudson (tjh@cryptsoft.com).

  Copyright remains Eric Young's, and as such any Copyright notices in
  the code are not to be removed.
  If this package is used in a product, Eric Young should be given attribution
  as the author of the parts of the library used.
  This can be in the form of a textual message at program startup or
  in documentation (online or textual) provided with the package.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. All advertising materials mentioning features or use of this software
     must display the following acknowledgement:
     "This product includes cryptographic software written by
      Eric Young (eay@cryptsoft.com)"
     The word 'cryptographic' can be left out if the rouines from the library
     being used are not cryptographic related :-).
  4. If you include any Windows specific code (or a derivative thereof) from
     the apps directory (application code) you must include an acknowledgement:
     "This product includes software written by Tim Hudson (tjh@cryptsoft.com)"

  THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  The licence and distribution terms for any publically available version or
  derivative of this code cannot be changed.  i.e. this code cannot simply be
  copied and put under another distribution licence
  [including the GNU Public Licence.]
 *)
interface
uses Use32, LIBeay32;


type
  SSL_CIPHER		=^ssl_cipher_st;
  SSL_METHOD		=^ssl_method_st;
  SSL_COMPRESSION	=^ssl_compression_st;
  SSL_SESSION		=^ssl_session_st;
  SSL_CTX		=^ssl_ctx_st;
  SSL			=^ssl_st;
  SSL2_CTX		=^ssl2_ctx_st;
  SSL3_CTX		=^ssl3_ctx_st;

{&CDecl+}
{$I SSLeay32.INC}

function  BIO_f_ssl:BIO_METHOD;
function  BIO_new_ssl(ctx:SSL_CTX;client:Integer):BIO;
function  BIO_new_ssl_connect(ctx:SSL_CTX):BIO;
function  BIO_new_buffer_ssl_connect(ctx:SSL_CTX):BIO;
function  BIO_ssl_copy_session_id(bto,bfrom:BIO):Integer;
procedure BIO_ssl_shutdown(ssl_bio:BIO);

function  SSL_CTX_set_cipher_list(ctx:SSL_CTX;str:PChar):Integer;
function  SSL_CTX_new(meth:SSL_METHOD):SSL_CTX;
procedure SSL_CTX_free(ctx:SSL_CTX);
procedure SSL_CTX_flush_sessions(ctx:SSL_CTX;tm:LongInt);

function  SSL_get_current_cipher(s:SSL):SSL_CIPHER;
function  SSL_CIPHER_get_bits(c:SSL_CIPHER;var alg_bits:Integer):Integer;
function  SSL_CIPHER_get_version(c:SSL_CIPHER):PChar;
function  SSL_CIPHER_get_name(c:SSL_CIPHER):PChar;

function  SSL_get_fd(s:SSL):Integer;
function  SSL_get_cipher_list(s:SSL;n:Integer):PChar;
function  SSL_get_shared_ciphers(s:SSL;buf:PChar;len:Integer):PChar;
function  SSL_get_read_ahead(s:SSL):Integer;
function  SSL_pending(s:SSL):Integer;

function  SSL_set_fd(s:SSL;fd:Integer):Integer;
function  SSL_set_rfd(s:SSL;fd:Integer):Integer;
function  SSL_set_wfd(s:SSL;fd:Integer):Integer;

procedure SSL_set_bio(s:SSL;rbio,wbio:BIO);
function  SSL_get_rbio(s:SSL):BIO;
function  SSL_get_wbio(s:SSL):BIO;

function  SSL_set_cipher_list(s:SSL;str:PChar):Integer;
procedure SSL_set_read_ahead(s:SSL;yes:Integer);
function  SSL_get_verify_mode(s:SSL):Integer;
//int	  (*SSL_get_verify_callback(SSL *s))();
//void	  SSL_set_verify(SSL *s, int mode, int (*callback) ());
function  SSL_use_RSAPrivateKey(s:SSL;r:RSA):Integer;
function  SSL_use_RSAPrivateKey_ASN1(s:SSL;d:Pointer;len:Integer):Integer;
function  SSL_use_PrivateKey(s:SSL;pkey:EVP_PKEY):Integer;
function  SSL_use_PrivateKey_ASN1(pk:Integer;s:SSL;d:Pointer;len:LongInt):Integer;
function  SSL_use_certificate(s:SSL;x:X509):Integer;
function  SSL_use_certificate_ASN1(s:SSL;len:Integer;d:Pointer):Integer;

function  SSL_use_RSAPrivateKey_file(s:SSL;fname:PChar;typ:Integer):Integer;
function  SSL_use_PrivateKey_file(s:SSL;fname:PChar;typ:Integer):Integer;
function  SSL_use_certificate_file(s:SSL;fname:PChar;typ:Integer):Integer;
function  SSL_CTX_use_RSAPrivateKey_file(ctx:SSL_CTX;fname:PChar;typ:Integer):Integer;
function  SSL_CTX_use_PrivateKey_file(ctx:SSL_CTX;fname:PChar;typ:Integer):Integer;
function  SSL_CTX_use_certificate_file(ctx:SSL_CTX;fname:PChar;typ:Integer):Integer;
function  SSL_load_client_CA_file(fname:PChar):STACK;

procedure ERR_load_SSL_strings;
procedure SSL_load_error_strings;
function  SSL_state_string(s:SSL):PChar;
function  SSL_rstate_string(s:SSL):PChar;
function  SSL_state_string_long(s:SSL):PChar;
function  SSL_rstate_string_long(s:SSL):PChar;
function  SSL_SESSION_get_time(s:SSL_SESSION):LongInt;
function  SSL_SESSION_set_time(s:SSL_SESSION;t:LongInt):LongInt;
function  SSL_SESSION_get_timeout(s:SSL_SESSION):LongInt;
function  SSL_SESSION_set_timeout(s:SSL_SESSION;t:LongInt):LongInt;
procedure SSL_copy_session_id(sto,sfrom:SSL);

function  SSL_SESSION_new:SSL_SESSION;
function  SSL_SESSION_hash(a:SSL_SESSION):Cardinal;
function  SSL_SESSION_cmp(a,b:SSL_SESSION):Integer;

//function  SSL_SESSION_print_fp(FILE *fp,SSL_SESSION *ses):Integer;

function  SSL_SESSION_print(bp:BIO;ses:SSL_SESSION):Integer;

procedure SSL_SESSION_free(ses:SSL_SESSION);
function  i2d_SSL_SESSION(s:SSL_SESSION;var pp:Pointer):Integer;
function  SSL_set_session(s:SSL;session:SSL_SESSION):Integer;
function  SSL_CTX_add_session(ctx:SSL_CTX;ses:SSL_SESSION):Integer;
function  SSL_CTX_remove_session(ctx:SSL_CTX;ses:SSL_SESSION):Integer;
function  d2i_SSL_SESSION(var ses:SSL_SESSION;var pp:Pointer;length:LongInt):SSL_SESSION;

function  SSL_get_peer_certificate(s:SSL):X509;

function  SSL_get_peer_cert_chain(s:SSL):STACK;

function  SSL_CTX_get_verify_mode(ctx:SSL_CTX):Integer;
//int (*SSL_CTX_get_verify_callback(SSL_CTX *ctx))();
//void SSL_CTX_set_verify(SSL_CTX *ctx,int mode,int (*callback)());
//void SSL_CTX_set_cert_verify_cb(SSL_CTX *ctx, int (*cb)(),char *arg);
function  SSL_CTX_use_RSAPrivateKey(ctx:SSL_CTX;r:RSA):Integer;
function  SSL_CTX_use_RSAPrivateKey_ASN1(ctx:SSL_CTX;d:Pointer;len:LongInt):Integer;
function  SSL_CTX_use_PrivateKey(ctx:SSL_CTX;pkey:EVP_PKEY):Integer;
function  SSL_CTX_use_PrivateKey_ASN1(pk:Integer;ctx:SSL_CTX;d:Pointer;len:LongInt):Integer;
function  SSL_CTX_use_certificate(ctx:SSL_CTX;x:X509):Integer;
function  SSL_CTX_use_certificate_ASN1(ctx:SSL_CTX;len:Integer;d:Pointer):Integer;

//void SSL_CTX_set_default_passwd_cb(SSL_CTX *ctx,int (*cb)());

function  SSL_CTX_check_private_key(ctx:SSL_CTX):Integer;
function  SSL_check_private_key(s:SSL):Integer;

function  SSL_new(ctx:SSL_CTX):SSL;
procedure SSL_clear(s:SSL);
procedure SSL_free(s:SSL);
function  SSL_accept(s:SSL):Integer;
function  SSL_connect(s:SSL):Integer;
function  SSL_read(s:SSL;var buf;num:Integer):Integer;
function  SSL_peek(s:SSL;var buf;num:Integer):Integer;
function  SSL_write(s:SSL;var buf;num:Integer):Integer;
function  SSL_ctrl(s:SSL;cmd:Integer;larg:LongInt;parg:Pointer):LongInt;
function  SSL_CTX_ctrl(ctx:SSL_CTX;cmd:Integer;larg:LongInt;parg:Pointer):LongInt;

function  SSL_get_error(s:SSL;ret_code:Integer):Integer;
function  SSL_get_version(s:SSL):PChar;

function  SSL_CTX_set_ssl_version(ctx:SSL_CTX;meth:SSL_METHOD):Integer;

function  SSLv2_method:SSL_METHOD;
function  SSLv2_server_method:SSL_METHOD;
function  SSLv2_client_method:SSL_METHOD;

function  SSLv3_method:SSL_METHOD;
function  SSLv3_server_method:SSL_METHOD;
function  SSLv3_client_method:SSL_METHOD;

function  SSLv23_method:SSL_METHOD;
function  SSLv23_server_method:SSL_METHOD;
function  SSLv23_client_method:SSL_METHOD;

function  TLSv1_method:SSL_METHOD;
function  TLSv1_server_method:SSL_METHOD;
function  TLSv1_client_method:SSL_METHOD;

function  SSL_get_ciphers(s:SSL):STACK;

function  SSL_do_handshake(s:SSL):Integer;
function  SSL_renegotiate(s:SSL):Integer;
function  SSL_shutdown(s:SSL):Integer;

function  SSL_get_ssl_method(s:SSL):SSL_METHOD;
function  SSL_set_ssl_method(s:SSL;method:SSL_METHOD):Integer;
function  SSL_alert_type_string_long(value:Integer):PChar;
function  SSL_alert_type_string(value:Integer):PChar;
function  SSL_alert_desc_string_long(value:Integer):PChar;
function  SSL_alert_desc_string(value:Integer):PChar;

procedure SSL_set_client_CA_list(s:SSL;list:STACK);
procedure SSL_CTX_set_client_CA_list(ctx:SSL_CTX;list:STACK);
function  SSL_get_client_CA_list(s:SSL):STACK;
function  SSL_CTX_get_client_CA_list(ctx:SSL_CTX):STACK;
function  SSL_add_client_CA(s:SSL;x:X509):Integer;
function  SSL_CTX_add_client_CA(ctx:SSL_CTX;x:X509):Integer;

procedure SSL_set_connect_state(s:SSL);
procedure SSL_set_accept_state(s:SSL);

function  SSL_get_default_timeout(s:SSL):LongInt;

procedure SSLeay_add_ssl_algorithms;

function  SSL_CIPHER_description(cipher:SSL_CIPHER;buf:PChar;size:Integer):PChar;
function  SSL_dup_CA_list(sk:STACK):STACK;

function  SSL_dup(s:SSL):SSL;

function  SSL_get_certificate(s:SSL):X509;
function  SSL_get_privatekey(s:SSL):EVP_PKEY;

procedure SSL_CTX_set_quiet_shutdown(ctx:SSL_CTX;mode:Integer);
function  SSL_CTX_get_quiet_shutdown(ctx:SSL_CTX):Integer;
procedure SSL_set_quiet_shutdown(s:SSL;mode:Integer);
function  SSL_get_quiet_shutdown(s:SSL):Integer;
procedure SSL_set_shutdown(s:SSL;mode:Integer);
function  SSL_get_shutdown(s:SSL):Integer;
function  SSL_version(s:SSL):Integer;
function  SSL_CTX_set_default_verify_paths(ctx:SSL_CTX):Integer;
function  SSL_CTX_load_verify_locations(ctx:SSL_CTX;CAfile,CApath:PChar):Integer;
function  SSL_get_session(s:SSL):SSL_SESSION;
function  SSL_get_SSL_CTX(s:SSL):SSL_CTX;
//void SSL_set_info_callback(SSL *ssl,void (*cb)());
//void (*SSL_get_info_callback(SSL *ssl))();
function  SSL_state(s:SSL):Integer;

procedure SSL_set_verify_result(s:SSL;v:LongInt);
function  SSL_get_verify_result(s:SSL):LongInt;

function  SSL_set_ex_data(s:SSL;idx:Integer;data:PChar):Integer;
function  SSL_get_ex_data(s:SSL;idx:Integer):PChar;
//int SSL_get_ex_new_index(long argl, char *argp, int (*new_func)(),
//	  int (*dup_func)(), void (*free_func)());

function  SSL_SESSION_set_ex_data(ses:SSL_SESSION;idx:Integer;data:Pointer):Integer;
function  SSL_SESSION_get_ex_data(ses:SSL_SESSION;idx:Integer):PChar;
//int SSL_SESSION_get_ex_new_index(long argl, char *argp, int (*new_func)(),
//	  int (*dup_func)(), void (*free_func)());

function  SSL_CTX_set_ex_data(ctx:SSL_CTX;idx:Integer;data:Pointer):Integer;
function  SSL_CTX_get_ex_data(ctx:SSL_CTX;idx:Integer):PChar;
//int SSL_CTX_get_ex_new_index(long argl, char *argp, int (*new_func)(),
//	  int (*dup_func)(), void (*free_func)());

{&CDecl-}

const
  BIO_C_SET_SSL 	= 109;

function BIO_set_ssl(b:BIO;s:SSL;doclose:Integer):LongInt; inline;
begin Result := BIO_ctrl(b,BIO_C_SET_SSL,doclose,s) end;


implementation

procedure SSLeay_add_ssl_algorithms;		external 'SSLEAY32' index  109;

function  BIO_f_ssl;				external 'SSLEAY32' index  121;
function  BIO_new_buffer_ssl_connect;		external 'SSLEAY32' index  173;
function  BIO_new_ssl;				external 'SSLEAY32' index  122;
function  BIO_new_ssl_connect;			external 'SSLEAY32' index  174;
function  BIO_ssl_copy_session_id;		external 'SSLEAY32' index  124;
procedure BIO_ssl_shutdown;			external 'SSLEAY32' index  131;

procedure ERR_load_SSL_strings; 		external 'SSLEAY32' index    1;

function  SSL_CIPHER_description;		external 'SSLEAY32' index    2;
function  SSL_CIPHER_get_bits;			external 'SSLEAY32' index  128;
function  SSL_CIPHER_get_name;			external 'SSLEAY32' index  130;
function  SSL_CIPHER_get_version;		external 'SSLEAY32' index  129;

function  SSL_CTX_add_client_CA;		external 'SSLEAY32' index    3;
function  SSL_CTX_add_session;			external 'SSLEAY32' index    4;
function  SSL_CTX_check_private_key;		external 'SSLEAY32' index    5;
function  SSL_CTX_ctrl; 			external 'SSLEAY32' index    6;
procedure SSL_CTX_flush_sessions;		external 'SSLEAY32' index    7;
procedure SSL_CTX_free; 			external 'SSLEAY32' index    8;
function  SSL_CTX_get_client_CA_list;		external 'SSLEAY32' index    9;
function  SSL_CTX_get_ex_data;			external 'SSLEAY32' index  138;
//function  SSL_CTX_get_ex_new_index;		  external 'SSLEAY32' index  167;
function  SSL_CTX_get_quiet_shutdown;		external 'SSLEAY32' index  140;
//function  SSL_CTX_get_verify_callback;	  external 'SSLEAY32' index   10;
function  SSL_CTX_get_verify_mode;		external 'SSLEAY32' index   11;
function  SSL_CTX_load_verify_locations;	external 'SSLEAY32' index  141;
function  SSL_CTX_new;				external 'SSLEAY32' index   12;
function  SSL_CTX_remove_session;		external 'SSLEAY32' index   13;
procedure SSL_CTX_set_cert_verify_cb;		external 'SSLEAY32' index   14;
function  SSL_CTX_set_cipher_list;		external 'SSLEAY32' index   15;
procedure SSL_CTX_set_client_CA_list;		external 'SSLEAY32' index   16;
procedure SSL_CTX_set_default_passwd_cb;	external 'SSLEAY32' index   17;
function  SSL_CTX_set_default_verify_paths;	external 'SSLEAY32' index  142;
function  SSL_CTX_set_ex_data;			external 'SSLEAY32' index  143;
procedure SSL_CTX_set_quiet_shutdown;		external 'SSLEAY32' index  145;
function  SSL_CTX_set_ssl_version;		external 'SSLEAY32' index   19;
procedure SSL_CTX_set_verify;			external 'SSLEAY32' index   21;
function  SSL_CTX_use_PrivateKey;		external 'SSLEAY32' index   22;
function  SSL_CTX_use_PrivateKey_ASN1;		external 'SSLEAY32' index   23;
function  SSL_CTX_use_PrivateKey_file;		external 'SSLEAY32' index   24;
function  SSL_CTX_use_RSAPrivateKey;		external 'SSLEAY32' index   25;
function  SSL_CTX_use_RSAPrivateKey_ASN1;	external 'SSLEAY32' index   26;
function  SSL_CTX_use_RSAPrivateKey_file;	external 'SSLEAY32' index   27;
function  SSL_CTX_use_certificate;		external 'SSLEAY32' index   28;
function  SSL_CTX_use_certificate_ASN1; 	external 'SSLEAY32' index   29;
function  SSL_CTX_use_certificate_file; 	external 'SSLEAY32' index   30;

function  SSL_SESSION_cmp;			external 'SSLEAY32' index  132;
procedure SSL_SESSION_free;			external 'SSLEAY32' index   31;
function  SSL_SESSION_get_ex_data;		external 'SSLEAY32' index  146;
//function  SSL_SESSION_get_ex_new_index;	  external 'SSLEAY32' index  168;
function  SSL_SESSION_get_time; 		external 'SSLEAY32' index  134;
function  SSL_SESSION_get_timeout;		external 'SSLEAY32' index  136;
function  SSL_SESSION_hash;			external 'SSLEAY32' index  133;
function  SSL_SESSION_new;			external 'SSLEAY32' index   32;
function  SSL_SESSION_print;			external 'SSLEAY32' index   33;
//function  SSL_SESSION_print_fp;		  external 'SSLEAY32' index   34;
function  SSL_SESSION_set_ex_data;		external 'SSLEAY32' index  148;
function  SSL_SESSION_set_time; 		external 'SSLEAY32' index  135;
function  SSL_SESSION_set_timeout;		external 'SSLEAY32' index  137;

function  SSL_accept;				external 'SSLEAY32' index   35;
function  SSL_add_client_CA;			external 'SSLEAY32' index   36;
function  SSL_alert_desc_string;		external 'SSLEAY32' index   37;
function  SSL_alert_desc_string_long;		external 'SSLEAY32' index   38;
function  SSL_alert_type_string;		external 'SSLEAY32' index   39;
function  SSL_alert_type_string_long;		external 'SSLEAY32' index   40;
function  SSL_check_private_key;		external 'SSLEAY32' index   41;
procedure SSL_clear;				external 'SSLEAY32' index   42;
function  SSL_connect;				external 'SSLEAY32' index   43;
procedure SSL_copy_session_id;			external 'SSLEAY32' index   44;
function  SSL_ctrl;				external 'SSLEAY32' index   45;
function  SSL_do_handshake;			external 'SSLEAY32' index  125;
function  SSL_dup;				external 'SSLEAY32' index   46;
function  SSL_dup_CA_list;			external 'SSLEAY32' index   47;
procedure SSL_free;				external 'SSLEAY32' index   48;
function  SSL_get_SSL_CTX;			external 'SSLEAY32' index  150;
function  SSL_get_certificate;			external 'SSLEAY32' index   49;
function  SSL_get_cipher_list;			external 'SSLEAY32' index   52;
function  SSL_get_ciphers;			external 'SSLEAY32' index   55;
function  SSL_get_client_CA_list;		external 'SSLEAY32' index   56;
function  SSL_get_current_cipher;		external 'SSLEAY32' index  127;
function  SSL_get_default_timeout;		external 'SSLEAY32' index   57;
function  SSL_get_error;			external 'SSLEAY32' index   58;
function  SSL_get_ex_data;			external 'SSLEAY32' index  151;
//function  SSL_get_ex_new_index;		  external 'SSLEAY32' index  169;
function  SSL_get_fd;				external 'SSLEAY32' index   59;
//function  SSL_get_info_callback;		  external 'SSLEAY32' index  165;
function  SSL_get_peer_cert_chain;		external 'SSLEAY32' index   60;
function  SSL_get_peer_certificate;		external 'SSLEAY32' index   61;
function  SSL_get_privatekey;			external 'SSLEAY32' index  126;
function  SSL_get_quiet_shutdown;		external 'SSLEAY32' index  153;
function  SSL_get_rbio; 			external 'SSLEAY32' index   63;
function  SSL_get_read_ahead;			external 'SSLEAY32' index   64;
function  SSL_get_session;			external 'SSLEAY32' index  154;
function  SSL_get_shared_ciphers;		external 'SSLEAY32' index   65;
function  SSL_get_shutdown;			external 'SSLEAY32' index  155;
function  SSL_get_ssl_method;			external 'SSLEAY32' index   66;
function  SSL_get_verify_mode;			external 'SSLEAY32' index   70;
function  SSL_get_verify_result;		external 'SSLEAY32' index  157;
function  SSL_get_version;			external 'SSLEAY32' index   71;
function  SSL_get_wbio; 			external 'SSLEAY32' index   72;
function  SSL_load_client_CA_file;		external 'SSLEAY32' index   73;
procedure SSL_load_error_strings;		external 'SSLEAY32' index   74;
function  SSL_new;				external 'SSLEAY32' index   75;
function  SSL_peek;				external 'SSLEAY32' index   76;
function  SSL_pending;				external 'SSLEAY32' index   77;
function  SSL_read;				external 'SSLEAY32' index   78;
function  SSL_renegotiate;			external 'SSLEAY32' index   79;
function  SSL_rstate_string;			external 'SSLEAY32' index   80;
function  SSL_rstate_string_long;		external 'SSLEAY32' index   81;
procedure SSL_set_accept_state; 		external 'SSLEAY32' index   82;
procedure SSL_set_bio;				external 'SSLEAY32' index   83;
function  SSL_set_cipher_list;			external 'SSLEAY32' index   84;
procedure SSL_set_client_CA_list;		external 'SSLEAY32' index   85;
procedure SSL_set_connect_state;		external 'SSLEAY32' index   86;
function  SSL_set_ex_data;			external 'SSLEAY32' index  158;
function  SSL_set_fd;				external 'SSLEAY32' index   87;
//procedure SSL_set_info_callback;		  external 'SSLEAY32' index  160;
procedure SSL_set_quiet_shutdown;		external 'SSLEAY32' index  161;
procedure SSL_set_read_ahead;			external 'SSLEAY32' index   88;
function  SSL_set_rfd;				external 'SSLEAY32' index   89;
function  SSL_set_session;			external 'SSLEAY32' index   90;
procedure SSL_set_shutdown;			external 'SSLEAY32' index  162;
function  SSL_set_ssl_method;			external 'SSLEAY32' index   91;
//procedure SSL_set_verify;			  external 'SSLEAY32' index   94;
procedure SSL_set_verify_result;		external 'SSLEAY32' index  163;
function  SSL_set_wfd;				external 'SSLEAY32' index   95;
function  SSL_shutdown; 			external 'SSLEAY32' index   96;
function  SSL_state;				external 'SSLEAY32' index  166;
function  SSL_state_string;			external 'SSLEAY32' index   97;
function  SSL_state_string_long;		external 'SSLEAY32' index   98;
function  SSL_use_PrivateKey;			external 'SSLEAY32' index   99;
function  SSL_use_PrivateKey_ASN1;		external 'SSLEAY32' index  100;
function  SSL_use_PrivateKey_file;		external 'SSLEAY32' index  101;
function  SSL_use_RSAPrivateKey;		external 'SSLEAY32' index  102;
function  SSL_use_RSAPrivateKey_ASN1;		external 'SSLEAY32' index  103;
function  SSL_use_RSAPrivateKey_file;		external 'SSLEAY32' index  104;
function  SSL_use_certificate;			external 'SSLEAY32' index  105;
function  SSL_use_certificate_ASN1;		external 'SSLEAY32' index  106;
function  SSL_use_certificate_file;		external 'SSLEAY32' index  107;
function  SSL_version;				external 'SSLEAY32' index  164;
function  SSL_write;				external 'SSLEAY32' index  108;

function  SSLv23_client_method; 		external 'SSLEAY32' index  110;
function  SSLv23_method;			external 'SSLEAY32' index  111;
function  SSLv23_server_method; 		external 'SSLEAY32' index  112;

function  SSLv2_client_method;			external 'SSLEAY32' index  113;
function  SSLv2_method; 			external 'SSLEAY32' index  114;
function  SSLv2_server_method;			external 'SSLEAY32' index  115;

function  SSLv3_client_method;			external 'SSLEAY32' index  116;
function  SSLv3_method; 			external 'SSLEAY32' index  117;
function  SSLv3_server_method;			external 'SSLEAY32' index  118;

function  TLSv1_client_method;			external 'SSLEAY32' index  172;
function  TLSv1_method; 			external 'SSLEAY32' index  170;
function  TLSv1_server_method;			external 'SSLEAY32' index  171;

function  d2i_SSL_SESSION;			external 'SSLEAY32' index  119;
function  i2d_SSL_SESSION;			external 'SSLEAY32' index  120;

end.

