  CERT			=^cert_st;
  ssl_cipher_st 	= record
    valid		: Integer;
    name		: PChar;
    id			: Cardinal;
    algorithms		: Cardinal;
    algorithm2		: Cardinal;
    mask		: Cardinal;
  end;

  ssl_method_st 	= record
    version		: Integer;
    ssl_new		: Pointer;	//	  int (*ssl_new)();
    ssl_clear		: Pointer;	//	  void (*ssl_clear)();
    ssl_free		: Pointer;	//	  void (*ssl_free)();
    ssl_accept		: Pointer;	//	  int (*ssl_accept)();
    ssl_connect 	: Pointer;	//	  int (*ssl_connect)();
    ssl_read		: Pointer;	//	  int (*ssl_read)();
    ssl_peek		: Pointer;	//	  int (*ssl_peek)();
    ssl_write		: Pointer;	//	  int (*ssl_write)();
    ssl_shutdown	: Pointer;	//	  int (*ssl_shutdown)();
    ssl_renegotiate	: Pointer;	//	  int (*ssl_renegotiate)();
    ssl_ctrl		: Pointer;	//	  long (*ssl_ctrl)();
    ssl_ctx_ctrl	: Pointer;	//	  long (*ssl_ctx_ctrl)();
    get_cipher_by_char	: Pointer;	//	  SSL_CIPHER *(*get_cipher_by_char)();
    put_cipher_by_char	: Pointer;	//	  int (*put_cipher_by_char)();
    ssl_pending 	: Pointer;	//	  int (*ssl_pending)();
    num_ciphers 	: Pointer;	//	  int (*num_ciphers)();
    get_cipher		: Pointer;	//	  SSL_CIPHER *(*get_cipher)();
    get_ssl_method	: Pointer;	//	  struct ssl_method_st *(*get_ssl_method)();
    get_timeout 	: Pointer;	//	  long (*get_timeout)();
    ssl3_end		: Pointer;	//	  struct ssl3_enc_method *ssl3_enc;*)
  end;

  ssl_compression_st	= record
    stuff		: PChar;
  end;

  ssl_session_st	= record
    ssl_version 	: Integer;

    key_arg_length	: Word;
    key_arg		: Array[0..7] of Byte;
    master_key_length	: Integer;
    master_key		: Array[0..47] of Byte;

    session_id_length	: Word;
    session_id		: Array[0..31] of Byte;

    not_resumable	: Integer;

    cert		: CERT;

    peer		: X509;

    references		: Integer;
    timeout		: LongInt;
    time		: LongInt;

    read_compression	: SSL_COMPRESSION;
    write_compression	: SSL_COMPRESSION;

    cipher		: SSL_CIPHER;
    cipher_id		: Cardinal;

    ciphers		: STACK;

    ex_data		: CRYPTO_EX_DATA;

    prev, next		: SSL_SESSION;
  end;

  ssl_ctx_st		= record
    method		: SSL_METHOD;
    options		: Cardinal;

    cipher_list 	: STACK;

    cipher_list_by_id	: STACK;

    cert_store		: X509_STORE;
    sessions		: LHASH;

    session_cache_size	: Cardinal;
    session_cache_head	: SSL_SESSION;
    session_cache_tail	: SSL_SESSION;

    session_cache_mode	: Integer;

    session_timeout	: LongInt;

    new_session_cb	: Pointer;	//    int (*new_session_cb)(struct ssl_st *ssl,SSL_SESSION *sess);
    remove_session_cb	: Pointer;	//    void (*remove_session_cb)(struct ssl_ctx_st *ctx,SSL_SESSION *sess);
    get_session_cb	: Pointer;	//    SSL_SESSION *(*get_session_cb)(struct ssl_st *ssl,
					//		      unsigned char *data,int len,int *copy);

    sess_connect	: Integer;
    sess_connect_renegotiate:Integer;
    sess_connect_good	: Integer;
    sess_accept 	: Integer;
    sess_accept_renegotiate:Integer;
    sess_accept_good	: Integer;
    sess_miss		: Integer;
    sess_timeout	: Integer;
    sess_cache_full	: Integer;
    sess_hit		: Integer;
    sess_cb_hit 	: Integer;

    references		: Integer;

    info_callback	: Pointer;	//    void (*info_callback)();

    app_verify_callback : Pointer;	//    int (*app_verify_callback)();
    app_verify_arg	: Pointer;

    default_cert	: CERT;
    default_read_ahead	: Integer;
    default_verify_mode : Integer;
    default_verify_callback:Pointer;	//    int (*default_verify_callback)();

    default_passwd_callback:Pointer;	//    int (*default_passwd_callback)();

    client_cert_cb	: Pointer;	//    int (*client_cert_cb)( );*)

    client_CA		: STACK;

    quiet_shutdown	: Integer;

    ex_data		: CRYPTO_EX_DATA;

    rsa_md5		: EVP_MD;
    md5 		: EVP_MD;
    sha1		: EVP_MD;
  end;

  ssl_st		= record
    version		: Integer;
    typ 		: Integer;

    method		: SSL_METHOD;

    rbio		: BIO;
    wbio		: BIO;
    bbio		: BIO;

    rwstate		: Integer;

    in_handshake	: Integer;
    handshake_func	: Pointer;	//    int (*handshake_func)();

    new_session 	: Integer;
    quiet_shutdown	: Integer;
    shutdown		: Integer;

    state		: Integer;
    rstate		: Integer;

    init_buf		: BUF_MEM;
    init_num		: Integer;
    init_off		: Integer;

    packet		: Pointer;
    packet_length	: Word;

    s2			: SSL2_CTX;
    s3			: SSL3_CTX;

    read_ahead		: Integer;
    hit 		: Integer;

    cipher_list 	: STACK;
    cipher_list_by_id	: STACK;

    enc_read_ctx	:^EVP_CIPHER_CTX;
    read_hash		: EVP_MD;
    read_compression	: SSL_COMPRESSION;

    enc_write_ctx	:^EVP_CIPHER_CTX;
    write_hash		: EVP_MD;
    write_compression	: SSL_COMPRESSION;

    cert		: CERT;

    session		: SSL_SESSION;

    verify_mode 	: Integer;

    verify_callback	: Pointer;	//    int (*verify_callback)();
    info_callback	: Pointer;	//    void (*info_callback)();

    error		: Integer;
    error_code		: Integer;

    ctx 		: SSL_CTX;

    debug		: Integer;

    verify_result	: LongInt;
    ex_data		: CRYPTO_EX_DATA;

    client_CA		: STACK;

    references		: Integer;
    options		: Cardinal;
    first_packet	: Integer;
  end;

  ssl2_ctx_st		= record
    three_byte_header	: Integer;
    clear_text		: Integer;
    escape		: Integer;
    ssl2_rollback	: Integer;

    wnum		: Word;
    wpend_tot		: Integer;
    wpend_buf		: PChar;

    wpend_off		: Integer;
    wpend_len		: Integer;
    wpend_ret		: Integer;

    rbuf_left		: Integer;
    rbuf_offs		: Integer;
    rbuf		: Pointer;
    wbuf		: Pointer;

    write_ptr		: Pointer;

    padding		: Word;
    rlength		: Word;
    ract_data_length	: Integer;
    wlength		: Word;
    wact_data_length	: Integer;
    ract_data		: Pointer;
    wact_data		: Pointer;
    mac_data		: Pointer;
    pad_data		: Pointer;

    read_key		: Pointer;
    write_key		: Pointer;

    challenge_length	: Word;
    challenge		: Array[0..31] of Byte;
    conn_id_length	: Word;
    conn_id		: Array[0..15] of Byte;
    key_material_length : Word;
    key_material	: Array[0..24*2-1] of Byte;

    read_sequence	: Cardinal;
    write_sequence	: Cardinal;

    tmp 		: record
      conn_id_length	: Word;
      cert_type 	: Word;
      cert_length	: Word;
      csl		: Integer;
      clear		: Integer;
      enc		: Word;
      ccl		: Array[0..31] of Byte;
      cipher_spec_length: Integer;
      session_id_length : Word;
      clen		: Word;
      rlen		: Word;
    end;
  end;

  ssl3_record_st	= record
    typ 		: Integer;

    length		: Word;
    off 		: Word;
    data		: Pointer;
    input		: Pointer;
    comp		: Pointer;
  end;
  SSL3_RECORD		= ssl3_record_st;

  ssl3_buffer_st	= record
    total		: Integer;
    wanted		: Integer;
    left		: Integer;
    offset		: Integer;
    buf 		: Pointer;
  end;
  SSL3_BUFFER		= ssl3_buffer_st;

  ssl3_compression_st	= record
    nothing		: Integer;
  end;
  SSL3_COMPRESSION	= ssl3_compression_st;

  ssl3_ctx_st		= record
    flags		: LongInt;
    delay_buf_pop_ret	: Integer;

    read_sequence	: Array[0..7] of Byte;
    read_mac_secret	: Array[0..(16+20)-1] of Byte;
    write_sequence	: Array[0..7] of Byte;
    write_mac_secret	: Array[0..(16+20)-1] of Byte;

    server_random	: Array[0..31] of Byte;
    client_random	: Array[0..31] of Byte;

    rbuf		: SSL3_BUFFER;
    wbuf		: SSL3_BUFFER;
    rrec		: SSL3_RECORD;
    wrec		: SSL3_RECORD;

    wnum		: Word;
    wpend_tot		: Integer;
    wpend_type		: Integer;
    wpend_ret		: Integer;
    wpend_buf		: PChar;

    finish_dgst1	: EVP_MD_CTX;
    finish_dgst2	: EVP_MD_CTX;

    change_cipher_spec	: Integer;

    warn_alert		: Integer;
    fatal_alert 	: Integer;

    alert_dispatch	: Integer;
    send_alert		: Array[0..1] of Char;

    renegotiate 	: Integer;
    total_renegotiations: Integer;
    num_renegotiations	: Integer;

    in_read_app_data	: Integer;

    tmp 		: record
      finish_md 	: Array[0..(16+20)*2-1] of Byte;

      message_size	: Cardinal;
      message_type	: Integer;

      new_cipher	: SSL_CIPHER;
      dh		: DH;

      next_state	: Integer;

      reuse_message	: Integer;

      cert_req		: Integer;
      ctype_num 	: Integer;
      ctype		: Array[0..6] of Char;
      ca_names		: STACK;

      use_rsa_tmp	: Integer;

      key_block_length	: Integer;
      key_block 	: Pointer;

      new_sym_enc	: EVP_CIPHER;
      new_hash		: EVP_MD;
      new_compression	: SSL_COMPRESSION;
      cert_request	: Integer;
    end;
  end;

  cert_st		= record
  end;

