Unit LIBeay32;
(* Copyright (C) 1995-1998 Eric Young (eay@cryptsoft.com)
  All rights reserved.

  This package is an SSL implementation written
  by Eric Young (eay@cryptsoft.com).
  The implementation was written so as to conform with Netscapes SSL.

  This library is free for commercial and non-commercial use as long as
  the following conditions are aheared to.  The following conditions
  apply to all code found in this distribution, be it the RC4, RSA,
  lhash, DES, etc., code; not just the SSL code.  The SSL documentation
  included with this distribution is covered by the same copyright terms
  except that the holder is Tim Hudson (tjh@cryptsoft.com).

  Copyright remains Eric Young's, and as such any Copyright notices in
  the code are not to be removed.
  If this package is used in a product, Eric Young should be given attribution
  as the author of the parts of the library used.
  This can be in the form of a textual message at program startup or
  in documentation (online or textual) provided with the package.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. All advertising materials mentioning features or use of this software
     must display the following acknowledgement:
     "This product includes cryptographic software written by
      Eric Young (eay@cryptsoft.com)"
     The word 'cryptographic' can be left out if the rouines from the library
     being used are not cryptographic related :-).
  4. If you include any Windows specific code (or a derivative thereof) from
     the apps directory (application code) you must include an acknowledgement:
     "This product includes software written by Tim Hudson (tjh@cryptsoft.com)"

  THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  The licence and distribution terms for any publically available version or
  derivative of this code cannot be changed.  i.e. this code cannot simply be
  copied and put under another distribution licence
  [including the GNU Public Licence.]
 *)
interface
uses Use32;

const
  _CRYPTO_NUM_LOCKS	= 21;
  _CRYPTO_LOCK		= 1;
  _CRYPTO_UNLOCK	= 2;
  _CRYPTO_READ		= 4;
  _CRYPTO_WRITE 	= 8;

type
  PHOSTENT		= Pointer;
  PPChar		=^PChar;
  BUF_MEM		=^buf_mem_st;
  STACK 		=^stack_st;
  LHASH_NODE		=^lhash_node_st;
  LHASH 		=^lhash_st;
  ERR_STATE		=^err_state_st;
  ERR_STRING_DATA	=^ERR_string_data_st;
  BIGNUM		=^bignum_st;
  BN_CTX		=^bignum_ctx;
  BN_BLINDING		=^bn_blinding_st;
  BN_MONT_CTX		=^bn_mont_ctx_st;
  DH			=^dh_st;
  RSA_METHOD		=^rsa_meth_st;
  RSA			=^rsa_st;
  DSA			=^dsa_st;
  TXT_DB		=^txt_db_st;
  BIO_METHOD		=^bio_method_st;
  BIO			=^bio_st;
  BIO_F_BUFFER_CTX	=^bio_f_buffer_ctx_struct;
  ASN1_CTX		=^asn1_ctx_st;
  ASN1_OBJECT		=^asn1_object_st;
  ASN1_STRING		=^asn1_string_st;
  ASN1_INTEGER		=^asn1_string_st;
  ASN1_BIT_STRING	=^asn1_string_st;
  ASN1_OCTET_STRING	=^asn1_string_st;
  ASN1_PRINTABLESTRING	=^asn1_string_st;
  ASN1_T61STRING	=^asn1_string_st;
  ASN1_IA5STRING	=^asn1_string_st;
  ASN1_UTCTIME		=^asn1_string_st;
  ASN1_GENERALIZEDTIME	=^asn1_string_st;
  ASN1_GENERALSTRING	=^asn1_string_st;
  ASN1_UNIVERSALSTRING	=^asn1_string_st;
  ASN1_BMPSTRING	=^asn1_string_st;
  ASN1_TYPE		=^asn1_type_st;
  ASN1_METHOD		=^asn1_method_st;
  ASN1_HEADER		=^asn1_header_st;
  EVP_PKEY		=^evp_pkey_st;
  EVP_MD		=^env_md_st;
  EVP_CIPHER		=^evp_cipher_st;
  X509_ALGOR		=^X509_algor_st;
  X509_VAL		=^X509_val_st;
  X509_PUBKEY		=^X509_pubkey_st;
  X509_SIG		=^X509_sig_st;
  X509_NAME_ENTRY	=^X509_name_entry_st;
  X509_NAME		=^X509_name_st;
  X509_EXTENSION_METHOD =^x509_extension_method_st;
  X509_REQ_INFO 	=^X509_req_info_st;
  X509_REQ		=^X509_req_st;
  X509_CINF		=^x509_cinf_st;
  X509			=^x509_st;
  X509_REVOKED		=^X509_revoked_st;
  X509_CRL_INFO 	=^X509_crl_info_st;
  X509_CRL		=^X509_crl_st;
  X509_ATTRIBUTE	=^x509_attributes_st;
  X509_PKEY		=^private_key_st;
  X509_INFO		=^X509_info_st;
  NETSCAPE_SPKAC	=^Netscape_spkac_st;
  NETSCAPE_SPKI 	=^Netscape_spki_st;
  X509_OBJECT		=^x509_object_st;
  X509_LOOKUP_METHOD	=^x509_lookup_method_st;
  X509_STORE		=^x509_store_st;
  X509_LOOKUP		=^x509_lookup_st;
  PKCS7_ISSUER_AND_SERIAL=^pkcs7_issuer_and_serial_st;
  PKCS7_SIGNER_INFO	=^pkcs7_signer_info_st;
  PKCS7_RECIP_INFO	=^pkcs7_recip_info_st;
  PKCS7_SIGNED		=^pkcs7_signed_st;
  PKCS7_ENC_CONTENT	=^pkcs7_enc_content_st;
  PKCS7_ENVELOPE	=^pkcs7_enveloped_st;
  PKCS7_SIGN_ENVELOPE	=^pkcs7_signedandenveloped_st;
  PKCS7_DIGEST		=^pkcs7_digest_st;
  PKCS7_ENCRYPT 	=^pkcs7_encrypted_st;
  PKCS7 		=^pkcs7_st;
  PEM_USER		=^pem_recip_st;

{&CDecl+}
{$I LIBeay32.INC}

procedure SSLeay_add_all_algorithms;
procedure SSLeay_add_all_ciphers;
procedure SSLeay_add_all_digests;
function  SSLeay_version(typ:Integer):PChar;
function  SSLeay:Cardinal;

function  ASN1_BIT_STRING_asn1_meth:ASN1_METHOD;
function  ASN1_BIT_STRING_get_bit(a:ASN1_BIT_STRING;n:Integer):Integer;
function  ASN1_BIT_STRING_set_bit(a:ASN1_BIT_STRING;n,value:Integer):Integer;
procedure ASN1_HEADER_free(a:ASN1_HEADER);
function  ASN1_HEADER_new:ASN1_HEADER;
function  ASN1_IA5STRING_asn1_meth:ASN1_METHOD;
function  ASN1_INTEGER_get(a:ASN1_INTEGER):LongInt;
function  ASN1_INTEGER_set(a:ASN1_INTEGER;v:LongInt):Integer;
function  ASN1_INTEGER_to_BN(ai:ASN1_INTEGER;bn:BIGNUM):BIGNUM;
function  ASN1_OBJECT_create(nid:Integer;data:Pointer;len:Integer;sn,ln:PChar):ASN1_OBJECT;
procedure ASN1_OBJECT_free(a:ASN1_OBJECT);
function  ASN1_OBJECT_new:ASN1_OBJECT;
function  ASN1_PRINTABLE_type(s:Pointer;max:Integer):Integer;(* given a string, return the correct type, max is the maximum length *)
function  ASN1_STRING_cmp(a,b:ASN1_STRING):Integer;
function  ASN1_STRING_dup(a:ASN1_STRING):ASN1_STRING;
procedure ASN1_STRING_free(a:ASN1_STRING);
function  ASN1_STRING_new:ASN1_STRING;
function  ASN1_STRING_print(bp:BIO;v:ASN1_STRING):Integer;
function  ASN1_STRING_set(str:ASN1_STRING;data:Pointer;len:Integer):Integer;
function  ASN1_STRING_type_new(typ:Integer):ASN1_STRING;
function  ASN1_STRING_length(a:ASN1_STRING):Integer; inline; begin Result := a^.length end;
function  ASN1_STRING_type(a:ASN1_STRING):Integer; inline; begin Result := a^.typ end;
function  ASN1_STRING_data(a:ASN1_STRING):Pointer; inline; begin Result := a^.data end;
procedure ASN1_TYPE_free(a:ASN1_TYPE);
function  ASN1_TYPE_get(a:ASN1_TYPE):Integer;
function  ASN1_TYPE_get_int_octetstring(a:ASN1_TYPE;var num:LongInt;data:Pointer;max_len:Integer):Integer;
function  ASN1_TYPE_get_octetstring(a:ASN1_TYPE;data:Pointer;max_len:Integer):Integer;
function  ASN1_TYPE_new:ASN1_TYPE;
procedure ASN1_TYPE_set(a:ASN1_TYPE;typ:Integer;value:PChar);
function  ASN1_TYPE_set_octetstring(a:ASN1_TYPE;data:Pointer;len:Integer):Integer;
function  ASN1_TYPE_set_int_octetstring(a:ASN1_TYPE;num:LongInt;data:Pointer;len:Integer):Integer;
function  ASN1_UNIVERSALSTRING_to_string(s:ASN1_UNIVERSALSTRING):Integer;
function  ASN1_UTCTIME_check(a:ASN1_UTCTIME):Integer;
function  ASN1_UTCTIME_print(bp:BIO;a:ASN1_UTCTIME):Integer;
//function  ASN1_UTCTIME_set(s:ASN1_UTCTIME;t:time_t):ASN1_UTCTIME;
function  ASN1_UTCTIME_set_string(s:ASN1_UTCTIME;str:PChar):Integer;
function  ASN1_check_infinite_end(var p:Pointer;len:LongInt):Integer;
function  ASN1_d2i_bio(xnew:asn1_create_func;d2i:asn1_d2i_func;bp:BIO;var x:Pointer):PChar;
//function  ASN1_d2i_fp(char *(*xnew)(),char *(*d2i)(),FILE *fp,unsigned char **x):PChar;
function  ASN1_digest(i2d:asn1_i2d_func;typ:EVP_MD;data:PChar;md:Pointer;var len:Word):Integer;
function  ASN1_dup(i2d:asn1_i2d_func;d2i:asn1_d2i_func;x:PChar):PChar;
function  ASN1_get_object(var pp:Pointer;var plength:LongInt;var ptag,pclass:Integer;omax:LongInt):Integer;
function  ASN1_i2d_bio(i2d:asn1_i2d_func;out:BIO;x:Pointer):Integer;
//function  ASN1_i2d_fp(int (*i2d)(),FILE *out,unsigned char *x):Integer;
function  ASN1_object_size(constructed, length, tag:Integer):Integer;
function  ASN1_parse(bp:BIO;pp:Pointer;len:LongInt;indent:Integer):Integer;
procedure ASN1_put_object(var pp:Pointer;constructed, length,tag, xclass:Integer);
function  ASN1_sign(i2d:asn1_i2d_func;algor1,algor2:X509_ALGOR;signature:ASN1_BIT_STRING;data:PChar;pkey:EVP_PKEY;typ:EVP_MD):Integer;
function  ASN1_verify(i2d:asn1_i2d_func;algor1:X509_ALGOR;signature:ASN1_BIT_STRING;data:PChar;pkey:EVP_PKEY):Integer;

procedure BF_cbc_encrypt(pin,pout:Pointer;length:LongInt;var ks:BF_KEY;iv:Pointer;enc:Integer);
procedure BF_cfb64_encrypt(pin,pout:Pointer;length:LongInt;var schedule:BF_KEY;ivec:Pointer;var num:Integer;enc:Integer);
procedure BF_decrypt(var data:Cardinal;var key:BF_KEY);
procedure BF_ecb_encrypt(pin,pout:Pointer;var key:BF_KEY;enc:Integer);
procedure BF_encrypt(var data:Cardinal;var key:BF_KEY);
procedure BF_ofb64_encrypt(pin,pout:Pointer;length:LongInt;var schedule:BF_KEY;ivec:Pointer;var num:Integer);
function  BF_options:PChar;
procedure BF_set_key(var key:BF_KEY;len:Integer;data:Pointer);

function  BIO_accept(sock:Integer;var ip_port:PChar):Integer;
procedure BIO_copy_next_retry(b:BIO);
function  BIO_ctrl(b:BIO;cmd:Integer;larg:LongInt;parg:Pointer):LongInt;
function  BIO_debug_callback(b:BIO;cmd:Integer;argp:Pointer;argi:Integer;argl,ret:LongInt):LongInt;
function  BIO_dump(b:BIO;bytes:Pointer;len:Integer):Integer;
function  BIO_dup_chain(b:BIO):BIO;
function  BIO_f_base64:BIO_METHOD;
function  BIO_f_buffer:BIO_METHOD;
function  BIO_f_cipher:BIO_METHOD;
function  BIO_f_md:BIO_METHOD;
function  BIO_f_nbio_test:BIO_METHOD;
function  BIO_f_null:BIO_METHOD;
function  BIO_fd_non_fatal_error(i:Integer):Boolean;
function  BIO_fd_should_retry(i:Integer):Boolean;
function  BIO_find_type(b:BIO;bio_type:Integer):BIO;
function  BIO_free(a:BIO):Integer;
procedure BIO_free_all(a:BIO);
function  BIO_get_accept_socket(host_port:PChar):Integer;
function  BIO_get_host_ip(str:PChar;var ip):Integer;
function  BIO_get_port(str:PChar;var port_ptr:SmallWord):Integer;
function  BIO_get_retry_BIO(b:BIO;var reason:Integer):BIO;
function  BIO_get_retry_reason(b:BIO):Integer;
function  BIO_gethostbyname(name:PChar):PHOSTENT;
function  BIO_gets(b:BIO;buf:PChar;size:Integer):Integer;
function  BIO_ghbn_ctrl(cmd,iarg:Integer;parg:Pointer):LongInt;
function  BIO_int_ctrl(b:BIO;cmd:Integer;larg:LongInt;iarg:Integer):LongInt;
function  BIO_new(method:BIO_METHOD):BIO;
function  BIO_new_accept(host_port:PChar):BIO;
function  BIO_new_connect(host_port:PChar):BIO;
function  BIO_new_fd(fd,close_flag:Integer):BIO;
function  BIO_new_file(filename,mode:PChar):BIO;
//function  BIO_new_fp(FILE *stream, int close_flag):BIO;
function  BIO_new_socket(sock,close_flag:Integer):BIO;
function  BIO_pop(b:BIO):BIO;
function  BIO_ptr_ctrl(b:BIO;cmd:Integer;larg:LongInt):PChar;
function  BIO_push(b,append:BIO):BIO;
function  BIO_puts(b:BIO;buf:PChar):Integer;
function  BIO_read(b:BIO;var data;len:Integer):Integer;
function  BIO_s_accept:BIO_METHOD;
function  BIO_s_connect:BIO_METHOD;
function  BIO_s_fd:BIO_METHOD;
function  BIO_s_file:BIO_METHOD;
function  BIO_s_mem:BIO_METHOD;
function  BIO_s_null:BIO_METHOD;
function  BIO_s_socket:BIO_METHOD;
function  BIO_set(a:BIO;method:BIO_METHOD):Integer;
procedure BIO_set_cipher(b:BIO;c:EVP_CIPHER;k,i:Pointer;enc:Integer);
function  BIO_set_tcp_ndelay(sock:Integer;turn_on:Integer):Integer;
procedure BIO_sock_cleanup;
function  BIO_sock_error(sock:Integer):Integer;
function  BIO_sock_init:Integer;
function  BIO_sock_non_fatal_error(error:Integer):Boolean;
function  BIO_sock_should_retry(i:Integer):Boolean;
function  BIO_socket_ioctl(fd:Integer;cmd:LongInt;var arg:Cardinal):Integer;
function  BIO_write(b:BIO;var data;len:Integer):Integer;

function  BN_BLINDING_convert(n:BIGNUM;r:BN_BLINDING;ctx:BN_CTX):Integer;
procedure BN_BLINDING_free(b:BN_BLINDING);
function  BN_BLINDING_invert(n:BIGNUM;b:BN_BLINDING;ctx:BN_CTX):Integer;
function  BN_BLINDING_new(A,Ai,_mod:BIGNUM):BN_BLINDING;
function  BN_BLINDING_update(b:BN_BLINDING;ctx:BN_CTX):Integer;
procedure BN_CTX_free(c:BN_CTX);
function  BN_CTX_new:BN_CTX;

procedure BN_MONT_CTX_free(mont:BN_MONT_CTX);
function  BN_MONT_CTX_new:BN_MONT_CTX;
function  BN_MONT_CTX_set(mont:BN_MONT_CTX;modulus:BIGNUM;ctx:BN_CTX):Integer;
function  BN_add(r,a,b:BIGNUM):Integer;
function  BN_add_word(a:BIGNUM;w:Cardinal):Integer;
function  BN_bin2bn(s:Pointer;len:Integer;ret:BIGNUM):BIGNUM;
function  BN_bn2bin(a:BIGNUM;pto:Pointer):Integer;
function  BN_bn2dec(a:BIGNUM):PChar;
function  BN_bn2hex(a:BIGNUM):PChar;
function  BN_bn2mpi(a:BIGNUM;pto:Pointer):Integer;
procedure BN_clear(a:BIGNUM);
function  BN_clear_bit(a:BIGNUM;n:Integer):Integer;
procedure BN_clear_free(a:BIGNUM);
function  BN_cmp(a,b:BIGNUM):Integer;
function  BN_copy(a,b:BIGNUM):BIGNUM;
function  BN_dec2bn(var a:BIGNUM;str:PChar):Integer;
function  BN_div(dv,rem,m,d:BIGNUM;ctx:BN_CTX):Integer;
function  BN_div_word(a:BIGNUM;w:Cardinal):Cardinal;
function  BN_dup(a:BIGNUM):BIGNUM;
function  BN_exp(r,a,p:BIGNUM;ctx:BN_CTX):Integer;
procedure BN_free(a:BIGNUM);
function  BN_from_montgomery(r,a:BIGNUM;mont:BN_MONT_CTX;ctx:BN_CTX):Integer;
function  BN_gcd(r,in_a,in_b:BIGNUM;ctx:BN_CTX):Integer;
function  BN_generate_prime(bits,strong:Integer;add,rem:BIGNUM;callback:bn_gen_prime_cb;cb_arg:PChar):BIGNUM;
function  BN_get_word(a:BIGNUM):Cardinal;
function  BN_hex2bn(var a:BIGNUM;str:PChar):Integer;
function  BN_is_bit_set(a:BIGNUM;n:Integer):Integer;
function  BN_is_prime(p:BIGNUM;nchecks:Integer;callback:bn_gen_prime_cb;ctx:BN_CTX;cb_arg:PChar):Integer;
function  BN_lshift(r,a:BIGNUM;n:Integer):Integer;
function  BN_lshift1(r,a:BIGNUM):Integer;
function  BN_mask_bits(a:BIGNUM;n:Integer):Integer;
function  BN_mod(rem,m,d:BIGNUM;ctx:BN_CTX):Integer;
function  BN_mod_exp(r,a,p,m:BIGNUM;ctx:BN_CTX):Integer;
function  BN_mod_exp_mont(r,a,p,m:BIGNUM;ctx:BN_CTX;m_ctx:BN_MONT_CTX):Integer;
function  BN_mod_exp_recp(r,a,p,m:BIGNUM;ctx:BN_CTX):Integer;
function  BN_mod_exp_simple(r,a,p,m:BIGNUM;ctx:BN_CTX):Integer;
function  BN_mod_inverse(a,n:BIGNUM;ctx:BN_CTX):BIGNUM;
function  BN_mod_mul(ret,a,b,m:BIGNUM;ctx:BN_CTX):Integer;
function  BN_mod_mul_montgomery(r,a,b:BIGNUM;mont:BN_MONT_CTX;ctx:BN_CTX):Integer;
function  BN_mod_mul_reciprocal(r,x,y,m,i:BIGNUM;nb:Integer;ctx:BN_CTX):Integer;
function  BN_mod_word(a:BIGNUM;w:Cardinal):Cardinal;
function  BN_mpi2bn(s:Pointer;len:Integer;ret:BIGNUM):BIGNUM;
function  BN_mul(r,a,b:BIGNUM):Integer;
function  BN_mul_word(a:BIGNUM;w:Cardinal):Integer;
function  BN_new:BIGNUM;
function  BN_num_bits(a:BIGNUM):Integer;
function  BN_num_bits_word(l:Cardinal):Integer;
function  BN_options:PChar;
function  BN_print(fp:BIO;a:BIGNUM):Integer;
//function  BN_print_fp(FILE *fp, BIGNUM *a):Integer;
function  BN_rand(rnd:BIGNUM;bits,top,bottom:Integer):Integer;
function  BN_reciprocal(r,m:BIGNUM;ctx:BN_CTX):Integer;
function  BN_rshift(r,a:BIGNUM;n:Integer):Integer;
function  BN_rshift1(r,a:BIGNUM):Integer;
function  BN_set_bit(a:BIGNUM;n:Integer):Integer;
function  BN_set_word(a:BIGNUM;w:Cardinal):Integer;
function  BN_sqr(r,a:BIGNUM;ctx:BN_CTX):Integer;
function  BN_sub(r,a,b:BIGNUM):Integer;
function  BN_sub_word(a:BIGNUM;w:Cardinal):Integer;
function  BN_to_ASN1_INTEGER(bn:BIGNUM;ai:ASN1_INTEGER):ASN1_INTEGER;
function  BN_ucmp(a,b:BIGNUM):Integer;
function  BN_value_one:BIGNUM;

procedure BUF_MEM_free(a:BUF_MEM);
function  BUF_MEM_grow(str:BUF_MEM;len:Integer):Integer;
function  BUF_MEM_new:BUF_MEM;
function  BUF_strdup(str:PChar):PChar;

procedure CAST_cbc_encrypt(pin,pout:Pointer;length:LongInt;var ks:CAST_KEY;iv:Pointer;enc:Integer);
procedure CAST_cfb64_encrypt(pin,pout:Pointer;length:LongInt;var schedule:CAST_KEY;iv:Pointer;var num:Integer;enc:Integer);
procedure CAST_decrypt(var data:Cardinal;var key:CAST_KEY);
procedure CAST_ecb_encrypt(pin,pout:Pointer;var key:CAST_KEY;enc:Integer);
procedure CAST_encrypt(var data:Cardinal;var key:CAST_KEY);
procedure CAST_ofb64_encrypt(pin,pout:Pointer;length:LongInt;var schedule:CAST_KEY;iv:Pointer;var num:Integer);
procedure CAST_set_key(var key:CAST_KEY;len:Integer;data:Pointer);

procedure CONF_free(conf:LHASH);
function  CONF_get_number(conf:LHASH;group,name:PChar):LongInt;
function  CONF_get_section(conf:LHASH;section:PChar):STACK;
function  CONF_get_string(conf:LHASH;group,name:PChar):PChar;
function  CONF_load(conf:LHASH;fname:PChar;var eline:LongInt):LHASH;

function  CRYPTO_add_lock(var pointer:Integer;amount,typ:Integer;fname:PChar;line:Integer):Integer;
procedure CRYPTO_dbg_free(addr:Pointer);
function  CRYPTO_dbg_malloc(num:Integer;fname:PChar;line:Integer):Pointer;
function  CRYPTO_dbg_realloc(addr:Pointer;num:Integer;fname:PChar;line:Integer):Pointer;
function  CRYPTO_dbg_remalloc(addr:Pointer;num:Integer;fname:PChar;line:Integer):Pointer;
function  CRYPTO_dup_ex_data(meth:STACK;var dfrom,dto:CRYPTO_EX_DATA):Integer;
procedure CRYPTO_free(addr:Pointer);
procedure CRYPTO_free_ex_data(meth:STACK;obj:PChar;var ad:CRYPTO_EX_DATA);
function  CRYPTO_get_add_lock_callback:crypto_add_lock_cb;
function  CRYPTO_get_ex_data(var ad:CRYPTO_EX_DATA;idx:Integer):PChar;
function  CRYPTO_get_ex_new_index(idx:Integer;var sk:STACK;argl:LongInt;argp:PChar;
	  new_func:crypto_ex_new_func;dup_func:crypto_ex_dup_func;free_func:crypto_ex_free_func):Integer;
function  CRYPTO_get_id_callback:crypto_id_cb;
function  CRYPTO_get_lock_name(typ:Integer):PChar;
function  CRYPTO_get_locking_callback:crypto_lock_cb;
procedure CRYPTO_get_mem_functions(var m:crypto_malloc_func;var r:crypto_realloc_func;var f:crypto_free_func);
function  CRYPTO_get_new_lockid(name:PChar):Integer;
procedure CRYPTO_lock(mode,typ:Integer;fname:PChar;line:Integer);
function  CRYPTO_malloc(num:Integer):Pointer;
function  CRYPTO_mem_ctrl(mode:Integer):Integer;
procedure CRYPTO_mem_leaks(b:BIO);
procedure CRYPTO_mem_leaks_cb(cb:crypto_leaks_cb);
//procedure CRYPTO_mem_leaks_fp(FILE *);
procedure CRYPTO_new_ex_data(meth:STACK;obj:PChar;var ad:CRYPTO_EX_DATA);
function  CRYPTO_realloc(addr:Pointer;num:Integer):Pointer;
function  CRYPTO_remalloc(addr:Pointer;num:Integer):Pointer;
procedure CRYPTO_set_add_lock_callback(func:crypto_add_lock_cb);
function  CRYPTO_set_ex_data(var ad:CRYPTO_EX_DATA;idx:Integer;val:PChar):Integer;
procedure CRYPTO_set_id_callback(func:crypto_id_cb);
procedure CRYPTO_set_locking_callback(func:crypto_lock_cb);
procedure CRYPTO_set_mem_functions(m:crypto_malloc_func;r:crypto_realloc_func;f:crypto_free_func);
procedure CRYPTO_thread_cleanup; Pascal;
function  CRYPTO_thread_id:Cardinal;
function  CRYPTO_thread_setup:Boolean; Pascal;

function  DH_check(d:DH;var codes:Integer):Integer;
function  DH_compute_key(key:Pointer;pub_key:BIGNUM;d:DH):Integer;
procedure DH_free(d:DH);
function  DH_generate_key(d:DH):Integer;
function  DH_generate_parameters(prime_len,generator:Integer;callback:dh_gen_parm_cb;cb_arg:PChar):DH;
function  DH_new:DH;
function  DH_size(d:DH):Integer;
function  DHparams_print(bp:BIO;x:DH):Integer;
//function  DHparams_print_fp(FILE *fp, DH *x):Integer;

procedure DSA_free(r:DSA);
function  DSA_generate_key(a:DSA):Integer;
function  DSA_generate_parameters(bits:Integer;seed:Pointer;seed_len:Integer;
	  var counter_ret:Integer;var h_ret:Cardinal;callback:dsa_cb_func;cb_arg:PChar):DSA;
function  DSA_is_prime(q:BIGNUM;callback:dsa_cb_func;cb_arg:PChar):Integer;
function  DSA_new:DSA;
function  DSA_print(bp:BIO;x:DSA;off:Integer):Integer;
//function  DSA_print_fp(FILE *bp, DSA *x, int off):Integer;
function  DSA_sign(typ:Integer;dgst:Pointer;dlen:Integer;sig:Pointer;var siglen:Word;d:DSA):Integer;
function  DSA_sign_setup(d:DSA;ctx_in:BN_CTX;var kinvp,rp:BIGNUM):Integer;
function  DSA_size(d:DSA):Integer;
	(* next 4 return -1 on error *)
function  DSA_verify(typ:Integer;dgst:Pointer;dgst_len:Integer;sigbuf:Pointer;siglen:Integer;d:DSA):Integer;
function  DSAparams_print(bp:BIO;x:DSA):Integer;
//int	  DSAparams_print_fp(FILE *fp, DSA *x):Integer;

//procedure ERR_add_err_data(...);
procedure ERR_clear_error;
function  ERR_error_string(e:Cardinal;buf:PChar):PChar;
procedure ERR_free_strings;
function  ERR_func_error_string(e:Cardinal):PChar;
function  ERR_get_err_state_table:LHASH;
function  ERR_get_error:Cardinal;
function  ERR_get_error_line(var f:PChar;var line:Integer):Cardinal;
function  ERR_get_next_error_library:Integer;
function  ERR_get_state:ERR_STATE;
function  ERR_get_string_table:LHASH;
function  ERR_lib_error_string(e:Cardinal):PChar;
procedure ERR_load_ASN1_strings;
procedure ERR_load_BIO_strings;
procedure ERR_load_BN_strings;
procedure ERR_load_BUF_strings;
procedure ERR_load_CONF_strings;
procedure ERR_load_CRYPTO_strings;
procedure ERR_load_DH_strings;
procedure ERR_load_DSA_strings;
procedure ERR_load_ERR_strings;
procedure ERR_load_EVP_strings;
procedure ERR_load_OBJ_strings;
procedure ERR_load_PEM_strings;
procedure ERR_load_PKCS7_strings;
procedure ERR_load_RSA_strings;
Procedure ERR_load_X509_strings;
procedure ERR_load_all_crypto_strings;
procedure ERR_load_strings(lib:Integer;str:ERR_STRING_DATA);
function  ERR_peek_error:Cardinal;
function  ERR_peek_error_line(var f:PChar;var line:Integer):Cardinal;
procedure ERR_print_errors(bp:BIO);
//procedure ERR_print_errors_fp(FILE *fp);
procedure ERR_put_error(lib,func,reason:Integer;f:PChar;line:Integer);
function  ERR_reason_error_string(e:Cardinal):PChar;
procedure ERR_remove_state(pid:Cardinal); (* if zero we look it up *)
procedure ERR_set_error_data(data:PChar;flags:Integer);

function  EVP_BytesToKey(typ:EVP_CIPHER;md:EVP_MD;salt:PChar;data:Pointer;datal:Integer;count:Integer;key,iv:Pointer):Integer;
procedure EVP_CIPHER_CTX_cleanup(var a:EVP_CIPHER_CTX);
procedure EVP_CIPHER_CTX_init(var a:EVP_CIPHER_CTX);
function  EVP_CIPHER_asn1_to_param(var c:EVP_CIPHER_CTX;typ:ASN1_TYPE):Integer;
function  EVP_CIPHER_get_asn1_iv(var c:EVP_CIPHER_CTX;typ:ASN1_TYPE):Integer;
function  EVP_CIPHER_param_to_asn1(var c:EVP_CIPHER_CTX;typ:ASN1_TYPE):Integer;
function  EVP_CIPHER_set_asn1_iv(var c:EVP_CIPHER_CTX;typ:ASN1_TYPE):Integer;
function  EVP_CipherFinal(var ctx:EVP_CIPHER_CTX;outm:Pointer;var outl:Integer):Integer;
procedure EVP_CipherInit(var ctx:EVP_CIPHER_CTX;typ:EVP_CIPHER;key,iv:Pointer;enc:Integer);
procedure EVP_CipherUpdate(var ctx:EVP_CIPHER_CTX;pout:Pointer;var outl:Integer;pin:Pointer;inl:Integer);
function  EVP_DecodeBlock(t,f:Pointer;n:Integer):Integer;
function  EVP_DecodeFinal(var ctx:EVP_ENCODE_CTX;pout:Pointer;var outl:Integer):Integer;
procedure EVP_DecodeInit(var ctx:EVP_ENCODE_CTX);
function  EVP_DecodeUpdate(var ctx:EVP_ENCODE_CTX;pout:Pointer;var outl:Integer;pin:Pointer;inl:Integer):Integer;
function  EVP_DecryptFinal(var ctx:EVP_CIPHER_CTX;outm:Pointer;var outl:Integer):Integer;
procedure EVP_DecryptInit(var ctx:EVP_CIPHER_CTX;typ:EVP_CIPHER;key,iv:Pointer);
procedure EVP_DecryptUpdate(var ctx:EVP_CIPHER_CTX;pout:Pointer;var outl:Integer;pin:Pointer;inl:Integer);
procedure EVP_DigestFinal(var ctx:EVP_MD_CTX;md:Pointer;var s:Word);
procedure EVP_DigestInit(var ctx:EVP_MD_CTX;typ:EVP_MD);
procedure EVP_DigestUpdate(var ctx:EVP_MD_CTX;d:Pointer;cnt:Word);
function  EVP_EncodeBlock(t,f:Pointer;n:Integer):Integer;
procedure EVP_EncodeFinal(var ctx:EVP_ENCODE_CTX;pout:Pointer;var outl:Integer);
procedure EVP_EncodeInit(var ctx:EVP_ENCODE_CTX);
procedure EVP_EncodeUpdate(var ctx:EVP_ENCODE_CTX;pout:Pointer;var outl:Integer;pin:Pointer;inl:Integer);
procedure EVP_EncryptFinal(var ctx:EVP_CIPHER_CTX;pout:Pointer;var outl:Integer);
procedure EVP_EncryptInit(var ctx:EVP_CIPHER_CTX;typ:EVP_CIPHER;key,iv:Pointer);
procedure EVP_EncryptUpdate(var ctx:EVP_CIPHER_CTX;pout:Pointer;var outl:Integer;pin:Pointer;inl:Integer);
function  EVP_OpenFinal(var ctx:EVP_CIPHER_CTX;pout:Pointer;var outl:Integer):Integer;
function  EVP_OpenInit(var ctx:EVP_CIPHER_CTX;typ:EVP_CIPHER;ek:Pointer;ekl:Integer;iv:Pointer;priv:EVP_PKEY):Integer;
function  EVP_PKEY_assign(pkey:EVP_PKEY;typ:Integer;key:PChar):Integer;
function  EVP_PKEY_bits(pkey:EVP_PKEY):Integer;
function  EVP_PKEY_cmp_parameters(a,b:EVP_PKEY):Integer;
function  EVP_PKEY_copy_parameters(pto,pfrom:EVP_PKEY):Integer;
function  EVP_PKEY_decrypt(dec_key,enc_key:Pointer;enc_key_len:Integer;private_key:EVP_PKEY):Integer;
function  EVP_PKEY_encrypt(env_key,key:Pointer;key_len:Integer;pub_key:EVP_PKEY):Integer;
procedure EVP_PKEY_free(pkey:EVP_PKEY);
function  EVP_PKEY_missing_parameters(pkey:EVP_PKEY):Integer;
function  EVP_PKEY_new:EVP_PKEY;
function  EVP_PKEY_save_parameters(pkey:EVP_PKEY;mode:Integer):Integer;
function  EVP_PKEY_size(pkey:EVP_PKEY):Integer;
function  EVP_PKEY_type(typ:Integer):Integer;
procedure EVP_SealFinal(var ctx:EVP_CIPHER_CTX;pout:Pointer;var outl:Integer);
function  EVP_SealInit(var ctx:EVP_CIPHER_CTX;typ:EVP_CIPHER;var ek:Pointer;var ekl:Integer;iv:Pointer;var pubk:EVP_PKEY;npubk:Integer):Integer;
function  EVP_SignFinal(var ctx:EVP_MD_CTX;md:Pointer;var s:Word;pkey:EVP_PKEY):Integer;
function  EVP_VerifyFinal(var ctx:EVP_MD_CTX;sigbuf:Pointer;siglen:Word;pkey:EVP_PKEY):Integer;
function  EVP_add_alias(name,alias:PChar):Integer;
function  EVP_add_cipher(cipher:EVP_CIPHER):Integer;
function  EVP_add_digest(digest:EVP_MD):Integer;
function  EVP_bf_cbc:EVP_CIPHER;
function  EVP_bf_cfb:EVP_CIPHER;
function  EVP_bf_ecb:EVP_CIPHER;
function  EVP_bf_ofb:EVP_CIPHER;
function  EVP_cast5_cbc:EVP_CIPHER;
function  EVP_cast5_cfb:EVP_CIPHER;
function  EVP_cast5_ecb:EVP_CIPHER;
function  EVP_cast5_ofb:EVP_CIPHER;
procedure EVP_cleanup;
function  EVP_delete_alias(name:PChar):Integer;
function  EVP_des_cbc:EVP_CIPHER;
function  EVP_des_cfb:EVP_CIPHER;
function  EVP_des_ecb:EVP_CIPHER;
function  EVP_des_ede:EVP_CIPHER;
function  EVP_des_ede3:EVP_CIPHER;
function  EVP_des_ede3_cbc:EVP_CIPHER;
function  EVP_des_ede3_cfb:EVP_CIPHER;
function  EVP_des_ede3_ofb:EVP_CIPHER;
function  EVP_des_ede_cbc:EVP_CIPHER;
function  EVP_des_ede_cfb:EVP_CIPHER;
function  EVP_des_ede_ofb:EVP_CIPHER;
function  EVP_des_ofb:EVP_CIPHER;
function  EVP_desx_cbc:EVP_CIPHER;
function  EVP_dss:EVP_MD;
function  EVP_dss1:EVP_MD;
function  EVP_enc_null:EVP_CIPHER;	       (* does nothing :-) *)
function  EVP_get_cipherbyname(name:PChar):EVP_CIPHER;
function  EVP_get_digestbyname(name:PChar):EVP_MD;
function  EVP_get_pw_prompt:PChar;
function  EVP_idea_cbc:EVP_CIPHER;
function  EVP_idea_cfb:EVP_CIPHER;
function  EVP_idea_ecb:EVP_CIPHER;
function  EVP_idea_ofb:EVP_CIPHER;
function  EVP_md2:EVP_MD;
function  EVP_md5:EVP_MD;
function  EVP_md_null:EVP_MD;
function  EVP_mdc2:EVP_MD;
function  EVP_rc2_40_cbc:EVP_CIPHER;
function  EVP_rc2_cbc:EVP_CIPHER;
function  EVP_rc2_cfb:EVP_CIPHER;
function  EVP_rc2_ecb:EVP_CIPHER;
function  EVP_rc2_ofb:EVP_CIPHER;
function  EVP_rc4:EVP_CIPHER;
function  EVP_rc4_40:EVP_CIPHER;
function  EVP_rc5_32_12_16_cbc:EVP_CIPHER;
function  EVP_rc5_32_12_16_cfb:EVP_CIPHER;
function  EVP_rc5_32_12_16_ecb:EVP_CIPHER;
function  EVP_rc5_32_12_16_ofb:EVP_CIPHER;
function  EVP_read_pw_string(buf:PChar;length:Integer;prompt:PChar;verify:Integer):Integer;
procedure EVP_set_pw_prompt(prompt:PChar);
function  EVP_sha:EVP_MD;
function  EVP_sha1:EVP_MD;
//function  EVP_ripemd160:EVP_MD;

function  HMAC(md:EVP_MD;key:Pointer;key_len:Integer;d:Pointer;n:Integer;md:Pointer;var md_len:Word):Pointer;
procedure HMAC_Final(var ctx:HMAC_CTX;md:Pointer;var len:Word);
procedure HMAC_Init(var ctx:HMAC_CTX;key:Pointer;len:Integer;md:EVP_MD);
procedure HMAC_Update(var ctx:HMAC_CTX;key:Pointer;len:Integer);
procedure HMAC_cleanup(var ctx:HMAC_CTX);

function  MD2(d:Pointer;n:Cardinal;md:Pointer):Pointer;
procedure MD2_Final(md:Pointer;var c:MD2_CTX);
procedure MD2_Init(var c:MD2_CTX);
procedure MD2_Update(var c:MD2_CTX;{register?}data:Pointer;len:Cardinal);
function  MD2_options:PChar;

function  MD5(d:Pointer; n:Cardinal; md:Pointer):Pointer;
procedure MD5_Final(md:Pointer;var c:MD5_CTX);
procedure MD5_Init(var c:MD5_CTX);
procedure MD5_Transform(var c:MD5_CTX; b:Pointer);
procedure MD5_Update(var c:MD5_CTX; data:Pointer; len:Cardinal);

function  MDC2(d:Pointer;n:Cardinal;md:Pointer):Pointer;
procedure MDC2_Final(md:Pointer;var c:MDC2_CTX);
procedure MDC2_Init(var c:MDC2_CTX);
procedure MDC2_Update(var c:MDC2_CTX;data:Pointer;len:Cardinal);

procedure NETSCAPE_SPKAC_free(a:NETSCAPE_SPKAC);
function  NETSCAPE_SPKAC_new:NETSCAPE_SPKAC;
procedure NETSCAPE_SPKI_free(a:NETSCAPE_SPKI);
function  NETSCAPE_SPKI_new:NETSCAPE_SPKI;
function  NETSCAPE_SPKI_sign(x:NETSCAPE_SPKI;pkey:EVP_PKEY;md:EVP_MD):Integer;
function  NETSCAPE_SPKI_verify(a:NETSCAPE_SPKI;r:EVP_PKEY):Integer;

function  OBJ_add_object(obj:ASN1_OBJECT):Integer;
function  OBJ_bsearch(key,base:PChar;num,size:Integer;cmp:lhash_comp_func):PChar;
procedure OBJ_cleanup;
function  OBJ_cmp(a,b:ASN1_OBJECT):Integer;
function  OBJ_create(oid,sn,ln:PChar):Integer;
function  OBJ_create_objects(bp_in:BIO):Integer;
function  OBJ_dup(o:ASN1_OBJECT):ASN1_OBJECT;
function  OBJ_ln2nid(s:PChar):Integer;
function  OBJ_new_nid(num:Integer):Integer;
function  OBJ_nid2ln(n:Integer):PChar;
function  OBJ_nid2obj(n:Integer):ASN1_OBJECT;
function  OBJ_nid2sn(n:Integer):PChar;
function  OBJ_obj2nid(o:ASN1_OBJECT):Integer;
function  OBJ_sn2nid(s:PChar):Integer;
function  OBJ_txt2nid(s:PChar):Integer;

//function  PEM_ASN1_read(d2i:asn1_d2i_func;name:PChar;FILE *fp;var x:PChar;cb:pem_callback_func):PChar;
function  PEM_ASN1_read_bio(d2i:asn1_d2i_func;name:PChar;bp:BIO;var x:PChar;cb:pem_callback_func):PChar;
//function  PEM_ASN1_write(i2d:asn1_i2d_func;name:PChar;FILE *fp;x:PChar;enc:EVP_CIPHER;kstr:Pointer;klen:Integer;callback:pem_callback_func):Integer;
function  PEM_ASN1_write_bio(i2d:asn1_i2d_func;name:PChar;bp:BIO;x:PChar;enc:EVP_CIPHER;kstr:Pointer;klen:Integer;callback:pem_callback_func):Integer;
function  PEM_SealFinal(var ctx:PEM_ENCODE_SEAL_CTX;sig:Pointer;var sigl:Integer;pout:Pointer;var outl:Integer;priv:EVP_PKEY):Integer;
function  PEM_SealInit(var ctx:PEM_ENCODE_SEAL_CTX;typ:EVP_CIPHER;md_type:EVP_MD;var ek:Pointer;
	  var ekl:Integer;iv:Pointer;var pubk:EVP_PKEY;npubk:Integer):Integer;
procedure PEM_SealUpdate(var ctx:PEM_ENCODE_SEAL_CTX;pout:Pointer;var outl:Integer;pin:Pointer;inl:Integer);
function  PEM_SignFinal(var ctx:EVP_MD_CTX;sigret:Pointer;var siglen:Word;pkey:EVP_PKEY):Integer;
//procedure PEM_SignInit(var ctx:EVP_MD_CTX;typ:EVP_MD);
//procedure PEM_SignUpdate(var ctx:EVP_MD_CTX;d:Pointer;cnt:Word);
//function  PEM_X509_INFO_read(FILE *fp;sk:STACK;cb:pem_callback_func):STACK;
function  PEM_X509_INFO_read_bio(bp:BIO;sk:STACK;cb:pem_callback_func):STACK;
function  PEM_X509_INFO_write_bio(bp:BIO;xi:X509_INFO;enc:EVP_CIPHER;kstr:Pointer;klen:Integer;cb:pem_callback_func):Integer;
procedure PEM_dek_info(buf,typ:PChar;len:Integer;str:PChar);
function  PEM_do_header(cipher:EVP_CIPHER_INFO;data:Pointer;var len:LongInt;callback:pem_callback_func):Integer;
function  PEM_get_EVP_CIPHER_INFO(header:PChar;cipher:EVP_CIPHER_INFO):Integer;
procedure PEM_proc_type(buf:PChar;typ:Integer);
//function  PEM_read(FILE *fp, char **name, char **header,unsigned char **data,long *len):Integer;
//function  PEM_read_DHparams(FILE *fp,DH **x,int (*cb)()):DH;
//function  PEM_read_DSAPrivateKey(FILE *fp,DSA **x,int (*cb)()):DSA;
//function  PEM_read_DSAparams(FILE *fp,DSA **x,int (*cb)()):DSA;
//function  PEM_read_PKCS7(FILE *fp,PKCS7 **x,int (*cb)()):PKCS7;
//function  PEM_read_PrivateKey(FILE *fp,EVP_PKEY **x,int (*cb)()):EVP_PKEY;
//function  PEM_read_RSAPrivateKey(FILE *fp,RSA **x,int (*cb)()):RSA;
//function  PEM_read_RSAPublicKey(FILE *fp,RSA **x,int (*cb)()):RSA;
//function  PEM_read_X509(FILE *fp,X509 **x,int (*cb)()):X509;
//function  PEM_read_X509_CRL(FILE *fp,X509_CRL **x,int (*cb)()):X509_CRL;
//function  PEM_read_X509_REQ(FILE *fp,X509_REQ **x,int (*cb)()):X509_REQ;
function  PEM_read_bio(bp:BIO;var name,header:PChar;var data:Pointer;var len:LongInt):Integer;
function  PEM_read_bio_DHparams(bp:BIO;var x:DH;cb:pem_callback_func):DH;
function  PEM_read_bio_DSAPrivateKey(bp:BIO;var x:DSA;cb:pem_callback_func):DSA;
function  PEM_read_bio_DSAparams(bp:BIO;var x:DSA;cb:pem_callback_func):DSA;
function  PEM_read_bio_PKCS7(bp:BIO;var x:PKCS7;cb:pem_callback_func):PKCS7;
function  PEM_read_bio_PrivateKey(bp:BIO;var x:EVP_PKEY;cb:pem_callback_func):EVP_PKEY;
function  PEM_read_bio_RSAPrivateKey(bp:BIO;var x:RSA;cb:pem_callback_func):RSA;
function  PEM_read_bio_RSAPublicKey(bp:BIO;var x:RSA;cb:pem_callback_func):RSA;
function  PEM_read_bio_X509(bp:BIO;var x:X509;cb:pem_callback_func):X509;
function  PEM_read_bio_X509_CRL(bp:BIO;var x:X509_CRL;cb:pem_callback_func):X509_CRL;
function  PEM_read_bio_X509_REQ(bp:BIO;var x:X509_REQ;cb:pem_callback_func):X509_REQ;
//function  PEM_write(FILE *fp,char *name,char *hdr,unsigned char *data,long len):Integer;
//function  PEM_write_DHparams(FILE *fp,DH *x):Integer;
//function  PEM_write_DSAPrivateKey(FILE *fp,DSA *x,EVP_CIPHER *enc,unsigned char *kstr,int klen,int (*cb)()):Integer;
//function  PEM_write_DSAparams(FILE *fp,DSA *x):Integer;
//function  PEM_write_PKCS7(FILE *fp,PKCS7 *x):Integer;
//function  PEM_write_PrivateKey(FILE *fp,EVP_PKEY *x,EVP_CIPHER *enc,unsigned char *kstr,int klen,int (*cb)()):Integer;
//function  PEM_write_RSAPrivateKey(FILE *fp,RSA *x,EVP_CIPHER *enc,unsigned char *kstr,int klen,int (*cb)()):Integer;
//function  PEM_write_RSAPublicKey(FILE *fp,RSA *x):Integer;
//int PEM_write_X509(FILE *fp,X509 *x):Integer;
//int PEM_write_X509_CRL(FILE *fp,X509_CRL *x):Integer;
//int PEM_write_X509_REQ(FILE *fp,X509_REQ *x):Integer;
function  PEM_write_bio(bp:BIO;name,hdr:PChar;data:Pointer;len:LongInt):Integer;
function  PEM_write_bio_DHparams(bp:BIO;x:DH):Integer;
function  PEM_write_bio_DSAPrivateKey(bp:BIO;x:DSA;enc:EVP_CIPHER;kstr:Pointer;klen:Integer;cb:pem_callback_func):Integer;
function  PEM_write_bio_DSAparams(bp:BIO;x:DSA):Integer;
function  PEM_write_bio_PKCS7(bp:BIO;x:PKCS7):Integer;
function  PEM_write_bio_PrivateKey(bp:BIO;x:EVP_PKEY;enc:EVP_CIPHER;kstr:Pointer;klen:Integer;cb:pem_callback_func):Integer;
function  PEM_write_bio_RSAPrivateKey(bp:BIO;x:RSA;enc:EVP_CIPHER;kstr:Pointer;klen:Integer;cb:pem_callback_func):Integer;
function  PEM_write_bio_RSAPublicKey(bp:BIO;x:RSA):Integer;
function  PEM_write_bio_X509(bp:BIO;x:X509):Integer;
function  PEM_write_bio_X509_CRL(bp:BIO;x:X509_CRL):Integer;
function  PEM_write_bio_X509_REQ(bp:BIO;x:X509_REQ):Integer;

procedure PKCS7_DIGEST_free(a:PKCS7_DIGEST);
function  PKCS7_DIGEST_new:PKCS7_DIGEST;
procedure PKCS7_ENCRYPT_free(a:PKCS7_ENCRYPT);
function  PKCS7_ENCRYPT_new:PKCS7_ENCRYPT;
procedure PKCS7_ENC_CONTENT_free(a:PKCS7_ENC_CONTENT);
function  PKCS7_ENC_CONTENT_new:PKCS7_ENC_CONTENT;
procedure PKCS7_ENVELOPE_free(a:PKCS7_ENVELOPE);
function  PKCS7_ENVELOPE_new:PKCS7_ENVELOPE;
function  PKCS7_ISSUER_AND_SERIAL_digest(data:PKCS7_ISSUER_AND_SERIAL;typ:EVP_MD;md:Pointer;var len:Word):Integer;
procedure PKCS7_ISSUER_AND_SERIAL_free(a:PKCS7_ISSUER_AND_SERIAL);
function  PKCS7_ISSUER_AND_SERIAL_new:PKCS7_ISSUER_AND_SERIAL;
procedure PKCS7_RECIP_INFO_free(a:PKCS7_RECIP_INFO);
function  PKCS7_RECIP_INFO_new:PKCS7_RECIP_INFO;
function  PKCS7_RECIP_INFO_set(p7i:PKCS7_RECIP_INFO;x:X509):Integer;
procedure PKCS7_SIGNED_free(a:PKCS7_SIGNED);
function  PKCS7_SIGNED_new:PKCS7_SIGNED;
procedure PKCS7_SIGNER_INFO_free(a:PKCS7_SIGNER_INFO);
function  PKCS7_SIGNER_INFO_new:PKCS7_SIGNER_INFO;
function  PKCS7_SIGNER_INFO_set(p7i:PKCS7_SIGNER_INFO;x:X509;pkey:EVP_PKEY;dgst:EVP_MD):Integer;
procedure PKCS7_SIGN_ENVELOPE_free(a:PKCS7_SIGN_ENVELOPE);
function  PKCS7_SIGN_ENVELOPE_new:PKCS7_SIGN_ENVELOPE;
function  PKCS7_add_certificate(p7:PKCS7;cert:X509):Integer;
function  PKCS7_add_crl(p7:PKCS7;crl:X509_CRL):Integer;
function  PKCS7_add_recipient(p7:PKCS7;x:X509):PKCS7_RECIP_INFO;
function  PKCS7_add_recipient_info(p7:PKCS7;ri:PKCS7_RECIP_INFO):Integer;
function  PKCS7_add_signature(p7:PKCS7;x:X509;pkey:EVP_PKEY;dgst:EVP_MD):PKCS7_SIGNER_INFO;
function  PKCS7_add_signer(p7:PKCS7;p7i:PKCS7_SIGNER_INFO):Integer;
function  PKCS7_cert_from_signer_info(p7:PKCS7;si:PKCS7_SIGNER_INFO):X509;
procedure PKCS7_content_free(a:PKCS7);
function  PKCS7_content_new(p7:PKCS7;nid:Integer):Integer;
function  PKCS7_ctrl(p7:PKCS7;cmd:Integer;larg:LongInt;parg:Pointer):LongInt;
function  PKCS7_dataInit(p7:PKCS7;b:BIO):BIO;
function  PKCS7_dataSign(p7:PKCS7;b:BIO):Integer;
function  PKCS7_dataVerify(cert_store:X509_STORE;var ctx:X509_STORE_CTX;b:BIO;p7:PKCS7;si:PKCS7_SIGNER_INFO):Integer;
function  PKCS7_dup(p7:PKCS7):PKCS7;
procedure PKCS7_free(a:PKCS7);
function  PKCS7_get_signer_info(p7:PKCS7):STACK;
function  PKCS7_new:PKCS7;
function  PKCS7_set_cipher(p7:PKCS7;cipher:EVP_CIPHER):Integer;
function  PKCS7_set_content(p7,p7_data:PKCS7):Integer;
function  PKCS7_set_type(p7:PKCS7;typ:Integer):Integer;

procedure RAND_bytes(var buf;num:Integer);
procedure RAND_cleanup;
function  RAND_file_name(fname:PChar;num:Integer):PChar;
function  RAND_load_file(fname:PChar;max_bytes:LongInt):Integer;
procedure RAND_seed(var buf;num:Integer);
function  RAND_write_file(fname:PChar):Integer;

procedure RC2_cbc_encrypt(pin,pout:Pointer;length:LongInt;var ks:RC2_KEY;iv:Pointer;enc:Integer);
procedure RC2_cfb64_encrypt(pin,pout:Pointer;length:LongInt;var schedule:RC2_KEY;ivec:Pointer;var num:Integer;enc:Integer);
procedure RC2_decrypt(var data:Cardinal;var key:RC2_KEY);
procedure RC2_ecb_encrypt(pin,pout:Pointer;var key:RC2_KEY;enc:Integer);
procedure RC2_encrypt(var data:Cardinal;var key:RC2_KEY);
procedure RC2_ofb64_encrypt(pin,pout:Pointer;length:LongInt;var schedule:RC2_KEY;ivec:Pointer;var num:Integer);
procedure RC2_set_key(var key:RC2_KEY;len:Integer;data:Pointer;bits:Integer);

procedure RC4(var key:RC4_KEY;len:Cardinal;indata,outdata:Pointer);
function  RC4_options:PChar;
procedure RC4_set_key(var key:RC4_KEY;len:Integer;data:Pointer);

procedure RC5_32_cbc_encrypt(pin,pout:Pointer;length:LongInt;var ks:RC5_32_KEY;iv:Pointer;enc:Integer);
procedure RC5_32_cfb64_encrypt(pin,pout:Pointer;length:LongInt;var schedule:RC5_32_KEY;iv:Pointer;var num:Integer;enc:Integer);
procedure RC5_32_decrypt(var data:Cardinal;var key:RC5_32_KEY);
procedure RC5_32_ecb_encrypt(pin,pout:Pointer;var key:RC5_32_KEY;enc:Integer);
procedure RC5_32_encrypt(var data:Cardinal;var key:RC5_32_KEY);
procedure RC5_32_ofb64_encrypt(pin,pout:Pointer;length:LongInt;var schedule:RC5_32_KEY;ivec:Pointer;var num:Integer);
procedure RC5_32_set_key(var key:RC5_32_KEY;len:Integer;data:Pointer;rounds:Integer);

function  RIPEMD160(d:Pointer;n:Cardinal;md:Pointer):Pointer;
procedure RIPEMD160_Final(md:Pointer;var c:RIPEMD160_CTX);
procedure RIPEMD160_Init(var c:RIPEMD160_CTX);
procedure RIPEMD160_Transform(var c:RIPEMD160_CTX;b:Pointer);
procedure RIPEMD160_Update(var c:RIPEMD160_CTX; data:Pointer;len:Cardinal);

function  RSAPrivateKey_asn1_meth:ASN1_METHOD;
function  RSAPrivateKey_dup(r:RSA):RSA;
function  RSAPublicKey_dup(r:RSA):RSA;
//function  RSA_PKCS1_RSAref:RSA_METHOD;  (* If you have RSAref compiled in. *)
function  RSA_PKCS1_SSLeay:RSA_METHOD;	(* these are the actual SSLeay RSA functions *)
procedure RSA_blinding_off(r:RSA);
function  RSA_blinding_on(r:RSA;ctx:BN_CTX):Integer;
function  RSA_flags(r:RSA):PChar;
procedure RSA_free(r:RSA);
function  RSA_generate_key(bits:Integer;e:Cardinal;callback:rsa_gen_key_cb;cb_arg:PChar):RSA;
function  RSA_get_ex_data(r:RSA;idx:Integer):PChar;
function  RSA_get_ex_new_index(argl:LongInt;argp:PChar;
	  new_func:crypto_ex_new_func;dup_func:crypto_ex_dup_func;free_func:crypto_ex_free_func):Integer;
function  RSA_new:RSA;
function  RSA_new_method(method:RSA_METHOD):RSA;
function  RSA_padding_add_PKCS1_type_1(pto:Pointer;tlen:Integer;f:Pointer;fl:Integer):Integer;
function  RSA_padding_add_PKCS1_type_2(pto:Pointer;tlen:Integer;f:Pointer;fl:Integer):Integer;
function  RSA_padding_add_SSLv23(pto:Pointer;tlen:Integer;f:Pointer;fl:Integer):Integer;
function  RSA_padding_add_none(pto:Pointer;tlen:Integer;f:Pointer;fl:Integer):Integer;
function  RSA_padding_check_PKCS1_type_1(pto:Pointer;tlen:Integer;f:Pointer;fl:Integer):Integer;
function  RSA_padding_check_PKCS1_type_2(pto:Pointer;tlen:Integer;f:Pointer;fl:Integer):Integer;
function  RSA_padding_check_SSLv23(pto:Pointer;tlen:Integer;f:Pointer;fl:Integer):Integer;
function  RSA_padding_check_none(pto:Pointer;tlen:Integer;f:Pointer;fl:Integer):Integer;
function  RSA_print(bp:BIO;r:RSA;offset:Integer):Integer;
//function  RSA_print_fp(FILE *fp, RSA *r,int offset):Integer;
function  RSA_private_decrypt(flen:Integer;pfrom,pto:Pointer;r:RSA;padding:Integer):Integer;
function  RSA_private_encrypt(flen:Integer;pfrom,pto:Pointer;r:RSA;padding:Integer):Integer;
function  RSA_public_decrypt(flen:Integer;pfrom,pto:Pointer;r:RSA;padding:Integer):Integer;
function  RSA_public_encrypt(flen:Integer;pfrom,pto:Pointer;r:RSA;padding:Integer):Integer;
procedure RSA_set_default_method(meth:RSA_METHOD);
function  RSA_set_ex_data(r:RSA;idx:Integer;arg:PChar):Integer;
function  RSA_sign(typ:Integer;m:Pointer;m_len:Word;sigret:Pointer;var siglen:Word;r:RSA):Integer;
function  RSA_sign_ASN1_OCTET_STRING(typ:Integer;m:Pointer;m_len:Word;sigret:Pointer;var siglen:Word;r:RSA):Integer;
function  RSA_size(r:RSA):Integer;
function  RSA_verify(typ:Integer;m:Pointer;m_len:Word;sigbuf:Pointer;siglen:Word;r:RSA):Integer;
function  RSA_verify_ASN1_OCTET_STRING(typ:Integer;m:Pointer;m_len:Word;sigbuf:Pointer;siglen:Word;r:RSA):Integer;

function  SHA(d:Pointer; n:Cardinal; md:Pointer):Pointer;
function  SHA1(d:Pointer; n:Cardinal; md:Pointer):Pointer;
procedure SHA1_Final(md:Pointer;var c:SHA_CTX);
procedure SHA1_Init(var c:SHA_CTX);
procedure SHA1_Transform(var c:SHA_CTX;data:Pointer);
procedure SHA1_Update(var c:SHA_CTX; data:Pointer; len:Cardinal);
procedure SHA_Final(md:Pointer;var c:SHA_CTX);
procedure SHA_Init(var c:SHA_CTX);
procedure SHA_Transform(var c:SHA_CTX;data:Pointer);
procedure SHA_Update(var c:SHA_CTX; data:Pointer; len:Cardinal);

function  TXT_DB_create_index(db:TXT_DB;field:Integer;qual:txt_db_qual_func;
	  hash:lhash_hash_func;cmp:lhash_comp_func):Integer;
procedure TXT_DB_free(db:TXT_DB);
function  TXT_DB_get_by_index(db:TXT_DB;idx:Integer;var value:PChar):PPChar;
function  TXT_DB_insert(db:TXT_DB;var value:PChar):Integer;
function  TXT_DB_read(fin:PChar;num:Integer):TXT_DB;
function  TXT_DB_write(fout:PChar;db:TXT_DB):LongInt;

procedure X509_ALGOR_free(a:X509_ALGOR);
function  X509_ALGOR_new:X509_ALGOR;
procedure X509_ATTRIBUTE_free(a:X509_ATTRIBUTE);
function  X509_ATTRIBUTE_new:X509_ATTRIBUTE;
procedure X509_CINF_free(a:X509_CINF);
function  X509_CINF_new:X509_CINF;
procedure X509_CRL_INFO_free(a:X509_CRL_INFO);
function  X509_CRL_INFO_new:X509_CRL_INFO;
function  X509_CRL_add_ext(x:X509_CRL; ex:X509_EXTENSION; loc:Integer):Integer;
function  X509_CRL_cmp(a,b:X509_CRL):Integer;
function  X509_CRL_delete_ext(x:X509_CRL; loc:Integer):X509_EXTENSION;
function  X509_CRL_dup(crl:X509_CRL):X509_CRL;
procedure X509_CRL_free(a:X509_CRL);
function  X509_CRL_get_ext(x:X509_CRL; loc:Integer):X509_EXTENSION;
function  X509_CRL_get_ext_by_NID(x:X509_CRL; nid, lastpos:Integer):Integer;
function  X509_CRL_get_ext_by_OBJ(x:X509_CRL;obj:ASN1_OBJECT;lastpos:Integer):Integer;
function  X509_CRL_get_ext_by_critical(x:X509_CRL; crit, lastpos:Integer):Integer;
function  X509_CRL_get_ext_count(x:X509_CRL):Integer;
function  X509_CRL_new:X509_CRL;
function  X509_CRL_sign(x:X509_CRL;pkey:EVP_PKEY;md:EVP_MD):Integer;
function  X509_CRL_verify(a:X509_CRL;r:EVP_PKEY):Integer;
function  X509_EXTENSION_create_by_NID(var ex:X509_EXTENSION;nid, crit:Integer;data:ASN1_OCTET_STRING):X509_EXTENSION;
function  X509_EXTENSION_create_by_OBJ(var ex:X509_EXTENSION;obj:ASN1_OBJECT;crit:Integer;data:ASN1_OCTET_STRING):X509_EXTENSION;
function  X509_EXTENSION_dup(ex:X509_EXTENSION):X509_EXTENSION;
procedure X509_EXTENSION_free(a:X509_EXTENSION);
function  X509_EXTENSION_get_critical(ex:X509_EXTENSION):Integer;
function  X509_EXTENSION_get_data(ne:X509_EXTENSION):ASN1_OCTET_STRING;
function  X509_EXTENSION_get_object(ex:X509_EXTENSION):ASN1_OBJECT;
function  X509_EXTENSION_new:X509_EXTENSION;
function  X509_EXTENSION_set_critical(ex:X509_EXTENSION;crit:Integer):Integer;
function  X509_EXTENSION_set_data(ex:X509_EXTENSION;data:ASN1_OCTET_STRING):Integer;
function  X509_EXTENSION_set_object(ex:X509_EXTENSION;obj:ASN1_OBJECT):Integer;
procedure X509_INFO_free(a:X509_INFO);
function  X509_INFO_new:X509_INFO;
function  X509_LOOKUP_by_alias(ctx:X509_LOOKUP;typ:Integer;str:PChar;len:Integer;ret:X509_OBJECT):Integer;
function  X509_LOOKUP_by_fingerprint(ctx:X509_LOOKUP;typ:Integer;bytes:Pointer;len:Integer;ret:X509_OBJECT):Integer;
function  X509_LOOKUP_by_issuer_serial(ctx:X509_LOOKUP;typ:Integer;name:X509_NAME;serial:ASN1_INTEGER;ret:X509_OBJECT):Integer;
function  X509_LOOKUP_by_subject(ctx:X509_LOOKUP;typ:Integer;name:X509_NAME;ret:X509_OBJECT):Integer;
function  X509_LOOKUP_ctrl(ctx:X509_LOOKUP;cmd:Integer;argc:PChar;argl:LongInt;var ret:PChar):Integer;
function  X509_LOOKUP_file:X509_LOOKUP_METHOD;(* These are used by EVP_CIPHER methods *)
procedure X509_LOOKUP_free(ctx:X509_LOOKUP);
function  X509_LOOKUP_hash_dir:X509_LOOKUP_METHOD;
function  X509_LOOKUP_init(ctx:X509_LOOKUP):Integer;
function  X509_LOOKUP_new(method:X509_LOOKUP_METHOD):X509_LOOKUP;
function  X509_LOOKUP_shutdown(ctx:X509_LOOKUP):Integer;
function  X509_NAME_ENTRY_create_by_NID(var ne:X509_NAME_ENTRY;nid,typ:Integer;bytes:Pointer;len:Integer):X509_NAME_ENTRY;
function  X509_NAME_ENTRY_create_by_OBJ(var ne:X509_NAME_ENTRY;obj:ASN1_OBJECT;typ:Integer;bytes:Pointer;len:Integer):X509_NAME_ENTRY;
function  X509_NAME_ENTRY_dup(ne:X509_NAME_ENTRY):X509_NAME_ENTRY;
procedure X509_NAME_ENTRY_free(a:X509_NAME_ENTRY);
function  X509_NAME_ENTRY_get_data(ne:X509_NAME_ENTRY):ASN1_STRING;
function  X509_NAME_ENTRY_get_object(ne:X509_NAME_ENTRY):ASN1_OBJECT;
function  X509_NAME_ENTRY_new:X509_NAME_ENTRY;
function  X509_NAME_ENTRY_set_data(ne:X509_NAME_ENTRY;typ:Integer;bytes:Pointer;len:Integer):Integer;
function  X509_NAME_ENTRY_set_object(ne:X509_NAME_ENTRY;obj:ASN1_OBJECT):Integer;
function  X509_NAME_add_entry(name:X509_NAME;ne:X509_NAME_ENTRY;loc:Integer;set_:Integer):Integer;
function  X509_NAME_cmp(a,b:X509_NAME):Integer;
function  X509_NAME_delete_entry(name:X509_NAME;loc:Integer):X509_NAME_ENTRY;
function  X509_NAME_digest(data:X509_NAME;typ:EVP_MD;md:Pointer;var len:Word):Integer;
function  X509_NAME_dup(xn:X509_NAME):X509_NAME;
function  X509_NAME_entry_count(name:X509_NAME):Integer;
procedure X509_NAME_free(a:X509_NAME);
function  X509_NAME_get_entry(name:X509_NAME;loc:Integer):X509_NAME_ENTRY;
function  X509_NAME_get_index_by_NID(name:X509_NAME;nid,lastpos:Integer):Integer;
function  X509_NAME_get_index_by_OBJ(name:X509_NAME;obj:ASN1_OBJECT;lastpos:Integer):Integer;
function  X509_NAME_get_text_by_NID(name:X509_NAME;nid:Integer;buf:PChar;len:Integer):Integer;
function  X509_NAME_get_text_by_OBJ(name:X509_NAME;obj:ASN1_OBJECT;buf:PChar;len:Integer):Integer;
function  X509_NAME_hash(x:X509_NAME):Cardinal;
function  X509_NAME_new:X509_NAME;
function  X509_NAME_oneline(a:X509_NAME;buf:PChar;size:Integer):PChar;
function  X509_NAME_print(bp:BIO;name:X509_NAME;obase:Integer):Integer;
function  X509_NAME_set(var xn:X509_NAME;name:X509_NAME):Integer;
procedure X509_OBJECT_free_contents(a:X509_OBJECT);
function  X509_OBJECT_retrive_by_subject(h:LHASH;typ:Integer;name:X509_NAME):X509_OBJECT;
procedure X509_OBJECT_up_ref_count(a:X509_OBJECT);
procedure X509_PKEY_free(a:X509_PKEY);
function  X509_PKEY_new:X509_PKEY;
procedure X509_PUBKEY_free(a:X509_PUBKEY);
function  X509_PUBKEY_new:X509_PUBKEY;
function  X509_PUBKEY_get(key:X509_PUBKEY):EVP_PKEY;
function  X509_PUBKEY_set(var x:X509_PUBKEY;pkey:EVP_PKEY):Integer;
procedure X509_REQ_INFO_free(a:X509_REQ_INFO);
function  X509_REQ_INFO_new:X509_REQ_INFO;
function  X509_REQ_dup(req:X509_REQ):X509_REQ;
procedure X509_REQ_free(a:X509_REQ);
function  X509_REQ_get_pubkey(req:X509_REQ):EVP_PKEY;
function  X509_REQ_new:X509_REQ;
function  X509_REQ_print(bp:BIO;req:X509_REQ):Integer;
//function  X509_REQ_print_fp(FILE *bp,X509_REQ *req):Integer;
function  X509_REQ_set_pubkey(x:X509_REQ;pkey:EVP_PKEY):Integer;
function  X509_REQ_set_subject_name(req:X509_REQ;name:X509_NAME):Integer;
function  X509_REQ_set_version(x:X509_REQ;version:LongInt):Integer;
function  X509_REQ_sign(x:X509_REQ;pkey:EVP_PKEY;md:EVP_MD):Integer;
function  X509_REQ_to_X509(r:X509_REQ;days:Integer;pkey:EVP_PKEY):X509;
function  X509_REQ_verify(a:X509_REQ;r:EVP_PKEY):Integer;
function  X509_REVOKED_add_ext(x:X509_REVOKED; ex:X509_EXTENSION; loc:Integer):Integer;
function  X509_REVOKED_delete_ext(x:X509_REVOKED; loc:Integer):X509_EXTENSION;
procedure X509_REVOKED_free(a:X509_REVOKED);
function  X509_REVOKED_get_ext(x:X509_REVOKED; loc:Integer):X509_EXTENSION;
function  X509_REVOKED_get_ext_by_critical(x:X509_REVOKED; crit, lastpos:Integer):Integer;
function  X509_REVOKED_get_ext_by_NID(x:X509_REVOKED; nid, lastpos:Integer):Integer;
function  X509_REVOKED_get_ext_by_OBJ(x:X509_REVOKED;obj:ASN1_OBJECT;lastpos:Integer):Integer;
function  X509_REVOKED_get_ext_count(x:X509_REVOKED):Integer;
function  X509_REVOKED_new:X509_REVOKED;
procedure X509_SIG_free(a:X509_SIG);
function  X509_SIG_new:X509_SIG;
procedure X509_STORE_CTX_cleanup(var ctx:X509_STORE_CTX);
function  X509_STORE_CTX_get_chain(var ctx:X509_STORE_CTX):STACK;
function  X509_STORE_CTX_get_current_cert(var ctx:X509_STORE_CTX):X509;
function  X509_STORE_CTX_get_error(var ctx:X509_STORE_CTX):Integer;
function  X509_STORE_CTX_get_error_depth(var ctx:X509_STORE_CTX):Integer;
function  X509_STORE_CTX_get_ex_data(var ctx:X509_STORE_CTX;idx:Integer):PChar;
procedure X509_STORE_CTX_init(var ctx:X509_STORE_CTX;store:X509_STORE;x509:X509;chain:STACK);
procedure X509_STORE_CTX_set_cert(var c:X509_STORE_CTX;x:X509);
procedure X509_STORE_CTX_set_chain(var c:X509_STORE_CTX;sk:STACK (* X509 *));
procedure X509_STORE_CTX_set_error(var ctx:X509_STORE_CTX;s:Integer);
function  X509_STORE_CTX_set_ex_data(var ctx:X509_STORE_CTX;idx:Integer;data:PChar):Integer;
function  X509_STORE_add_cert(ctx:X509_STORE;x:X509):Integer;
function  X509_STORE_add_crl(ctx:X509_STORE;x:X509_CRL):Integer;
function  X509_STORE_add_lookup(v:X509_STORE;m:X509_LOOKUP_METHOD):X509_LOOKUP;
procedure X509_STORE_free(v:X509_STORE);
function  X509_STORE_get_by_subject(var vs:X509_STORE_CTX;typ:Integer;name:X509_NAME;ret:X509_OBJECT):Integer;
function  X509_STORE_load_locations (ctx:X509_STORE;fname,dir:PChar):Integer;
function  X509_STORE_new:X509_STORE;
function  X509_STORE_set_default_paths(ctx:X509_STORE):Integer;
procedure X509_VAL_free(a:X509_VAL);
function  X509_VAL_new:X509_VAL;
function  X509_add_ext(x:X509; ex:X509_EXTENSION;loc:Integer):Integer;
function  X509_asn1_meth:ASN1_METHOD;(* Not used that much at this point, except for the first two *)
function  X509_certificate_type(x:X509;pubkey:EVP_PKEY(* optional *)):Integer;
function  X509_check_private_key(x:X509;pkey:EVP_PKEY):Integer;
function  X509_cmp_current_time(s:ASN1_UTCTIME):Integer;
function  X509_delete_ext(x:X509; loc:Integer):X509_EXTENSION;
function  X509_digest(data:X509;typ:EVP_MD;md:Pointer;len:Word):Integer;
function  X509_dup(x:X509):X509;
function  X509_find_by_issuer_and_serial(sk:STACK;name:X509_NAME;serial:ASN1_INTEGER):X509;(* lookup a cert from a X509 STACK *)
function  X509_find_by_subject(sk:STACK;name:X509_NAME):X509;
procedure X509_free(a:X509);
function  X509_get_default_cert_area:PChar;
function  X509_get_default_cert_dir:PChar;
function  X509_get_default_cert_dir_env:PChar;
function  X509_get_default_cert_file:PChar;
function  X509_get_default_cert_file_env:PChar;
function  X509_get_default_private_dir:PChar;
function  X509_get_ext(x:X509; loc:Integer):X509_EXTENSION;
function  X509_get_ext_by_NID(x:X509;nid, lastpos:Integer):Integer;
function  X509_get_ext_by_OBJ(x:X509;obj:ASN1_OBJECT;lastpos:Integer):Integer;
function  X509_get_ext_by_critical(x:X509; crit, lastpos:Integer):Integer;
function  X509_get_ext_count(x:X509):Integer;
function  X509_get_issuer_name(a:X509):X509_NAME;
function  X509_get_pubkey(x:X509):EVP_PKEY;
function  X509_get_pubkey_parameters(pkey:EVP_PKEY;chain:STACK):Integer;
function  X509_get_serialNumber(x:X509):ASN1_INTEGER;
function  X509_get_subject_name(a:X509):X509_NAME;
function  X509_gmtime_adj(s:ASN1_UTCTIME;adj:LongInt):ASN1_UTCTIME;
function  X509_issuer_and_serial_cmp(a,b:X509):Integer;
function  X509_issuer_and_serial_hash(a:X509):Cardinal;
function  X509_issuer_name_cmp(a,b:X509):Integer;
function  X509_issuer_name_hash(a:X509):Cardinal;
function  X509_load_cert_file(ctx:X509_LOOKUP;fname:PChar;typ:Integer):Integer;
function  X509_load_crl_file(ctx:X509_LOOKUP;fname:PChar;typ:Integer):Integer;
function  X509_new:X509;
function  X509_print(bp:BIO;x:X509):Integer;
//function  X509_print_fp(FILE *bp,X509 *x):Integer;
function  X509_set_issuer_name(x:X509;name:X509_NAME):Integer;
function  X509_set_notAfter(x:X509;tm:ASN1_UTCTIME):Integer;
function  X509_set_notBefore(x:X509;tm:ASN1_UTCTIME):Integer;
function  X509_set_pubkey(x:X509;pkey:EVP_PKEY):Integer;
function  X509_set_serialNumber(x:X509;serial:ASN1_INTEGER):Integer;
function  X509_set_subject_name(x:X509;name:X509_NAME):Integer;
function  X509_set_version(x:X509;version:LongInt):Integer;
function  X509_sign(x:X509;pkey:EVP_PKEY;md:EVP_MD):Integer;
function  X509_subject_name_cmp(a,b:X509):Integer;
function  X509_subject_name_hash(x:X509):Cardinal;
function  X509_to_X509_REQ(x:X509;pkey:EVP_PKEY;md:EVP_MD):X509_REQ;
function  X509_verify(a:X509;r:EVP_PKEY):Integer;
function  X509_verify_cert(var ctx:X509_STORE_CTX):Integer;
function  X509_verify_cert_error_string(n:LongInt):PChar;

function  X509v3_add_ext(var x:STACK;ex:X509_EXTENSION;loc:Integer):STACK;
function  X509v3_add_extension(x:X509_EXTENSION_METHOD):Integer;
function  X509v3_add_netscape_extensions:Integer;
function  X509v3_add_standard_extensions:Integer;
procedure X509v3_cleanup_extensions;
function  X509v3_data_type_by_OBJ(obj:ASN1_OBJECT):Integer;
function  X509v3_data_type_by_NID(nid:Integer):Integer;
function  X509v3_delete_ext(x:STACK;loc:Integer):X509_EXTENSION;
function  X509v3_get_ext(x:STACK;loc:Integer):X509_EXTENSION;
function  X509v3_get_ext_by_NID(x:STACK;nid, lastpos:Integer):Integer;
function  X509v3_get_ext_by_OBJ(x:STACK;obj:ASN1_OBJECT;lastpos:Integer):Integer;
function  X509v3_get_ext_by_critical(x:STACK;crit, lastpos:Integer):Integer;
function  X509v3_get_ext_count(x:STACK):Integer;
function  X509v3_pack_string(var ex:ASN1_OCTET_STRING;typ:Integer;bytes:Pointer;len:Integer):ASN1_OCTET_STRING;
function  X509v3_pack_type_by_OBJ(obj:ASN1_OBJECT):Integer;
function  X509v3_pack_type_by_NID(nid:Integer):Integer;
function  X509v3_unpack_string(var ex:ASN1_STRING;typ:Integer;os:ASN1_OCTET_STRING):ASN1_STRING;

function  a2d_ASN1_OBJECT(pout:Pointer;olen:Integer;buf:PChar;num:Integer):Integer;
function  a2i_ASN1_INTEGER(bp:BIO;bs:ASN1_INTEGER;buf:Pointer;size:Integer):Integer;
function  a2i_ASN1_STRING(bp:BIO;bs:ASN1_STRING;buf:Pointer;size:Integer):Integer;
function  asn1_Finish(c:ASN1_CTX):Integer;	    (* PARSING *)

function  bn_add_words(var rp,ap,bp:Cardinal;num:Integer):Cardinal;
function  bn_div64(h,l,d:Cardinal):Cardinal;
function  bn_expand2(b:BIGNUM;bits:Integer):BIGNUM;
function  bn_mul_add_words(var rp,ap:Cardinal;num:Integer;w:Cardinal):Cardinal;
function  bn_mul_words(var rp,ap:Cardinal;num:Integer;w:Cardinal):Cardinal;
procedure bn_qadd(r,a,b:BIGNUM);
procedure bn_qsub(r,a,b:BIGNUM);
procedure bn_sqr_words(var rp,ap:Cardinal;num:Integer);

function  crypt(const buf,salt:PChar):PChar;

function  d2i_ASN1_BIT_STRING(var a:ASN1_BIT_STRING;var pp:Pointer;length:LongInt):ASN1_BIT_STRING;
function  d2i_ASN1_BOOLEAN(var a:Integer;var pp:Pointer;length:LongInt):Integer;
function  d2i_ASN1_HEADER(var a:ASN1_HEADER;var pp:Pointer;length:LongInt):ASN1_HEADER;
function  d2i_ASN1_IA5STRING(a:ASN1_IA5STRING;var pp:Pointer;l:LongInt):ASN1_IA5STRING;
function  d2i_ASN1_INTEGER(var a:ASN1_INTEGER;var pp:Pointer;length:LongInt):ASN1_INTEGER;
function  d2i_ASN1_T61STRING(var a:ASN1_T61STRING;var pp:Pointer;l:LongInt):ASN1_T61STRING;
function  d2i_ASN1_TYPE(var a:ASN1_TYPE;var pp:Pointer;length:LongInt):ASN1_TYPE;
function  d2i_ASN1_OCTET_STRING(var a:ASN1_OCTET_STRING;var pp:Pointer;length:LongInt):ASN1_OCTET_STRING;
function  d2i_ASN1_OBJECT(var a:ASN1_OBJECT;var pp:Pointer;length:LongInt):ASN1_OBJECT;
function  d2i_ASN1_PRINTABLE(var a:ASN1_STRING;var pp:Pointer;l:LongInt):ASN1_STRING;
function  d2i_ASN1_PRINTABLESTRING(var a:ASN1_PRINTABLESTRING;var pp:Pointer;l:LongInt):ASN1_PRINTABLESTRING;
function  d2i_ASN1_SET(var a:STACK;var pp:Pointer;length:LongInt;func:stack_func;ex_tag, ex_class:Integer):STACK;
function  d2i_ASN1_UTCTIME(var a:ASN1_UTCTIME;var pp:Pointer;length:LongInt):ASN1_UTCTIME;
function  d2i_ASN1_bytes(var a:ASN1_STRING;var pp:Pointer;length:LongInt;Ptag, Pclass:Integer):ASN1_STRING;
function  d2i_ASN1_type_bytes(var a:ASN1_STRING;var pp:Pointer;length:LongInt;typ:Integer):ASN1_STRING;
function  d2i_DHparams(var a:DH;var pp:Pointer; length:LongInt):DH;
function  d2i_DSAPrivateKey(var a:DSA;var pp:Pointer;length:Longint):DSA;
function  d2i_DSAPrivateKey_bio(bp:BIO;d:DSA):DSA;
//function  d2i_DSAPrivateKey_fp(FILE *fp, DSA *dsa):DSA;
function  d2i_DSAPublicKey(var a:DSA;var pp:Pointer;length:Longint):DSA;
function  d2i_DSAparams(var a:DSA;var pp:Pointer;length:Longint):DSA;
function  d2i_NETSCAPE_SPKAC(var a:NETSCAPE_SPKAC;var pp:Pointer;length:LongInt):NETSCAPE_SPKAC;
function  d2i_NETSCAPE_SPKI(var a:NETSCAPE_SPKI;var pp:Pointer;length:LongInt):NETSCAPE_SPKI;
function  d2i_Netscape_RSA(var a:RSA;var pp:Pointer;length:LongInt;var cb):RSA;
function  d2i_Netscape_RSA_2(var a:RSA;var pp:Pointer;length:LongInt;var cb):RSA;
function  d2i_PKCS7(var a:PKCS7;var pp:Pointer;length:LongInt):PKCS7;
function  d2i_PKCS7_DIGEST(var a:PKCS7_DIGEST;var pp:Pointer;length:LongInt):PKCS7_DIGEST;
function  d2i_PKCS7_ENC_CONTENT(var a:PKCS7_ENC_CONTENT;var pp:Pointer;length:LongInt):PKCS7_ENC_CONTENT;
function  d2i_PKCS7_ENCRYPT(var a:PKCS7_ENCRYPT;var pp:Pointer;length:LongInt):PKCS7_ENCRYPT;
function  d2i_PKCS7_ENVELOPE(var a:PKCS7_ENVELOPE;var pp:Pointer;length:LongInt):PKCS7_ENVELOPE;
function  d2i_PKCS7_ISSUER_AND_SERIAL(var a:PKCS7_ISSUER_AND_SERIAL;var pp:Pointer;length:LongInt):PKCS7_ISSUER_AND_SERIAL;
function  d2i_PKCS7_RECIP_INFO(var a:PKCS7_RECIP_INFO;var pp:Pointer;length:LongInt):PKCS7_RECIP_INFO;
function  d2i_PKCS7_SIGN_ENVELOPE(var a:PKCS7_SIGN_ENVELOPE;var pp:Pointer;length:LongInt):PKCS7_SIGN_ENVELOPE;
function  d2i_PKCS7_SIGNED(var a:PKCS7_SIGNED;var pp:Pointer;length:LongInt):PKCS7_SIGNED;
function  d2i_PKCS7_SIGNER_INFO(var a:PKCS7_SIGNER_INFO;var pp:Pointer;length:LongInt):PKCS7_SIGNER_INFO;
function  d2i_PKCS7_bio(bp:BIO;p7:PKCS7):PKCS7;
//function  d2i_PKCS7_fp(FILE *fp,PKCS7 *p7):PKCS7;
function  d2i_PrivateKey(typ:Integer;var a:EVP_PKEY;var pp:Pointer;length:LongInt):EVP_PKEY;
function  d2i_PublicKey(typ:Integer;var a:EVP_PKEY;var pp:Pointer;length:LongInt):EVP_PKEY;
function  d2i_RSAPrivateKey(var a:RSA;var pp:Pointer;length:LongInt):RSA;
function  d2i_RSAPrivateKey_bio(bp:BIO;r:RSA):RSA;
//function  d2i_RSAPrivateKey_fp(FILE *fp,RSA *rsa):RSA;
function  d2i_RSAPublicKey(var a:RSA;var pp:Pointer;length:LongInt):RSA;
function  d2i_RSAPublicKey_bio(bp:BIO;r:RSA):RSA;
//function  d2i_RSAPublicKey_fp(FILE *fp,RSA *rsa):RSA;
function  d2i_X509(var a:X509;var pp:Pointer;length:LongInt):X509;
function  d2i_X509_ALGOR(var a:X509_ALGOR;var pp:Pointer;length:LongInt):X509_ALGOR;
function  d2i_X509_ATTRIBUTE(var a:X509_ATTRIBUTE;var pp:Pointer;length:LongInt):X509_ATTRIBUTE;
function  d2i_X509_CINF(var a:X509_CINF;var pp:Pointer;length:LongInt):X509_CINF;
function  d2i_X509_CRL(var a:X509_CRL;var pp:Pointer;length:LongInt):X509_CRL;
function  d2i_X509_CRL_INFO(var a:X509_CRL_INFO;var pp:Pointer;length:LongInt):X509_CRL_INFO;
function  d2i_X509_CRL_bio(bp:BIO;crl:X509_CRL):X509_CRL;
//function  d2i_X509_CRL_fp(FILE *fp,X509_CRL *crl):X509_CRL;
function  d2i_X509_EXTENSION(var a:X509_EXTENSION;var pp:Pointer;length:LongInt):X509_EXTENSION;
function  d2i_X509_NAME(var a:X509_NAME;var pp:Pointer;length:LongInt):X509_NAME;
function  d2i_X509_NAME_ENTRY(var a:X509_NAME_ENTRY;var pp:Pointer;length:LongInt):X509_NAME_ENTRY;
function  d2i_X509_PKEY(var a:X509_PKEY;var pp:Pointer;length:LongInt):X509_PKEY;
function  d2i_X509_PUBKEY(var a:X509_PUBKEY;var pp:Pointer;length:LongInt):X509_PUBKEY;
function  d2i_X509_REQ(var a:X509_REQ;var pp:Pointer;length:LongInt):X509_REQ;
function  d2i_X509_REQ_INFO(var a:X509_REQ_INFO;var pp:Pointer;length:LongInt):X509_REQ_INFO;
function  d2i_X509_REQ_bio(bp:BIO;req:X509_REQ):X509_REQ;
//function  d2i_X509_REQ_fp(FILE *fp,X509_REQ *req):X509_REQ;
function  d2i_X509_REVOKED(var a:X509_REVOKED;var pp:Pointer;length:LongInt):X509_REVOKED;
function  d2i_X509_SIG(var a:X509_SIG;var pp:Pointer;length:LongInt):X509_SIG;
function  d2i_X509_VAL(var a:X509_VAL;var pp:Pointer;length:LongInt):X509_VAL;
function  d2i_X509_bio(bp:BIO;x:X509):X509;
//function  d2i_X509_fp(FILE *fp, X509 *x509):X509;

function  des_cbc_cksum(var input,output:des_cblock;length:LongInt;schedule:des_key_schedule;var ivec:des_cblock):Cardinal;
procedure des_cbc_encrypt(var input,output:des_cblock;length:LongInt;schedule:des_key_schedule;var ivec:des_cblock;enc:Integer);
//procedure des_cblock_print_file(des_cblock *cb, FILE *fp);
procedure des_cfb64_encrypt(pin,pout:Pointer;length:LongInt;schedule:des_key_schedule;var ivec:des_cblock;var num:Integer;enc:Integer);
procedure des_cfb_encrypt(pin,pout:Pointer;numbits:Integer;length:LongInt;schedule:des_key_schedule;var ivec:des_cblock;enc:Integer);
procedure des_decrypt3(var data:Cardinal;ks1,ks2,ks3:des_key_schedule);
procedure des_ecb3_encrypt(var input,output:des_cblock;ks1,ks2,ks3:des_key_schedule;enc:Integer);
procedure des_ecb_encrypt(var input,output:des_cblock;ks:des_key_schedule;enc:Integer);
procedure des_ede3_cbc_encrypt(var input,output:des_cblock;length:LongInt;ks1,ks2,ks3:des_key_schedule;var ivec:des_cblock;enc:Integer);
procedure des_ede3_cfb64_encrypt(pin,pout:Pointer;length:LongInt;ks1,ks2,ks3:des_key_schedule;var ivec:des_cblock;var num:Integer;enc:Integer);
procedure des_ede3_ofb64_encrypt(pin,pout:Pointer;length:LongInt;ks1,ks2,ks3:des_key_schedule;var ivec:des_cblock;var num:Integer);
function  des_enc_read(fd:Integer;var buf;len:Integer;sched:des_key_schedule;var iv:des_cblock):Integer;
function  des_enc_write(fd:Integer;var buf;len:Integer;sched:des_key_schedule;var iv:des_cblock):Integer;
procedure des_encrypt(var data:Cardinal;ks:des_key_schedule;enc:Integer);
procedure des_encrypt2(var data:Cardinal;ks:des_key_schedule;enc:Integer);
procedure des_encrypt3(var data:Cardinal;ks1,ks2,ks3:des_key_schedule);
function  des_fcrypt(const buf,salt:PChar;ret:PChar):PChar;
function  des_is_weak_key(var key:des_cblock):Boolean;
function  des_key_sched(var key:des_cblock;schedule:des_key_schedule):Integer;
procedure des_ncbc_encrypt(var input,output:des_cblock;length:LongInt;schedule:des_key_schedule;var ivec:des_cblock;enc:Integer);
procedure des_ofb64_encrypt(pin,pout:Pointer;length:LongInt;schedule:des_key_schedule;var ivec:des_cblock;var num:Integer);
procedure des_ofb_encrypt(pin,pout:Pointer;numbits:Integer;length:LongInt;schedule:des_key_schedule;var ivec:des_cblock);
function  des_options:PChar;
procedure des_pcbc_encrypt(var input,output:des_cblock;length:LongInt;scheduke:des_key_schedule;var ivec:des_cblock;enc:Integer);
function  des_quad_cksum(var input,output:des_cblock;length:LongInt;out_count:Integer;var seed:des_cblock):Cardinal;
procedure des_random_key(ret:des_cblock);
procedure des_random_seed(key:des_cblock);
function  des_read_2passwords(var key1,key2:des_cblock;prompt:PChar;verify:Integer):Integer;
function  des_read_password(var key:des_cblock;prompt:PChar;verify:Integer):Integer;
function  des_read_pw(buf, buff:PChar;size:Integer; prompt:PChar; verify:Integer):Integer;
function  des_read_pw_string(buf:PChar;length:Integer;prompt:PChar;verify:Integer):Integer;
function  des_set_key(var key:des_cblock;schedule:des_key_schedule):Integer;
procedure des_set_odd_parity(var key:des_cblock);
procedure des_string_to_2keys(str:PChar;var key1,key2:des_cblock);
procedure des_string_to_key(str:PChar;var key:des_cblock);
procedure des_xcbc_encrypt(var input,output:des_cblock;length:LongInt;schedule:des_key_schedule;var ivec,inw,outw:des_cblock;enc:Integer);
procedure des_xwhite_in2out(var des_key,in_white,out_white:des_cblock);

function  i2a_ASN1_INTEGER(bp:BIO;a:ASN1_INTEGER):Integer;
function  i2a_ASN1_OBJECT(bp:BIO;a:ASN1_OBJECT):Integer;
function  i2a_ASN1_STRING(bp:BIO;a:ASN1_STRING;typ:Integer):Integer;

function  i2d_ASN1_BIT_STRING(a:ASN1_BIT_STRING;var pp:Pointer):Integer;
function  i2d_ASN1_BOOLEAN(a:Integer;var pp:Pointer):Integer;
function  i2d_ASN1_HEADER(a:ASN1_HEADER;var pp:Pointer):Integer;
function  i2d_ASN1_IA5STRING(a:ASN1_IA5STRING;var pp:Pointer):Integer;
function  i2d_ASN1_INTEGER(a:ASN1_INTEGER;var pp:Pointer):Integer;
function  i2d_ASN1_OBJECT(a:ASN1_OBJECT;var pp:Pointer):Integer;
function  i2d_ASN1_OCTET_STRING(a:ASN1_OCTET_STRING;var pp:Pointer):Integer;
function  i2d_ASN1_PRINTABLE(a:ASN1_STRING;var pp:Pointer):Integer;
function  i2d_ASN1_SET(a:STACK;var pp:Pointer;func:stack_func;ex_tag, ex_class:Integer):Integer;
function  i2d_ASN1_TYPE(a:ASN1_TYPE;var pp:Pointer):Integer;
function  i2d_ASN1_UTCTIME(a:ASN1_UTCTIME;var pp:Pointer):Integer;
function  i2d_ASN1_bytes(a:ASN1_STRING;var pp:Pointer;tag, xclass:Integer):Integer;
function  i2d_DHparams(a:DH;var pp:Pointer):Integer;
function  i2d_DSAPrivateKey(a:DSA;var pp:Pointer):Integer;
function  i2d_DSAPrivateKey_bio(bp:BIO;d:DSA):Integer;
//function  i2d_DSAPrivateKey_fp(FILE *fp, DSA *dsa):Integer;
function  i2d_DSAPublicKey(a:DSA;var pp:Pointer):Integer;
function  i2d_DSAparams(a:DSA;var pp:Pointer):Integer;
function  i2d_NETSCAPE_SPKAC(a:NETSCAPE_SPKAC;var pp:Pointer):Integer;
function  i2d_NETSCAPE_SPKI(a:NETSCAPE_SPKI;var pp:Pointer):Integer;
function  i2d_Netscape_RSA(a:RSA;var pp:Pointer;var cb):Integer;
function  i2d_PKCS7(a:PKCS7;var pp:Pointer):Integer;
function  i2d_PKCS7_DIGEST(a:PKCS7_DIGEST;var pp:Pointer):Integer;
function  i2d_PKCS7_ENC_CONTENT(a:PKCS7_ENC_CONTENT;var pp:Pointer):Integer;
function  i2d_PKCS7_ENCRYPT(a:PKCS7_ENCRYPT;var pp:Pointer):Integer;
function  i2d_PKCS7_ENVELOPE(a:PKCS7_ENVELOPE;var pp:Pointer):Integer;
function  i2d_PKCS7_ISSUER_AND_SERIAL(a:PKCS7_ISSUER_AND_SERIAL;var pp:Pointer):Integer;
function  i2d_PKCS7_RECIP_INFO(a:PKCS7_RECIP_INFO;var pp:Pointer):Integer;
function  i2d_PKCS7_SIGNED(a:PKCS7_SIGNED;var pp:Pointer):Integer;
function  i2d_PKCS7_SIGNER_INFO(a:PKCS7_SIGNER_INFO;var pp:Pointer):Integer;
function  i2d_PKCS7_SIGN_ENVELOPE(a:PKCS7_SIGN_ENVELOPE;var pp:Pointer):Integer;
function  i2d_PKCS7_bio(bp:BIO;p7:PKCS7):Integer;
//function  i2d_PKCS7_fp(FILE *fp,PKCS7 *p7):Integer;
function  i2d_PrivateKey(a:EVP_PKEY;var pp:Pointer):Integer;
function  i2d_PublicKey(a:EVP_PKEY;var pp:Pointer):Integer;
function  i2d_RSAPrivateKey(a:RSA;var pp:Pointer):Integer;
function  i2d_RSAPrivateKey_bio(bp:BIO;r:RSA):Integer;
//function i2d_RSAPrivateKey_fp(FILE *fp,RSA *rsa):Integer;
function  i2d_RSAPublicKey(a:RSA;var pp:Pointer):Integer;
function  i2d_RSAPublicKey_bio(bp:BIO;r:RSA):Integer;
//function i2d_RSAPublicKey_fp(FILE *fp,RSA *rsa):Integer;
function  i2d_X509(a:X509;var pp:Pointer):Integer;
function  i2d_X509_ALGOR(a:X509_ALGOR;var pp:Pointer):Integer;
function  i2d_X509_ATTRIBUTE(a:X509_ATTRIBUTE;var pp:Pointer):Integer;
function  i2d_X509_CINF(a:X509_CINF;var pp:Pointer):Integer;
function  i2d_X509_CRL(a:X509_CRL;var pp:Pointer):Integer;
function  i2d_X509_CRL_INFO(a:X509_CRL_INFO;var pp:Pointer):Integer;
function  i2d_X509_CRL_bio(bp:BIO;crl:X509_CRL):Integer;
//function  i2d_X509_CRL_fp(FILE *fp,X509_CRL *crl):Integer;
function  i2d_X509_EXTENSION(a:X509_EXTENSION;var pp:Pointer):Integer;
function  i2d_X509_NAME(a:X509_NAME;var pp:Pointer):Integer;
function  i2d_X509_NAME_ENTRY(a:X509_NAME_ENTRY;var pp:Pointer):Integer;
function  i2d_X509_PKEY(a:X509_PKEY;var pp:Pointer):Integer;
function  i2d_X509_PUBKEY(a:X509_PUBKEY;var pp:Pointer):Integer;
function  i2d_X509_REQ(a:X509_REQ;var pp:Pointer):Integer;
function  i2d_X509_REQ_INFO(a:X509_REQ_INFO;var pp:Pointer):Integer;
function  i2d_X509_REQ_bio(bp:BIO;req:X509_REQ):Integer;
//function  i2d_X509_REQ_fp(FILE *fp,X509_REQ *req):Integer;
function  i2d_X509_REVOKED(a:X509_REVOKED;var pp:Pointer):Integer;
function  i2d_X509_SIG(a:X509_SIG;var pp:Pointer):Integer;
function  i2d_X509_VAL(a:X509_VAL;var pp:Pointer):Integer;
function  i2d_X509_bio(bp:BIO;x:X509):Integer;
//function  i2d_X509_fp(FILE *fp,X509 *x509):Integer;
function  i2t_ASN1_OBJECT(buf:Pointer;buf_len:Integer;a:ASN1_OBJECT):Integer;

procedure idea_cbc_encrypt(pin,pout:Pointer;length:LongInt;var ks:IDEA_KEY_SCHEDULE;iv:Pointer;enc:Integer);
procedure idea_cfb64_encrypt(pin,pout:Pointer;length:LongInt;var ks:IDEA_KEY_SCHEDULE;iv:Pointer;var num:Integer;enc:Integer);
procedure idea_ecb_encrypt(pin,pout:Pointer;var ks:IDEA_KEY_SCHEDULE);
procedure idea_encrypt(pin:Pointer;var ks:IDEA_KEY_SCHEDULE);
procedure idea_ofb64_encrypt(pin,pout:Pointer;length:LongInt;var ks:IDEA_KEY_SCHEDULE;iv:Pointer;var num:Integer);
function  idea_options:PChar;
procedure idea_set_decrypt_key(var ek,dk:IDEA_KEY_SCHEDULE);
procedure idea_set_encrypt_key(key:Pointer;var ks:IDEA_KEY_SCHEDULE);

function  lh_delete(lh:LHASH;data:Pointer):Pointer;
procedure lh_doall(lh:LHASH;func:lhash_doall_proc);
procedure lh_doall_arg(lh:LHASH;func:lhash_doall_arg_proc;arg:Pointer);
procedure lh_free(lh:LHASH);
function  lh_insert(lh:LHASH;data:Pointer):Pointer;
function  lh_new(h:lhash_hash_func;c:lhash_comp_func):LHASH;
//procedure lh_node_stats(LHASH *lh, FILE *out);
procedure lh_node_stats_bio(lh:LHASH;bp:BIO);
//procedure lh_node_usage_stats(LHASH *lh, FILE *out);}
procedure lh_node_usage_stats_bio(lh:LHASH;bp:BIO);
function  lh_retrieve(lh:LHASH;data:Pointer):Pointer;
//procedure lh_stats(LHASH *lh, FILE *out);
procedure lh_stats_bio(lh:LHASH;bp:BIO);
function  lh_strhash(c:Pointer):Cardinal;

function  sk_delete(st:STACK;loc:Integer):PChar;
function  sk_delete_ptr(st:STACK;p:Pointer):PChar;
function  sk_dup(st:STACK):STACK;
function  sk_find(st:STACK;data:Pointer):Integer;
procedure sk_free(st:STACK);
function  sk_insert(sk:STACK;data:Pointer;where:Integer):Integer;
function  sk_new(cmp:stack_func):STACK;
function  sk_pop(st:STACK):Pointer;
procedure sk_pop_free(st:STACK;func:stack_proc);
function  sk_push(st:STACK;data:Pointer):Integer;
procedure sk_set_cmp_func(sk:STACK;s:stack_func);
function  sk_shift(st:STACK):Pointer;
function  sk_unshift(st:STACK;data:Pointer):Integer;
procedure sk_zero(st:STACK);

{&CDecl-}
const
  (* Types of BIOs *)
  BIO_TYPE_NONE 	=  0;
  BIO_TYPE_MEM		=  1 or $0400;
  BIO_TYPE_FILE 	=  2 or $0400;
  BIO_TYPE_FD		=  4 or $0400 or $0100;
  BIO_TYPE_SOCKET	=  5 or $0400 or $0100;
  BIO_TYPE_NULL 	=  6 or $0400;
  BIO_TYPE_SSL		=  7 or $0200;		(* SSL filter *)
  BIO_TYPE_MD		=  8 or $0200;		(* passive filter *)
  BIO_TYPE_BUFFER	=  9 or $0200;		(* filter *)
  BIO_TYPE_CIPHER	= 10 or $0200;
  BIO_TYPE_BASE64	= 11 or $0200;
  BIO_TYPE_CONNECT	= 12 or $0400 or $0100;
  BIO_TYPE_ACCEPT	= 13 or $0400 or $0100;
  BIO_TYPE_PROXY_CLIENT = 14 or $0200;
  BIO_TYPE_PROXY_SERVER = 15 or $0200;
  BIO_TYPE_NBIO_TEST	= 16 or $0200;
  BIO_TYPE_NULL_FILTER	= 17 or $0200;

  BIO_TYPE_DESCRIPTOR	= $0100;	(* socket, fd, connect or accept *)
  BIO_TYPE_FILTER	= $0200;
  BIO_TYPE_SOURCE_SINK	= $0400;

  BIO_CLOSE		= 1;
  BIO_NOCLOSE		= 0;

  (* BIO_ctrl commands *)
  BIO_CTRL_RESET	=  1;		(* opt - rewind/zero etc *)
  BIO_CTRL_EOF		=  2;		(* opt - are we at the eof *)
  BIO_CTRL_INFO 	=  3;		(* opt - extra tit-bits *)
  BIO_CTRL_SET		=  4;		(* man - set the IO type *)
  BIO_CTRL_GET		=  5;		(* man - get the IO type *)
  BIO_CTRL_PUSH 	=  6;
  BIO_CTRL_POP		=  7;
  BIO_CTRL_GET_CLOSE	=  8;		(* man - get the close flag *)
  BIO_CTRL_SET_CLOSE	=  9;		(* man - set the close flag *)
  BIO_CTRL_PENDING	= 10;		(* opt - is there more data *)
  BIO_CTRL_FLUSH	= 11;		(* opt - flush buffered output *)
  BIO_CTRL_DUP		= 12;		(* man - extra stuff for duped BIO *)
  BIO_CTRL_WPENDING	= 13;		(* opt - bytes still to write *)
  BIO_CTRL_SET_CALLBACK = 14;		(* opt - set callback function *)
  BIO_CTRL_GET_CALLBACK = 15;		(* opt - get callback function *)
  BIO_CTRL_SET_FILENAME = 30;		(* BIO_s_file special *)

  (* modifiers *)
  BIO_FP_READ		= $02;
  BIO_FP_WRITE		= $04;
  BIO_FP_APPEND 	= $08;
  BIO_FP_TEXT		= $10;

  BIO_FLAGS_READ	= $01;
  BIO_FLAGS_WRITE	= $02;
  BIO_FLAGS_IO_SPECIAL	= $04;
  BIO_FLAGS_SHOULD_RETRY= $08;
  BIO_FLAGS_RWS 	= BIO_FLAGS_READ or BIO_FLAGS_WRITE or BIO_FLAGS_IO_SPECIAL;

  (* Used in BIO_gethostbyname *)
  BIO_GHBN_CTRL_HITS	= 1;
  BIO_GHBN_CTRL_MISSES	= 2;
  BIO_GHBN_CTRL_CACHE_SZ= 3;
  BIO_GHBN_CTRL_GETENTRY= 4;
  BIO_GHBN_CTRL_FLUSH	= 5;

  BIO_FLAGS_BASE64_NO_NL= $0100;

  BIO_RR_SSL_X509_LOOKUP= $01;
  BIO_RR_CONNECT	= $02;

  BIO_CB_FREE		= $01;
  BIO_CB_READ		= $02;
  BIO_CB_WRITE		= $03;
  BIO_CB_PUTS		= $04;
  BIO_CB_GETS		= $05;
  BIO_CB_CTRL		= $06;
  BIO_CB_RETURN 	= $80;

  BIO_C_SET_CONNECT	= 100;
  BIO_C_SET_NBIO	= 102;

procedure BIO_set_flags(b:BIO;f:Integer):Integer; inline;
begin b^.flags := b^.flags or f end;

function BIO_get_flags(b:BIO):Integer; inline;
begin Result := b^.flags end;

procedure BIO_set_retry_special(b:BIO); inline;
begin b^.flags := b^.flags or BIO_FLAGS_IO_SPECIAL or BIO_FLAGS_SHOULD_RETRY end;

procedure BIO_set_retry_read(b:BIO); inline;
begin b^.flags := b^.flags or BIO_FLAGS_READ or BIO_FLAGS_SHOULD_RETRY end;

procedure BIO_set_retry_write(b:BIO); inline;
begin b^.flags := b^.flags or BIO_FLAGS_WRITE or BIO_FLAGS_SHOULD_RETRY end;

function BIO_should_read(b:BIO):Boolean; inline;
begin Result := b^.flags and BIO_FLAGS_READ <> 0 end;

function BIO_should_write(b:BIO):Boolean; inline;
begin Result := b^.flags and BIO_FLAGS_WRITE <> 0 end;

function BIO_should_io_special(b:BIO):Boolean; inline;
begin Result := b^.flags and BIO_FLAGS_IO_SPECIAL <> 0 end;

function BIO_retry_type(b:BIO):Integer; inline;
begin Result := b^.flags and BIO_FLAGS_RWS end;

function BIO_should_retry(b:BIO):Boolean; inline;
begin Result := b^.flags and BIO_FLAGS_SHOULD_RETRY <> 0 end;

function BIO_cb_pre(a:Integer):Boolean; inline;
begin Result := a and BIO_CB_RETURN = 0 end;

function BIO_cb_post(a:Integer):Boolean; inline;
begin Result := a and BIO_CB_RETURN <> 0 end;

procedure BIO_set_callback(b:BIO;cb:bio_callback_func); inline;
begin @b^.callback := @cb end;

procedure BIO_set_callback_arg(b:BIO;arg:Pointer); inline;
begin b^.cb_arg := arg end;

procedure BIO_get_callback(b:BIO;var cb:bio_callback_func); inline;
begin @cb := @b^.callback end;

procedure BIO_get_callback_arg(b:BIO;var arg:Pointer); inline;
begin arg := b^.cb_arg end;

function BIO_method_name(b:BIO):PChar; inline;
begin Result := b^.method^.name end;
function BIO_method_type(b:BIO):Integer; inline;
begin Result := b^.method^.type end;




function BIO_set_conn_hostname(b:BIO;name:PChar):LongInt; inline;
begin Result := BIO_ctrl(b,BIO_C_SET_CONNECT,0,name) end;

function BIO_set_nbio(b:BIO;n:Integer):LongInt; inline;
begin Result := BIO_ctrl(b,BIO_C_SET_NBIO,n,nil) end;

{function  ASN1_BIT_STRING_new:ASN1_BIT_STRING; inline; begin Result := ASN1_BIT_STRING(ASN1_STRING_type_new(V_ASN1_BIT_STRING)) end;
procedure ASN1_BIT_STRING_free(a:ASN1_BIT_STRING); inline; begin ASN1_STRING_free(ASN1_STRING(a)) end;
function  ASN1_BIT_STRING_dup(a:ASN1_BIT_STRING):ASN1_BIT_STRING; inline; begin Result := ASN1_BIT_STRING(ASN1_STRING_dup(ASN1_STRING(a))) end;
{function  ASN1_BIT_STRING_cmp}

var
  stdin, stdout, stderr 	: BIO;

procedure AssignBIO(var t:Text;b:BIO;doclose:Integer);
procedure ConsoleBIO(b:BIO);	      // for Multithreaded programs

implementation
Uses Dos,VPSysLow;

threadvar
  console			: BIO;

procedure SSLeay_add_all_algorithms;		external 'LIBEAY32' index  508;
procedure SSLeay_add_all_ciphers;		external 'LIBEAY32' index  509;
procedure SSLeay_add_all_digests;		external 'LIBEAY32' index  510;
function  SSLeay_version;			external 'LIBEAY32' index    2;
function  SSLeay;				external 'LIBEAY32' index    1;

function  ASN1_BIT_STRING_asn1_meth;		external 'LIBEAY32' index    3;
function  ASN1_BIT_STRING_get_bit;		external 'LIBEAY32' index 1060;
function  ASN1_BIT_STRING_set_bit;		external 'LIBEAY32' index 1061;
procedure ASN1_HEADER_free;			external 'LIBEAY32' index    4;
function  ASN1_HEADER_new;			external 'LIBEAY32' index    5;
function  ASN1_IA5STRING_asn1_meth;		external 'LIBEAY32' index    6;
function  ASN1_INTEGER_get;			external 'LIBEAY32' index    7;
function  ASN1_INTEGER_set;			external 'LIBEAY32' index    8;
function  ASN1_INTEGER_to_BN;			external 'LIBEAY32' index    9;
function  ASN1_OBJECT_create;			external 'LIBEAY32' index   10;
procedure ASN1_OBJECT_free;			external 'LIBEAY32' index   11;
function  ASN1_OBJECT_new;			external 'LIBEAY32' index   12;
function  ASN1_PRINTABLE_type;			external 'LIBEAY32' index   13;
function  ASN1_STRING_cmp;			external 'LIBEAY32' index   14;
function  ASN1_STRING_dup;			external 'LIBEAY32' index   15;
procedure ASN1_STRING_free;			external 'LIBEAY32' index   16;
function  ASN1_STRING_new;			external 'LIBEAY32' index   17;
function  ASN1_STRING_print;			external 'LIBEAY32' index   18;
function  ASN1_STRING_set;			external 'LIBEAY32' index   19;
function  ASN1_STRING_type_new; 		external 'LIBEAY32' index   20;
procedure ASN1_TYPE_free;			external 'LIBEAY32' index   21;
function  ASN1_TYPE_get;			external 'LIBEAY32' index  916;
function  ASN1_TYPE_get_int_octetstring;	external 'LIBEAY32' index 1076;
function  ASN1_TYPE_get_octetstring;		external 'LIBEAY32' index 1077;
function  ASN1_TYPE_new;			external 'LIBEAY32' index   22;
procedure ASN1_TYPE_set;			external 'LIBEAY32' index  917;
function  ASN1_TYPE_set_octetstring;		external 'LIBEAY32' index 1078;
function  ASN1_TYPE_set_int_octetstring;	external 'LIBEAY32' index 1079;
function  ASN1_UNIVERSALSTRING_to_string;	external 'LIBEAY32' index   23;
function  ASN1_UTCTIME_check;			external 'LIBEAY32' index   24;
function  ASN1_UTCTIME_print;			external 'LIBEAY32' index   25;
//function  ASN1_UTCTIME_set;			  external 'LIBEAY32' index   26;
function  ASN1_UTCTIME_set_string;		external 'LIBEAY32' index 1080;
function  ASN1_check_infinite_end;		external 'LIBEAY32' index   27;
function  ASN1_d2i_bio; 			external 'LIBEAY32' index   28;
//function  ASN1_d2i_fp;			  external 'LIBEAY32' index   29;
function  ASN1_digest;				external 'LIBEAY32' index   30;
function  ASN1_dup;				external 'LIBEAY32' index   31;
function  ASN1_get_object;			external 'LIBEAY32' index   32;
function  ASN1_i2d_bio; 			external 'LIBEAY32' index   33;
//function  ASN1_i2d_fp;			  external 'LIBEAY32' index   34;
function  ASN1_object_size;			external 'LIBEAY32' index   35;
function  ASN1_parse;				external 'LIBEAY32' index   36;
procedure ASN1_put_object;			external 'LIBEAY32' index   37;
function  ASN1_sign;				external 'LIBEAY32' index   38;
function  ASN1_verify;				external 'LIBEAY32' index   39;

procedure BF_cbc_encrypt;			external 'LIBEAY32' index   40;
procedure BF_cfb64_encrypt;			external 'LIBEAY32' index   41;
procedure BF_decrypt;				external 'LIBEAY32' index  987;
procedure BF_ecb_encrypt;			external 'LIBEAY32' index   42;
procedure BF_encrypt;				external 'LIBEAY32' index   43;
procedure BF_ofb64_encrypt;			external 'LIBEAY32' index   44;
function  BF_options;				external 'LIBEAY32' index   45;
procedure BF_set_key;				external 'LIBEAY32' index   46;

function  BIO_accept;				external 'LIBEAY32' index   51;
procedure BIO_copy_next_retry;			external 'LIBEAY32' index  955;
function  BIO_ctrl;				external 'LIBEAY32' index   52;
function  BIO_debug_callback;			external 'LIBEAY32' index   54;
function  BIO_dump;				external 'LIBEAY32' index   55;
function  BIO_dup_chain;			external 'LIBEAY32' index   56;
function  BIO_f_base64; 			external 'LIBEAY32' index   57;
function  BIO_f_buffer; 			external 'LIBEAY32' index   58;
function  BIO_f_cipher; 			external 'LIBEAY32' index   59;
function  BIO_f_md;				external 'LIBEAY32' index   60;
function  BIO_f_nbio_test;			external 'LIBEAY32' index  915;
function  BIO_f_null;				external 'LIBEAY32' index   61;
function  BIO_fd_non_fatal_error;		external 'LIBEAY32' index   63;
function  BIO_fd_should_retry;			external 'LIBEAY32' index   64;
function  BIO_find_type;			external 'LIBEAY32' index   65;
function  BIO_free;				external 'LIBEAY32' index   66;
procedure BIO_free_all; 			external 'LIBEAY32' index   67;
function  BIO_get_accept_socket;		external 'LIBEAY32' index   69;
function  BIO_get_host_ip;			external 'LIBEAY32' index   71;
function  BIO_get_port; 			external 'LIBEAY32' index   72;
function  BIO_get_retry_BIO;			external 'LIBEAY32' index   73;
function  BIO_get_retry_reason; 		external 'LIBEAY32' index   74;
function  BIO_gethostbyname;			external 'LIBEAY32' index   75;
function  BIO_gets;				external 'LIBEAY32' index   76;
function  BIO_ghbn_ctrl;			external 'LIBEAY32' index 1003;
function  BIO_int_ctrl; 			external 'LIBEAY32' index   53;
function  BIO_new;				external 'LIBEAY32' index   78;
function  BIO_new_accept;			external 'LIBEAY32' index   79;
function  BIO_new_connect;			external 'LIBEAY32' index   80;
function  BIO_new_fd;				external 'LIBEAY32' index   81;
function  BIO_new_file; 			external 'LIBEAY32' index   82;
//function  BIO_new_fp; 			  external 'LIBEAY32' index   83;
function  BIO_new_socket;			external 'LIBEAY32' index   84;
function  BIO_pop;				external 'LIBEAY32' index   85;
function  BIO_ptr_ctrl; 			external 'LIBEAY32' index  969;
function  BIO_push;				external 'LIBEAY32' index   87;
function  BIO_puts;				external 'LIBEAY32' index   88;
function  BIO_read;				external 'LIBEAY32' index   89;
function  BIO_s_accept; 			external 'LIBEAY32' index   90;
function  BIO_s_connect;			external 'LIBEAY32' index   91;
function  BIO_s_fd;				external 'LIBEAY32' index   92;
function  BIO_s_file;				external 'LIBEAY32' index   93;
function  BIO_s_mem;				external 'LIBEAY32' index   95;
function  BIO_s_null;				external 'LIBEAY32' index   96;
function  BIO_s_socket; 			external 'LIBEAY32' index   98;
function  BIO_set;				external 'LIBEAY32' index  100;
procedure BIO_set_cipher;			external 'LIBEAY32' index  101;
function  BIO_set_tcp_ndelay;			external 'LIBEAY32' index  102;
procedure BIO_sock_cleanup;			external 'LIBEAY32' index  103;
function  BIO_sock_error;			external 'LIBEAY32' index  104;
function  BIO_sock_init;			external 'LIBEAY32' index  105;
function  BIO_sock_non_fatal_error;		external 'LIBEAY32' index  106;
function  BIO_sock_should_retry;		external 'LIBEAY32' index  107;
function  BIO_socket_ioctl;			external 'LIBEAY32' index  108;
function  BIO_write;				external 'LIBEAY32' index  109;

function  BN_BLINDING_convert;			external 'LIBEAY32' index  973;
procedure BN_BLINDING_free;			external 'LIBEAY32' index  981;
function  BN_BLINDING_invert;			external 'LIBEAY32' index  974;
function  BN_BLINDING_new;			external 'LIBEAY32' index  980;
function  BN_BLINDING_update;			external 'LIBEAY32' index  975;
procedure BN_CTX_free;				external 'LIBEAY32' index  110;
function  BN_CTX_new;				external 'LIBEAY32' index  111;
procedure BN_MONT_CTX_free;			external 'LIBEAY32' index  112;
function  BN_MONT_CTX_new;			external 'LIBEAY32' index  113;
function  BN_MONT_CTX_set;			external 'LIBEAY32' index  114;
function  BN_add;				external 'LIBEAY32' index  115;
function  BN_add_word;				external 'LIBEAY32' index  116;
function  BN_bin2bn;				external 'LIBEAY32' index  118;
function  BN_bn2bin;				external 'LIBEAY32' index  120;
function  BN_bn2dec;				external 'LIBEAY32' index 1002;
function  BN_bn2hex;				external 'LIBEAY32' index  119;
function  BN_bn2mpi;				external 'LIBEAY32' index 1058;
procedure BN_clear;				external 'LIBEAY32' index  121;
function  BN_clear_bit; 			external 'LIBEAY32' index  122;
procedure BN_clear_free;			external 'LIBEAY32' index  123;
function  BN_cmp;				external 'LIBEAY32' index  124;
function  BN_copy;				external 'LIBEAY32' index  125;
function  BN_dec2bn;				external 'LIBEAY32' index 1001;
function  BN_div;				external 'LIBEAY32' index  126;
function  BN_div_word;				external 'LIBEAY32' index  127;
function  BN_dup;				external 'LIBEAY32' index  128;
function  BN_exp;				external 'LIBEAY32' index  998;
procedure BN_free;				external 'LIBEAY32' index  129;
function  BN_from_montgomery;			external 'LIBEAY32' index  130;
function  BN_gcd;				external 'LIBEAY32' index  131;
function  BN_generate_prime;			external 'LIBEAY32' index  132;
function  BN_get_word;				external 'LIBEAY32' index  133;
function  BN_hex2bn;				external 'LIBEAY32' index  117;
function  BN_is_bit_set;			external 'LIBEAY32' index  134;
function  BN_is_prime;				external 'LIBEAY32' index  135;
function  BN_lshift;				external 'LIBEAY32' index  136;
function  BN_lshift1;				external 'LIBEAY32' index  137;
function  BN_mask_bits; 			external 'LIBEAY32' index  138;
function  BN_mod;				external 'LIBEAY32' index  139;
function  BN_mod_exp;				external 'LIBEAY32' index  140;
function  BN_mod_exp_mont;			external 'LIBEAY32' index  141;
function  BN_mod_exp_recp;			external 'LIBEAY32' index  142;
function  BN_mod_exp_simple;			external 'LIBEAY32' index  143;
function  BN_mod_inverse;			external 'LIBEAY32' index  144;
function  BN_mod_mul;				external 'LIBEAY32' index  145;
function  BN_mod_mul_montgomery;		external 'LIBEAY32' index  146;
function  BN_mod_mul_reciprocal;		external 'LIBEAY32' index  147;
function  BN_mod_word;				external 'LIBEAY32' index  148;
function  BN_mpi2bn;				external 'LIBEAY32' index 1059;
function  BN_mul;				external 'LIBEAY32' index  149;
function  BN_mul_word;				external 'LIBEAY32' index  999;
function  BN_new;				external 'LIBEAY32' index  150;
function  BN_num_bits;				external 'LIBEAY32' index  151;
function  BN_num_bits_word;			external 'LIBEAY32' index  152;
function  BN_options;				external 'LIBEAY32' index  153;
function  BN_print;				external 'LIBEAY32' index  154;
//function  BN_print_fp;			  external 'LIBEAY32' index  155;
function  BN_rand;				external 'LIBEAY32' index  156;
function  BN_reciprocal;			external 'LIBEAY32' index  157;
function  BN_rshift;				external 'LIBEAY32' index  158;
function  BN_rshift1;				external 'LIBEAY32' index  159;
function  BN_set_bit;				external 'LIBEAY32' index  160;
function  BN_set_word;				external 'LIBEAY32' index  161;
function  BN_sqr;				external 'LIBEAY32' index  162;
function  BN_sub;				external 'LIBEAY32' index  163;
function  BN_sub_word;				external 'LIBEAY32' index 1000;
function  BN_to_ASN1_INTEGER;			external 'LIBEAY32' index  164;
function  BN_ucmp;				external 'LIBEAY32' index  165;
function  BN_value_one; 			external 'LIBEAY32' index  166;

procedure BUF_MEM_free; 			external 'LIBEAY32' index  167;
function  BUF_MEM_grow; 			external 'LIBEAY32' index  168;
function  BUF_MEM_new;				external 'LIBEAY32' index  169;
function  BUF_strdup;				external 'LIBEAY32' index  170;

procedure CAST_cbc_encrypt;			external 'LIBEAY32' index  992;
procedure CAST_cfb64_encrypt;			external 'LIBEAY32' index  993;
procedure CAST_decrypt; 			external 'LIBEAY32' index  990;
procedure CAST_ecb_encrypt;			external 'LIBEAY32' index  991;
procedure CAST_encrypt; 			external 'LIBEAY32' index  989;
procedure CAST_ofb64_encrypt;			external 'LIBEAY32' index  994;
procedure CAST_set_key; 			external 'LIBEAY32' index  988;

procedure CONF_free;				external 'LIBEAY32' index  171;
function  CONF_get_number;			external 'LIBEAY32' index  172;
function  CONF_get_section;			external 'LIBEAY32' index  173;
function  CONF_get_string;			external 'LIBEAY32' index  174;
function  CONF_load;				external 'LIBEAY32' index  175;

function  CRYPTO_add_lock;			external 'LIBEAY32' index  176;
procedure CRYPTO_dbg_free;			external 'LIBEAY32' index  177;
function  CRYPTO_dbg_malloc;			external 'LIBEAY32' index  178;
function  CRYPTO_dbg_realloc;			external 'LIBEAY32' index  179;
function  CRYPTO_dbg_remalloc;			external 'LIBEAY32' index  180;
function  CRYPTO_dup_ex_data;			external 'LIBEAY32' index 1025;
procedure CRYPTO_free;				external 'LIBEAY32' index  181;
procedure CRYPTO_free_ex_data;			external 'LIBEAY32' index 1004;
function  CRYPTO_get_add_lock_callback; 	external 'LIBEAY32' index  182;
function  CRYPTO_get_ex_data;			external 'LIBEAY32' index 1005;
function  CRYPTO_get_ex_new_index;		external 'LIBEAY32' index 1041;
function  CRYPTO_get_id_callback;		external 'LIBEAY32' index  183;
function  CRYPTO_get_lock_name; 		external 'LIBEAY32' index  184;
function  CRYPTO_get_locking_callback;		external 'LIBEAY32' index  185;
procedure CRYPTO_get_mem_functions;		external 'LIBEAY32' index  186;
function  CRYPTO_get_new_lockid;		external 'LIBEAY32' index 1026;
procedure CRYPTO_lock;				external 'LIBEAY32' index  187;
function  CRYPTO_malloc;			external 'LIBEAY32' index  188;
function  CRYPTO_mem_ctrl;			external 'LIBEAY32' index  189;
procedure CRYPTO_mem_leaks;			external 'LIBEAY32' index  190;
procedure CRYPTO_mem_leaks_cb;			external 'LIBEAY32' index  191;
//procedure CRYPTO_mem_leaks_fp(FILE *);	  external 'LIBEAY32' index  192;
procedure CRYPTO_new_ex_data;			external 'LIBEAY32' index 1027;
function  CRYPTO_realloc;			external 'LIBEAY32' index  193;
function  CRYPTO_remalloc;			external 'LIBEAY32' index  194;
procedure CRYPTO_set_add_lock_callback; 	external 'LIBEAY32' index  195;
function  CRYPTO_set_ex_data;			external 'LIBEAY32' index 1007;
procedure CRYPTO_set_id_callback;		external 'LIBEAY32' index  196;
procedure CRYPTO_set_locking_callback;		external 'LIBEAY32' index  197;
procedure CRYPTO_set_mem_functions;		external 'LIBEAY32' index  198;
function  CRYPTO_thread_id;			external 'LIBEAY32' index  199;

function  DH_check;				external 'LIBEAY32' index  200;
function  DH_compute_key;			external 'LIBEAY32' index  201;
procedure DH_free;				external 'LIBEAY32' index  202;
function  DH_generate_key;			external 'LIBEAY32' index  203;
function  DH_generate_parameters;		external 'LIBEAY32' index  204;
function  DH_new;				external 'LIBEAY32' index  205;
function  DH_size;				external 'LIBEAY32' index  206;
function  DHparams_print;			external 'LIBEAY32' index  207;
//function  DHparams_print_fp;			  external 'LIBEAY32' index  208;

procedure DSA_free;				external 'LIBEAY32' index  209;
function  DSA_generate_key;			external 'LIBEAY32' index  210;
function  DSA_generate_parameters;		external 'LIBEAY32' index  211;
function  DSA_is_prime; 			external 'LIBEAY32' index  212;
function  DSA_new;				external 'LIBEAY32' index  213;
function  DSA_print;				external 'LIBEAY32' index  214;
//function  DSA_print_fp;			  external 'LIBEAY32' index  215;
function  DSA_sign;				external 'LIBEAY32' index  216;
function  DSA_sign_setup;			external 'LIBEAY32' index  217;
function  DSA_size;				external 'LIBEAY32' index  218;
function  DSA_verify;				external 'LIBEAY32' index  219;
function  DSAparams_print;			external 'LIBEAY32' index  220;
//int	  DSAparams_print_fp;			  external 'LIBEAY32' index  221;

//procedure ERR_add_err_data;			  external 'LIBEAY32' index 1081;
procedure ERR_clear_error;			external 'LIBEAY32' index  222;
function  ERR_error_string;			external 'LIBEAY32' index  223;
procedure ERR_free_strings;			external 'LIBEAY32' index  224;
function  ERR_func_error_string;		external 'LIBEAY32' index  225;
function  ERR_get_err_state_table;		external 'LIBEAY32' index  226;
function  ERR_get_error;			external 'LIBEAY32' index  227;
function  ERR_get_error_line;			external 'LIBEAY32' index  228;
function  ERR_get_next_error_library;		external 'LIBEAY32' index  966;
function  ERR_get_state;			external 'LIBEAY32' index  229;
function  ERR_get_string_table; 		external 'LIBEAY32' index  230;
function  ERR_lib_error_string; 		external 'LIBEAY32' index  231;
procedure ERR_load_ASN1_strings;		external 'LIBEAY32' index  232;
procedure ERR_load_BIO_strings; 		external 'LIBEAY32' index  233;
procedure ERR_load_BN_strings;			external 'LIBEAY32' index  234;
procedure ERR_load_BUF_strings; 		external 'LIBEAY32' index  235;
procedure ERR_load_CONF_strings;		external 'LIBEAY32' index  236;
procedure ERR_load_CRYPTO_strings;		external 'LIBEAY32' index 1009;
procedure ERR_load_DH_strings;			external 'LIBEAY32' index  237;
procedure ERR_load_DSA_strings; 		external 'LIBEAY32' index  238;
procedure ERR_load_ERR_strings; 		external 'LIBEAY32' index  239;
procedure ERR_load_EVP_strings; 		external 'LIBEAY32' index  240;
procedure ERR_load_OBJ_strings; 		external 'LIBEAY32' index  241;
procedure ERR_load_PEM_strings; 		external 'LIBEAY32' index  242;
procedure ERR_load_PKCS7_strings;		external 'LIBEAY32' index  919;
procedure ERR_load_RSA_strings; 		external 'LIBEAY32' index  244;
Procedure ERR_load_X509_strings;		external 'LIBEAY32' index  245;
procedure ERR_load_all_crypto_strings;		external 'LIBEAY32' index  246;
procedure ERR_load_strings;			external 'LIBEAY32' index  247;
function  ERR_peek_error;			external 'LIBEAY32' index  248;
function  ERR_peek_error_line;			external 'LIBEAY32' index  249;
procedure ERR_print_errors;			external 'LIBEAY32' index  250;
//procedure ERR_print_errors_fp;		  external 'LIBEAY32' index  251;
procedure ERR_put_error;			external 'LIBEAY32' index  252;
function  ERR_reason_error_string;		external 'LIBEAY32' index  253;
procedure ERR_remove_state;			external 'LIBEAY32' index  254;
procedure ERR_set_error_data;			external 'LIBEAY32' index 1082;

function  EVP_BytesToKey;			external 'LIBEAY32' index  255;
procedure EVP_CIPHER_CTX_cleanup;		external 'LIBEAY32' index  256;
procedure EVP_CIPHER_CTX_init;			external 'LIBEAY32' index  961;
function  EVP_CIPHER_asn1_to_param;		external 'LIBEAY32' index 1083;
function  EVP_CIPHER_get_asn1_iv;		external 'LIBEAY32' index 1085;
function  EVP_CIPHER_param_to_asn1;		external 'LIBEAY32' index 1084;
function  EVP_CIPHER_set_asn1_iv;		external 'LIBEAY32' index 1086;
function  EVP_CipherFinal;			external 'LIBEAY32' index  257;
procedure EVP_CipherInit;			external 'LIBEAY32' index  258;
procedure EVP_CipherUpdate;			external 'LIBEAY32' index  259;
function  EVP_DecodeBlock;			external 'LIBEAY32' index  260;
function  EVP_DecodeFinal;			external 'LIBEAY32' index  261;
procedure EVP_DecodeInit;			external 'LIBEAY32' index  262;
function  EVP_DecodeUpdate;			external 'LIBEAY32' index  263;
function  EVP_DecryptFinal;			external 'LIBEAY32' index  264;
procedure EVP_DecryptInit;			external 'LIBEAY32' index  265;
procedure EVP_DecryptUpdate;			external 'LIBEAY32' index  266;
procedure EVP_DigestFinal;			external 'LIBEAY32' index  267;
procedure EVP_DigestInit;			external 'LIBEAY32' index  268;
procedure EVP_DigestUpdate;			external 'LIBEAY32' index  269;
function  EVP_EncodeBlock;			external 'LIBEAY32' index  270;
procedure EVP_EncodeFinal;			external 'LIBEAY32' index  271;
procedure EVP_EncodeInit;			external 'LIBEAY32' index  272;
procedure EVP_EncodeUpdate;			external 'LIBEAY32' index  273;
procedure EVP_EncryptFinal;			external 'LIBEAY32' index  274;
procedure EVP_EncryptInit;			external 'LIBEAY32' index  275;
procedure EVP_EncryptUpdate;			external 'LIBEAY32' index  276;
function  EVP_OpenFinal;			external 'LIBEAY32' index  277;
function  EVP_OpenInit; 			external 'LIBEAY32' index  278;
function  EVP_PKEY_assign;			external 'LIBEAY32' index  279;
function  EVP_PKEY_bits;			external 'LIBEAY32' index 1010;
function  EVP_PKEY_cmp_parameters;		external 'LIBEAY32' index  967;
function  EVP_PKEY_copy_parameters;		external 'LIBEAY32' index  280;
function  EVP_PKEY_decrypt;			external 'LIBEAY32' index 1070;
function  EVP_PKEY_encrypt;			external 'LIBEAY32' index 1071;
procedure EVP_PKEY_free;			external 'LIBEAY32' index  281;
function  EVP_PKEY_missing_parameters;		external 'LIBEAY32' index  282;
function  EVP_PKEY_new; 			external 'LIBEAY32' index  283;
function  EVP_PKEY_save_parameters;		external 'LIBEAY32' index  284;
function  EVP_PKEY_size;			external 'LIBEAY32' index  285;
function  EVP_PKEY_type;			external 'LIBEAY32' index  286;
procedure EVP_SealFinal;			external 'LIBEAY32' index  287;
function  EVP_SealInit; 			external 'LIBEAY32' index  288;
function  EVP_SignFinal;			external 'LIBEAY32' index  289;
function  EVP_VerifyFinal;			external 'LIBEAY32' index  290;
function  EVP_add_alias;			external 'LIBEAY32' index  291;
function  EVP_add_cipher;			external 'LIBEAY32' index  292;
function  EVP_add_digest;			external 'LIBEAY32' index  293;
function  EVP_bf_cbc;				external 'LIBEAY32' index  294;
function  EVP_bf_cfb;				external 'LIBEAY32' index  295;
function  EVP_bf_ecb;				external 'LIBEAY32' index  296;
function  EVP_bf_ofb;				external 'LIBEAY32' index  297;
function  EVP_cast5_cbc;			external 'LIBEAY32' index  983;
function  EVP_cast5_cfb;			external 'LIBEAY32' index  984;
function  EVP_cast5_ecb;			external 'LIBEAY32' index  985;
function  EVP_cast5_ofb;			external 'LIBEAY32' index  986;
procedure EVP_cleanup;				external 'LIBEAY32' index  298;
function  EVP_delete_alias;			external 'LIBEAY32' index  941;
function  EVP_des_cbc;				external 'LIBEAY32' index  299;
function  EVP_des_cfb;				external 'LIBEAY32' index  300;
function  EVP_des_ecb;				external 'LIBEAY32' index  301;
function  EVP_des_ede;				external 'LIBEAY32' index  302;
function  EVP_des_ede3; 			external 'LIBEAY32' index  303;
function  EVP_des_ede3_cbc;			external 'LIBEAY32' index  304;
function  EVP_des_ede3_cfb;			external 'LIBEAY32' index  304;
function  EVP_des_ede3_ofb;			external 'LIBEAY32' index  306;
function  EVP_des_ede_cbc;			external 'LIBEAY32' index  307;
function  EVP_des_ede_cfb;			external 'LIBEAY32' index  308;
function  EVP_des_ede_ofb;			external 'LIBEAY32' index  309;
function  EVP_des_ofb;				external 'LIBEAY32' index  310;
function  EVP_desx_cbc; 			external 'LIBEAY32' index  311;
function  EVP_dss;				external 'LIBEAY32' index  312;
function  EVP_dss1;				external 'LIBEAY32' index  313;
function  EVP_enc_null; 			external 'LIBEAY32' index  314;
function  EVP_get_cipherbyname; 		external 'LIBEAY32' index  315;
function  EVP_get_digestbyname; 		external 'LIBEAY32' index  316;
function  EVP_get_pw_prompt;			external 'LIBEAY32' index  317;
function  EVP_idea_cbc; 			external 'LIBEAY32' index  318;
function  EVP_idea_cfb; 			external 'LIBEAY32' index  319;
function  EVP_idea_ecb; 			external 'LIBEAY32' index  320;
function  EVP_idea_ofb; 			external 'LIBEAY32' index  321;
function  EVP_md2;				external 'LIBEAY32' index  322;
function  EVP_md5;				external 'LIBEAY32' index  323;
function  EVP_md_null;				external 'LIBEAY32' index  324;
function  EVP_mdc2;				external 'LIBEAY32' index  942;
function  EVP_rc2_40_cbc;			external 'LIBEAY32' index  959;
function  EVP_rc2_cbc;				external 'LIBEAY32' index  325;
function  EVP_rc2_cfb;				external 'LIBEAY32' index  326;
function  EVP_rc2_ecb;				external 'LIBEAY32' index  327;
function  EVP_rc2_ofb;				external 'LIBEAY32' index  328;
function  EVP_rc4;				external 'LIBEAY32' index  329;
function  EVP_rc4_40;				external 'LIBEAY32' index  960;
function  EVP_rc5_32_12_16_cbc; 		external 'LIBEAY32' index 1087;
function  EVP_rc5_32_12_16_cfb; 		external 'LIBEAY32' index 1088;
function  EVP_rc5_32_12_16_ecb; 		external 'LIBEAY32' index 1089;
function  EVP_rc5_32_12_16_ofb; 		external 'LIBEAY32' index 1090;
function  EVP_read_pw_string;			external 'LIBEAY32' index  330;
procedure EVP_set_pw_prompt;			external 'LIBEAY32' index  331;
function  EVP_sha;				external 'LIBEAY32' index  332;
function  EVP_sha1;				external 'LIBEAY32' index  333;
//function  EVP_ripemd160;			  external 'LIBEAY32' index  ???;

function  HMAC; 				external 'LIBEAY32' index  962;
procedure HMAC_Final;				external 'LIBEAY32' index  965;
procedure HMAC_Init;				external 'LIBEAY32' index  963;
procedure HMAC_Update;				external 'LIBEAY32' index  964;
procedure HMAC_cleanup; 			external 'LIBEAY32' index  968;

function  MD2;					external 'LIBEAY32' index  334;
procedure MD2_Final;				external 'LIBEAY32' index  335;
procedure MD2_Init;				external 'LIBEAY32' index  336;
procedure MD2_Update;				external 'LIBEAY32' index  337;
function  MD2_options;				external 'LIBEAY32' index  338;

function  MD5;					external 'LIBEAY32' index  339;
procedure MD5_Final;				external 'LIBEAY32' index  340;
procedure MD5_Init;				external 'LIBEAY32' index  341;
procedure MD5_Transform;			external 'LIBEAY32' index 1011;
procedure MD5_Update;				external 'LIBEAY32' index  342;

function  MDC2; 				external 'LIBEAY32' index  343;
procedure MDC2_Final;				external 'LIBEAY32' index  344;
procedure MDC2_Init;				external 'LIBEAY32' index  345;
procedure MDC2_Update;				external 'LIBEAY32' index  346;

procedure NETSCAPE_SPKAC_free;			external 'LIBEAY32' index  347;
function  NETSCAPE_SPKAC_new;			external 'LIBEAY32' index  348;
procedure NETSCAPE_SPKI_free;			external 'LIBEAY32' index  349;
function  NETSCAPE_SPKI_new;			external 'LIBEAY32' index  350;
function  NETSCAPE_SPKI_sign;			external 'LIBEAY32' index  351;
function  NETSCAPE_SPKI_verify; 		external 'LIBEAY32' index  352;

function  OBJ_add_object;			external 'LIBEAY32' index  353;
function  OBJ_bsearch;				external 'LIBEAY32' index  354;
procedure OBJ_cleanup;				external 'LIBEAY32' index  355;
function  OBJ_cmp;				external 'LIBEAY32' index  356;
function  OBJ_create;				external 'LIBEAY32' index  357;
function  OBJ_create_objects;			external 'LIBEAY32' index  997;
function  OBJ_dup;				external 'LIBEAY32' index  358;
function  OBJ_ln2nid;				external 'LIBEAY32' index  359;
function  OBJ_new_nid;				external 'LIBEAY32' index  360;
function  OBJ_nid2ln;				external 'LIBEAY32' index  361;
function  OBJ_nid2obj;				external 'LIBEAY32' index  362;
function  OBJ_nid2sn;				external 'LIBEAY32' index  363;
function  OBJ_obj2nid;				external 'LIBEAY32' index  364;
function  OBJ_sn2nid;				external 'LIBEAY32' index  365;
function  OBJ_txt2nid;				external 'LIBEAY32' index  366;

//function  PEM_ASN1_read;			  external 'LIBEAY32' index  367;
function  PEM_ASN1_read_bio;			external 'LIBEAY32' index  368;
//function  PEM_ASN1_write;			  external 'LIBEAY32' index  369;
function  PEM_ASN1_write_bio;			external 'LIBEAY32' index  370;
function  PEM_SealFinal;			external 'LIBEAY32' index  371;
function  PEM_SealInit; 			external 'LIBEAY32' index  372;
procedure PEM_SealUpdate;			external 'LIBEAY32' index  373;
function  PEM_SignFinal;			external 'LIBEAY32' index  374;
//procedure PEM_SignInit;			  external 'LIBEAY32' index  375;
//procedure PEM_SignUpdate;			  external 'LIBEAY32' index  376;
//function  PEM_X509_INFO_read; 		  external 'LIBEAY32' index  377;
function  PEM_X509_INFO_read_bio;		external 'LIBEAY32' index  378;
function  PEM_X509_INFO_write_bio;		external 'LIBEAY32' index  379;
procedure PEM_dek_info; 			external 'LIBEAY32' index  380;
function  PEM_do_header;			external 'LIBEAY32' index  381;
function  PEM_get_EVP_CIPHER_INFO;		external 'LIBEAY32' index  382;
procedure PEM_proc_type;			external 'LIBEAY32' index  383;
//function  PEM_read;				  external 'LIBEAY32' index  384;
//function  PEM_read_DHparams;			  external 'LIBEAY32' index  385;
//function  PEM_read_DSAPrivateKey;		  external 'LIBEAY32' index  386;
//function  PEM_read_DSAparams; 		  external 'LIBEAY32' index  387;
//function  PEM_read_PKCS7;			  external 'LIBEAY32' index  388;
//function  PEM_read_PrivateKey;		  external 'LIBEAY32' index  389;
//function  PEM_read_RSAPrivateKey;		  external 'LIBEAY32' index  390;
//function  PEM_read_RSAPublicKey;		  external 'LIBEAY32' index  947;
//function  PEM_read_X509;			  external 'LIBEAY32' index  391;
//function  PEM_read_X509_CRL;			  external 'LIBEAY32' index  392;
//function  PEM_read_X509_REQ;			  external 'LIBEAY32' index  393;
function  PEM_read_bio; 			external 'LIBEAY32' index  394;
function  PEM_read_bio_DHparams;		external 'LIBEAY32' index  395;
function  PEM_read_bio_DSAPrivateKey;		external 'LIBEAY32' index  396;
function  PEM_read_bio_DSAparams;		external 'LIBEAY32' index  397;
function  PEM_read_bio_PKCS7;			external 'LIBEAY32' index  398;
function  PEM_read_bio_PrivateKey;		external 'LIBEAY32' index  399;
function  PEM_read_bio_RSAPrivateKey;		external 'LIBEAY32' index  400;
function  PEM_read_bio_RSAPublicKey;		external 'LIBEAY32' index  943;
function  PEM_read_bio_X509;			external 'LIBEAY32' index  401;
function  PEM_read_bio_X509_CRL;		external 'LIBEAY32' index  402;
function  PEM_read_bio_X509_REQ;		external 'LIBEAY32' index  403;
//function  PEM_write;				  external 'LIBEAY32' index  404;
//function  PEM_write_DHparams; 		  external 'LIBEAY32' index  405;
//function  PEM_write_DSAPrivateKey;		  external 'LIBEAY32' index  406;
//function  PEM_write_DSAparams;		  external 'LIBEAY32' index  407;
//function  PEM_write_PKCS7;			  external 'LIBEAY32' index  408;
//function  PEM_write_PrivateKey;		  external 'LIBEAY32' index  409;
//function  PEM_write_RSAPrivateKey;		  external 'LIBEAY32' index  410;
//function  PEM_write_RSAPublicKey;		  external 'LIBEAY32' index  949;
//function  PEM_write_X509;			  external 'LIBEAY32' index  411;
//function  PEM_write_X509_CRL; 		  external 'LIBEAY32' index  412;
//function  PEM_write_X509_REQ; 		  external 'LIBEAY32' index  413;
function  PEM_write_bio;			external 'LIBEAY32' index  414;
function  PEM_write_bio_DHparams;		external 'LIBEAY32' index  415;
function  PEM_write_bio_DSAPrivateKey;		external 'LIBEAY32' index  416;
function  PEM_write_bio_DSAparams;		external 'LIBEAY32' index  417;
function  PEM_write_bio_PKCS7;			external 'LIBEAY32' index  418;
function  PEM_write_bio_PrivateKey;		external 'LIBEAY32' index  419;
function  PEM_write_bio_RSAPrivateKey;		external 'LIBEAY32' index  420;
function  PEM_write_bio_RSAPublicKey;		external 'LIBEAY32' index  944;
function  PEM_write_bio_X509;			external 'LIBEAY32' index  421;
function  PEM_write_bio_X509_CRL;		external 'LIBEAY32' index  422;
function  PEM_write_bio_X509_REQ;		external 'LIBEAY32' index  423;

procedure PKCS7_DIGEST_free;			external 'LIBEAY32' index  424;
function  PKCS7_DIGEST_new;			external 'LIBEAY32' index  425;
procedure PKCS7_ENCRYPT_free;			external 'LIBEAY32' index  426;
function  PKCS7_ENCRYPT_new;			external 'LIBEAY32' index  427;
procedure PKCS7_ENC_CONTENT_free;		external 'LIBEAY32' index  428;
function  PKCS7_ENC_CONTENT_new;		external 'LIBEAY32' index  429;
procedure PKCS7_ENVELOPE_free;			external 'LIBEAY32' index  430;
function  PKCS7_ENVELOPE_new;			external 'LIBEAY32' index  431;
function  PKCS7_ISSUER_AND_SERIAL_digest;	external 'LIBEAY32' index  432;
procedure PKCS7_ISSUER_AND_SERIAL_free; 	external 'LIBEAY32' index  433;
function  PKCS7_ISSUER_AND_SERIAL_new;		external 'LIBEAY32' index  434;
procedure PKCS7_RECIP_INFO_free;		external 'LIBEAY32' index  435;
function  PKCS7_RECIP_INFO_new; 		external 'LIBEAY32' index  436;
function  PKCS7_RECIP_INFO_set; 		external 'LIBEAY32' index 1072;
procedure PKCS7_SIGNED_free;			external 'LIBEAY32' index  437;
function  PKCS7_SIGNED_new;			external 'LIBEAY32' index  438;
procedure PKCS7_SIGNER_INFO_free;		external 'LIBEAY32' index  439;
function  PKCS7_SIGNER_INFO_new;		external 'LIBEAY32' index  440;
function  PKCS7_SIGNER_INFO_set;		external 'LIBEAY32' index  930;
procedure PKCS7_SIGN_ENVELOPE_free;		external 'LIBEAY32' index  441;
function  PKCS7_SIGN_ENVELOPE_new;		external 'LIBEAY32' index  442;
function  PKCS7_add_certificate;		external 'LIBEAY32' index  932;
function  PKCS7_add_crl;			external 'LIBEAY32' index  933;
function  PKCS7_add_recipient;			external 'LIBEAY32' index 1073;
function  PKCS7_add_recipient_info;		external 'LIBEAY32' index 1074;
function  PKCS7_add_signature;			external 'LIBEAY32' index  938;
function  PKCS7_add_signer;			external 'LIBEAY32' index  931;
function  PKCS7_cert_from_signer_info;		external 'LIBEAY32' index  939;
procedure PKCS7_content_free;			external 'LIBEAY32' index  918;
function  PKCS7_content_new;			external 'LIBEAY32' index  934;
function  PKCS7_ctrl;				external 'LIBEAY32' index  927;
function  PKCS7_dataInit;			external 'LIBEAY32' index  937;
function  PKCS7_dataSign;			external 'LIBEAY32' index  935;
function  PKCS7_dataVerify;			external 'LIBEAY32' index  936;
function  PKCS7_dup;				external 'LIBEAY32' index  443;
procedure PKCS7_free;				external 'LIBEAY32' index  444;
function  PKCS7_get_signer_info;		external 'LIBEAY32' index  940;
function  PKCS7_new;				external 'LIBEAY32' index  445;
function  PKCS7_set_cipher;			external 'LIBEAY32' index 1075;
function  PKCS7_set_content;			external 'LIBEAY32' index  929;
function  PKCS7_set_type;			external 'LIBEAY32' index  928;

procedure RAND_bytes;				external 'LIBEAY32' index  464;
procedure RAND_cleanup; 			external 'LIBEAY32' index  465;
function  RAND_file_name;			external 'LIBEAY32' index  466;
function  RAND_load_file;			external 'LIBEAY32' index  467;
procedure RAND_seed;				external 'LIBEAY32' index  469;
function  RAND_write_file;			external 'LIBEAY32' index  470;

procedure RC2_cbc_encrypt;			external 'LIBEAY32' index  471;
procedure RC2_cfb64_encrypt;			external 'LIBEAY32' index  472;
procedure RC2_decrypt;				external 'LIBEAY32' index  995;
procedure RC2_ecb_encrypt;			external 'LIBEAY32' index  473;
procedure RC2_encrypt;				external 'LIBEAY32' index  474;
procedure RC2_ofb64_encrypt;			external 'LIBEAY32' index  475;
procedure RC2_set_key;				external 'LIBEAY32' index  476;

procedure RC4;					external 'LIBEAY32' index  477;
function  RC4_options;				external 'LIBEAY32' index  478;
procedure RC4_set_key;				external 'LIBEAY32' index  479;

procedure RC5_32_cbc_encrypt;			external 'LIBEAY32' index 1051;
procedure RC5_32_cfb64_encrypt; 		external 'LIBEAY32' index 1052;
procedure RC5_32_decrypt;			external 'LIBEAY32' index 1050;
procedure RC5_32_ecb_encrypt;			external 'LIBEAY32' index 1048;
procedure RC5_32_encrypt;			external 'LIBEAY32' index 1049;
procedure RC5_32_ofb64_encrypt; 		external 'LIBEAY32' index 1053;
procedure RC5_32_set_key;			external 'LIBEAY32' index 1047;

function  RIPEMD160;				external 'LIBEAY32' index 1045;
procedure RIPEMD160_Final;			external 'LIBEAY32' index 1044;
procedure RIPEMD160_Init;			external 'LIBEAY32' index 1042;
procedure RIPEMD160_Transform;			external 'LIBEAY32' index 1046;
procedure RIPEMD160_Update;			external 'LIBEAY32' index 1043;

function  RSAPrivateKey_asn1_meth;		external 'LIBEAY32' index  480;
function  RSAPrivateKey_dup;			external 'LIBEAY32' index  481;
function  RSAPublicKey_dup;			external 'LIBEAY32' index  482;
//function  RSA_PKCS1_RSAref;			  external 'LIBEAY32' index  ???;
function  RSA_PKCS1_SSLeay;			external 'LIBEAY32' index  483;
procedure RSA_blinding_off;			external 'LIBEAY32' index  978;
function  RSA_blinding_on;			external 'LIBEAY32' index  977;
function  RSA_flags;				external 'LIBEAY32' index  956;
procedure RSA_free;				external 'LIBEAY32' index  484;
function  RSA_generate_key;			external 'LIBEAY32' index  485;
function  RSA_get_ex_data;			external 'LIBEAY32' index 1029;
function  RSA_get_ex_new_index; 		external 'LIBEAY32' index 1030;
function  RSA_new;				external 'LIBEAY32' index  486;
function  RSA_new_method;			external 'LIBEAY32' index  487;
function  RSA_padding_add_PKCS1_type_1; 	external 'LIBEAY32' index 1031;
function  RSA_padding_add_PKCS1_type_2; 	external 'LIBEAY32' index 1032;
function  RSA_padding_add_SSLv23;		external 'LIBEAY32' index 1033;
function  RSA_padding_add_none; 		external 'LIBEAY32' index 1034;
function  RSA_padding_check_PKCS1_type_1;	external 'LIBEAY32' index 1035;
function  RSA_padding_check_PKCS1_type_2;	external 'LIBEAY32' index 1036;
function  RSA_padding_check_SSLv23;		external 'LIBEAY32' index 1037;
function  RSA_padding_check_none;		external 'LIBEAY32' index 1038;
function  RSA_print;				external 'LIBEAY32' index  488;
//function  RSA_print_fp;			  external 'LIBEAY32' index  489;
function  RSA_private_decrypt;			external 'LIBEAY32' index  490;
function  RSA_private_encrypt;			external 'LIBEAY32' index  491;
function  RSA_public_decrypt;			external 'LIBEAY32' index  492;
function  RSA_public_encrypt;			external 'LIBEAY32' index  493;
procedure RSA_set_default_method;		external 'LIBEAY32' index  494;
function  RSA_set_ex_data;			external 'LIBEAY32' index 1028;
function  RSA_sign;				external 'LIBEAY32' index  495;
function  RSA_sign_ASN1_OCTET_STRING;		external 'LIBEAY32' index  496;
function  RSA_size;				external 'LIBEAY32' index  497;
function  RSA_verify;				external 'LIBEAY32' index  498;
function  RSA_verify_ASN1_OCTET_STRING; 	external 'LIBEAY32' index  499;

function  SHA;					external 'LIBEAY32' index  500;
function  SHA1; 				external 'LIBEAY32' index  501;
procedure SHA1_Final;				external 'LIBEAY32' index  502;
procedure SHA1_Init;				external 'LIBEAY32' index  503;
procedure SHA1_Transform;			external 'LIBEAY32' index 1012;
procedure SHA1_Update;				external 'LIBEAY32' index  504;
procedure SHA_Final;				external 'LIBEAY32' index  505;
procedure SHA_Init;				external 'LIBEAY32' index  506;
procedure SHA_Transform;			external 'LIBEAY32' index 1013;
procedure SHA_Update;				external 'LIBEAY32' index  507;

function  TXT_DB_create_index;			external 'LIBEAY32' index  511;
procedure TXT_DB_free;				external 'LIBEAY32' index  512;
function  TXT_DB_get_by_index;			external 'LIBEAY32' index  513;
function  TXT_DB_insert;			external 'LIBEAY32' index  514;
function  TXT_DB_read;				external 'LIBEAY32' index  515;
function  TXT_DB_write; 			external 'LIBEAY32' index  516;

procedure X509_ALGOR_free;			external 'LIBEAY32' index  517;
function  X509_ALGOR_new;			external 'LIBEAY32' index  518;
procedure X509_ATTRIBUTE_free;			external 'LIBEAY32' index  519;
function  X509_ATTRIBUTE_new;			external 'LIBEAY32' index  520;
procedure X509_CINF_free;			external 'LIBEAY32' index  521;
function  X509_CINF_new;			external 'LIBEAY32' index  522;
procedure X509_CRL_INFO_free;			external 'LIBEAY32' index  523;
function  X509_CRL_INFO_new;			external 'LIBEAY32' index  524;
function  X509_CRL_add_ext;			external 'LIBEAY32' index  525;
function  X509_CRL_cmp; 			external 'LIBEAY32' index  526;
function  X509_CRL_delete_ext;			external 'LIBEAY32' index  527;
function  X509_CRL_dup; 			external 'LIBEAY32' index  528;
procedure X509_CRL_free;			external 'LIBEAY32' index  529;
function  X509_CRL_get_ext;			external 'LIBEAY32' index  530;
function  X509_CRL_get_ext_by_NID;		external 'LIBEAY32' index  531;
function  X509_CRL_get_ext_by_OBJ;		external 'LIBEAY32' index  532;
function  X509_CRL_get_ext_by_critical; 	external 'LIBEAY32' index  533;
function  X509_CRL_get_ext_count;		external 'LIBEAY32' index  534;
function  X509_CRL_new; 			external 'LIBEAY32' index  535;
function  X509_CRL_sign;			external 'LIBEAY32' index  536;
function  X509_CRL_verify;			external 'LIBEAY32' index  537;
function  X509_EXTENSION_create_by_NID; 	external 'LIBEAY32' index  538;
function  X509_EXTENSION_create_by_OBJ; 	external 'LIBEAY32' index  539;
function  X509_EXTENSION_dup;			external 'LIBEAY32' index  540;
procedure X509_EXTENSION_free;			external 'LIBEAY32' index  541;
function  X509_EXTENSION_get_critical;		external 'LIBEAY32' index  542;
function  X509_EXTENSION_get_data;		external 'LIBEAY32' index  543;
function  X509_EXTENSION_get_object;		external 'LIBEAY32' index  544;
function  X509_EXTENSION_new;			external 'LIBEAY32' index  545;
function  X509_EXTENSION_set_critical;		external 'LIBEAY32' index  546;
function  X509_EXTENSION_set_data;		external 'LIBEAY32' index  547;
function  X509_EXTENSION_set_object;		external 'LIBEAY32' index  548;
procedure X509_INFO_free;			external 'LIBEAY32' index  549;
function  X509_INFO_new;			external 'LIBEAY32' index  550;
function  X509_LOOKUP_by_alias; 		external 'LIBEAY32' index  551;
function  X509_LOOKUP_by_fingerprint;		external 'LIBEAY32' index  552;
function  X509_LOOKUP_by_issuer_serial; 	external 'LIBEAY32' index  553;
function  X509_LOOKUP_by_subject;		external 'LIBEAY32' index  554;
function  X509_LOOKUP_ctrl;			external 'LIBEAY32' index  555;
function  X509_LOOKUP_file;			external 'LIBEAY32' index  556;
procedure X509_LOOKUP_free;			external 'LIBEAY32' index  557;
function  X509_LOOKUP_hash_dir; 		external 'LIBEAY32' index  558;
function  X509_LOOKUP_init;			external 'LIBEAY32' index  559;
function  X509_LOOKUP_new;			external 'LIBEAY32' index  560;
function  X509_LOOKUP_shutdown; 		external 'LIBEAY32' index  561;
function  X509_NAME_ENTRY_create_by_NID;	external 'LIBEAY32' index  562;
function  X509_NAME_ENTRY_create_by_OBJ;	external 'LIBEAY32' index  563;
function  X509_NAME_ENTRY_dup;			external 'LIBEAY32' index  564;
procedure X509_NAME_ENTRY_free; 		external 'LIBEAY32' index  565;
function  X509_NAME_ENTRY_get_data;		external 'LIBEAY32' index  566;
function  X509_NAME_ENTRY_get_object;		external 'LIBEAY32' index  567;
function  X509_NAME_ENTRY_new;			external 'LIBEAY32' index  568;
function  X509_NAME_ENTRY_set_data;		external 'LIBEAY32' index  569;
function  X509_NAME_ENTRY_set_object;		external 'LIBEAY32' index  570;
function  X509_NAME_add_entry;			external 'LIBEAY32' index  571;
function  X509_NAME_cmp;			external 'LIBEAY32' index  572;
function  X509_NAME_delete_entry;		external 'LIBEAY32' index  573;
function  X509_NAME_digest;			external 'LIBEAY32' index  574;
function  X509_NAME_dup;			external 'LIBEAY32' index  575;
function  X509_NAME_entry_count;		external 'LIBEAY32' index  576;
procedure X509_NAME_free;			external 'LIBEAY32' index  577;
function  X509_NAME_get_entry;			external 'LIBEAY32' index  578;
function  X509_NAME_get_index_by_NID;		external 'LIBEAY32' index  579;
function  X509_NAME_get_index_by_OBJ;		external 'LIBEAY32' index  580;
function  X509_NAME_get_text_by_NID;		external 'LIBEAY32' index  581;
function  X509_NAME_get_text_by_OBJ;		external 'LIBEAY32' index  582;
function  X509_NAME_hash;			external 'LIBEAY32' index  583;
function  X509_NAME_new;			external 'LIBEAY32' index  584;
function  X509_NAME_oneline;			external 'LIBEAY32' index  585;
function  X509_NAME_print;			external 'LIBEAY32' index  586;
function  X509_NAME_set;			external 'LIBEAY32' index  587;
procedure X509_OBJECT_free_contents;		external 'LIBEAY32' index  588;
function  X509_OBJECT_retrive_by_subject;	external 'LIBEAY32' index  589;
procedure X509_OBJECT_up_ref_count;		external 'LIBEAY32' index  590;
procedure X509_PKEY_free;			external 'LIBEAY32' index  591;
function  X509_PKEY_new;			external 'LIBEAY32' index  592;
procedure X509_PUBKEY_free;			external 'LIBEAY32' index  593;
function  X509_PUBKEY_new;			external 'LIBEAY32' index  594;
function  X509_PUBKEY_get;			external 'LIBEAY32' index  595;
function  X509_PUBKEY_set;			external 'LIBEAY32' index  596;
procedure X509_REQ_INFO_free;			external 'LIBEAY32' index  597;
function  X509_REQ_INFO_new;			external 'LIBEAY32' index  598;
function  X509_REQ_dup; 			external 'LIBEAY32' index  599;
procedure X509_REQ_free;			external 'LIBEAY32' index  600;
function  X509_REQ_get_pubkey;			external 'LIBEAY32' index  601;
function  X509_REQ_new; 			external 'LIBEAY32' index  602;
function  X509_REQ_print;			external 'LIBEAY32' index  603;
//function  X509_REQ_print_fp;			  external 'LIBEAY32' index  604;
function  X509_REQ_set_pubkey;			external 'LIBEAY32' index  605;
function  X509_REQ_set_subject_name;		external 'LIBEAY32' index  606;
function  X509_REQ_set_version; 		external 'LIBEAY32' index  607;
function  X509_REQ_sign;			external 'LIBEAY32' index  608;
function  X509_REQ_to_X509;			external 'LIBEAY32' index  609;
function  X509_REQ_verify;			external 'LIBEAY32' index  610;
function  X509_REVOKED_add_ext; 		external 'LIBEAY32' index  611;
function  X509_REVOKED_delete_ext;		external 'LIBEAY32' index  612;
procedure X509_REVOKED_free;			external 'LIBEAY32' index  613;
function  X509_REVOKED_get_ext; 		external 'LIBEAY32' index  614;
function  X509_REVOKED_get_ext_by_critical;	external 'LIBEAY32' index  615;
function  X509_REVOKED_get_ext_by_NID;		external 'LIBEAY32' index  616;
function  X509_REVOKED_get_ext_by_OBJ;		external 'LIBEAY32' index  617;
function  X509_REVOKED_get_ext_count;		external 'LIBEAY32' index  618;
function  X509_REVOKED_new;			external 'LIBEAY32' index  619;
procedure X509_SIG_free;			external 'LIBEAY32' index  620;
function  X509_SIG_new; 			external 'LIBEAY32' index  621;
procedure X509_STORE_CTX_cleanup;		external 'LIBEAY32' index  622;
function  X509_STORE_CTX_get_chain;		external 'LIBEAY32' index 1014;
function  X509_STORE_CTX_get_current_cert;	external 'LIBEAY32' index 1015;
function  X509_STORE_CTX_get_error;		external 'LIBEAY32' index 1016;
function  X509_STORE_CTX_get_error_depth;	external 'LIBEAY32' index 1017;
function  X509_STORE_CTX_get_ex_data;		external 'LIBEAY32' index 1018;
procedure X509_STORE_CTX_init;			external 'LIBEAY32' index  623;
procedure X509_STORE_CTX_set_cert;		external 'LIBEAY32' index 1020;
procedure X509_STORE_CTX_set_chain;		external 'LIBEAY32' index 1021;
procedure X509_STORE_CTX_set_error;		external 'LIBEAY32' index 1022;
function  X509_STORE_CTX_set_ex_data;		external 'LIBEAY32' index 1023;
function  X509_STORE_add_cert;			external 'LIBEAY32' index  624;
function  X509_STORE_add_crl;			external 'LIBEAY32' index  957;
function  X509_STORE_add_lookup;		external 'LIBEAY32' index  625;
procedure X509_STORE_free;			external 'LIBEAY32' index  626;
function  X509_STORE_get_by_subject;		external 'LIBEAY32' index  627;
function  X509_STORE_load_locations;		external 'LIBEAY32' index  628;
function  X509_STORE_new;			external 'LIBEAY32' index  629;
function  X509_STORE_set_default_paths; 	external 'LIBEAY32' index  630;
procedure X509_VAL_free;			external 'LIBEAY32' index  631;
function  X509_VAL_new; 			external 'LIBEAY32' index  632;
function  X509_add_ext; 			external 'LIBEAY32' index  633;
function  X509_asn1_meth;			external 'LIBEAY32' index  634;
function  X509_certificate_type;		external 'LIBEAY32' index  635;
function  X509_check_private_key;		external 'LIBEAY32' index  636;
function  X509_cmp_current_time;		external 'LIBEAY32' index  637;
function  X509_delete_ext;			external 'LIBEAY32' index  638;
function  X509_digest;				external 'LIBEAY32' index  639;
function  X509_dup;				external 'LIBEAY32' index  640;
function  X509_find_by_issuer_and_serial;	external 'LIBEAY32' index  920;
function  X509_find_by_subject; 		external 'LIBEAY32' index  921;
procedure X509_free;				external 'LIBEAY32' index  641;
function  X509_get_default_cert_area;		external 'LIBEAY32' index  642;
function  X509_get_default_cert_dir;		external 'LIBEAY32' index  643;
function  X509_get_default_cert_dir_env;	external 'LIBEAY32' index  644;
function  X509_get_default_cert_file;		external 'LIBEAY32' index  645;
function  X509_get_default_cert_file_env;	external 'LIBEAY32' index  646;
function  X509_get_default_private_dir; 	external 'LIBEAY32' index  647;
function  X509_get_ext; 			external 'LIBEAY32' index  648;
function  X509_get_ext_by_NID;			external 'LIBEAY32' index  649;
function  X509_get_ext_by_OBJ;			external 'LIBEAY32' index  650;
function  X509_get_ext_by_critical;		external 'LIBEAY32' index  651;
function  X509_get_ext_count;			external 'LIBEAY32' index  652;
function  X509_get_issuer_name; 		external 'LIBEAY32' index  653;
function  X509_get_pubkey;			external 'LIBEAY32' index  654;
function  X509_get_pubkey_parameters;		external 'LIBEAY32' index  655;
function  X509_get_serialNumber;		external 'LIBEAY32' index  656;
function  X509_get_subject_name;		external 'LIBEAY32' index  657;
function  X509_gmtime_adj;			external 'LIBEAY32' index  658;
function  X509_issuer_and_serial_cmp;		external 'LIBEAY32' index  659;
function  X509_issuer_and_serial_hash;		external 'LIBEAY32' index  660;
function  X509_issuer_name_cmp; 		external 'LIBEAY32' index  661;
function  X509_issuer_name_hash;		external 'LIBEAY32' index  662;
function  X509_load_cert_file;			external 'LIBEAY32' index  663;
function  X509_load_crl_file;			external 'LIBEAY32' index  958;
function  X509_new;				external 'LIBEAY32' index  664;
function  X509_print;				external 'LIBEAY32' index  665;
//function  X509_print_fp;			  external 'LIBEAY32' index  666;
function  X509_set_issuer_name; 		external 'LIBEAY32' index  667;
function  X509_set_notAfter;			external 'LIBEAY32' index  668;
function  X509_set_notBefore;			external 'LIBEAY32' index  669;
function  X509_set_pubkey;			external 'LIBEAY32' index  670;
function  X509_set_serialNumber;		external 'LIBEAY32' index  671;
function  X509_set_subject_name;		external 'LIBEAY32' index  672;
function  X509_set_version;			external 'LIBEAY32' index  673;
function  X509_sign;				external 'LIBEAY32' index  674;
function  X509_subject_name_cmp;		external 'LIBEAY32' index  675;
function  X509_subject_name_hash;		external 'LIBEAY32' index  676;
function  X509_to_X509_REQ;			external 'LIBEAY32' index  677;
function  X509_verify;				external 'LIBEAY32' index  678;
function  X509_verify_cert;			external 'LIBEAY32' index  679;
function  X509_verify_cert_error_string;	external 'LIBEAY32' index  680;

function  X509v3_add_ext;			external 'LIBEAY32' index  681;
function  X509v3_add_extension; 		external 'LIBEAY32' index  682;
function  X509v3_add_netscape_extensions;	external 'LIBEAY32' index  683;
function  X509v3_add_standard_extensions;	external 'LIBEAY32' index  684;
procedure X509v3_cleanup_extensions;		external 'LIBEAY32' index  685;
function  X509v3_data_type_by_OBJ;		external 'LIBEAY32' index  686;
function  X509v3_data_type_by_NID;		external 'LIBEAY32' index  687;
function  X509v3_delete_ext;			external 'LIBEAY32' index  688;
function  X509v3_get_ext;			external 'LIBEAY32' index  689;
function  X509v3_get_ext_by_NID;		external 'LIBEAY32' index  690;
function  X509v3_get_ext_by_OBJ;		external 'LIBEAY32' index  691;
function  X509v3_get_ext_by_critical;		external 'LIBEAY32' index  692;
function  X509v3_get_ext_count; 		external 'LIBEAY32' index  693;
function  X509v3_pack_string;			external 'LIBEAY32' index  694;
function  X509v3_pack_type_by_OBJ;		external 'LIBEAY32' index  695;
function  X509v3_pack_type_by_NID;		external 'LIBEAY32' index  696;
function  X509v3_unpack_string; 		external 'LIBEAY32' index  697;

function  a2d_ASN1_OBJECT;			external 'LIBEAY32' index  699;
function  a2i_ASN1_INTEGER;			external 'LIBEAY32' index  700;
function  a2i_ASN1_STRING;			external 'LIBEAY32' index  701;
function  asn1_Finish;				external 'LIBEAY32' index  702;

function  bn_add_words; 			external 'LIBEAY32' index 1039;
function  bn_div64;				external 'LIBEAY32' index  704;
function  bn_expand2;				external 'LIBEAY32' index  705;
function  bn_mul_add_words;			external 'LIBEAY32' index  706;
function  bn_mul_words; 			external 'LIBEAY32' index  707;
procedure bn_qadd;				external 'LIBEAY32' index  708;
procedure bn_qsub;				external 'LIBEAY32' index  709;
procedure bn_sqr_words; 			external 'LIBEAY32' index  710;

function  crypt;				external 'LIBEAY32' index  711;

function  d2i_ASN1_BIT_STRING;			external 'LIBEAY32' index  712;
function  d2i_ASN1_BOOLEAN;			external 'LIBEAY32' index  713;
function  d2i_ASN1_HEADER;			external 'LIBEAY32' index  714;
function  d2i_ASN1_IA5STRING;			external 'LIBEAY32' index  715;
function  d2i_ASN1_INTEGER;			external 'LIBEAY32' index  716;
function  d2i_ASN1_OCTET_STRING;		external 'LIBEAY32' index  717;
function  d2i_ASN1_OBJECT;			external 'LIBEAY32' index  718;
function  d2i_ASN1_PRINTABLE;			external 'LIBEAY32' index  719;
function  d2i_ASN1_PRINTABLESTRING;		external 'LIBEAY32' index  720;
function  d2i_ASN1_SET; 			external 'LIBEAY32' index  721;
function  d2i_ASN1_T61STRING;			external 'LIBEAY32' index  722;
function  d2i_ASN1_TYPE;			external 'LIBEAY32' index  723;
function  d2i_ASN1_UTCTIME;			external 'LIBEAY32' index  724;
function  d2i_ASN1_bytes;			external 'LIBEAY32' index  725;
function  d2i_ASN1_type_bytes;			external 'LIBEAY32' index  726;
function  d2i_DHparams; 			external 'LIBEAY32' index  727;
function  d2i_DSAPrivateKey;			external 'LIBEAY32' index  728;
function  d2i_DSAPrivateKey_bio;		external 'LIBEAY32' index  729;
//function  d2i_DSAPrivateKey_fp;		  external 'LIBEAY32' index  730;
function  d2i_DSAPublicKey;			external 'LIBEAY32' index  731;
function  d2i_DSAparams;			external 'LIBEAY32' index  732;
function  d2i_NETSCAPE_SPKAC;			external 'LIBEAY32' index  733;
function  d2i_NETSCAPE_SPKI;			external 'LIBEAY32' index  734;
function  d2i_Netscape_RSA;			external 'LIBEAY32' index  735;
function  d2i_Netscape_RSA_2;			external 'LIBEAY32' index 1040;
function  d2i_PKCS7;				external 'LIBEAY32' index  736;
function  d2i_PKCS7_DIGEST;			external 'LIBEAY32' index  737;
function  d2i_PKCS7_ENC_CONTENT;		external 'LIBEAY32' index  738;
function  d2i_PKCS7_ENCRYPT;			external 'LIBEAY32' index  739;
function  d2i_PKCS7_ENVELOPE;			external 'LIBEAY32' index  740;
function  d2i_PKCS7_ISSUER_AND_SERIAL;		external 'LIBEAY32' index  741;
function  d2i_PKCS7_RECIP_INFO; 		external 'LIBEAY32' index  742;
function  d2i_PKCS7_SIGN_ENVELOPE;		external 'LIBEAY32' index  743;
function  d2i_PKCS7_SIGNED;			external 'LIBEAY32' index  744;
function  d2i_PKCS7_SIGNER_INFO;		external 'LIBEAY32' index  745;
function  d2i_PKCS7_bio;			external 'LIBEAY32' index  746;
//function  d2i_PKCS7_fp;			  external 'LIBEAY32' index  747;
function  d2i_PrivateKey;			external 'LIBEAY32' index  748;
function  d2i_PublicKey;			external 'LIBEAY32' index  749;
function  d2i_RSAPrivateKey;			external 'LIBEAY32' index  750;
function  d2i_RSAPrivateKey_bio;		external 'LIBEAY32' index  751;
//function  d2i_RSAPrivateKey_fp;		  external 'LIBEAY32' index  752;
function  d2i_RSAPublicKey;			external 'LIBEAY32' index  753;
function  d2i_RSAPublicKey_bio; 		external 'LIBEAY32' index  945;
//function  d2i_RSAPublicKey_fp;		  external 'LIBEAY32' index  952;
function  d2i_X509;				external 'LIBEAY32' index  754;
function  d2i_X509_ALGOR;			external 'LIBEAY32' index  755;
function  d2i_X509_ATTRIBUTE;			external 'LIBEAY32' index  756;
function  d2i_X509_CINF;			external 'LIBEAY32' index  757;
function  d2i_X509_CRL; 			external 'LIBEAY32' index  758;
function  d2i_X509_CRL_INFO;			external 'LIBEAY32' index  759;
function  d2i_X509_CRL_bio;			external 'LIBEAY32' index  760;
//function  d2i_X509_CRL_fp;			  external 'LIBEAY32' index  761;
function  d2i_X509_EXTENSION;			external 'LIBEAY32' index  762;
function  d2i_X509_NAME;			external 'LIBEAY32' index  763;
function  d2i_X509_NAME_ENTRY;			external 'LIBEAY32' index  764;
function  d2i_X509_PKEY;			external 'LIBEAY32' index  765;
function  d2i_X509_PUBKEY;			external 'LIBEAY32' index  766;
function  d2i_X509_REQ; 			external 'LIBEAY32' index  767;
function  d2i_X509_REQ_INFO;			external 'LIBEAY32' index  768;
function  d2i_X509_REQ_bio;			external 'LIBEAY32' index  769;
//function  d2i_X509_REQ_fp;			  external 'LIBEAY32' index  770;
function  d2i_X509_REVOKED;			external 'LIBEAY32' index  771;
function  d2i_X509_SIG; 			external 'LIBEAY32' index  772;
function  d2i_X509_VAL; 			external 'LIBEAY32' index  773;
function  d2i_X509_bio; 			external 'LIBEAY32' index  774;
//function  d2i_X509_fp;			  external 'LIBEAY32' index  775;

function  des_cbc_cksum;			external 'LIBEAY32' index  777;
procedure des_cbc_encrypt;			external 'LIBEAY32' index  778;
//procedure des_cblock_print_file;		  external 'LIBEAY32' index  779;
procedure des_cfb64_encrypt;			external 'LIBEAY32' index  780;
procedure des_cfb_encrypt;			external 'LIBEAY32' index  781;
procedure des_decrypt3; 			external 'LIBEAY32' index  782;
procedure des_ecb3_encrypt;			external 'LIBEAY32' index  783;
procedure des_ecb_encrypt;			external 'LIBEAY32' index  784;
procedure des_ede3_cbc_encrypt; 		external 'LIBEAY32' index  785;
procedure des_ede3_cfb64_encrypt;		external 'LIBEAY32' index  786;
procedure des_ede3_ofb64_encrypt;		external 'LIBEAY32' index  787;
function  des_enc_read; 			external 'LIBEAY32' index  788;
function  des_enc_write;			external 'LIBEAY32' index  789;
procedure des_encrypt;				external 'LIBEAY32' index  790;
procedure des_encrypt2; 			external 'LIBEAY32' index  791;
procedure des_encrypt3; 			external 'LIBEAY32' index  792;
function  des_fcrypt;				external 'LIBEAY32' index  793;
function  des_is_weak_key;			external 'LIBEAY32' index  794;
function  des_key_sched;			external 'LIBEAY32' index  795;
procedure des_ncbc_encrypt;			external 'LIBEAY32' index  796;
procedure des_ofb64_encrypt;			external 'LIBEAY32' index  797;
procedure des_ofb_encrypt;			external 'LIBEAY32' index  798;
function  des_options;				external 'LIBEAY32' index  799;
procedure des_pcbc_encrypt;			external 'LIBEAY32' index  800;
function  des_quad_cksum;			external 'LIBEAY32' index  801;
procedure des_random_key;			external 'LIBEAY32' index  802;
procedure des_random_seed;			external 'LIBEAY32' index  803;
function  des_read_2passwords;			external 'LIBEAY32' index  804;
function  des_read_password;			external 'LIBEAY32' index  805;
function  des_read_pw;				external 'LIBEAY32' index  806;
function  des_read_pw_string;			external 'LIBEAY32' index  807;
function  des_set_key;				external 'LIBEAY32' index  808;
procedure des_set_odd_parity;			external 'LIBEAY32' index  809;
procedure des_string_to_2keys;			external 'LIBEAY32' index  810;
procedure des_string_to_key;			external 'LIBEAY32' index  811;
procedure des_xcbc_encrypt;			external 'LIBEAY32' index  812;
procedure des_xwhite_in2out;			external 'LIBEAY32' index  813;

function  i2a_ASN1_INTEGER;			external 'LIBEAY32' index  815;
function  i2a_ASN1_OBJECT;			external 'LIBEAY32' index  816;
function  i2a_ASN1_STRING;			external 'LIBEAY32' index  817;

function  i2d_ASN1_BIT_STRING;			external 'LIBEAY32' index  818;
function  i2d_ASN1_BOOLEAN;			external 'LIBEAY32' index  819;
function  i2d_ASN1_HEADER;			external 'LIBEAY32' index  820;
function  i2d_ASN1_IA5STRING;			external 'LIBEAY32' index  821;
function  i2d_ASN1_INTEGER;			external 'LIBEAY32' index  822;
function  i2d_ASN1_OBJECT;			external 'LIBEAY32' index  823;
function  i2d_ASN1_OCTET_STRING;		external 'LIBEAY32' index  824;
function  i2d_ASN1_PRINTABLE;			external 'LIBEAY32' index  825;
function  i2d_ASN1_SET; 			external 'LIBEAY32' index  826;
function  i2d_ASN1_TYPE;			external 'LIBEAY32' index  827;
function  i2d_ASN1_UTCTIME;			external 'LIBEAY32' index  828;
function  i2d_ASN1_bytes;			external 'LIBEAY32' index  829;
function  i2d_DHparams; 			external 'LIBEAY32' index  830;
function  i2d_DSAPrivateKey;			external 'LIBEAY32' index  831;
function  i2d_DSAPrivateKey_bio;		external 'LIBEAY32' index  832;
//function  i2d_DSAPrivateKey_fp;		  external 'LIBEAY32' index  833;
function  i2d_DSAPublicKey;			external 'LIBEAY32' index  834;
function  i2d_DSAparams;			external 'LIBEAY32' index  835;
function  i2d_NETSCAPE_SPKAC;			external 'LIBEAY32' index  836;
function  i2d_NETSCAPE_SPKI;			external 'LIBEAY32' index  837;
function  i2d_Netscape_RSA;			external 'LIBEAY32' index  838;
function  i2d_PKCS7;				external 'LIBEAY32' index  839;
function  i2d_PKCS7_DIGEST;			external 'LIBEAY32' index  840;
function  i2d_PKCS7_ENC_CONTENT;		external 'LIBEAY32' index  841;
function  i2d_PKCS7_ENCRYPT;			external 'LIBEAY32' index  842;
function  i2d_PKCS7_ENVELOPE;			external 'LIBEAY32' index  843;
function  i2d_PKCS7_ISSUER_AND_SERIAL;		external 'LIBEAY32' index  844;
function  i2d_PKCS7_RECIP_INFO; 		external 'LIBEAY32' index  845;
function  i2d_PKCS7_SIGNED;			external 'LIBEAY32' index  846;
function  i2d_PKCS7_SIGNER_INFO;		external 'LIBEAY32' index  847;
function  i2d_PKCS7_SIGN_ENVELOPE;		external 'LIBEAY32' index  848;
function  i2d_PKCS7_bio;			external 'LIBEAY32' index  849;
//function  i2d_PKCS7_fp;			  external 'LIBEAY32' index  850;
function  i2d_PrivateKey;			external 'LIBEAY32' index  851;
function  i2d_PublicKey;			external 'LIBEAY32' index  852;
function  i2d_RSAPrivateKey;			external 'LIBEAY32' index  853;
function  i2d_RSAPrivateKey_bio;		external 'LIBEAY32' index  854;
//function i2d_RSAPrivateKey_fp;		  external 'LIBEAY32' index  855;
function  i2d_RSAPublicKey;			external 'LIBEAY32' index  856;
function  i2d_RSAPublicKey_bio; 		external 'LIBEAY32' index  946;
//function i2d_RSAPublicKey_fp; 		  external 'LIBEAY32' index  954;
function  i2d_X509;				external 'LIBEAY32' index  857;
function  i2d_X509_ALGOR;			external 'LIBEAY32' index  858;
function  i2d_X509_ATTRIBUTE;			external 'LIBEAY32' index  859;
function  i2d_X509_CINF;			external 'LIBEAY32' index  860;
function  i2d_X509_CRL; 			external 'LIBEAY32' index  861;
function  i2d_X509_CRL_INFO;			external 'LIBEAY32' index  862;
function  i2d_X509_CRL_bio;			external 'LIBEAY32' index  863;
//function  i2d_X509_CRL_fp;			  external 'LIBEAY32' index  864;
function  i2d_X509_EXTENSION;			external 'LIBEAY32' index  865;
function  i2d_X509_NAME;			external 'LIBEAY32' index  866;
function  i2d_X509_NAME_ENTRY;			external 'LIBEAY32' index  867;
function  i2d_X509_PKEY;			external 'LIBEAY32' index  868;
function  i2d_X509_PUBKEY;			external 'LIBEAY32' index  869;
function  i2d_X509_REQ; 			external 'LIBEAY32' index  870;
function  i2d_X509_REQ_INFO;			external 'LIBEAY32' index  871;
function  i2d_X509_REQ_bio;			external 'LIBEAY32' index  872;
//function  i2d_X509_REQ_fp;			  external 'LIBEAY32' index  873;
function  i2d_X509_REVOKED;			external 'LIBEAY32' index  874;
function  i2d_X509_SIG; 			external 'LIBEAY32' index  875;
function  i2d_X509_VAL; 			external 'LIBEAY32' index  876;
function  i2d_X509_bio; 			external 'LIBEAY32' index  877;
//function  i2d_X509_fp;			  external 'LIBEAY32' index  878;
function  i2t_ASN1_OBJECT;			external 'LIBEAY32' index  979;

procedure idea_cbc_encrypt;			external 'LIBEAY32' index  879;
procedure idea_cfb64_encrypt;			external 'LIBEAY32' index  880;
procedure idea_ecb_encrypt;			external 'LIBEAY32' index  881;
procedure idea_encrypt; 			external 'LIBEAY32' index  882;
procedure idea_ofb64_encrypt;			external 'LIBEAY32' index  883;
function  idea_options; 			external 'LIBEAY32' index  884;
procedure idea_set_decrypt_key; 		external 'LIBEAY32' index  885;
procedure idea_set_encrypt_key; 		external 'LIBEAY32' index  886;

function  lh_delete;				external 'LIBEAY32' index  887;
procedure lh_doall;				external 'LIBEAY32' index  888;
procedure lh_doall_arg; 			external 'LIBEAY32' index  889;
procedure lh_free;				external 'LIBEAY32' index  890;
function  lh_insert;				external 'LIBEAY32' index  891;
function  lh_new;				external 'LIBEAY32' index  892;
//procedure lh_node_stats;			  external 'LIBEAY32' index  893;
procedure lh_node_stats_bio;			external 'LIBEAY32' index  894;
//procedure lh_node_usage_stats;		  external 'LIBEAY32' index  895;
procedure lh_node_usage_stats_bio;		external 'LIBEAY32' index  896;
function  lh_retrieve;				external 'LIBEAY32' index  897;
//procedure lh_stats;				  external 'LIBEAY32' index  898;
procedure lh_stats_bio; 			external 'LIBEAY32' index  899;
function  lh_strhash;				external 'LIBEAY32' index  900;

function  sk_delete;				external 'LIBEAY32' index  901;
function  sk_delete_ptr;			external 'LIBEAY32' index  902;
function  sk_dup;				external 'LIBEAY32' index  903;
function  sk_find;				external 'LIBEAY32' index  904;
procedure sk_free;				external 'LIBEAY32' index  905;
function  sk_insert;				external 'LIBEAY32' index  906;
function  sk_new;				external 'LIBEAY32' index  907;
function  sk_pop;				external 'LIBEAY32' index  908;
procedure sk_pop_free;				external 'LIBEAY32' index  909;
function  sk_push;				external 'LIBEAY32' index  910;
procedure sk_set_cmp_func;			external 'LIBEAY32' index  911;
function  sk_shift;				external 'LIBEAY32' index  912;
function  sk_unshift;				external 'LIBEAY32' index  913;
procedure sk_zero;				external 'LIBEAY32' index  914;

const
  CRYPTO_thread_is_setup	: Boolean	= False;
var
  lock_cs			: Array[0.._CRYPTO_NUM_LOCKS-1] of TSemHandle;

procedure vp_locking_callback(mode,typ:Integer;fname:PChar;line:Integer);CDecl;
begin
  if mode and _CRYPTO_LOCK <> 0 then begin
    SemRequestMutex(lock_cs[typ], -1);
  end else begin
    SemReleaseMutex(lock_cs[typ]);
  end;
end;

function CRYPTO_thread_setup:Boolean;
var
  i				: Integer;
begin
  if CRYPTO_thread_is_setup then exit;
  CRYPTO_thread_is_setup := True;
  for i := 0 to _CRYPTO_NUM_LOCKS-1 do
    lock_cs[i] := SemCreateMutex(nil,false,false);
  CRYPTO_set_locking_callback(vp_locking_callback);
  Result := True;
end;

procedure CRYPTO_thread_cleanup;
var
  i				: Integer;
begin
  if not CRYPTO_thread_is_setup then exit;
  CRYPTO_set_locking_callback(nil);
  for i := 0 to _CRYPTO_NUM_LOCKS-1 do
    SemCloseMutex(lock_cs[i]);
  CRYPTO_thread_is_setup := False;
end;


function  vp_malloc(size:LongInt):Pointer; CDecl;
begin
  Result := SysGetMem(size);
end;

function vp_realloc(p:Pointer;size:LongInt):Pointer; CDecl;
begin
  Result := SysReallocMem(p,size);
end;

procedure vp_free(p:Pointer); CDecl;
begin
  SysFreeMem(p);
end;

function vp_threadid:Cardinal; CDecl;
begin
  Result := GetThreadId;
end;

type
  MyData		= record	// UserData structure in TextRec
  case Integer of
    0:(_		: Array[0..31] of Byte);
    1:(b		: BIO;
       doclose		: Integer);
  end;

function textOutput(var F:TextRec):Integer;
var
  i			: Integer;
begin
  if F.BufPos>0 then begin
    i := BIO_write(MyData(F.UserData).b,F.BufPtr^,F.BufPos);
  end;
  F.BufPos := 0;
  F.BufEnd := 0;
  textOutput := 0;
end;

function textInput(var F:TextRec):Integer;
var
  i			: Integer;
begin
  i := BIO_read(MyData(F.UserData).b,F.BufPtr^,F.BufSize);
  if i>=0 then F.BufEnd := i else F.BufEnd := 0;
  F.BufPos := 0;
  textInput := 0;
end;

function textClose(var F:TextRec):Integer;
begin
  if MyData(F.UserData).doclose<>0 then BIO_free_all(MyData(F.UserData).b);
  textClose := 0;
end;

function textOpen(var F:TextRec):Integer;
begin
  if F.Mode = fmInput then begin
    F.InOutFunc := @textInput;
    F.FlushFunc := nil;
  end else begin
    F.InOutFunc := @textOutput;
    F.FlushFunc := @textOutput;
  end;
  F.CloseFunc := @textClose;
  textOpen := 0;
end;

procedure AssignBIO(var t:Text;b:BIO;doclose:Integer);
begin
  FillChar(t, SizeOf(TextRec), 0);
  with TextRec(t) do begin
    Handle := $FFFFFFFF;
    MyData(UserData).b := b;
    MyData(UserData).doclose := doclose;
    Mode := fmClosed;
    BufSize := SizeOf(Buffer);
    BufPtr := @Buffer;
    OpenFunc := @textOpen;
    Name[0] := #0;
  end;
end;

function conOutput(var F:TextRec):Integer;
var
  i			: Integer;
begin
  if F.BufPos>0 then begin
    if console<>nil then
    i := BIO_write(console,F.BufPtr^,F.BufPos) else
    i := BIO_write(stdout,F.BufPtr^,F.BufPos);
  end;
  F.BufPos := 0;
  F.BufEnd := 0;
  conOutput := 0;
end;

function conInput(var F:TextRec):Integer;
var
  i			: Integer;
begin
  if console<>nil then
  i := BIO_read(console,F.BufPtr^,F.BufSize) else
  i := BIO_read(stdin,F.BufPtr^,F.BufSize);
  if i>=0 then F.BufEnd := i else F.BufEnd := 0;
  F.BufPos := 0;
  conInput := 0;
end;

function conClose(var F:TextRec):Integer;
begin
  conClose := 0;
end;

function conOpen(var F:TextRec):Integer;
begin
  if F.Mode = fmInput then begin
    F.InOutFunc := @conInput;
    F.FlushFunc := nil;
  end else begin
    F.InOutFunc := @conOutput;
    F.FlushFunc := @conOutput;
  end;
  F.CloseFunc := @conClose;
  conOpen := 0;
end;

procedure AssignConsole(var t:Text);
begin
  FillChar(t, SizeOf(TextRec), 0);
  with TextRec(t) do begin
    Handle := $FFFFFFFF;
    Mode := fmClosed;
    BufSize := 1{SizeOf(Buffer)};
    BufPtr := @Buffer;
    OpenFunc := @conOpen;
    Name[0] := #0;
  end;
end;

procedure ConsoleBIO(b:BIO);	      // for Multithreaded programs
begin
  console := b;
end;

var
  OldExit		: Pointer;
  OldInput,OldOutput	: Text;
procedure MyExit;
begin
  CRYPTO_thread_cleanup;
  close(Input); close(Output);
  Move(OldInput,Input,SizeOf(OldInput));
  Move(OldOutput,Output,SizeOf(OldOutput));
  if stdin <> nil then BIO_free(stdin); stdin := nil;
  if stdout <> nil then BIO_free(stdout); stdout := nil;
  if stderr <> nil then BIO_free(stderr); stderr := nil;
end;

begin
  CRYPTO_set_mem_functions(vp_malloc,vp_realloc,vp_free);
  CRYPTO_set_id_callback(vp_threadid);
  OldExit := ExitProc;
  Move(Input,OldInput,SizeOf(OldInput));
  Move(Output,OldOutput,SizeOf(OldOutput));
  stdin  := BIO_new_fd(SysFileStdIn,0);
  stdout := BIO_new_fd(SysFileStdOut,0);
  stderr := BIO_new_fd(SysFileStdErr,0);
  //AssignBIO(output,stdout); Rewrite(output);
  //AssignBIO(input,stdin); Reset(input);
  AssignConsole(output); Rewrite(output);	// Potentially unsafe
  AssignConsole(input); Rewrite(input); 	// but what the heck!
  ExitProc := @MyExit;
end.
