/***************************************************************************

  Program:      GCPPGPFE.E Version 1.2

  Author:       John C. Frickson

  Copyright:    Copyright (c) 1994-1996 by Gibbon Computer Products
                All rights reserved.

  Description:

        Front end for PGP (Pretty Good Privacy) 2.6.x

        This E macro will build a menu containing various options for
        executing PGP.  When a menu item is selected, the corresponding
        command is run.

  Notes for the Security Conscious:

        Uses temporary files
        Passphrase stored in memory

  Not Implemented:

        see if wipefile (-w) does any good
        sign and conventionally encrypt?
        the esoteric commands           ???????

r = WinMessageBox('Debug', 'Message', 16416)

 ***************************************************************************/

include 'stdconst.e'

/************
  Constants
************/
const
   Copyright = 'GCP PGP Front-End'\10 ||
               'Copyright 1994-1996 by Gibbon Computer Products'\10 ||
               'All rights reserved'\10
   PGP_P  = \1'PGP operations'
   ENCN_P = \1'Encryption operations'
   ENCR_P = \1'Encrypt the selected text'
   ENCS_P = \1'Encrypt and sign the selected text'
   ENCC_P = \1'Encrypt the selected text using Conventional encryption'
   INCL_P = \1'Operations to include public key or fingerprint'
   IKEY_P = \1'Include public key at the current cursor position'
   IFNG_P = \1'Include fingerprint at the current cursor position'
   SIGN_P = \1'Sign the selected text'
   DECR_P = \1'Decrypt and display the message'
   CSIG_P = \1'Check for a valid signature'
   DFLT_P = \1'Toggle default settings on or off'
   CLPW_P = \1'Erase Password from EPM memory'
   SLCT_P = \1'Select which public and secret keyrings will be used'
   SELS_P = \1'Select which secret keyring to use'
   SELP_P = \1'Select which public keyring to use'
   VIEW_P = \1'View the contents of your keyrings'
   VPRN_P = \1'View the contents of your public keyring'
   VPRV_P = \1'Verbose view the contents of your public keyring'
   VPRT_P = \1'View public keyring IDs, signatures, trust, and validity'
   VPRF_P = \1'View fingerprints from your public keyring'
   VSRN_P = \1'View the contents of your secret keyring'
   VSRV_P = \1'Verbose view the contents of your secret keyring'
   VSRT_P = \1'View public keyring IDs, signatures, trust, and validity'
   VSRF_P = \1'View fingerprints from your secret keyring'
   MGMT_P = \1'Key management operations'
   KADD_P = \1'Add the currently displayed key to your public keyring'
   KGEN_P = \1'Generate public/secret key pair (OS/2 Command Shell)'
   KRED_P = \1'Edit your user id or secret ring passphrase (OS/2 Command Shell)'
   TRST_P = \1'Edit trust parameters for a public key (OS/2 Command Shell)'
   REMV_P = \1'Remove a key from your keyring (OS/2 Command Shell)'
   KSGN_P = \1'Sign and certify a key on public ring (OS/2 Command Shell)'
   RMSG_P = \1'Remove selected signatures from a key (OS/2 Command Shell)'
   REVK_P = \1'Permantly revoke your key (OS/2 Command Shell)'
   KDBL_P = \1'Enable or Disable a key on public ring (OS/2 Command Shell)'
   HELP_P = \1'PGP Help operations'
   PHLP_P = \1'Display the PGP Help file'
   ABOT_P = \1'Display the "About" dialog'


/*********************************
  Execute this on initialization
*********************************/
definit
   universal vTEMP_PATH                             -- Path for temporary file - Predefined
   universal activemenu, defaultmenu
   universal pgp_armor, pgp_textmode,
             pgp_clearsig, pgp_uselang
   universal sec_name, sec_keyid, sec_pswd, pub_keyid, pub_name
   universal pgp_pubring, pgp_curpubring
   universal pgp_secring
   universal pgp_randseed, pgp_config
   universal pgp_path, pgp_found
   universal pgp_cmd, pgp_opts

   sec_keyid = ''
   sec_name  = ''
   sec_pswd = ''
   pub_keyid = ''
   pub_name  = ''
   pgp_path = Strip(Get_Env('PGPPATH'))
   sec_pswd = Strip(Get_Env('PGPPASS'))
   pgp_found = 1
   if RightStr(pgp_path,1) = '\' then
      pgp_path = LeftStr(pgp_path, Length(pgp_path) - 1)
    endif
   pgp_cmd = 'PGP +bat +int=off +pa=cat +verb=0'
   pgp_opts = '+la=en +cl -at'

   pgp_armor       = 1                  -- -a option
   pgp_textmode    = 1                  -- -t option
   pgp_clearsig    = 1                  -- +clearsig
   pgp_uselang     = 1                  -- +la=en

   pgp_pubring     = pgp_path'\pubring.pgp'
   pgp_curpubring  = pgp_path'\pubring.pgp'
   pgp_secring     = pgp_path'\secring.pgp'
   pgp_randseed    = pgp_path'\randseed.bin'
   pgp_config      = ''

   deletemenu defaultmenu, 6, 0, 0  -- delete the existing Help menu
                                    -- (we want it to stay at the right)

; ****> Create the PGP menu

   buildsubmenu  defaultmenu,    70,      'P~GP',                              PGP_P,                  0, 0
   buildmenuitem defaultmenu,    70, 710, '~Encrypt or Sign',                  ENCN_P,                17, 0
      buildmenuitem defaultmenu, 70, 711, '~Encrypt Text'\9'-e',               'PGPEncr -e'ENCR_P,     0, 0
      buildmenuitem defaultmenu, 70, 712, '~Sign Text'\9'-s',                  'PGPEncr -s'SIGN_P,     0, 0
      buildmenuitem defaultmenu, 70, 713, 'Encrypt ~and Sign'\9'-se',          'PGPEncr -se'ENCS_P,    0, 0
      buildmenuitem defaultmenu, 70, 714, '~Conventional Encryption'\9'-c',    'PGPEncr -c'ENCC_P, 32769, 0
   buildmenuitem defaultmenu,    70, 720, '~Include Key or Fingerprint',       INCL_P,                17, 0
      buildmenuitem defaultmenu, 70, 721, 'Include ~Public Key'\9'-kx',        'PGPIncKey x'IKEY_P,    0, 0
      buildmenuitem defaultmenu, 70, 722, 'Include Key ~Fingerprint'\9'-kvc',  'PGPIncKey vc'IFNG_P,32769,0
   buildmenuitem defaultmenu,    70, 729,  \0,                                 '',                     4, 0
   buildmenuitem defaultmenu,    70, 730, '~Decrypt Message',                  'PGPDecr d'DECR_P,      0, 0
   buildmenuitem defaultmenu,    70, 731, '~Check Signature',                  'PGPDecr c'CSIG_P,      0, 0
   buildmenuitem defaultmenu,    70, 739,  \0,                                 '',                     4, 0
   buildmenuitem defaultmenu,    70, 740, 'Cha~nge Defaults',                  'PGPDflt'DFLT_P,        0, 0
   buildmenuitem defaultmenu,    70, 741, 'Clear ~Password',                   'PGPClrPw'CLPW_P,       0, 0
   buildmenuitem defaultmenu,    70, 750, 'Select ~Keyrings',                  SLCT_P,                17, 0
      buildmenuitem defaultmenu, 70, 751, '~Secret Keyring',                   'PGPRing s'SELS_P,      0, 0
      buildmenuitem defaultmenu, 70, 752, '~Public Keyring',                   'PGPRing p'SELP_P,  32769, 0
   buildmenuitem defaultmenu,    70, 759,  \0,                                 '',                     4, 0
   buildmenuitem defaultmenu,    70, 760, '~View Keyring',                     VIEW_P,                17, 0
      buildmenuitem defaultmenu, 70, 761, 'Pubring ~Normal'\9'-kv',            'PGPKV p v'VPRN_P,      0, 0
      buildmenuitem defaultmenu, 70, 762, 'Pubring ~Verbose'\9'-kvv',          'PGPKV p vv'VPRV_P,     0, 0
      buildmenuitem defaultmenu, 70, 763, 'Pubring ~Trust/Validity'\9'-kc',    'PGPKV p c'VPRT_P,      0, 0
      buildmenuitem defaultmenu, 70, 764, 'Pubring ~Fingerprint'\9'-kvc',      'PGPKV p vc'VPRF_P,     0, 0
      buildmenuitem defaultmenu, 70, 765, 'Secring Nor~mal'\9'-kv',            'PGPKV s v'VSRN_P,      0, 0
      buildmenuitem defaultmenu, 70, 766, 'Secring Ver~bose'\9'-kvv',          'PGPKV s vv'VSRV_P,     0, 0
      buildmenuitem defaultmenu, 70, 767, 'Secring Fing~erprint'\9'-kvc',      'PGPKV s vc'VSRF_P, 32769, 0
   buildmenuitem defaultmenu,    70, 770, 'Key ~Management',                   MGMT_P,                17, 0
      buildmenuitem defaultmenu, 70, 771, '~Add Key to Pubring'\9'-ka',        'PGPAddKey a'KADD_P,    0, 0
      buildmenuitem defaultmenu, 70, 772, '(S) ~Generate a Key'\9'-kg',        'PGPKMgt s g'KGEN_P,    0, 0
      buildmenuitem defaultmenu, 70, 773, '(S) ~Edit UserID or Passphrase'\9'-ke','PGPKMgt s e'KRED_P, 0, 0
      buildmenuitem defaultmenu, 70, 774, '(S) Edit ~Trust Parameters'\9'-ke', 'PGPKMgt p e'TRST_P,    0, 0
      buildmenuitem defaultmenu, 70, 775, '(S) ~Remove a Key'\9'-kr',          'PGPKMgt p r'REMV_P,    0, 0
      buildmenuitem defaultmenu, 70, 776, '(S) ~Sign and certify a Key'\9'-ks','PGPKMgt p s'KSGN_P,    0, 0
      buildmenuitem defaultmenu, 70, 777, '(S) Re~move signatures'\9'-krs',    'PGPKMgt p rs'RMSG_P,   0, 0
      buildmenuitem defaultmenu, 70, 778, '(S) Revo~ke your key'\9'-kd',       'PGPKMgt s d'REVK_P,    0, 0
      buildmenuitem defaultmenu, 70, 779, '(S) ~Disable/enable a key'\9'-kd',  'PGPKMgt p d'KDBL_P,32769, 0
   buildmenuitem defaultmenu,    70, 780,  \0,                                 '',                     4, 0
   buildmenuitem defaultmenu,    70, 781, '~Help',                              HELP_P,               17, 0
      buildmenuitem defaultmenu, 70, 782, 'PGP ~Help',                         'PGPHelp'PHLP_P,        0, 0
      buildmenuitem defaultmenu, 70, 783, '~About...',                         'PGPAbout'ABOT_P,   32769, 0

   call readd_help_menu()           -- Add the Help menu back in

   showmenu defaultmenu             -- Ta da!


/******************************
  Execute this on termination
******************************/
defexit
   universal defaultmenu, activemenu
   deletemenu defaultmenu,700,0,0
   call maybe_show_menu()


/************************
  Display PGP Help (-h)
************************/
defc PGPHelp=
   if pgp_checkrings() = 0 then
      return
   endif
   sayerror 'Getting help.  Please wait...'  -- Information message
   refresh                                   -- Make sure the message is displayed
   r = pgp_redirect('-h')               -- pass commands to routine the does the work
   if r = 'ERROR' then
      return
   endif
   .filename='/PGP Help/'                    -- change the title line
   if .last=0 then                           -- if the output window
      'q'                                    --    has no lines, then quit
      sayerror 'Unable to display help!'     --    and give a message
   endif


/***************************
  Display the About dialog
***************************/
defc PGPAbout=

   r = WinMessageBox('About Gibbon PGP Front End v1.2',
                        'Copyright (c) 1994-1996 by ' ||
                        'Gibbon Computer Products'\10 ||
                        'All rights reserved'\10\10 ||
                        'Gibbon PGP Front End v1.2'\10 ||
                        'EPM, Lamail, and NR/2 interface '||
                        'to PGP Version 2.6.x.  See the ' ||
                        'README for more information.'\10\10 ||
                        'John C. Frickson <frickson@gibbon.com>', 16432)
; MB_OK           = 0
; MB_ICONASTERISK = 48
; MB_INFORMATION  = MB_ICONASTERISK
; MB_MOVEABLE     = 16384
   x = pgp_checkrings()


/******************************************************************************
  View either public or secret keyring, normal (-kv) or verbose (-kvv) or
  trust/validity (-kc) or fingerprints (-kvc)
******************************************************************************/
defc PGPKV=
   universal pgp_curpubring, pgp_secring

   arg1 = Word(arg(1),1)
   arg2 = Word(arg(1),2)

   switch = '-k'arg2

   if pgp_checkrings() = 0 then
      return
   endif

   user = EntryBox('Enter user id, key id or "*" for all', '', '*', 30, 128)
   if user = '' then
      Return
   endif
   if LeftStr(user,1) <> '"' then
      user = '"' || user || '"'
   endif

   sayerror 'Getting Keyring Information.  Please wait...'  -- Information message
   refresh                                   -- Make sure the message is displayed

   if arg1 = 'p' then
      pubsec = 'Public'
      r = pgp_redirect(switch user pgp_curpubring)  -- pass commands to routine the does the work
      if r = 'ERROR' then
         return
      endif
   else
      pubsec = 'Secret'
      r = pgp_redirect(switch user pgp_secring)  -- pass commands to routine the does the work
      if r = 'ERROR' then
         return
      endif
   endif

   If arg2 = 'vv' then
      temp = '/Verbose'
   elseif arg2 = 'vc' then
      temp = '/Fingerprint'
   elseif arg2 = 'c' then
      temp = '/Trust and Validity'
   else
      temp = '/Normal'
   endif

   .filename=temp 'Listing of' pubsec 'Keyring/'      -- change the title line
   if .last=0 then                           -- if the output window
      'q'                                    --    has no lines, then quit
      sayerror 'Unable to view keyring!'     --    and give a message
   endif


/***********************************************
  Select which public or secret keyring to use
***********************************************/
defc PGPRing=
   universal pgp_curpubring, pgp_secring

   message = 'Changing public or secret keyrings will ' ||
             'NOT change which keyrings are used for '  ||
             'encryption.  This is only for key '       ||
             'management and viewing purposes!'
   r = WinMessageBox('Gibbon PGP Front End', message, 16432)
;                                      MB_INFORMATION = 48
;                                      MB_MOVEABLE    = 16384

   if arg(1) = 'p' then
      temp1 = pgp_curpubring
      temp2 = 'Public'
   else
      temp1 = pgp_secring
      temp2 = 'Secret'
   endif

   kr = EntryBox('Enter' temp2 'Keyring Filename', '/~OK/~Cancel', temp1, 30, 128)
   if kr <> '' then
      if pgp_checkrings() = 0 then
         return
      endif
      if arg(1) = 'p' then
         pgp_curpubring = kr
      else
         pgp_secring = kr
      endif
      if pgp_checkrings() = 0 then
         if arg(1) = 'p' then
            pgp_curpubring = temp1
         else
            pgp_secring = temp1
         endif
         return
      endif
      if arg(1) = 's' then
         pgp_get_sec_id()
      endif
      sayerror temp2 'Keyring is now:' kr
   endif


/************************************************************
  Put up a listbox that allows toggling of default settings
************************************************************/
defc PGPDflt=

   universal pgp_armor, pgp_textmode,
             pgp_clearsig, pgp_uselang
   universal pgp_cmd, pgp_opts

   if pgp_checkrings() = 0 then
      return
   endif

   message = 'By default, Gibbon PGP Front End turns on ' ||
             'Armor, Textmode and Clearsig, and sets the '||
             'language to English.  If you toggle these ' ||
             'OFF, the defaults from your CONFIG.TXT '    ||
             'file will be used.'                         ||
             \10\10'This may not mean these options are ' ||
             'OFF!  Check your CONFIG.TXT for the '       ||
             'default status.'
   r = WinMessageBox('Gibbon PGP Front End', message, 16432)
;                                      MB_INFORMATION = 48
;                                      MB_MOVEABLE    = 16384

   one = atoi(1)
   zero = atoi(0)

   tpgp_armor       = pgp_armor
   tpgp_textmode    = pgp_textmode
   tpgp_clearsig    = pgp_clearsig
   tpgp_uselang     = pgp_uselang

   Do Forever

      if tpgp_armor then
         pgpoptn = '^ASCII Armor (-a) is ON'
      else
         pgpoptn = '^ASCII Armor (-a) is OFF'
      endif
      if tpgp_textmode then
         pgpoptn = pgpoptn || '^Text mode (-t) is ON'
      else
         pgpoptn = pgpoptn || '^Text mode (-t) is OFF'
      endif
      if tpgp_clearsig then
         pgpoptn = pgpoptn || '^Clear sig (+clearsig) is ON'
      else
         pgpoptn = pgpoptn || '^Clear sig (+clearsig) is OFF'
      endif
      if tpgp_uselang then
         pgpoptn = pgpoptn || '^Language (+la=en) is ON'
      else
         pgpoptn = pgpoptn || '^Language (+la=en) is OFF'
      endif

      parse value listbox('Gibbon PGP Processing Defaults',
                           pgpoptn,
                          '/~OK/~Cancel/~Toggle',
                          0, 0, 4, 40,
                          compile if EVERSION >= 5.60 --gethwndc(APP_HANDLE)
                             zero || zero || one || one || zero ||
                          compile else                --gethwndc(APP_HANDLE)
                             one || one || zero || zero || zero ||
                          compile endif
                          'Toggle Options On or Off -- CAREFULLY!!') with button 2 text \0

      btn = itoa(button || \0, 10)

      if btn < '3' then
         leave
      endif

      test = Word(text,1) || Word(text,Words(text))

      if test = 'ASCIION' then
         tpgp_armor = 0
      elseif test = 'ASCIIOFF' then
         tpgp_armor = 1
      elseif test = 'TextON' then
         tpgp_textmode = 0
      elseif test = 'TextOFF' then
         tpgp_textmode = 1
      elseif test = 'ClearON' then
         tpgp_clearsig = 0
      elseif test = 'ClearOFF' then
         tpgp_clearsig = 1
      elseif test = 'LanguageON' then
         tpgp_uselang = 0
      elseif test = 'LanguageOFF' then
         tpgp_uselang = 1
      endif

   EndDo

   if btn = '1' then
      pgp_armor       = tpgp_armor
      pgp_textmode    = tpgp_textmode
      pgp_clearsig    = tpgp_clearsig
      pgp_uselang     = tpgp_uselang
      if pgp_clearsig then
         pgp_opts = '+cl'
      else
         pgp_opts = '+cl=off'
      endif
      if pgp_armor then
         pgp_opts = pgp_opts '-a'
      endif
      if pgp_textmode then
         if pgp_armor then
            pgp_opts = pgp_opts || 't'
         else
            pgp_opts = pgp_opts '-t'
         endif
      endif
      if pgp_uselang then
         pgp_opts = pgp_opts '+la=en'
      endif
   endif


/***************************************
   Clear Password from memory
***************************************/
defc PGPClrPW=
   universal sec_name, sec_pswd
   sec_name = ''
   sec_pswd = ''
   message = 'Password has been cleared from memory'
   r = WinMessageBox('Gibbon PGP Front End', message, 16432)
;                                      MB_INFORMATION = 48
;                                      MB_MOVEABLE    = 16384


/****************************************************
  Include public key or fingerprint in message text
  arg   vc  fingerprint
        x   public key
****************************************************/
defc PGPIncKey=
   universal pgp_curpubring, pgp_secring
   universal sec_name, pub_keyid, pub_name
   universal pgp_cmd, pgp_opts

   if pgp_checkrings() = 0 then
      return
   endif

   switch = '-k'arg(1)

/* select public key */
   pgp_get_pub_id(0)
   if pub_keyid = '' then
      return
   endif

   sayerror 'Getting Keyring Information.  Please wait...'  -- Information message
   refresh                                   -- Make sure the message is displayed

   Display -3                                -- turn off display updates and error messages
   GetFileID msgFileID                       -- get fileid of current message

   r = pgp_redirect(pgp_opts switch pub_keyid pgp_curpubring)
   if r = 'ERROR' then
      Display 3                              -- enable display updates and messages
      return
   endif
   GetFileID tempFileID                    -- get fileid of processed text file

/* Here we parse stderr looking for errors and warnings */
   lastline = .last
   Do line = 1 to lastline
      GetLine viewline, line, tempFileID
      if rc < 0 then
         Display 3                           -- enable display updates and messages
         sayerror 'unexpected EOF during parse of stderr'
         Return
      endif

-- handle case of unknown error, we search for the error flag \007
      if Pos('', viewline) > 0 then
         message = viewline
         'q'                               -- leave stderr
         ActivateFile msgFileID            -- activate the original file
         Display 3                         -- enable display updates and messages
         refresh
         r = WinMessageBox('Gibbon PGP Front End', message, 16432)
;                                            MB_INFORMATION = 48
;                                            MB_MOVEABLE    = 16384
         Return

-- else, get next line of stderr
      else
         iterate
      endif
   EndDo /* getline */

-- Normally we exit this way if no errors found in stderr

   if .last=0 then                           -- if the output window
      'q'                                    --    has no lines, then quit
      Display 3                              --    enable display updates and messages
      sayerror 'PGP returned nothing for the selected key!'  --    and give a message
      Return
   endif

   ActivateFile msgFileID                    -- activate the original file
   EndLine                                   -- Go to the end of the line
   Split                                     -- Start a new line
   Down                                      -- Move down one line

   copyflag = 0

   do lnum = 1 to tempFileID.last            -- Copy the lines from the temp file
      Getline xferline, lnum, tempFileID     --    output from PGP command
      if LeftStr(xferline,10) = '-----BEGIN' then
         copyflag = 1
      endif
      if copyflag then
         InsertLine xferline                 --  into the current file
      endif
      if LeftStr(xferline,10) = 'Type bits/' then
         InsertLine xferline                 --  into the current file
      endif
      if LeftStr(xferline,4) = 'pub ' then
         InsertLine xferline                 --  into the current file
      endif
      if Pos('Key fingerprint', xferline) > 0 then
         xferline = strip(xferline)      --  strip off leading spaces
         InsertLine xferline                 --  into the current file
      endif
      if LeftStr(xferline,8) = '-----END' then
         copyflag = 0
      endif
   EndDo

   ActivateFile tempFileID                   -- activate the temp file
   'q'                                       -- quit the file
   ActivateFile msgFileID                    -- activate the original file
   display 3                                 -- turn updates & messages on
   refresh

   message = 'Inserted'
   if arg(1) = 'vc' then
      message = message 'fingerprint'
   else
      message = message 'public key'
   endif
   message = message ' for' pub_name
   r = WinMessageBox('Gibbon PGP Front End', message, 16432)
;                                      MB_INFORMATION = 48
;                                      MB_MOVEABLE    = 16384


/************************************
  Encrypt or Sign the selected text
  -s sign
  -e encrypt
  -se sign and encrypt
  -c conventional encrypt
************************************/
defc PGPEncr=
   universal vTEMP_PATH
   universal pgp_pubring, pgp_secring
   universal pgp_armor, pgp_textmode,
             pgp_clearsig
   universal sec_name, sec_keyid, sec_pswd, pub_keyid, pub_name
   universal pgp_opts

   if pgp_checkrings() = 0 then
      return
   endif

   bad_pswd = 0

   switch = arg(1)

   if switch = '-s' then
      function = 'Sign'
   else
      function = 'Encrypt'
   endif
   message = function'ing in progress -- Please wait...'

-- check if user marked text to encrypt/sign
   PSAVE_MARK(savemark)
   parse value savemark with firstl lastl firstc lastc fileid marktyp
   SETMARK firstl, lastl, 1, LongestLine(), 1, fileid

   if (marktyp = '') then
      r = WinMessageBox('Gibbon PGP Front End',
                        'I can''t' function 'anything without knowing what ' ||
                        'to' function'.  Please mark the appropriate text.', 16416)
;                                                                MB_CUAWARNING = 32
;                                                                MB_MOVEABLE   = 16384
      return
   endif

   if (.line = 0) then
      .line = 1
   endif

-- get secret key if signing
   if Pos('s', switch) > 0 then
      -- Always get the secret key id (changed from v1.0) --
      pgp_get_sec_id()            -- sets global variables sec_keyid and sec_name
      if sec_keyid = '' then      -- make sure didn't fail
         return
      endif
   endif

-- get public key if encrypting
   if Pos('e', switch) > 0 then
      pgp_get_pub_id(1)           -- sets global variables pub_keyid and pub_name
      if pub_keyid = '' then      -- make sure didn't fail
         return
      endif
   endif

-- check for a revoked key
   if pub_name = '*** KEY REVOKED ***' then
      message = 'Key ID:' pub_keyid || \10\10
      message = message || 'This key has been *REVOKED*' || \10
      message = message || 'so you can not use this key!'
      r = WinMessageBox('Gibbon PGP Front End', message, 16416)
;                                        MB_CUAWARNING = 32
;                                        MB_MOVEABLE   = 16384
      return
   endif

-- get passphrase if signing
   if Pos('s', switch) > 0 then
      if sec_pswd = '' then
compile if EVERSION > 6.01
         pass = EntryBox('Enter your passphrase', '/OK/Cancel', '', 30, 1024, '', 140)
compile else
         pass = EntryBox('Enter your passphrase', '/OK/Cancel', '', 30, 1024)
compile endif
         if pass = '' then
            Return
         endif
         sec_pswd = pass
      endif
   endif

-- get passphrase if encrypting conventionally
   if switch = '-c' then
compile if EVERSION > 6.01
      pgp_convpswd = EntryBox('Enter passphrase for conventional encryption',
                            '/~OK/~Cancel', '', 30, 1024, '', 140)
compile else
      pgp_convpswd = EntryBox('Enter passphrase for conventional encryption',
                            '/~OK/~Cancel', '', 30, 1024)
compile endif
      if pgp_convpswd = '' then
         Return
      endif
    endif

   sayerror message

   Display -3                              -- turn off display updates and error messages
   GetFileID msgFileID                     -- get fileid of current message
   save_modify = msgFileID.modify          -- save the modified flag
   outfile=vTEMP_PATH || 'pgpfe.out'       -- Build the file name for the temp file
   call erasetemp(outfile)                 -- clear out any leftover temp file
   'e' outfile                             -- open it
   MoveMark                                -- move the marked text to the outfile window
   's'                                     -- save the temporary file
   GetFileID outFileID

   sayerror message

-- switch can have values -e -se -s -c (encrypt, sign&encrypt, sign, conventional)
   cmdline = switch
   if Pos('c', switch) > 0 then
      cmdline = cmdline '-z"'pgp_convpswd'" '
   endif
   if Pos('s', switch) > 0 then
      cmdline = cmdline '-z"'sec_pswd'" '
   endif
   if Pos('e', switch) > 0 then
      cmdline = cmdline  pub_keyid || ' '
   endif
   if Pos('s', switch) > 0 then
      cmdline = cmdline || '-u 'sec_keyid' '
   endif

   cmdline = cmdline || '<' outfile

   r = pgp_redirect(pgp_opts cmdline)
   call erasetemp(outfile)                 -- and delete the temp file

   sayerror 'Processing complete.'

   if r = 'ERROR' then
      UnMark
      ActivateFile outFileID
      SETMARK 1, .last, 1, LongestLine(), 1, outFileID
      ActivateFile msgFileID               -- activate the original file
      CopyMark                             -- restore the moved text
      ActivateFile outFileID
      'q'                                  -- quit the file
      ActivateFile msgFileID               -- activate the original file
      Display 3                            -- enable display updates and messages
      refresh
      return
   endif

   GetFileID tempFileID                    -- get fileid of processed text file
   lastline = .last
   ActivateFile msgFileID                  -- activate the original file

   copyflag = 0
   copied = 0

-- this routine copies message portion of stdout to original message file
   Do line = 1 to lastline
      GetLine xferline, line, tempFileID
      if LeftStr(xferline,10) = '-----BEGIN' then
         copyflag = 1
      endif
      if copyflag then
         InsertLine xferline
         copied = 1
      endif
      if LeftStr(xferline,8) = '-----END' then
         copyflag = 0
      endif
   End

-- if message was not copied from stdout file, then something bad happened,
-- most likely a bad passphrase was given
-- first thing we do is restore message file back to original condition
   if copied = 0 then
      UnMark
      ActivateFile outFileID
      SETMARK 1, .last, 1, LongestLine(), 1, outFileID
      ActivateFile msgFileID               -- activate the original file
      CopyMark                             -- restore the text
      msgFileID.modify = save_modify       -- reset modified flag
   end

   ActivateFile outFileID
   'q'                                     -- quit the file
   ActivateFile msgFileID                  -- activate the original file
   Unmark

   Display 3                               -- enable display updates and messages
   refresh

-- summarize what was accomplished...
-- if copied=0 then some error occurred
   if copied = 0 then
      errlineno = 2
      GetLine errorline, errlineno, tempFileID
      chkline = UpCase(errorline)
      if Pos('ERROR',chkline) then
         message = 'PGP Detected an error while attempting ' ||
                   'to encrypt or sign this message.  The '  ||
                   'error message is:'\10\10
         While Length(errorline) > 3 Do
            if LeftStr(errorline,1) = \7 then
               errorline = RightStr(errorline, Length(errorline) - 1)
            endif
            if LeftStr(errorline,24) = "Error:  Bad pass phrase." then
               sec_pswd = ''
               bad_pswd = 1
            endif
            message = message || errorline || \10
            errlineno = errlineno + 1
            if errlineno > tempFileID.last then
               Leave
            endif
            GetLine errorline, errlineno, tempFileID
         EndWhile

      else
         message = 'The requested action was not performed, and ' ||
                   'the reason is unknown.  Make sure you are '   ||
                   'executing an OS/2 version of PGP, that your ' ||
                   'PATH/PGPPATH are correct, and your keyrings ' ||
                   'are valid.  If you can''t figure out the '    ||
                   'problem, contact frickson@gibbon.com.'
      endif
 -- copied != 0 so pgp was successful at something
   else
      message = 'This message has been'
      if Pos('s', switch) > 0 then
         if Pos('e', switch) then
            message = message || \10
         endif
         message = message 'signed by' sec_name
      endif
      if Pos('e', switch) then
         if Pos('s', switch) > 0 then
            message = message || \10\10'and'
         endif
         message = message 'encrypted using the public key for' pub_name
      endif
      if switch = '-c' then
         message = message \10'conventionally encrypted.'
      endif
   endif
   ActivateFile tempFileID                 -- activate the temporary file
   'q'                                     -- quit the file
   ActivateFile msgFileID                  -- activate the original file
   refresh
   if bad_pswd then
      message = message || \10\10 || 'Please try again.'
   endif
   r = WinMessageBox('Gibbon PGP Front End', message, 16432)
;                                      MB_INFORMATION = 48
;                                      MB_MOVEABLE    = 16384


/***************************************
  Decrypt message or check a signature
    -c  check signature
    -d  decrypt
***************************************/
defc PGPDecr=
   universal vTEMP_PATH
   universal pgp_pubring, pgp_secring
   universal pgp_armor, pgp_textmode,
             pgp_clearsig
   universal sec_name, sec_keyid, sec_pswd

   if pgp_checkrings() = 0 then
      return
   endif

   needconvpswd = 0
   needpswd = 0

   Display -3                              -- turn off display updates and error messages

   Do Forever

      -- This would only happen on the 2nd go-around (or 3rd...) and
      -- would happen because the message being decrypted was conventionally
      -- encrypted and needs a pass phrase, or because the message was
      -- encrypted with a public key.  On the 3rd+ time, it would be
      -- needed because an incorrect pass phrase was entered.

      if needconvpswd then
compile if EVERSION > 6.01
         pgp_convpswd = EntryBox('Enter passphrase for conventional encryption',
                               '/~OK/~Cancel', '', 30, 1024, '', 140)
compile else
         pgp_convpswd = EntryBox('Enter passphrase for conventional encryption',
                               '/~OK/~Cancel', '', 30, 1024)
compile endif
         if pgp_convpswd = '' then
            Display 3                      -- enable display updates and messages
            Return
         endif
      endif

      if needpswd then
         if sec_pswd = '' then
compile if EVERSION > 6.01
            pass = EntryBox('Enter your passphrase', '/OK/Cancel', '',
                            30, 1024, '', 140)
compile else
            pass = EntryBox('Enter your passphrase', '/OK/Cancel', '', 30, 1024)
compile endif
            if pass = '' then
               Display 3                      -- enable display updates and messages
               Return
            endif
            sec_pswd = pass
         endif
      endif

      GetFileID msgFileID                     -- get fileid of current message

      lastline = .last
      Do line = 1 to lastline
         GetLine curline, line
         startcol = Pos('-----BEGIN PGP', curline)
         if startcol > 0 then
            leave
         endif
      End

      if startcol = 0 then
         r = WinMessageBox('Gibbon PGP Front End',
                           'This does not appear to be a PGP ' ||
                           'encrypted or signed message', 16432)
;                                            MB_INFORMATION = 48
;                                            MB_MOVEABLE    = 16384
         Display 3                      -- enable display updates and messages
         Return
      endif

--      SETMARK 1, .last, 1, LongestLine(), 1, msgFileID  -- Mark the whole message
      SETMARK line, .last, startcol, LongestLine(), 2, msgFileID  -- Mark the whole message
      outfile=vTEMP_PATH || 'pgpfe.out'       -- Build the file name for the temp file
      'e' outfile                             -- open it
      CopyMark                                -- copy the marked text to the outfile window
      's'                                     -- save the temporary file
      'q'                                     -- exit the temporary window
      sayerror 'Processing in progress...'

-- conventional decryption
      if needconvpswd then
         cmdline = '-z"'pgp_convpswd'" <' outfile
-- public key decryption
      elseif needpswd then
         cmdline = '-z"'sec_pswd'" <' outfile
-- signature check
      else
         cmdline = ' <' outfile
      endif

-- option -t for textmode files
      r = pgp_redirect('+la=en -t' cmdline)   -- pass commands to routine that does the work
      sayerror 'Processing complete.'
      call erasetemp(outfile)                 -- and delete the temp file
      if r = 'ERROR' then
         ActivateFile msgFileID               -- activate the original file
         Display 3                            -- enable display updates and messages
         return
      endif
      GetFileID tempFileID                    -- get fileid of processed text file

      .filename='/Unencrypted Message/'       -- change the title line
      viewline=""
      GetLine viewline, 2, tempFileID         -- get line 2 (error or 'good sig' message)

/* Here we are looking for success, or errors and warnings
   The types of information we look for are as follows...

  1) good signature:
     'Good signature from user'
  2) Can't check signature cause we don't have the key
     'Key matching expected Key ID'
  3) encrypted so passphrase needed
     'You need a pass phrase to unlock your RSA secret key.'
  4) bad pass phrase
     'Error:  Bad pass phrase." then
  5) missing secret key to decrypt
     ' You do not have the secret key'
  6) bad signature:
     'Bad signature from user '
  7) damaged file:
     'Error: Transport armor stripping failed'
  8) Unknown error decrypting file:
     'Error:'
*/

-- handle case of good signature
      if LeftStr(viewline,24) = 'Good signature from user' then
         message = viewline
         GetLine viewline, 3, tempFileID
         message = message || \10viewline
         if arg(1) = 'c' then                 -- if we're only checking the sig
            'q'                               -- leave the file
            ActivateFile msgFileID            -- activate the original file
         endif
         if arg(1) <> 'c' then                -- if we're not only checking the sig
            Do line = 1 to 3
               DeleteLine 1, tempFileID
            End
            tempFileID.modify = 0             -- reset the modified flag
         endif
         Display 3                            -- enable display updates and messages
         refresh
         r = WinMessageBox('Gibbon PGP Front End', message, 16432)
;                                            MB_INFORMATION = 48
;                                            MB_MOVEABLE    = 16384
         Return

-- handle case of not having key to check for valid signature
      elseif LeftStr(viewline, 29) = 'Key matching expected Key ID' then
         message = RightStr(viewline, Length(viewline) - 1)
         GetLine viewline, 6, tempFileID
         Do line = 1 to 6
            DeleteLine 1, tempFileID
         End
         tempFileID.Modify = 0                -- reset the modified flag
         message = message || \10\10viewline
         if arg(1) = 'c' then                 -- if we're only checking the sig
            'q'                               -- leave the file
            ActivateFile msgFileID            -- activate the original file
         endif
         r = WinMessageBox('Gibbon PGP Front End', message, 16416)
;                                            MB_CUAWARNING = 32
;                                            MB_MOVEABLE   = 16384
         Display 3                            -- enable display updates and messages
         Return

-- handle case of needing a passphrase to continue
-- (this will be the case for any encrypted file)
      elseif LeftStr(viewline,22) = 'You need a pass phrase' then
         'q'                                  -- leave the file
         ActivateFile msgFileID               -- activate the original file
         if needconvpswd then
            message = 'Apparently, the pass phrase you entered ' ||
                      'didn''t work.'
         else
            message = 'This is a conventionally encrypted file.  ' ||
                      'A pass phrase must be entered to decrypt '  ||
                      'it.'
         endif
         message = message ||
                   \10\10'Enter the pass phrase in the next '   ||
                   'dialog, or press the Cancel button if you ' ||
                   'don''t want to try to decrypt the file.'

         r = WinMessageBox('Gibbon PGP Front End', message, 16416)
;                                           MB_CUAWARNING = 32
;                                           MB_MOVEABLE   = 16384
         needconvpswd = 1

-- handle the case of a bad pass phrase
      elseif LeftStr(viewline,25) = "Error:  Bad pass phrase." then
         'q'                                  -- leave the file
         ActivateFile msgFileID               -- activate the original file
         if needpswd then
            message = 'Apparently, the pass phrase you entered didn''t work.' ||
                      \10\10'Enter the pass phrase in the next '   ||
                      'dialog, or press the Cancel button if you ' ||
                      'don''t want to try to decrypt the file.'

            r = WinMessageBox('Gibbon PGP Front End', message, 16416)
;                                              MB_CUAWARNING = 32
;                                              MB_MOVEABLE   = 16384
            sec_pswd = ''
         endif
         needpswd = 1

-- handle case of not having the necessary secret key to decrypt
      elseif LeftStr(viewline,33) = 'This message can only be read by:' then
         GetLine vl2, 3, tempFileID
         message = viewline || vl2
         GetLine vl2, 5, tempFileID
         message = message || \10\10 || vl2
         'q'                                  -- leave the file
         ActivateFile msgFileID               -- activate the original file
         Display 3                            -- enable display updates and messages
         refresh
         r = WinMessageBox('Gibbon PGP Front End', message, 16432)
;                                               MB_INFORMATION = 48
;                                               MB_MOVEABLE    = 16384
         Return

-- handle case of bad signature
      elseif LeftStr(viewline,23) = 'Bad signature from user' then
         message = 'WARNING: ' || viewline
         GetLine viewline, 3, tempFileID      -- get line 3 ("signature made" message)
         message = message || \10viewline
         if arg(1) = 'c' then                 -- if we're only checking the sig
            'q'                               -- leave the file
            ActivateFile msgFileID            -- activate the original file
         endif
         Display 3                            -- enable display updates and messages
         refresh
         r = WinMessageBox('Gibbon PGP Front End', message, 16432)
;                                               MB_INFORMATION = 48
;                                               MB_MOVEABLE    = 16384
         Return

-- handle case of damaged file
      elseif LeftStr(viewline,40) = 'Error: Transport armor stripping failed' then
         message = 'ERROR: file has been damaged or tampered with and PGP could not continue.'
         'q'                                  -- leave the file
         ActivateFile msgFileID               -- activate the original file
         Display 3                            -- enable display updates and messages
         refresh
         r = WinMessageBox('Gibbon PGP Front End', message, 16432)
;                                               MB_INFORMATION = 48
;                                               MB_MOVEABLE    = 16384
         Return

-- handle case of unknown error
      elseif LeftStr(viewline,7) = 'Error:' or LeftStr(viewline,6) = 'Error:' then
         message = 'ERROR: an unexpected error has occurred:'
         viewline = RightStr(viewline,Length(viewline) - 1)
         message = message || \10 || viewline
         'q'                               -- leave the file
         ActivateFile msgFileID            -- activate the original file
         Display 3                            -- enable display updates and messages
         refresh
         r = WinMessageBox('Gibbon PGP Front End', message, 16432)
;                                               MB_INFORMATION = 48
;                                               MB_MOVEABLE    = 16384
         Return

-- Normally we exit this way after decrypting a file
-- that has not been signed, but we need to trap the
-- case where we only wanted to check the signature
-- and the file turns out to be unsigned.
      else
         if arg(1) = 'c' then                 -- if we're only checking the sig
            'q'                               -- leave the file
            ActivateFile msgFileID            -- activate the original file
            message = 'WARNING: File has not been signed, could not verify ' ||
                      'signature'
            Display 3                         -- enable display updates and messages
            refresh
            r = WinMessageBox('Gibbon PGP Front End', message, 16432)
;                                               MB_INFORMATION = 48
;                                               MB_MOVEABLE    = 16384
         endif

         Display 3                            -- enable display updates and messages
         Return
      endif

   EndDo
   Display 3                                  -- enable display updates and messages


/****************************
  Add key to public Keyring
****************************/
defc PGPAddKey=
   universal vTEMP_PATH
   universal pgp_pubring, pgp_secring,
             pgp_curpubring
   universal pgp_armor, pgp_textmode,
             pgp_clearsig
   universal sec_name, sec_pswd
   universal pgp_cmd, pgp_opts

   if pgp_checkrings() = 0 then
      return
   endif

   switch = '-k'arg(1)
   GetFileID msgFileID                     -- get fileid of current message

   Display -3                              -- turn off display updates and error messages

   if arg(1) = 'a' then
      lastline = .last
      startkey = 0
      endkey   = 0
      Do line = 1 to lastline
         GetLine curline, line
         if curline = '-----BEGIN PGP PUBLIC KEY BLOCK-----' then
            startkey = line
         elseif curline = '-----END PGP PUBLIC KEY BLOCK-----' then
            endkey = line
         endif
      End

      if startkey = 0 or endkey = 0 then
         message = 'I couldn''t find a public key ' ||
                   'block anywhere in this message!'
         r = WinMessageBox('Gibbon PGP Front End', message, 16416)
;                                           MB_CUAWARNING = 32
;                                           MB_MOVEABLE   = 16384
         Display 3                            -- enable display updates and messages
         return
      else
         message = 'WARNING: All new keys and signatures will ' ||
                   'be added to your public key ring WITHOUT '  ||
                   'asking if you want to add each key.'\10\10  ||
                   'ALSO, any *existing* bad or malformed '     ||
                   'signatures will be DELETED!'
         r = WinMessageBox('Gibbon PGP Front End', message, 16416)
;                                           MB_CUAWARNING = 32
;                                           MB_MOVEABLE   = 16384
         message = 'Keys and signatures will be added to ' ||
                   pgp_curpubring \10\10'Do you want to continue?'
         r = WinMessageBox('Gibbon PGP Front End', message, 16404)
;                                           MB_YESNO        = 4
;                                           MB_ICONQUESTION = 16
;                                           MB_MOVEABLE     = 16384
         if r = 7 then   -- MBID_NO is 7
            Display 3                            -- enable display updates and messages
            return
         endif

;         SETMARK startkey, endkey, 1, 65, 2, msgFileID  -- Mark the key block
         SETMARK startkey, endkey, 1, 65, 1, msgFileID  -- Mark the key block
         outfile=vTEMP_PATH || 'pgpfe.out'    -- Build the file name for the temp file
         'e' outfile                             -- open it
         CopyMark                                -- copy the key block to the outfile window
         's'                                     -- save the temporary file
         'q'                                     -- exit the temporary window

         cmdline = switch pgp_curpubring '<' outfile
         r = pgp_redirect(pgp_opts cmdline)
         call erasetemp(outfile)                 -- and delete the temp file
         if r = 'ERROR' then
            ActivateFile msgFileID               -- activate the original file
            Display 3                            -- enable display updates and messages
            return
         endif

         GetFileID tempFileID                    -- get fileid of results file
         ActivateFile msgFileID                  -- activate the original file
         UnMark

         ActivateFile tempFileID                 -- activate the temporary file
         .filename = '/Results of Key Add (-ka) Processing/'
         GetLine curline, 3
         If curline = 'No new keys or signatures in keyfile.' then
            'q'                                  -- quit the file
            ActivateFile msgFileID               -- activate the original file
            r = WinMessageBox('Gibbon PGP Front End', curline, 16416)
;                                              MB_CUAWARNING = 32
;                                              MB_MOVEABLE   = 16384
            Display 3                            -- enable display updates and messages
            return
         endif

         GetLine curline, 1
         if LeftStr(curline,6) = 'ERROR:' then
            message = 'PGP Detected an error while attempting ' ||
                      'to add this key to' pgp_curpubring'.'\10 ||
                      \10'The error message is:'\10\10          ||
                      RightStr(curline, Length(curline) - 7)
            'q'                                  -- quit the file
            ActivateFile msgFileID               -- activate the original file
            r = WinMessageBox('Gibbon PGP Front End', message, 16416)
;                                              MB_CUAWARNING = 32
;                                              MB_MOVEABLE   = 16384
            Display 3                            -- enable display updates and messages
            return
         endif


      endif

   Endif

   Display 3                            -- enable display updates and messages


/**************************
  Key Management Commands
**************************/
defc PGPKMgt=
   universal vTEMP_PATH
   universal pgp_pubring, pgp_secring,
             pgp_curpubring
   universal pgp_armor, pgp_textmode,
             pgp_clearsig
   universal sec_name, sec_pswd, pub_keyid, pub_name

   arg1 = Word(arg(1),1)
   arg2 = Word(arg(1),2)

   if arg2 <> 'g' then
      if pgp_checkrings() = 0 then
         return
      endif
   endif

   switch = '-k'arg2

   if arg1 = 'p' then                      -- Public key ring management commands
      pgp_get_pub_id(0)
      if pub_keyid = '' then
         return
      endif

      if arg2 = 'e' then
         message = 'Edit Trust Parameters for'
      elseif arg2 = 'r' then
         message = 'Remove the key for'
      elseif arg2 = 's' then
         message = 'Sign and Certify the key for'
      elseif arg2 = 'rs' then
         message = 'Remove a signature from'
      elseif arg2 = 'd' then
         message = 'Disable or Enable the key for'
      endif

      message = 'You are about to' message pub_name ||
                ' on your public keyring:' pgp_curpubring

   else

      if arg2 = 'g' then
         message = 'Generate a new public/secret key pair.'
      elseif arg2 = 'e' then
         message = 'Edit your userid or passphrase.'
      elseif arg2 = 'd' then
         message = 'REVOKE YOUR KEY and ISSUE A KEY COMPROMISE CERTIFICATE.'
      endif

      message = 'You are about to' message

   endif

   message = message || \10\10'This action will DIRECTLY affect your keyring!' ||
                        \10\10'Are you SURE you want to continue?'

   r = WinMessageBox('Gibbon PGP Front End', message, 16404)
;                                     MB_YESNO        = 4
;                                     MB_ICONQUESTION = 16
;                                     MB_MOVEABLE     = 16384

   if r = 7 then   -- MBID_NO is 7
      return
   endif

   if arg1 = 's' then
      sec_name = ''
      sec_pswd = ''
   endif

   if arg2 <> 'g' then
      pgp_get_sec_id()
   endif

   cmd = switch

   if arg1 = 'p' then
      cmd = cmd pub_keyid '-u "' || sec_name || '"' pgp_curpubring
   else
      if arg2 = 'e' then
         cmd = cmd '"'sec_name'"' pgp_secring
      elseif arg2 = 'd' then
         cmd = cmd '"'sec_name'"'
      endif
   endif

   'OS2 /C PGP' cmd

/*

MB_OK                =        0  -- Pick one of the following for the
MB_OKCANCEL          =        1  -- buttons you want on the message box
MB_RETRYCANCEL       =        2
MB_ABORTRETRYIGNORE  =        3
MB_YESNO             =        4
MB_YESNOCANCEL       =        5
MB_CANCEL            =        6
MB_ENTER             =        7
MB_ENTERCANCEL       =        8

MB_NOICON            =        0  -- Add one of the following for the
MB_CUANOTIFICATION   =        0  -- icon you want in the message box
MB_ICONQUESTION      =       16
MB_ICONEXCLAMATION   =       32
MB_CUAWARNING        =       32
MB_ICONASTERISK      =       48
MB_ICONHAND          =       64
MB_CUACRITICAL       =       64
MB_QUERY             =     MB_ICONQUESTION
MB_WARNING           =     MB_CUAWARNING
MB_INFORMATION       =     MB_ICONASTERISK
MB_CRITICAL          =     MB_CUACRITICAL
MB_ERROR             =     MB_CRITICAL

MB_DEFBUTTON1        =          0  -- This specifies which button is the
MB_DEFBUTTON2        =        256  -- default if Enter is pressed.
MB_DEFBUTTON3        =        512

MB_APPLMODAL         =       0000  -- Application modal
MB_SYSTEMMODAL       =       4096  -- System modal
MB_HELP              =       8192
MB_MOVEABLE          =      16384  -- The message box can be moved.

MBID_OK              =     1  -- Message box return codes
MBID_CANCEL          =     2  -- (correspond with the button pressed)
MBID_ABORT           =     3
MBID_RETRY           =     4
MBID_IGNORE          =     5
MBID_YES             =     6
MBID_NO              =     7
MBID_HELP            =     8
MBID_ENTER           =     9
MBID_ERROR           =     65535

*/


/****************************************
  get_sec_id gets the secret key to use
*****************************************/
defproc pgp_get_sec_id()
   universal vTEMP_PATH
   universal pgp_pubring, pgp_secring
   universal sec_name, sec_keyid, sec_pswd

   if pgp_checkrings() = 0 then
      return
   endif

   one = atoi(1)
   zero = atoi(0)

;   Display -3                              -- turn off display updates and error messages
   GetFileID msgFileID                     -- get fileid of current message
   r = pgp_redirect('-kv *' pgp_secring)  -- pass commands to routine the does the work
   if r = 'ERROR' then
;      Display 3                            -- enable display updates and messages
      return
   endif
   GetFileID tempFileID

   uidlist = ''
   lastline = .last
   numhits = 0

   Do line = 1 to lastline
      GetLine viewline, line, tempFileID
      if Word(viewline,1) = 'sec' then
         numhits = numhits + 1
         parse value viewline with . temp1 . temp2
         -- strip off key length from keyid  (eg. 1024/18CC6311)
         temp1 = '0x' || SubStr(temp1, Pos('/',temp1)+1)
         uidlist = uidlist || '^' || temp1' 'temp2
      endif
   End

   ActivateFile tempFileID                 -- activate the temporary file
   'q'                                     -- quit the file
   ActivateFile msgFileID                  -- activate the original file

/* no secret keys were found so punt */
   if numhits = 0 then
      r = WinMessageBox('Gibbon PGP Front End',
                        'I could not find any secret keys in' pgp_secring'!', 16416)
;                                                        MB_CUAWARNING = 32
;                                                        MB_MOVEABLE   = 16384
      sec_name = ''
      sec_keyid = ''
;      Display 3                            -- enable display updates and messages
      return ''
   endif

/* If only 1 secret key is found, don't display the list */
   if numhits = 1 then
      if temp1 <> sec_keyid then
         sec_pswd = ''
      endif
      sec_keyid = temp1
      sec_name = temp2
      return ''
   endif

/* otherwise, display secret keys for selection */
   parse value listbox('Gibbon PGP Key Selection',
                        uidlist,
                       '/~OK/~Cancel',
                       0, 0, 4, 60,
                       compile if EVERSION >= 5.60 --gethwndc(APP_HANDLE)
                          zero || zero || one || one || zero ||
                       compile else                --gethwndc(APP_HANDLE)
                          one || one || zero || zero || zero ||
                       compile endif
                       'Select which secret key you want to use') with button 2 text \0
   btn = itoa(button || \0, 10)
   if btn = '2' then
      sec_keyid = ''
      sec_name = ''
      return ''
   endif
   parse value text with sec_keyid sec_name
;   Display 3                               -- enable display updates and messages



/*****************************************
  get_pub_id gets the public key(s) to use
******************************************/
defproc pgp_get_pub_id(mult)
   universal vTEMP_PATH
   universal pgp_pubring, pgp_secring
   universal pub_keyid, pub_name

   if pgp_checkrings() = 0 then
      return ''
   endif

   one = atoi(1)
   zero = atoi(0)

   uid = ''
   pub_keyid = ''
   pub_name = ''

   lastline = .last
   if lastline > 30 then
      lastline = 30
   endif
   hival = 0

/*
   search the message file for email headers To:,  Reply-To:,  or From:
   and snag email address if found.  Note that if more than one of the
   above headers is found, priority is to use 'To:', then  'Reply-To:',
   and then finally 'From:'.  This is controlled by hival.
*/
   do line = 1 to lastline
      GetLine viewline, line
      test = Word(viewline,1)
      if test <> 'Reply-To:' and test <> 'From:' and test <> 'To:' then
         iterate
      endif

/* From: is the lowest priority */
      if test = 'From:' then
         if hival > 1 then
            iterate
         else
            hival = 1
         endif
      endif
/* Reply-To: is next lowest priority */
      if test = 'Reply-To:' then
         if hival > 2 then
            iterate
         else
            hival = 2
         endif
      endif
/* To: is highest priority */
      if test = 'To:' then
         hival = 3
      endif

/* if we get here, then we found a header and need to extract address  */
      found = 0
      do numword = 2 to Words(viewline)
         if Pos('@',Word(viewline,numword)) > 1 then
            uid = Word(viewline,numword)
            found = 1
            leave
         endif
      enddo

/* if we can't find internet style address, then use first word after keyword */
      if found = 0 then
         uid = Word(viewline,2)
      endif

/* strip off '<' or '(' from email address */
      if LeftStr(uid,1) = '<' or LeftStr(uid,1) = '(' then
         uid = RightStr(uid, Length(uid) - 1)
      endif
      if RightStr(uid,1) = '>' or RightStr(uid,1) = ')' then
         uid = LeftStr(uid, Length(uid) - 1)
      endif

   enddo /* end search for email headers */

/* uid contains the email address from header search, if any  */
   if uid = '' then
      uid = '*'
   endif

/* if mult set, then multiple public keys can be selected simultaneously */
   if mult then
      entrytitle = 'Enter public key user id, "*" for a list, or "+" for multiple users'
   else
      entrytitle = 'Enter public key user id or "*" for a list'
   endif
   mask = EntryBox(entrytitle, '/~OK/~Cancel', uid, 5, 72)

/* punt if nothing selected */
   if mask = '' then
      Return ''
   endif

/* trap attempt to mult when mult=0 */
   if mask = '+' and mult = 0 then
      mask = '*'
   endif

   if mask = '+' then
      mask = '*'
      doingmult = 1
   else
      doingmult = 0
   endif

;   Display -3                              -- turn off display updates and error messages
   GetFileID msgFileID                     -- get fileid of current message
/* search public keyring */
   r = pgp_redirect('-kv "'mask'"' pgp_pubring)  -- pass commands to routine the does the work
   if r = 'ERROR' then
;      Display 3                            -- enable display updates and messages
      return
   endif
   GetFileID tempFileID

   lastline = .last
   numhits = 0

/* we build a list of public keys found saving only the user name and keyid */
   listfile=vTEMP_PATH || 'Listbuf.out'    -- Build the file name for the list file
   'e' listfile                            -- open it
   GetFileID ListFileID                    -- Get its fileid
   ActivateFile tempFileID                 -- activate the temporary file

/* search the raw data for pub keys, and parse out key id and user name */
   Do line = 1 to lastline
      GetLine viewline, line
      if Word(viewline,1) = 'pub' then
         numhits = numhits + 1
         parse value viewline with . temp1 . temp2
         /* strip off key length from keyid  (eg. 1024/18CC6311) */
         temp1 = '0x' || SubStr(temp1, Pos('/',temp1)+1)
         temp = \255 || temp1' 'temp2
         Insertline temp, ListFileID.last, ListFileID -- Add it to the list
      endif
   End

   ListFileID.Modify = 0                   -- reset the modified flag for quit

   ActivateFile tempFileID                 -- activate the temporary file
   'q'                                     -- quit the file
   ActivateFile msgFileID                  -- activate the original file

/* here only one pub key was found so go ahead and use it */
   if numhits = 1 then
      getline pub_key, 1, ListFileID
      parse value pub_key with pub_keyid pub_name
      /* strip off \255 character on left side */
      pub_keyid = RightStr(pub_keyid, Length(pub_keyid) - 1)
      ActivateFile ListFileID              -- activate the list file
      'q'                                  -- quit the file
      ActivateFile msgFileID               -- activate the original file
;      Display 3                            -- enable display updates and messages
      return
   endif

/* no matching public keys were found so punt */
   if numhits = 0 then
      r = WinMessageBox('Gibbon PGP Front End',
                        'I could not find any keys matching 'mask' in 'pgp_pubring'!', 16416)
;                                                        MB_CUAWARNING = 32
;                                                        MB_MOVEABLE   = 16384
      ActivateFile ListFileID              -- activate the list file
      'q'                                  -- quit the file
      ActivateFile msgFileID               -- activate the original file
;      Display 3                            -- enable display updates and messages
      return ''
   endif

/* here more than one pub key was found so need user to select from list box */

   Deleteline ListFileID.last, ListFileID  -- Delete blank line at the end

   if doingmult then
      buttons = '/~OK/~Cancel/~Add to List'
   else
      buttons = '/~OK/~Cancel'
   endif

   temp_keyid = ''
   temp_name = ''

   Do Forever
      ActivateFile ListFileID              -- activate the list file
      ListHndl = Buffer(CREATEBUF, 'ListBuffer', MAXBUFSIZE, 1)
      if ListHndl = 0 then
          sayerror 'ERROR: could not create buffer'
          return ''
      endif
      noflines = buffer(PUTBUF, ListHndl, 1, 0, APPENDCR)
--      noflines = Buffer(PUTBUF, ListHndl, 1, .last)
      bufsize = Buffer(USEDSIZEBUF, ListHndl) -- get the size of the buffer
      ListFileID.Modify = 0                -- reset the modified flag for quit
      parse value listbox('Gibbon PGP Key Selection',
                  compile if EPM32  -- Or, if not including STDCONST, "if EVERSION >= 6"
                           \0 || atol(bufsize) || atoi(32) || atoi(ListHndl),
                  compile else
                           \0 || atoi(bufsize) || atoi(ListHndl) || atoi(32),
                  compile endif
                           buttons,
                           0, 0, 10, 72,
                  compile if EVERSION >= 5.60 --gethwndc(APP_HANDLE)
                           zero || zero || one || one || zero ||
                  compile else                --gethwndc(APP_HANDLE)
                           one || one || zero || zero || zero ||
                  compile endif
                           'Select a public key') with button 2 pub_key \0

      Call Buffer(FREEBUF, ListHndl)       -- Free the buffer
      btn = itoa(button || \0, 10)

/* cancel button pressed */
      if btn = '2' or pub_key = '' then
         ActivateFile ListFileID           -- activate the list file
         'q'                               -- quit the file
         ActivateFile msgFileID            -- activate the original file
         pub_keyid = ''
         pub_name = ''
;         Display 3                         -- enable display updates and messages
         return
      endif

/* strip off funny note symbol at end of pub_key and parse */
      if Length(pub_key) > 1 then
         pub_key = LeftStr(pub_key, Length(pub_key) - 1)
         parse value pub_key with pub_keyid pub_name
      endif

/* OK button pressed */
      if btn = '1' then
         if doingmult then
            pub_keyid = temp_keyid
            pub_name = temp_name
            if pub_keyid = '' then
               message = 'You selected "OK" but haven''t added ' ||
                         'any public keys yet!  Either use the '  ||
                         '"Cancel" or "Add to List" buttons.'
               r = WinMessageBox('Gibbon PGP Front End', message, 16432)
;                                                MB_INFORMATION = 48
;                                                MB_MOVEABLE    = 16384
               iterate
            endif
         endif
         ActivateFile ListFileID           -- activate the list file
         'q'                               -- quit the file
         ActivateFile msgFileID            -- activate the original file
;         Display 3                         -- enable display updates and messages
         return
      endif

/*
   Add-to-List button pressed  (for multiple keys only)
         Note: we need to trap the case where the same user is selected
         twice by checking for pub_keyid = *
*/
      if btn = '3' and pub_keyid <> '*' then
         if temp_name = '' then
            temp_name = pub_name
            temp_keyid = pub_keyid
         else
            temp_name = temp_name' and 'pub_name
            temp_keyid = temp_keyid' 'pub_keyid
         endif
         ActivateFile ListFileID           -- activate the list file
         for curline = 1 to .last
            getline chgline, curline
            if Length(chgline) > 1 then
               chgline = RightStr(chgline, Length(chgline) - 1)
            endif
            if chgline = pub_key then
               chgline = \255 || '* ' || chgline
               replaceline chgline, curline
            endif
         endfor
         ActivateFile msgFileID            -- activate the original file
      endif

   EndDo
;   Display 3                               -- enable display updates and messages



/***************************************************
  pgp_checkrings makes sure the keyrings are there
***************************************************/
defproc pgp_checkrings()
   universal vTEMP_PATH
   universal pgp_curpubring, pgp_pubring, pgp_secring
   universal pgp_path, pgp_found, pgp_config
   universal pgp_randseed, pgp_cmd

   if pgp_path = '' then
      r = WinMessageBox('Gibbon PGP Front End',
                        'Your PGPPATH environment variable has not been set!', 16416)
;                                                        MB_CUAWARNING = 32
;                                                        MB_MOVEABLE   = 16384
      Return 0
    endif

   if pgp_config = '' then                        -- Has the config file been read yet?
      v_PATH = Get_Env('TEMP')
      if v_PATH = '' then
         v_PATH = Get_Env('TMP')
      endif
      if v_PATH <> '' then
         vTEMP_PATH = v_PATH
      endif

      pgp_config = pgp_path'\config.txt'          -- No - set the path
      if not Exist(pgp_config) then
         pgp_config = pgp_path'\pgp.ini'
         if not Exist(pgp_config) then
            pgp_config = pgp_path'\.pgprc'
         endif
      endif
      if Exist(pgp_config) then                   -- Read it only if it exists
         GetFileID msgFileID                      -- get fileid of current message
         'e' pgp_config                           -- Edit it
         Do line = 1 to .last
            GetLine viewline, line                -- Get a line
            if LeftStr(viewline,1) = '#' then     -- Check for comments
               iterate
            endif
            if Words(viewline) < 1 then           -- Check for blank lines
               iterate
            endif
            Parse Value viewline with keyword '=' text '#' .
            Do Forever
               test = LeftStr(text,1)
               if test = ' ' or test = '"' or test = "'" then
                  text = RightStr(text, Length(text) - 1)
               else
                  leave
               endif
            EndDo
            Do Forever
               test = RightStr(text,1)
               if test = ' ' or test = '"' or test = "'" then
                  text = LeftStr(text, Length(text) - 1)
               else
                  leave
               endif
            EndDo
            keyword = UpCase(keyword)
            if keyword = 'MYNAME' then
               sec_name = Strip(text)
            elseif keyword = 'TMP' then
               vTEMP_PATH = Strip(text)
            elseif keyword = 'PUBRING' then
               pgp_pubring = Strip(text)
               pgp_curpubring = Strip(text)
            elseif keyword = 'SECRING' then
               pgp_secring = Strip(text)
            elseif keyword = 'RANDSEED' then
               pgp_randseed = Strip(text)
            endif

         EndDo
         'q'
         ActivateFile msgFileID                   -- activate the original file
      endif

      if RightStr(vTEMP_PATH,1) <> '\' and RightStr(vTEMP_PATH,1) <> ':' then
         vTEMP_PATH = vTEMP_PATH || '\'
      Endif

/* make sure we can find pgp.exe, if not in path then make pgp_cmd fully qualified
   pgp_found = -1 -> PGP.EXE is not an OS/2 executable
   pgp_found = 0  -> cannot find pgp in PATH or pgp_path
   pgp_found = 1  -> pgp is in PATH
   pgp_found = 2  -> pgp is in pgp_path but not PATH
*/
      findfile cmdline, 'PGP', 'PATH', 'P'
      If cmdline = '' then
         pgp_cmd = pgp_path || '\' || pgp_cmd
         findfile cmdline, pgp_path || '\PGP', '', 'P'
         If cmdline = '' then
            pgp_found = 0
         else
            pgp_found = 2
         endif
      endif

compile if EVERSION >= 5.60
      if pgp_found = 1 then
         'e' cmdline
         lth = 0
         Do line = 1 to .last
            GetLine viewline, line                -- Get a line
            if (Pos("LX", viewline) > 0) then
               leave
            endif
            lth = lth + Length(viewline)
            if (lth > 300) then
               pgp_found = -1
               leave
            endif
         EndDo
         'q'
         if pgp_found = 0 then
            Return 0
         endif
      endif
compile endif

   endif

   if pgp_found = -1 then
   	r = WinMessageBox('Gibbon PGP Front End',
                          'Unable to run PGP.EXE because the program ' ||
                          'found is not an OS/2 executable.' , 16416)
;                                              MB_CUAWARNING = 32
;                                              MB_MOVEABLE   = 16384
      Return 0
   endif

   if pgp_found = 0 then
      r = WinMessageBox('Gibbon PGP Front End',
                        'Unable to run PGP.EXE because it could not ' ||
                        'be found in either the PATH or in PGPPATH!'  ||
                         \10\10 || 'Make sure the directory that '    ||
                        'contains PGP is in your PATH.'    , 16416)
;                                                        MB_CUAWARNING = 32
;                                                        MB_MOVEABLE   = 16384
      Return 0
   endif

compile if EVERSION < 5.60
   if pgp_found > 1 and pgp_found < 4 then
      message = 'PGP.EXE was not in the path, but was found in' pgp_path'.' ||
                \10\10 || 'Make sure the directory that contains PGP is in your PATH.'
      r = WinMessageBox('Gibbon PGP Front End', message, 16416)
;                                                     MB_CUAWARNING = 32
;                                                     MB_MOVEABLE   = 16384
      pgp_found = pgp_found + 1
   endif
compile endif

   ranseedok = Exist(pgp_randseed)
   pubringok = Exist(pgp_pubring)
   curpubok  = Exist(pgp_curpubring)
   secringok = Exist(pgp_secring)

   if pubringok = 0 then
      message = 'Could not find PUBRING.PGP!'
   endif
   if curpubok = 0 then
      if pubringok then
         message = 'Could not find public key ring' pgp_curpubring'!'
      else
         message = message || \10'Or public key ring' pgp_curpubring'!'
      endif
   endif
   if secringok = 0 then
      if pubringok + curpubok = 2 then
         message = 'Could not find your secret key ring!'
      else
         message = message || \10 || 'Or your secret key ring, either!'
      endif
   endif
   if ranseedok = 0 then
      if pubringok + curpubok + secringok = 3 then
         message = 'Could not find RANDSEED.BIN!'
      else
         message = message || \10 || 'Or RANDSEED.BIN, either!'
      endif
   endif

   if (pubringok + curpubok + secringok + ranseedok) < 4 then
      r = WinMessageBox('Gibbon PGP Front End', message, 16416)
;                                                        MB_CUAWARNING = 32
;                                                        MB_MOVEABLE   = 16384
      Return 0
   endif

   Return 1


/*********************************************************************
  redirect invokes PGP and redirects the output to a temproary file.
  It then loads the file into an edit window, and deletes the file.
*********************************************************************/
defproc pgp_redirect(cmdline)
   universal vTEMP_PATH                             -- Path for temporary file - Predefined
   universal pgp_armor, pgp_textmode,
             pgp_clearsig
   universal pgp_cmd, pgp_opts

   outfile=vTEMP_PATH || 'pgpfe.tmp'                -- Build the file name for the temp file

   -- The output is redirected to pgpfe.tmp so it can be picked up

   lth = Length(pgp_cmd) + Length(cmdline) + Length(outfile) + 11
compile if EVERSION >= 5.60
   if lth > 1590 then
      message = 'Unable to complete the requested action.  ' ||
                'The command line length (' || lth || ') '   ||
                'exceeds the limit of 1590 characters.'
compile else
   if lth > 248 then
      message = 'Unable to complete the requested action.  ' ||
                'The command line length (' || lth || ') '   ||
                'exceeds the limit of 248 characters.'
compile endif
      r = WinMessageBox('Gibbon PGP Front End', message, 16448)
;                                         MB_CUACRITICAL = 64
;                                         MB_MOVEABLE    = 16384
      return 'ERROR'
   endif
   cmd = pgp_cmd '-f' cmdline '>'outfile '2>&1'
   quietshell cmd

   if RC = sayerror('Insufficient memory') or
      RC = sayerror('File Not found') then stop; endif
   'e' outfile                                      -- bring up the output
--   'MONOFONT'                                       -- set font to monospaced
   call erasetemp(outfile)                          -- and delete the temp file
