@echo off

REM Batch file to correct sporadic problems with TE/2 Classic install
REM not extracting files from one of the installation archives.
REM
REM Run this file with these parameters:
REM
REM    INSTFIX PathToInstallFiles PathToTE2Directory
REM

if "%2" == "" goto usage
if "%1" == "" goto usage

if not exist %1\TE2INST.000 goto notFound1
if not exist %1\TE2INST.002 goto notFound1
echo on
copy /b %1\TE2INST.000+%1\TE2INST.002 %2\iWork.Exe
@echo off
if not exist %2\iWork.Exe goto notFound2
echo on
%2\iWork %2 /o
del %2\iWork.exe
@echo off
goto TheEnd

:notFound1
echo INSTFIX cannot locate one of the files %1\TE2INST.000 or %1\TE2INST.002
echo Make sure that the first parameter specifies the directory containing
echo your TE/2 installation files.
echo.
echo.
goto usage

:notFound2
echo INSTFIX was not able to create a file in the %2 directory.
echo Make sure that the second parameter refers to your installed TE/2
echo directory.
echo.
echo.
goto usage

:usage
echo Usage: INSTFIX PathToInstallFiles PathToTE2Directory
echo.
echo Example (source files on a floppy in drive A):
echo.
echo        INSTFIX A: C:\TE2
echo.
echo.
echo Example (source file in a temp directory on HD):
echo.
echo        INSTFIX D:\TEMP C:\TE2
echo.

:TheEnd
