/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.util;

import com.borland.jbcl.util.ImageLoader;
import java.awt.Component;
import java.awt.Image;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

class ImageCache
implements Serializable {
    private transient Hashtable map = new Hashtable();
    private transient Vector list = new Vector();
    int limit;

    ImageCache() {
        this(10);
    }

    ImageCache(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.limit = n;
    }

    void setLimit(int n) {
        int n2;
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        while ((n2 = this.list.size()) > n) {
            Object e = this.list.elementAt(n2 - 1);
            this.list.removeElementAt(n2 - 1);
            this.map.remove(e);
        }
        this.limit = n;
    }

    int getLimit() {
        return this.limit;
    }

    void put(Object object, Image image, Component component) {
        if (this.limit > 0 && this.list.size() >= this.limit) {
            Object e = this.list.elementAt(this.list.size() - 1);
            this.list.removeElementAt(this.list.size() - 1);
            if (e != null) {
                Image image2 = (Image)this.map.get(e);
                ImageLoader.waitForImage(component, image2);
            }
            this.map.remove(e);
        }
        this.map.put(object, image);
        this.list.insertElementAt(object, 0);
    }

    Image get(Object object) {
        Image image = (Image)this.map.get(object);
        if (image != null) {
            this.list.removeElement(object);
            this.list.insertElementAt(object, 0);
        }
        return image;
    }
}

