/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.layout.PaneLayout;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.BeanPanel;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;

public class SplitPanel
extends BeanPanel
implements MouseListener,
MouseMotionListener,
Serializable {
    PaneLayout layout = new PaneLayout();
    Canvas paneLayoutDivider = new Canvas();
    Cursor cursor;
    boolean yChanges;
    int xDelta;
    int yDelta;
    Rectangle dividerRect;
    Rectangle dividerBounds;
    boolean isSizing = false;
    boolean mouseOverPanel = false;
    transient Rectangle bounds;
    transient Component[] enabledComponents;
    String textureName;

    public SplitPanel() {
        super(null);
        this.setFocusAware(false);
        this.paneLayoutDivider.setName("SplitPanel.splitter");
        this.add(this.paneLayoutDivider);
        this.paneLayoutDivider.setVisible(false);
        this.paneLayoutDivider.setEnabled(false);
        this.setDividerColor(Color.black);
        this.layout.setGap(2);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        super.setLayout(this.layout);
    }

    public void setGap(int n) {
        this.layout.setGap(n);
    }

    public int getGap() {
        return this.layout.getGap();
    }

    public void setDividerColor(Color color) {
        this.paneLayoutDivider.setBackground(color);
    }

    public Color getDividerColor() {
        return this.paneLayoutDivider.getBackground();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String string) {
        if (string != null && !string.equals("")) {
            Image image = ImageLoader.load(string, (Component)this);
            if (image == null) throw new IllegalArgumentException(string);
            ImageLoader.waitForImage(this, image);
            this.textureName = string;
            this.setTexture(image);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof PaneLayout) {
            this.layout = (PaneLayout)layoutManager;
            super.setLayout(layoutManager);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() != this || !this.mouseOverPanel) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.mouseOverPanel) {
            this.dividerRect = this.layout.getDividerRect(n, n2);
        }
        if (this.dividerRect != null) {
            this.dividerBounds = this.layout.getDividerBounds();
            if (this.dividerRect.width > this.dividerRect.height) {
                this.yChanges = true;
                this.yDelta = n2 - this.dividerRect.y;
            } else {
                this.yChanges = false;
                this.xDelta = n - this.dividerRect.x;
            }
            this.isSizing = true;
            this.bounds = this.getBounds();
            Component[] componentArray = this.getComponents();
            this.enabledComponents = new Component[componentArray.length];
            for (int i = 0; i < componentArray.length; ++i) {
                if (!componentArray[i].isEnabled()) continue;
                this.enabledComponents[i] = componentArray[i];
                componentArray[i].setEnabled(false);
            }
            this.add((Component)this.paneLayoutDivider, 0);
            this.paneLayoutDivider.setBounds(this.dividerRect.x, this.dividerRect.y, this.dividerRect.width, this.dividerRect.height);
            this.paneLayoutDivider.setVisible(true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.paneLayoutDivider.setVisible(false);
        if (this.isSizing) {
            this.isSizing = false;
            for (int i = 0; i < this.enabledComponents.length; ++i) {
                if (this.enabledComponents[i] == null) continue;
                this.enabledComponents[i].setEnabled(true);
            }
            this.setCursor(this.cursor);
        }
        this.validate();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOverPanel = false;
        if (this.cursor != null && !this.isSizing) {
            this.setCursor(this.cursor);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseOverPanel = true;
        if (!this.isSizing) {
            this.cursor = this.getCursor();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.isSizing = false;
        if (mouseEvent.getComponent() != this) {
            return;
        }
        Rectangle rectangle = this.layout.getDividerRect(mouseEvent.getX(), mouseEvent.getY());
        if (rectangle != null) {
            if (rectangle.width > rectangle.height) {
                this.setCursor(Cursor.getPredefinedCursor(8));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(11));
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isSizing) {
            int n = this.dividerRect.x;
            int n2 = this.dividerRect.y;
            int n3 = mouseEvent.getY();
            int n4 = mouseEvent.getX();
            if (n3 <= this.bounds.y || n3 >= this.bounds.y + this.bounds.height) {
                return;
            }
            if (n4 <= this.bounds.x || n4 >= this.bounds.x + this.bounds.width) {
                return;
            }
            if (this.yChanges) {
                n2 = n3 - this.yDelta;
                if (n2 < this.dividerBounds.y) {
                    n2 = this.dividerBounds.y;
                } else if (n2 > this.dividerBounds.height + this.dividerBounds.y - 1) {
                    n2 = this.dividerBounds.height + this.dividerBounds.y - 1;
                }
            } else {
                n = n4 - this.xDelta;
                if (n > this.dividerBounds.width + this.dividerBounds.x - 1) {
                    n = this.dividerBounds.width + this.dividerBounds.x - 1;
                } else if (n < this.dividerBounds.x) {
                    n = this.dividerBounds.x;
                }
            }
            this.layout.dragDivider(n, n2);
            this.dividerRect.x = n;
            this.dividerRect.y = n2;
            this.paneLayoutDivider.setLocation(n, n2);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width == 10) {
            dimension.width = 100;
        }
        if (dimension.height == 10) {
            dimension.height = 100;
        }
        return dimension;
    }
}

