// ----------------------------------------------------------------------------
// cpsms.pro
//
// Consens 2.00 Comparts Lotus Notes to SMS Gateway Profile
//
// (C) Compart Systemhaus GmbH 1997
//
//
// Dieses Profile wird von Consens jeweils zur Laufzeit und zur
// Installation/Deinstallation verwendet und bentigt.
// Die Standardwerte der Konfiguration sollten einen ersten Einsatz
// des Programmes ohne Anpassungen des Profiles ermglichen.
// Die Dokumentation der Parameter erfolgt jeweils hier.
// Vor nderungen bitte Sicherungskopie anfertigen.
//
// Aufbau des Profiles:
//
//     [Allgemeine Werte]
//         {
//         [SERVICE 1 Beschreibung]
//         }
//
//         {
//         [SERVICE n Beschreibung]
//         }
//
// Es knnen bis zu 16 Service-Beschreibungen definiert werden.
//
// Schlsselwrter fr Service-Beschreibung:
//
//     SERVICE.NAME
//        Typ:
//            Text
//
//        Beschreibung:
//            Voller Name des Services im Klartext. Dieser
//            Text ist frei whlbar ubd wird nur fr Konsolenausgaben
//            verwendet.
//
//        Beispiel:
//            SERVICE.NAME=D2 Privat
//
//
//     SERVICE.PROTOCOL
//
//         Typ:
//            Schlsselwort
//
//         Werte:
//            TAP
//            UCP
//
//         Beschreibung:
//            Je nach Betreiber werden die SMSC Einwahlknoten mit unterschiedlichen
//            Protokollen bedient. Consens untersttzt sowohl das
//            sog. TAP als auch das UCP Protokoll.
//            Diese beiden Protokolle sind in Consens speziell auf die momentan
//            in Consens verfgbaren Services (D1/D2/E1/TeLMI) ausgelegt; wenngleich
//            auch andere SMSCs eines der beiden (UCP/TAP) untersttzen mgen,
//            kann nicht davon ausgegangen werden, da Consens diese dann
//            bei geeigneter Konfiguration auch a priori untersttzt;
//            einen Versuch auf eigenes Risiko ist es jedoch sichre Wert;
//            Bestandteil der Consens Produktpflege wird sicher das Validieren
//            weiterer Pager-Services und das evaluieren aller europischen SMSCs
//            sein.
//
//     SERVICE.SERVERNAME
//        Typ:
//            Text
//
//        Beschreibung:
//            Name des Services in der names.nsf des Gateway Servers
//            Unter diesem Namen werden
//            1. bei der Installation Verbindungsdokumente angelegt und
//            2. beim Aufwhlen auf den entsprechenden Service unter diesem
//               Namen verwendet.
//
//        Beispiel:
//            SERVICE.SERVERNAME=D2
//
//
//     SERVICE.SUBDOMAIN
//        Typ:
//            Text
//
//        Beschreibung:
//            Name einer 'virtuellen' Subdomne, deren Name zur Bildung
//            eines Empfngernamens verwendet werden kann (aber nicht mu),
//            um bereits im Empfngernamen diesen Service, mit dem dann versendet
//            werden soll, zu spezifizieren.
//
//        Beispiel:
//            Eine Addresse, die z.B. Felix Findig@D2@SMS lautet, wird, unbesehen
//            von der ggf. ermittelten Telefon/Pager-Nummer immer ber den Service
//            verschickt,der den Eintrag
//
//            SERVICE.SUBDOMAIN=D2
//
//            beinhaltet.
//
//
//     SERVICE.LOGCLASS
//        Typ:
//            Text
//
//        Beschreibung:
//            Freier Text, unter dem der Service in einem Feld Namens 'Class'
//            im Datensatz der Protokolldatenbank eingetragen wird, und somit
//            dann auch in den Ansichten dargestellt wird.
//
//        Beispiel:
//            SERVICE.LOGCLASS=D2
//
//     SERVICE.FROMNUMBER.FORMULA
//        Typ:
//            Notes-Formel
//
//        Beschreibung:
//
//        Beispiel:
//            SERVICE.FROMNUMBER.FORMULA = @if(CellPhoneNumber != ""; CellPhoneNumber; "")
//
//     SERVICE.MESSAGESPERCALL
//        Typ:
//            Ganzzahl
//
//        Beschreibung:
//            Services knnen je Telefon-Anruf nur eine bestimmte Zahl von
//            Messages bertragen. Nach bertragung dieser Anzahl ist ein
//            erneutes Aufwhlen auf den jeweiligen Service ntig;
//            Im Extremfall kann pro Anruf genau eine Message bertragen
//            werden. Die Zahl der Messages pro Aufwahl kann hier
//            angegeben werden. Nachdem diese Anzahl an Nachrichten bermittelt
//            wurde, trennt Consens die Verbindung und baut sie ggf.
//            erneut auf.
//
//        Beispiel:
//            SERVICE.MESSAGESPERCALL=1
//
//
//     SERVICE.LIMITMESSAGELENGTH
//        Typ:
//            Ganzzahl
//
//        Beschreibung:
//            Jeder Service kann nur Messages einer Bestimmten Lnge bertragen.
//            Unter Message ist die Gesamtlnge einer gem Formatierungsangaben
//            von Consens aufgebauter String zu verstehen.
//            Der intern verwendete Vorgabewert ist auf 160 festgelegt. Sie
//            knnen hier die Lnge je Service festlegen.
//            Der Wert 0 setllt einen Spezialfall dar. Bei
//            SERVICE.LIMITMESSAGELENGTH=0 wird die Nachricht nicht (bzw.
//            nur durch sehr grozgige programminterne Grenzwerte) beschrnkt.
//            Das SMSC kann dann jedoch mglicherweise Nachrichten aufgrund
//            von berlnge zurckweisen
//
//        Beispiel:
//            SERVICE.LIMITMESSAGELENGTH=160
//
//     SERVICE.DISABLE
//        Typ:
//            BOOL
//
//        Werte:
//            YES
//            NO
//            JA
//            NEIN
//
//        Beschreibung:
//            Ermglicht das 'stilllegen' eines Services. Das Ausblenden
//            erstreckt sich hierbei auf die Installation, Deinstallation und
//            Laufzeit.
//            Ein stillgelegter Eintrag verhlt sich im wesentlichen so, als
//            ob der enstprechende Block aus dem Profile gelscht worden
//            wre.
//            Der Vorgabewert ist NEIN (d.h. Service ist aktiv)
//
//        Beispiel:
//
//
//     SERVICE.DIALUPNUMBER
//        Typ:
//            Telefonnummer
//
//        Format:
//            +cc(vvvv)nnnnn
//
//             cc      Landesvorwahl
//             vvvv    Ortsvorwahl ohne fhrende 0
//             nnnnnn  Rufnummer ohne Vorwahlen
//
//        Beschreibung:
//            Der Gatway bentzt die hier angegebenen Nummern ausschlielich
//            fr die Installation. Diese Nummern sind externe Einwahlknoten
//            der jeweiligen Netzwerkbetreiber und sollten i.A. nicht gendert
//            werden. Die Lngen von cc/vvvv/nnnnn sind natrlich nicht auf
//            2/4/5 festgelegt.
//
//        Beispiel:
//            SERVICE.DIALUPNUMBER       = +49(166)01010101
//
//
//
//     SERVICE.NUMERICONLY
//         future use only
//
//     SERVICE.ACCNT.TIME.PRE
//        Typ:
//            Ganzzahl
//
//        Beschreibung:
//            Konstanter Wert in Milisekunden, der bei diesem Service
//            vom physikalischen Verbinden des Modems mit dem Gegenmodem
//            bis zur erfolgreichen CONNECT-Verbindung verstreicht.
//            Dieser Wert kann vom Gateway nicht gemessen werden, so da
//            hier fr die Kostenrechnung ein konstanter Wert angegeben werden
//            kann.
//
//
//     SERVICE.ACCNT.TIME.POST
//        Typ:
//            Ganzzahl
//
//        Beschreibung:
//            Konstanter wert, der zur Verbindungszeit nach Verbindungsabbau
//            Dazugerechnet werden soll.
//
//     SERVICE.ACCNT.TIME.PERUNIT
//        Typ:
//            Ganzzahl
//
//        Beschreibung:
//            Dauer einer Gebhreneinheit in Milisekunden
//
//
//     SERVICE.ACCNT.COST.PERUNIT
//        Typ:
//            Ganzzahl
//
//        Beschreibung:
//            Kosten einer Gebhreneinheit in Pfennigen
//
//
//     SERVICE.ACCNT.COST.PERCALL
//        Typ:
//            Ganzzahl
//
//        Beschreibung:
//            Kosten eines Anrufes in Pfennigen
//            Wird bei den hier vorkonfigurierten Services nicht verwendet;
//            diese sind alle zeitabhngig.
//            Sie knnen diese Angabe jedoch fr interne Verrechnungszwecke nutzen.
//
//     SERVICE.ACCNT.COST.PERMSG
//        Typ:
//            Ganzzahl
//
//        Beschreibung:
//            Kosten einer Nachricht in Pfennigen.
//            Wird bei den hier vorkonfigurierten Services nicht verwendet;
//            diese sind alle Zeitabhngig.
//            Sie knnen diese Angabe jedoch fr interne Verrechnungszwecke nutzen.
//
//
//     SERVICE.NUMBER.FORMULA
//        Typ:
//            Notes-Formel
//
//        Beschreibung:
//            Bei der unspezifischen Versendung vom Messages an nummer @ SMS
//            mu entschieden werden, welcher Service fr die Versendung
//            gewhlt wird. Die Nummer wird gegen die Formel, wie unter
//            diesem Eintrag hinterlegt, fr jeden Service geprft. Der erste
//            Service, der dann eine nicht leere Zeichenkette zurckgibt,
//            wird gewhlt. Diese Zeichenkette ist dann auch gleichzeitig
//            die Nummer, an die dann gesendet wird, so da hier die Mglichkeit
//            geboten ist, an der Nummer noch Vernderungen vornehmen zu lassen.
//            Bei spezifischer Versendung auf einen speziellen Service
//            wird diese Formel dann ebenfalls verwendet, um die eigentliche
//            Nummer abzuleiten.
//
//        Beispiel:
//            SERVICE.NUMBER.FORMULA = a:="%s";@if(@Begins(a;"0171");a;@Begins(a;"049171");"0"+@RightBack(a;3);"")
//
//
// Wenn der Empfngername (und nicht direkt die Nummer) angegeben wurde,
// Ermittelt der Gateway die Nummer des Empfngers selbstndig.
// Diese Ermittlung geschieht durch 'scannen' der Mail-Note und ggf. eines
// Lokalisierten Adressbucheintrages auf verschiedene Feldinhalte.
//
// Werte-Listen mit bis zu 4 Eintrgen je Service, fr Ermittlung der
// Empfngerkennung:
//
//     SERVICE.NUMBER.DIRECT
//         Hier knnen je Service bis zu 4 Notes-Feldnamen angegeben werden.
//         Diese Feldnamen werden, fr alle Services,
//         zuerst in der Mail-Note gesucht und dann in
//         dem Adressbucheintrag zu dem jeweiligen Beutzer.
//         Wird bei dieser Feld dieses Namens bzw. ein Wert gefunden,
//         so wird die zugehrige Message ohne weitere Prfungen mit dem
//         entsprechenden Service verschickt.
//
//
//     SERVICE.NUMBER.MATCH
//         Fhrte die suche ber die unter SERVICE.NUMBER.DIRECT spezifizierten
//         Felder bei keinem Service zu einem Ergebnis, so wird ber das oder
//         die unter SERVICE.NUMBER.MATCH spezifizierten Feldnamen gesucht,
//         ebenfalls ber alle Services hinweg.
//         Jedoch wird auf jeden gefundenen Feldinhalt die unter
//         SERVICE.NUMBER.FORMULA angegebene Notes-Formel angewendet.
//         Wenn diese einen nicht-leeren String zurckgibt, so wird die
//         suche beendet, das Ergebnis ist der Rckgabewert der Formel.
//
//  Diese etwas komplex erscheinende Logik ermglicht die Modellierung
//  unterschiedlicher Interessenlagen:
//
//  Wenn eine SMS an eine Person verschickt werden soll, so mchte der Absender
//  dies einerseits ohne Kenntnis des Services, ber den diese Person erreichbar ist,
//  bewerkstelligen, also z.B. Hans Meister@SMS
//  (und eben nicht Hans Meister@D2@SMS).
//  Andererseits mchte man, wenn ein Teilnehmer mehrere Mglichkeiten der
//  SMS-Erreichbarkeit hat, sehr wohl steuern knnen, ber welchen Service
//  die Zustellung erreichen soll.
//  Daneben kann dann in der Default-Konfiguration im bereits vorhandenen Feld
//  CellPhoneNumber des Standard-Notes-Addressbuch einfach die jeweilige
//  SMS-Nummer des Teilnehmers hinterlegt werden; Consens kmmert sich dann
//  um die Zuordnung des Services.
//
//
//
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//                          **** ALLGEMEINE WERTE ****
// ----------------------------------------------------------------------------
                                        // Lizenkey. Dieser Eintrag macht
                                        // die Demo-Version zu einer Vollversion
                                        // und wird Ihnen ggf. telefonisch/
                                        // schriftlich mitgeteilt.
                                        // Die entsprechende Fehlermeldung
                                        // ERR license string not ...
                                        // beim Starten das Gateways kann ignoriert
                                        // werden.

// LICENSE.KEY=


                                        // Name der durch den Gateway
                                        // realisierten Domne, wird
                                        // bei der Installation sowie in
                                        // Protokollen bentigt
DOMAIN=SMS



// ----------------------------------------------------------------------------
// Aufbau und Formatierung eine Message
// ----------------------------------------------------------------------------
// Die Aufbereitung einer Message zur Versendung ber Consens kann durch Angabe
// eines Format-Strings kontolliert werden:
// Der Aufbau einer Format-Steuersequenz besteht aus einer oder mehreren
// Formatanweisungen, die aus je einer Buchstaben-Kennung und drei Ziffern
// bestehen. Der Buchstabe steht fr ein Item der Message, die drei Ziffern
// fr die Lnge des Textes, der hiervon in die Mail bernommen werden soll.
// Ist diese Lnge mit 0 (also 000) spezifiziert, so wird dieses Item in
// voller Lnge bernommen.
//
// Kennung Beschreibung
//    F    Absender - Fully specified Canonical Name (CN=...)
//    f    Absender - Fully specified Canonical Abbreviated
//    G    Absender - Common Name (Felix Findig)
//    g    Absender - Family Name (Findig)
//    R    Empfnger, wie angegeben (Fritz Empfnger)
//    r    Empfnger, aufgelst (01721234567)
//    S    Subject
//    b    Body, Abstract (experimentell)
//    B    Message Body Text
//    T    Message Time
//    #    CR/LF
//    L    Limitieren der Gesmtlnge der Nachricht auf NNN Zeichen
//    N    Absenderkennung
//    n    Absenderkennung, aber nur dann, wenn nicht bereits fester Bestandteil
//         des Protokolles (d.h. z.B. im Falle eines D1-Empfngers wird hier
//         der Wert eingetragen, im Falle D2 nicht)
//    1    Consens Versionsnummer
//    2    Copyright
//    3    Zeichensatz-Test
//
// Dieser Formatierungsstring kann eingesteuert werden
//
// - je Message
//
//   Wenn der Body (Haupt-Text) einer Message mit der unter FORMATESCAPE
//   spezifizierten Zeichenkette beginnt, wird die darauf folgende Zeichenkette
//   bis zum Ende der Zeile als Format-String gewertet. FORMATESCAPE und
//   der Formats-String werden aus der Message vor dem Versenden
//   natrlich entfernt.
//
//   Wenn in der Message ein Textfeld mit einem unter NOTESFIELD.FORMAT
//   bezeichneten Namen beinhaltet ist, wird die Formatierungsanweisung aus
//   dem Feldinhalt bezogen.
//
// - generell
//   Wenn im Profile (also dieser Datei) der Eintrag SMSFORMAT spezifiziert ist,
//   wird dieser Wer verwendet
//
//   Wenn keine dieser Angaben vorliegt, wird
//
//         G000n000#000S000#000B000
//
//   , also
//         Absender-Name, Absender-Nummer(wenn nicht UCP), Trenner,
//         Thema, Text der Nachricht
//
// verwendet.
// ----------------------------------------------------------------------------
SMSFORMAT=
NOTESFIELD.FORMAT=
FORMATESCAPE=++++


                                        // Such-Intervall nach neuen
                                        // Sendeauftrgen
POLLSECONDS=60

// ---------------------------------------------------------------------------
// INSTALL.LOCATIONDIAL
//
// FALSE:
//         Die bisherigen Serververbindungen wurden nicht unter Bezugnahme
//         auf ein Lokations-Dokument (Arbeitsumgebung) formuliert,
//         die bisherigen Servernummern sind alle eine als komplette Wahlnummer
//         eingetragen und nicht in in in Landesvorwahl/Vorwahl/Nummer
//         gegliedert.
//         Um nicht alle bereits
//         bestehenden Serververbindungen anpassen zu mssen, kann hier die
//         Installation von Consens so gesteuert werden, die Nummern ebenfalls
//         in diesem Stil abzulegen.
//         Diese Installations-Variante garantiert eine relativ sichere, sofortige
//         Verfgbarkeit der Verbindungen (/TESTSERVICES), die erzeugten
//         Verbindungsdokumente sind aber in einem gewissen Mae 'unsthetisch'
//
// TRUE:
//         Die bisherigen Serververbindungen wurden unter Bezugnahme auf ein
//         Lokations-Dokument (Arbeitsumgebung) angelegt.
//         Die Amtsholung, Vorwahl fr Ferngesprche, Lnderkennung
//         werden bereits aus diesem Dokument bezogen.
//         Die Installation wird dann die Serververbindungen, die fr
//         Consens erforderlich sind, bei der Installation ebenso einrichten.
//
// In jedem Fall knnen und sollten Sie die angelegten Serververbindungen
// kontollieren und ggf. anpassen.
// ---------------------------------------------------------------------------
INSTALL.LOCATIONDIAL = FALSE

// ----------------------------------------------------------------------------
// GATEWAY DATENBANK
// ----------------------------------------------------------------------------
                                        // Name der Gateway-Datenbank
                                        // Wird bei der Installation unter diesem
                                        // Dateinamen aus Standard-Template
                                        // angelegt.
                                        // Ebenso legt die Installation im
                                        // N&A ein Domnen-Dokument fr die
                                        // Domne DOMAIN (s.o.)
                                        // Der Router legt hier die Mail, die fr
                                        // den Versand an diese Domne bestimmt ist,
                                        // ab. Consens verarbeitet diese von
                                        // dort aus weiter.
MESSAGES.DATABASE=cpsms.box

                                        // Titel der Gateway-Datenbank
                                        // Bei der Anlage der Datenbank
                                        // MESSAGES.DATABASE wird dieser
                                        // Text als Datenbank-Titel verwendet
MESSAGES.CREATIONTITLE=Consens 2.00 Mailbox


// ----------------------------------------------------------------------------
// LOG/PROTOKOLL-Datenbank
// ----------------------------------------------------------------------------

                                        // Name der Protokoll-Datenbank,
                                        // die von der Installation angelegt wird und
                                        // in der die Verbindungsvorgnge
                                        // des Gateways dokumentiert werden.
                                        // Fgen Sie bitte diese Datenbank
                                        // dem Arbeitsbereich Ihres Notes-Clienten zu
LOG.DATABASE=cpsmsl.nsf

                                        // Wenn /INSTALL die Protokoll-
                                        // Datenbank anleget, wird dieser
                                        // Titel verwendet
LOG.CREATIONTITLE=Consens 2.00 Protokolldatenbank

                                        // Mitgelieferte Datenbank-Template,
                                        // aus der
LOG.TEMPLATEFILE=cpsmsl.ntf

                                        // Intern benutzter View Name in
                                        // Protokoll-Datenbank
                                        // (sollte i.A. nicht gendert werden)
LOG.KEYVIEWNAME=($MERGE)



// ---------------------------------------------------------------------------
// Absenderkennung
//
// Bei Short Messages ist es zum einen praktisch, wenn automatisch eine
// Telefonnummer (Absenderkennung) des Absenders automatisch in die
// Message eingetragen wird, zum anderen erfordert das Protokoll UCP zwingend
// solch eine Kennung im technischen Teil des Protokolls.
//
// Die Absenderkennung kann entweder (in Speziallfllen) Bestandteil der Mail
// sein, oder ber eine Notes-Datenbank ermittelt werden.
// Die geffnete Mail Note wird, wenn zum Service eine
// SERVICE.FROMNUMBER.FORMULA gegeben ist, mit dieser, ansonsten mit
// der FROMNUMBER.FORMULA_DEFAULT 'durchgerechnet'. Liefert der Ausdruck
// eine Wert ungleich "" zurck, wird dieser als Absenderkennung verwendet.
//
// Wird der Wert so nicht gefunden, was der Normalfall bei nicht speziell
// prparierten SMS-Versendemasken (also Memos) ist, so ermittelt
// Consens dann zum Absender der Notes-Mail aus einer Notes-Datenbank
// (Typischerweise das Namens- und Adressbuch) eine solche Absender-Kennung
// Die FROMNUMBER.xxx Eintrge konfigurieren den Ablauf dieser Nummernermittlung.
// Je Service kann optional eine eigene, dann Service-abhngige,
// Formel angegeben werden (SERVICE.FROMNUMBER.FORMULA).
// Das ermglicht dann zum Beispiel beim Senden einer Message an D2-Teilnehmer
// speziell das Einbrennen der eigenen Handynummer statt der eigenen
// Festapparat-Nummer.
//
// Am Beispiel D2-Privat wurde ein Vorschlag fr
// SERVICE.FROMNUMBER.FORMULA eingearbeitet.
// ---------------------------------------------------------------------------
                                        // Absenderkennungsermittlung allgemein
                                        // aktiviert (ja/nein, yes/no)
                                        // NO: die Absenderermittling ist
                                        // deaktiviert.
FROMNUMBER.ENABLE              = YES

                                        // Name der Datenbank, ber die die
                                        // Absenderkennungsermittlung
                                        // durchgefhrt wird. Mu View
                                        // FROMNUMBER.VIEW_NAME enthalten.
FROMNUMBER.DATABASE_NAME       = names.nsf
FROMNUMBER.VIEW_NAME           = ($Users)

                                        // Ableitung des Zugriffs-Schlssels
                                        // aus dem Absender der SMS, mit welchem
                                        // dann in
                                        // FROMNUMBER.DATABASE_NAME ber View
                                        // FROMNUMBER.VIEW_NAME
                                        // Informationen zum Absender
                                        // ermittelt werden.
                                        // %s steht hierbei fr einen Platzhalter,
                                        // der vor der eigentlichen Berechnung
                                        // jeweils durch den vollen
                                        // Absendernamen der
                                        // Mail ersetzt wird.
                                        // Im Beispiel hier wird der Domnen-
                                        // Name abgeschnitten und der Namens-
                                        // Anteil Vorname/Nachname bentzt.
FROMNUMBER.FORMULA_FROM_SENDER = @Name([CN]; @Subset("%s";1))

                                        // Wurde in
                                        // FROMNUMBER.DATABASE_NAME ber View
                                        // FROMNUMBER.VIEW_NAME
                                        // ein Absender-Dokument ermittelt, wird
                                        // die // Absenderkennung ber diese
                                        // hier angegebene // Notes-Formel
                                        // gebildet, sofern nicht in der
                                        // Definition des Services eine
                                        // ersetzende, servicespezifische
                                        // Formel unter
                                        //    SERVICE.FROMNUMBER.FORMULA
                                        // angegeben wurde.
FROMNUMBER.FORMULA_DEFAULT     = @if(OfficePhoneNumber != ""; OfficePhoneNumber;  "")


// ----------------------------------------------------------------------------
//                              **** SERVICES ****
// ----------------------------------------------------------------------------

// ---------------------------------------------------------------------------
// Nachfolgend Beschreibung der einzelnen Services.
// Jede Servicebeschreibung wird durch { } umfasst.
//
// Die einzelnen Schlsselwrter sind bereits am Dateianfang beschrieben,
// so da im folgenden nur noch Besonderheiten ausgewiesen werden
// ---------------------------------------------------------------------------

// ---------------------------------------------------------------------------
// Name          : D1 Telecom
// Country       : Germany
// ---------------------------------------------------------------------------
{
    SERVICE.NAME               = D1 Telekom
    SERVICE.PROTOCOL           = TAP
    SERVICE.SUBDOMAIN          = D1
    SERVICE.SERVERNAME         = D1
    SERVICE.LOGCLASS           = D1
    SERVICE.MESSAGESPERCALL    = 5
    SERVICE.LIMITMESSAGELENGTH = 160


    SERVICE.NUMBER.FORMULA     = a:="%s";@if(@Begins(a;"0171");a;@Begins(a;"049171");"0"+@RightBack(a;3);"")

    SERVICE.NUMBER.DIRECT      = SMSNumberD1

    SERVICE.NUMBER.MATCH       = CellPhoneNumber
    SERVICE.NUMBER.MATCH       = SMSNumber
    SERVICE.NUMBER.MATCH       = OfficeSMSPhoneNumber

    SERVICE.DIALUPNUMBER       = +49(171)2092522

//  SERVICE.FROMNUMBER.FORMULA = @if(CellPhoneNumber != ""; CellPhoneNumber; "")

    SERVICE.ACCNT.TIME.PRE     = 3000
    SERVICE.ACCNT.TIME.PERUNIT = 5400
    SERVICE.ACCNT.COST.PERUNIT =   12
}

// ---------------------------------------------------------------------------
// Name          : D2 Privat
// Country       : Germany
// ---------------------------------------------------------------------------
{
    SERVICE.NAME               = D2 privat
    SERVICE.PROTOCOL           = UCP
    SERVICE.SUBDOMAIN          = D2
    SERVICE.SERVERNAME         = D2
    SERVICE.LOGCLASS           = D2
    SERVICE.MESSAGESPERCALL    = 500

                                        // bei D2 kann dieser Wert auf bis zu
                                        // 640 erhht werden. Dadurch wird
                                        // jedoch vom SMSC die Message in
                                        // Einzelpakete a 160 zerlegt.
    SERVICE.LIMITMESSAGELENGTH = 160


    SERVICE.NUMBER.FORMULA     = a:="%s";@if(@Begins(a;"0172");a;@Begins(a;"049172");"0"+@RightBack(a;3);"")

    SERVICE.NUMBER.DIRECT      = SMSNumberD2

    SERVICE.NUMBER.MATCH       = CellPhoneNumber
    SERVICE.NUMBER.MATCH       = SMSNumber
    SERVICE.NUMBER.MATCH       = OfficeSMSPhoneNumber

    SERVICE.DIALUPNUMBER       = +49(172)2278020

    SERVICE.FROMNUMBER.FORMULA = a:=CellPhoneNumber;@if(@Begins(a;"0172");a;@Begins(a;"049172");"0"+@RightBack(a;3);OfficePhoneNumber)

    SERVICE.ACCNT.TIME.PRE     = 3000
    SERVICE.ACCNT.TIME.PERUNIT = 5400
    SERVICE.ACCNT.COST.PERUNIT =   12
}



// ---------------------------------------------------------------------------
// Name          : E1/E Plus
// Country       : Germany
// ---------------------------------------------------------------------------
{
    SERVICE.NAME               = E Plus
    SERVICE.PROTOCOL           = TAP
    SERVICE.SUBDOMAIN          = E1
    SERVICE.SERVERNAME         = E1
    SERVICE.LOGCLASS           = E1
    SERVICE.MESSAGESPERCALL    = 50
    SERVICE.LIMITMESSAGELENGTH = 160

    SERVICE.NUMBER.FORMULA     = a:="%s";@if(@Begins(a;"0177");a;@Begins(a;"049177");"0"+@RightBack(a;3);"")

    SERVICE.NUMBER.DIRECT      = SMSNumberE1

    SERVICE.NUMBER.MATCH       = CellPhoneNumber
    SERVICE.NUMBER.MATCH       = SMSNumber
    SERVICE.NUMBER.MATCH       = OfficeSMSPhoneNumber

    SERVICE.DIALUPNUMBER       = +49(177)1167

//  SERVICE.FROMNUMBER.FORMULA = @if(CellPhoneNumber != ""; CellPhoneNumber; "")

    SERVICE.ACCNT.TIME.PRE     = 3000
    SERVICE.ACCNT.TIME.PERUNIT = 5400
    SERVICE.ACCNT.COST.PERUNIT =   12
}



// ---------------------------------------------------------------------------
// Name          : TELMI Pro Pager
// Country       : Germany
// ---------------------------------------------------------------------------
{
    SERVICE.NAME               = TELMI PRO Pager
    SERVICE.PROTOCOL           = TAP
    SERVICE.SUBDOMAIN          = TELMI
    SERVICE.SERVERNAME         = TELMI
    SERVICE.LOGCLASS           = TELMI
    SERVICE.MESSAGESPERCALL    = 1

                                        // Fr TeLMI Fun    115,
                                        //     TeLMI Family 115
                                        //
                                        // ggf. als eigene Service-Block
                                        // unter eigenem Namen definieren
    SERVICE.LIMITMESSAGELENGTH = 260


    SERVICE.NUMBER.FORMULA     = a:="%s";@if(@Begins(a;"800");a;"")

    SERVICE.NUMBER.DIRECT      = SMSNumberTELMI

    SERVICE.NUMBER.MATCH       = CellPhoneNumber
    SERVICE.NUMBER.MATCH       = SMSNumber
    SERVICE.NUMBER.MATCH       = OfficeSMSPhoneNumber

    SERVICE.DIALUPNUMBER       = +49(166)01010101

//  SERVICE.FROMNUMBER.FORMULA = @if(CellPhoneNumber != ""; CellPhoneNumber; "8009999")

    SERVICE.ACCNT.TIME.PRE     = 3000
    SERVICE.ACCNT.TIME.PERUNIT = 5200
    SERVICE.ACCNT.COST.PERUNIT =   12
}
