program UpdFile;
uses
  ApiInt, Types,
  TParam,
  Bits,
  DOS;

type
  PUpdFiles        = ^TUpdFiles;
  TUpdFiles        = object
    SkipDate       : Boolean;
    SkipSize       : Boolean;
    AreaCode       : string;
    FileSpec       : string;

    constructor Init;
    destructor Done;

    procedure ReadParams;
    procedure UpdateFiles;
  end;

var
  UpdFiles         : PUpdFiles;

constructor TUpdFiles.Init;
begin
  dllInit( '', 0 );
end;

destructor TUpdFiles.Done;
begin
end;

procedure TUpdFiles.ReadParams;
begin
  if Par^.SwAct['D'] then SkipDate := TRUE
  else SkipDate := FALSE;

  if Par^.SwAct['S'] then SkipSize := TRUE
  else SkipSize := FALSE;

  if Par^.SwAct['A'] then AreaCode := Par^.SwStr['A']
  else AreaCode := 'MAIN';

  FileSpec := UpStr( Par^.Str[1] );
end; { procedure ReadParams }

procedure TUpdFiles.UpdateFiles;
var
  AreaRec          : Area_Config_Record;
  DirRec           : Area_Directory_Record;
  FileRec          : Area_Dir;
  FPos             : LongInt;
  SRec             : SearchRec;

begin
  if SkipSize or SkipDate then
  begin
    if SkipSize then Writeln( '- No size update will be done' );
    if SkipDate then Writeln( '- No date update will be done' );
  end
  else Writeln( '- Both size and date will be updated' );
  fioFindAreaCode( AreaRec, AreaCode, 0 );
  Writeln( '- Searching for files in ' + AreaRec.AreaName );
  Writeln;

  FPos := 0;
  while fioReadFileRec( FileRec, AreaRec, FPos ) do
  begin
    Inc( FPos );
    if ( KilledFile in FileRec.FileFlags ) then Continue;

    with FileRec do
    begin
      if LookInIf( UpStr( FileName ), FileSpec ) then
      begin
        if fioFindDirNo( DirRec, DirNo, AreaRec, 0 ) then
        begin
          FindFirst( DirRec.DiskDir + '\' + FileName, AnyFile, SRec );
          if ( DosError = 0 ) then
          begin
            if not SkipSize then Size := SRec.Size;
            if not SkipDate then with Date.Date do Bits.Date( Year, Month, Day );

            fioWriteFileRec( FileRec, AreaRec, FileRec.RecPos );
            Writeln( FileName + ', updated!' );
          end
          else Writeln( FileName + ' not found on disk!' );
        end;
      end;
    end;
  end;
end; { procedure UpdateFile }

begin
  Writeln;
  Writeln('UpdFile v1.04 - Update file date and size information in FOSS/2 filedatabase');
  Writeln;

  if not ( Par^.Count = 1 ) then
  begin
    Writeln( 'Usage:' );
    Writeln( '   UPDFILE {-D} {-S} {-A[area]} [filespec]' );
    Writeln;
    Writeln( '   -D           Do not update "date" information' );
    Writeln( '   -S           Do not update "size" information' );
    Writeln( '   -A           Area code of area to update files in' );
    Writeln( '                (Default: MAIN)' );
    Writeln( '   [filespec]   Name of the file to update (wildchars accepted) ');
    Exit;
  end;

  New( UpdFiles, Init );
  UpdFiles^.ReadParams;
  UpdFiles^.UpdateFiles;
  Dispose( UpdFiles, Done );
end. { Write DumpDir }