unit Types;

interface
const
  { Size of maximum buffer arrays }
  CByteMaxHigh     = 65519;
  CWordMaxHigh     = 32759;
  CLongMaxHigh     = 16379;

type
  { Maximum sized arrays for 16-bit programs }
  TByteMax         = array[0..CByteMaxHigh] of Byte;
  TWordMax         = array[0..CWordMaxHigh] of Word;
  TLongMax         = array[0..CLongMaxHigh] of LongInt;

  { Variable usage maximum buffer }
  TBufMax          = record
    case Byte of
      0: ( Bytes : TByteMax );
      1: ( Words : TWordMax );
      2: ( Longs : TLongMax );
  end;

  { Message text buffer }
  PMsgBuffer       = ^TMsgBuffer;
  TMsgBuffer       = array[0..CByteMaxHigh] of Char;

  { Type orginally defined in the DOS unit }
  PathStr          = string[79];
  DirStr           = string[67];

  { String types }
  Str4             = string[4];
  Str6             = string[6];
  Str10            = string[10];
  Str12            = string[12];
  Str16            = string[16];
  Str30            = string[30];
  Str40            = string[40];
  Str46            = string[46];
  Str60            = string[60];
  Str80            = string[80];
  Str200           = string[200];

  { Date and time types }
  T_Date           = record
    Year           : Word;
    Month,
    Day            : Byte;
  end;
  T_Time           = record
    Hour,
    Minute         : Byte;
  end;
  T_DateTime       = record
    Date           : T_Date;
    Time           : T_Time;
  end;

  { Password types }
  T_Password       = record
    Pwd            : Str12;
    Date           : T_Date;
  end;

  { System text type }
  T_NewTxt         = record
    Pnt            : array[0..799] of record
      Pos          : Word;
      Len          : Char;
    end;
    Text           : array[0..49151] of Byte;
  end;

  { System meny types }
  TMenuKey         = record
    Func           : string[25];
    MinKey         : Byte;
  end;
  PMenus           = ^TMenus;
  TMenus           = array[0..99] of TMenuKey;

  { Various type used }
  T_Access         = ( ReadMsg,
                       WriteMsg,
                       UploadFile,
                       DownloadFile,
                       OpenDoor,
                       AreaOp,
                       SysOp );
  S_Access         = set of T_Access;

  T_Area           = ( AllowresignA );
  S_Area           = set of T_Area;

  GraphT      = (IBM,ANSI);
  Graph       = Set Of GraphT;

  ClearScrT   = (ClrMenu,ClrMsg,ClrBullet);
  ClearScr    = Set Of ClearScrT;

  ANSIUseT    = (ANSMenu,ANSMsg,ANSBullet);
  ANSIUseS    = Set Of ANSIUseT;

  ArcT        = (None,ZIP,ARC,LZH,ARJ);

  AreaMarkT   = Array[1..32767] Of Word;

  ConnectT         = record
    ModemSpeed     : LongInt;
    PCSpeed        : LongInt;
    ErrorCorrect   : ( eNone, eMNP, eMNP10, eLAPM );
    Compression    : ( cNone, cMNP5, cV42b );
  end;

  Days_Typ		= (Mon,Tue,Wed,Thu,Fri,Sat,Sun);
  Days_Set    = Set Of Days_Typ;
{  EventT      = Record
    FHour       : ShortInt;
    FMin        : Byte;
    LHour       : Byte;
    LMin        : Byte;
    Days        : Days_Set;
    LastDay     : Byte;
  End;
}
  bNetAddr         = Record
    Case LongInt Of
      0: (Country : Word; Region, Node : Byte);
      1: (Buf : LongInt);
  End;

{  NodeIDT          = Record
    Case Word Of
      0: (Country, Region, Node : Word);
      1: (Buf : Real);
  End;}

{----------------------------------------------------------------------------
  Fileformat for B&BSYS.CFG file - main configuration file
                 MAIN\B&BMODEM.CFG - node configuration file
                 MAIN\B&BAREAS.CFG - area configuration file
 ----------------------------------------------------------------------------}
Type
  SysCfgT    = Record
    Version        : String[19];       {   1-  20=  20}
    BoardName      : Str30;            {  21-  51=  31}
    MaxLoggedChats : Word;             {  52-  53=   2}
    VersionID      : Word;             {  54-  55=   2}
    SystemNodeID   : bNetAddr;         {  56-  59=   4}
    Registered     : Boolean;          {  60-  60=   1}

    NU2            : array[61..71] of Byte;

{    __Country1       : Str4;             {  52-  56=   5}
{    __Board1         : Str10;            {  61-  71=  11}

    SysOpName      : Str30;            {  72- 102=  31}
    SysOpPassword  : T_Password;        { 103- 119=  17}
    FileDescrName  : Str12;            { 120- 132=  13}
    BNetReqUser    : Str30;            { 133- 163=  31}
    Location       : Str30;            { 164- 194=  31}
    GiveBackMS     : Byte;             { 195- 195=   1 * 10..250 }
    NU1            : Array[196..199] Of Byte;
    NewUserTime    : Word;             { 200- 201=  2}
    NewLevel       : Byte;             { 202     =  1}
    NewFlags       : Set Of (NewOk2Reg);
                                       { 203     =  3}
    ScratchPad     : PathStr;          { 204- 283= 80}
    PKUNZIPPath    : PathStr;          { 284- 363= 80}
    PKZIPPath      : PathStr;          { 364- 443= 80}
    MainPhone      : Str16;            { 444- 460= 17}
    PipeServer     : Str30;            { 461- 491= 31}
    NU3            : Array[492..603] Of Byte;
    RAMDisk        : DirStr;           { 604- 671= 68}
    Inactivity     : Word;             { 672- 673=  2}
    NU4            : Array[674..1013] Of Byte;
    PkArcPath      : PathStr;          {1014-1093= 80}
    PkXArcPath     : PathStr;          {1094-1173= 80}
    LHAPath        : PathStr;          {1174-1253= 80}
    ARJPath        : PathStr;          {1254-1333= 80}
    NU6            : Array[1334..1413] Of Byte;
    CDROM          : Array[1..10] Of Char;

                                       {1414-1423= 10}
    RFU            : Array[1424..4092] Of Byte;
                                       {1424-4092}
    RecPos         : LongInt;          {4093-4096}
  End; { Type SYSCfgT }

  ModFlags1   = Set Of (ShowWhenOffline, UseInactivity);

  ModCfgT     = Record
    ComPort        : Integer;          {  2/  2 * 1..4 = COM1..4
                                                  5    = use specified dev.  }
    NU1            : LongInt;          {  4/  6 *                            }
    NU3            : Word;             {  2/  8 * Init baudrate              }
    LockedSpeed    : Boolean;          {  1/  9 * Locked speed node?         }
    ConnectType    : (DirectCOM, DirectLOCAL, WaitForRING, WaitForDCD);

    InitStr        : Str60;            { 61/ 71 * Init string                }
    AnswerStr      : Str30;            { 31/102 * Answer string              }
    OnHookStr      : Str30;            { 31/133 * Onhook string              }
    OffHookStr     : Str30;            { 31/164 * Offhook string             }

    SysOpAvail     : Boolean;          {  1/165 * SysOp available?           }
    NU2            : Boolean;          {  1/166 * Inactivity disconnect here }

    RingB4Answer   : Byte;             {  1/167 * Number of "RING" before
                                                  answering                  }
    IODevice       : Str16;            { 17/184 * IO-Device used if ComPort
                                                  is 5                       }
    Flags1         : ModFlags1;
                                       {  1/185 * }
    InitSpeed      : LongInt;          {  4/189 * Init string                }
    MinSpeed,
    MaxSpeed       : LongInt;          {  8/197 * Min and/or max accepted
                                                  CONNECT rates              }
    MinLevel,
    MaxLevel       : Word;             {  4/201 * Min and/or max accepted
                                                  access level               }
    DialStr        : Str30;            { 31/232 *                            }

    RFU            : Array[233..252] Of Byte;
                                       {   /252 * RFU                        }
    RecPos         : LongInt;          {  4/256 * }
  End; { Type ModCfgT }

  Area_Directory_Record = Record
    DirNo          : Word;             {  2/  2 * Internal number of
                                                  directory                  }
    DirName        : Str30;            { 31/ 33 * Name of directory          }
    DiskDir        : DirStr;           { 68/101 * Assigned disk directory    }
    Flags          : Set Of (ShowUploader, UploadDir, NoDownload);
                                       {  1/102 * Directory flags            }
    FirstRec,
    NextRec        : LongInt;          {  8/110 * Internal pointers to .DIR  }
    RFU            : Array[111..124] Of Byte;
    RecPos         : LongInt;          {  4/128 * }
  End;

  Area_Flags_Type  = Set Of (New_User_Member,
                             Allow_Resign,
                             Public_Messages,
                             Private_Messages,
                             BNet_Member,
                             NU1,
                             External_Area);
  Area_Config_Record = Record
    AreaName       : Str30;            { 31/ 31 * Name of area showed to user}
    AreaCode       : Str4;             {  5/ 36 * Code used for AREAxxxx files
                                                  and bNet                   }
    FileCode       : Str4;             {  5/ 41 *                            }
    DoorCode       : Str4;             {  5/ 46 *                            }
    BullCode       : Str4;             {  5/ 51 *                            }
    NU1            : Word;
    ReadOldMsg     : Word;             {  2/ 55 *                            }
    AreaFlags      : Area_Flags_Type;  {  1/ 56 *                            }
    HostNodeID     : bNetAddr;         {  4/ 60 *                            }
    NU2            : Word;

    AccessLevel    : Array[0..15] Of S_Access;
                                       { 15/ 78 *                            }

    RFU            : Array[79..124] Of Byte;
                                       {   /124 * RFU                        }
    RecPos         : LongInt;          {  4/128 * }
  End; { Area_Config_Record }

  Link_Cfg_Flags   = Set Of (ActiveLink,
                             AcceptRequest,
                             AcceptResign);
  Link_Cfg_Record  = Record
    LinkFlags      : Link_Cfg_Flags;   {  1/  1 * bNet link flags            }
    LastMsgXfer    : LongInt;          {  4/  5 * Last message transfered    }
    TempMsgXfer    : LongInt;          {  4/  9 * Temp message pointer       }

    RFU            : Array[10..28] Of Byte;
    RecPos         : LongInt;          {  4/ 32 * }
  End; { Area_Net_Type }

  Event_Cfg_Record = record            { Used for file MAIN\EVENTS.CFG       }
    EventName      : Str30;            { 31/ 31 * Name of event              }
    EventType      : ( evtCommand,
                       evtPollHUB );   {  1/ 32 * Type of event              }
    EventFreq      : ( evtCustom,
                       evtDaily,
                       evtWeekly,
                       evtMonthly,
                       evtYearly );    {  1/ 32 * Frequency of event         }
    LastRun,
    NextRun,
    CustomFreq     : T_DateTime;       { 16/ 45 * Last and next time to run  }

    EventCommand   : Str80;            { 81/130 * Command to execute         }
    EventNode      : Word;             {  2/132 * Run event from node        }

    RFU            : array[123..1020] of Byte;
    RecPos         : Longint;          {  4/    *                            }
  end;

{----------------------------------------------------------------------------
  Fileformat for MAIN\LOCUSERS.REG file - The local user database
 ----------------------------------------------------------------------------}
 Type
  LocUsers    = Record
    UserName       : Str30;            { 31/ 31 * Navnet p lokal bruker     }
    UserAddress    : Str30;            { 31/ 62 *  Adressen                  }
    UserPostCode   : Str30;            { 31/ 93 *  PostAdressen              }
    City           : Str12;            { 13/106 *  Bostedsby                 }
    Password       : T_Password;        { 17/123 *  Passord og seneste dato
                                                   for forandring            }
    HomePhone      : Str16;            { 17/140 *  Telefonnummer privat      }
    WorkPhone      : Str16;            { 17/157 *  Telefonnummer arbeid      }

    FirstOn        : T_DateTime;        {  6/163 * Tidspunkt for registrering }
    TimesOn        : LongInt;          {  4/167 * Antall ganger p           }
    MsgWritten     : Word;             {  4/171 *                            }
    MsgRead        : Word;             {        *                            }
    LastOn         : T_DateTime;        {  6/177 * Siste gang p              }
    NetNumber      : Byte;             {  1/178 * Brukere en node nummer ... }

    Flags          : Set Of (Available,Xpert,Killed,Background,FreeForUse);
                                       {  1/179 *                            }

    Downloads      : Word;             {  2/181 * Filer downloadet           }
    DownloadKB     : Word;             {  2/183 * KB downloadet              }
    Uploads        : Word;             {  2/185 * Filer uploadet             }
    UploadKB       : Word;             {  2/187 * KB uploadet                }
    Protocol       : Char;             {  1/188 * Overfringsprotokol        }

    Graphics       : Graph;            {  1/189 * Graphics                   }
    AccessLevel    : Byte;             {  1/190 * Xpert modus                }

    TimeAllowed    : Word;             {  2/192 * Maks online tid/dag        }
    TimeLeft       : Word;             {  2/194 * Tid igjen i dag            }
    TimeTotal      : LongInt;          {  4/198 * Tid brukt totalt           }

    ANSIClear      : ClearScr;         {  1/199 * Hvor skal skjermen blankes }
    ScreenLines    : Byte;             {  1/200 * Hvor lang er skjermen din? }
    Language       : Char;             {  1/201 * Sprkvalg                  }
    ANSIUse        : ANSIUseS;         {  1/202 * Hvor skal ANSI brukes      }
    LastScan       : T_DateTime;        {  6/208 * Last New-files scan        }
    Packing        : ArcT;             {  1/209 * Pakkemte                  }
    Toggles				 : Set Of (DisplayStatus, ShowAddress);

    RFU            : Array[211..252] Of Byte;
                                       {   /252 * RFU                        }
    RecPos         : LongInt;          {  4/256 * }
  End; { Type LocUsers }

{----------------------------------------------------------------------------
  Fileformat for MAIN\NETUSERS.REG file - bNet user database
 ----------------------------------------------------------------------------}
{Type
  NetUsers    = Record
    UserName       : Str30;            {31/31 * Name of remote-user (nicecase}
 {   NodeID         : bNetAddr;         { 4/35 * Address of remote-node       }

{    RFU            : Array[36..124] Of Byte;
    RecPos         : LongInt;
  End; { Type NetUsers }

{----------------------------------------------------------------------------
  Fileformat for AREAxxxx.REG files
 ----------------------------------------------------------------------------}
Type
  Area_Flags  = Set Of (Member, Invited);

  AREA_Reg    = Record
    LastRead       : LongInt;          {4/ 4 * Last message read in area     }
    Access         : S_Access;           {1/ 5 * Additional access for this area
                                               access should primary be taken
                                               from the B&BAREAS.CFG file    }
    LastScan       : T_DateTime;				 {6/11 * Last new files scan in area,
                                               this one is saved only for file
                                               areas                         }
    Flags          : Area_Flags;       {1/12 * Users area flags              }
    InvitedBy      : LongInt;          {4/16 * Invited by user ...           }

    RFU            : Array[17..32] Of Byte;
                                       { /8 * RFU                            }
  End; { Type AREA_Reg }

{----------------------------------------------------------------------------
  Filformat for AREAxxxx.MHD filene - filene som innholder headere for
  meldingene i AREAxxxx.MTX filene.
 ----------------------------------------------------------------------------}
Type
  MsgSecT     = (ActiveM,PublicM,PrivateM,ReadM,FileM,ReqM);
  MsgSec      = Set Of MsgSecT;

  NetRegT     = (ToLocal,FromLocal,Echo);
  NetReg      = Set Of NetRegT;

  TMsgUser         = record
    case UserType : ( Local, FrogNet, OtherNet ) of
      Local:
        ( ID       : LongInt );        { Pos in user database }
      FrogNet:
        ( User     : Str30;            { User name }
          Addr     : bNetAddr;         { User address }
          Node     : bNetAddr );       { Received from node }
      OtherNet:
        ( UserAddr : Str80;
          ExtraPos : LongInt );        { 86/  86 - }
  end; { TMsgUser }


  AREA_Mhd    = Record
    FromUser       : LongInt;          { 4/  4 - Pointer to LOCALUSR.REG     }
    ToUser         : LongInt;          { 4/  8 - Pointer to LOCALUSR.REG     }
    NetUsers       : NetReg;           { 1/  9 -                             }
    Security       : MsgSec;           { 1/ 10 -                             }

    Subject        : Str60;            {61/ 71 - Emne p meldingen           }
    MsgPointer     : LongInt;          { 4/ 75 - Peker til AREAxxxx.MTX      }
    MsgNumber      : LongInt;          { 4/ 79 - Nummeret p meldingen       }
    ReplyTo        : LongInt;          { 4/ 83 - Denne er svar p xxx        }
    FirstReply     : LongInt;          { 4/ 87 - Frste svar til denne er    }

    Lines          : Word;             { 2/ 89 - Linjer i meldingen          }
    DateEntered    : T_DateTime;       { 6/ 95 - Dato meldingen er skrevet   }

    ONumber        : LongInt;          { 4/ 99 - Orginal meldingens nummer   }
    RNumber        : LongInt;          { 4/103 - Denne er svar til           }
    NextInThread   : LongInt;          { 4/107 - Neste melding i denne trden}
    ReceivedFrom   : bNetAddr;         { 4/111 - }
    RemoteFromID   : bNetAddr;         { 4/115 - }

    NU1            : array[116..118] of Byte;

    MsgBufLen      : LongInt;          { 4/122 - }

    NetFromPos     : LongInt;          { 4/126 - Pointer to .ADR             }
    NetFromLen     : Word;             { 2/128 - Length of addresse          }
    NetToPos       : LongInt;          { 4/132 - Pointer to .ADR             }
    NetToLen       : Word;             { 2/134 - Length of addresse          }

    RemoteToID     : bNetAddr;         { 4/138 - }

    RFU            : array[139..252] of Byte;
                                       {  /252 - RFU                         }
    RecPos         : LongInt;          { 4/256 - }
  End; { Type AREA_Mhd }

{----------------------------------------------------------------------------
  Record format for the MAIN\AREA\AREA*.DIR files - Board file databases
 ----------------------------------------------------------------------------}
type
  PFileRec         = ^TFileRec;
  TFileRec         = record
    FileName       : string[16];       { 17/ 17 * Name of file shown to user }
    Description    : string[120];      {121/138 * File description           }

{    Description1   : String[55];       { 56/ 73 * First line of description  }
 {   RFU1           : Array[74..78] Of Byte;
    Description2   : String[55];       { 56/134 * Second line of description }

    RFU2           : array[139..139] of Byte;
    FTXPointer     : LongInt;          {  4/143 * Pointer to extended info   }
    Date           : T_DateTime;        {  6/149 * Date of install/upload     }
    Size           : LongInt;          {  4/153 * Size of file in bytes      }
    DirNo          : LongInt;          {  4/157 * DirNo belonging to         }
    UploadedBy     : LongInt;          {  4/161 * Uploaded by Ptr to user db }
    Downloads      : LongInt;          {  4/165 * Number of downloads        }
    CDROM          : Byte;             {  1/166 * CD-ROM# or 0 for normal    }
    CDPath         : string[60];       { 61/227 * CD-ROM path                }
    FileFlags      : set of (KilledFile);
                                       {  1/228 * File record flags          }
    TBU            : array[229..252] of Byte;
    RecPos         : LongInt;          {  4/256 * }
  end; { Type AREA_Dir }

{----------------------------------------------------------------------------
  Filformat for MAIN\NODESTAT filen - filen som inneholder node-aktivitet
  post tilsvarer nodenummer, 0=0, 1=1 osv.
 ----------------------------------------------------------------------------}
Type
  ActivityS   = Set Of (WrittenMessage,
                        ReadMessage,
                        UploadedFile,
                        DownloadedFile,
                        OpenedDoor);

  NodeStat    = Record
    NodeNo         : Byte;             {  1/  1 * Node nummer                }
    Activity       : Word;             { 0=Down,   1=Event,  2=Wait,
                                         3=Recycling, 4=Picking up call,
                                         5=Loggin in, 6=FrogNet xfer
                                        10=Active,11=Enter, 12=D/l,
                                        13=Upload,14=OpenD, 15=SysOpChat,
                                        16=BiTran,
                                        500..755=Chatting with node          }

    ComPort        : Byte;             {  1/  4 * 0 = Local, 1/2, 3=Base+Irq }
    ShowAllways    : Boolean;          {  1/  5 * Allways show in status     }
    IOHandle       : Word;             {  2/  7 * Current COM-handle for node}
    NU2            : Word;
    BaudRate       : Word;             {  2/ 11 * Init bps-rate              }
    DoneWhat       : ActivityS;        {  1/ 12 *                            }
    NU1            : Byte;             {  1/ 13 *                            }
    LockedSpeed    : Boolean;          {  1/ 14 * Kjres fast hastighet?
                                                  dvs. bruk initrate?        }

    UserName       : Str30;            { 31/ 45 * Navnet p lokal bruker     }
    UserAddress    : Str30;            { 31/ 76 *  Adressen                  }
    UserPostCode   : Str30;            { 31/107 *  PostAdressen              }
    City           : Str12;            { 13/120 *  Bostedsby                 }

    Downloads      : Word;             {  2/122 * Filer downloadet           }
    DownloadKB     : Word;             {  2/124 * KB downloadet              }
    Uploads        : Word;             {  2/126 * Filer uploadet             }
    UploadKB       : Word;             {  2/128 * KB uploadet                }
    Protocol       : Char;             {  1/129 * Overfringsprotokol        }

    TimeAllowed    : Word;             {  2/131 * Maks online tid/dag        }
    TimeLeft       : Word;             {  2/133 * Tid igjen i dag            }
    Connected      : LongInt;          {  4/137 * Innloggingstid             }
    Graphics       : Graph;            {  1/138 * Grafikk                    }

    ConnectSpeed   : ConnectT;         { 10/148 * Connected speed            }
    Avail          : Boolean;          {  1/149 *                            }
    UserPos        : LongInt;          {  4/153 * }

    RFU            : Array[154..256] Of Byte;
                                       {   /256 * RFU                        }
  End; { Type NodeStat }

{----------------------------------------------------------------------------
  Filformat for MAIN/NODEMSG.* filene - filene inneholder meldinger mellom
  nodene.
 ----------------------------------------------------------------------------}
Type
  NodeMsg     = Record
    FromNode       : Byte;             {  1/  1 * Sendt fra node             }
    FromUser       : LongInt;          {  4/  5 * Sendt av bruker            }
    ToNode         : Byte;             {  1/  6 }
    ToUser         : LongInt;          {  4/ 10 }
    Flags          : Set Of (nmRead, nmInBuffer);
                                       {  1/ 11 }
    RFU            : Array[12..47] Of Byte;
                                       {   / 47 * RFU                        }
    SystemMsg      : Byte;             {  1/ 48 }
    Messy          : String[79];       { 80/128 * Melding                    }
  End; { Type NodeMsg }

{----------------------------------------------------------------------------
  Fileformat for the MAIN\B&BLINKS.CFG file - Network link config
 ----------------------------------------------------------------------------}
Type
  Net_Config_Record = Record
    LinkType       : ( FrogNetHost,    { 1/  1 * Remote system is ...        }
                       FrogNetNode,
                       OtherNetLink );
    NodeAddr       : Str30;            {31/ 32 * Remote system ID            }
    LastBullDate   : Word;             { 2/ 34 * Last bulletin exchange date }
    LinkSysOp      : Str30;            {31/ 65 * Remote SysOp name           }
    LinkPassword   : Str12;            {13/ 78 * Password to access link     }
    LinkPhone      : Str16;            {17/ 95 * Link phone number           }
    LinkSystem     : Str30;            {31/126 * Remote system name          }
    NodeID         : bNetAddr;         { 4/130 * }

    RFU            : Array[131..254] Of Byte;

    LinkLocalPos   : Word;             { 2/256 * Temp pointer to this record,
                                                 only internal use           }
  End; { Record Net_Config_Record }

{----------------------------------------------------------------------------
  Fileformat for the MAIN\B&BPROT.CFG file - The file protocol config file
 ----------------------------------------------------------------------------}
type
  ProtTypeType      = set of (Batch, BiDirectional, Auto);

  Protocol_Config_Record = record
    Letter         : Char;            {  1/  1 * Letter used to select prot. }
    Name           : Str30;           { 31/ 32 * Name of protocol            }
    ProgramPath    : Str60;           { 61/ 93 * Program path                }
    UploadCommand  : Str200;          {201/294 * Receive command             }
    DownloadCommand: Str200;          {201/495 * Send command                }

    OkErrorLevel   : ShortInt;        {  1/496 * Error level returned if OK  }
    ProtType       : ProtTypeType;    {  1/497 * Protocol capabilities       }
    AutoReceive    : Str16;           { 17/514 * Auto receive string         }

    RFU            : array[515..1020] of Byte;
    RecPos         : LongInt;         {  4/1024 * Temp pointer to this record,
                                                  only internal use          }
  end; { Record Protocol_Config_Record }

IMPLEMENTATION

End. { Unit Types }