{$i DEF.INC}
unit W95Find;
interface

const
  Max_Path = 260;

type
  THandle = integer;
  DWORD = longint;
  BOOL = boolean;

  PFileTime = ^TFileTime;
  TFileTime = record
    dwLowDateTime: DWORD;
    dwHighDateTime: DWORD;
  end;

  TWin32FindData = record
    dwFileAttributes: DWORD;
    ftCreationTime: TFileTime;
    ftLastAccessTime: TFileTime;
    ftLastWriteTime: TFileTime;
    nFileSizeHigh: DWORD;
    nFileSizeLow: DWORD;
    dwReserved0: DWORD;
    dwReserved1: DWORD;
    cFileName: array[0..MAX_PATH - 1] of Char;
    cAlternateFileName: array[0..13] of Char;
  end;

var LFNError:integer;

function FindFirstFile(lpFileName: PChar; var lpFindFileData: TWIN32FindData): THandle;
function FindNextFile(hFindFile: THandle; var lpFindFileData: TWIN32FindData): BOOL;
function FindClose(hFindFile: THandle): BOOL;

IMPLEMENTATION

procedure CallDOS; near; assembler; { int 21h & error->LFNError}
asm
   int 21h
   push ax
   push ds
   jc @ERR
   cmp ax,7100h
   je @ERR
   xor ax,ax
@ERR:
   push ax
   mov ax,seg @Data
   mov ds,ax
   pop ax
   mov LFNError,ax
   pop ds
   pop ax
end;

const Attr = 0;
function FindFirstFile(lpFileName:PChar; var lpFindFileData:TWIN32FindData):THandle;
assembler;
asm
   push ds
   mov si,1
   mov cx,Attr
   lds dx,lpFileName
   les di,lpFindFileData
   mov ax,714Eh
   call CallDOS
   pop ds
   cmp LFNError,0
   je @OK
   mov ax,-1
@OK:
end;

function _OK:bool; near; assembler;
asm
   mov ax,LFNError
   test ax,ax
   jnz @ERR
   inc ax
   retn
@ERR:
   xor ax,ax
end;

function FindNextFile(hFindFile:THandle; var lpFindFileData:TWIN32FindData):BOOL;
assembler;
asm
   mov si,1
   mov bx,hFindFile
   les di,lpFindFileData
   mov ax,714Fh
   call CallDOS
   call _OK
end;

function FindClose(hFindFile:THandle):BOOL;
assembler;
asm
   mov bx,hFindFile
   mov ax,71A1h
   call CallDOS
   call _OK
end;

END.

