{$i def.inc}
unit Upper;
interface
{$IFDEF SysUtils}
uses SysUtils;
{$ELSE}
  {$IFDEF OS2} uses OS2Def,OS2Base;{$ENDIF}
{$ENDIF}


function UpCase(c:char):char;
{$IFnDEF SysUtils}
function AnsiUpperCase(s:string):string;
function AnsiCompareStr(const s1,s2:string):integer;
{$ENDIF}


IMPLEMENTATION
var TBLUpCase:array [char] of char;


{$IFDEF SysUtils}

function XUpCase(c:char):char;
var s:string[1];
begin
     s:=ANSIUpperCase(c);
     XUpCase:=s[1];
end;

{$ELSE}

function AnsiUpperCase(s:string):string;
var i:integer;
begin
     for i:=1 to length(s) do s[i]:=TBLUpCase[s[i]];
     AnsiUpperCase:=s;
end;

function AnsiCompareStr(const s1,s2:string):integer;
var i,n:integer;
    c1,c2:char;
begin
     n:=length(s1); i:=length(s2);
     if n>i then n:=i;
     for i:=1 to n do begin
         c1:=TBLUpCase[s1[i]];
         c2:=TBLUpCase[s2[i]];
         if c1<c2 then begin
            AnsiCompareStr:=-1;
            exit;
         end else if c1>c2 then begin
             AnsiCompareStr:=1;
             exit;
         end;
     end;
     if s1<s2 then AnsiCompareStr:=-1
     else if s1>s2 then AnsiCompareStr:=1
     else AnsiCompareStr:=0;
end;

{$IFDEF DOS}

function _UpCase(c:char):char; far;
begin
     _UpCase:=system.UpCase(c);
end;

function XUpCase(c:char):char; assembler;
asm
   mov ax,6520h
   mov dl,c
   int 21h
   jnc @OK
   pop bp
   jmp _UpCase
@OK:
   mov al,dl
end;

{$ELSE}
{$IFDEF OS2}

function XUpCase(c:char):char;
const cc:CountryCode = (Country:0; Codepage:0);
begin
     DosMapCase(1,cc,@c);
     XUpCase:=c;
end;

{$ELSE}

{$IFDEF WIN32}
function XUpCase(c:char):char;
begin
     XUpCase:=UpCase(c);
end;

{$ELSE}
function XUpCase(c:char):char;
begin
     XUpCase:=UpCase(c);
end;
{$ENDIF}
{$ENDIF}
{$ENDIF}
{$ENDIF}


function UpCase(c:char):char;
begin
     UpCase:=TBLUpCase[c];
end;


procedure TblInit;
var c:char;
begin
     for c:=low(TBLUpCase) to high(TBLUpCase) do TBLUpCase[c]:=system.UpCase(c);
     for c:=low(TBLUpCase) to high(TBLUpCase) do TBLUpCase[c]:=XUpCase(c);
end;

BEGIN
     TblInit;
END.

