{$i+}
{$i def.inc}
uses
  {$IFDEF VIRTUALPASCAL}Use32,{$ENDIF}
  {$IFDEF SysUtils}{$IFDEF TestTime}DOS,{$ENDIF}SysUtils,
  {$ELSE}Strings,DOS,
  {$ENDIF}
  {$IFDEF WIN32}Windows,{$ELSE}{$IFDEF W32LFN}W95Find,{$ENDIF}{$ENDIF}
  {$IFDEF EA} OS2EA, {$ENDIF}
  Upper,UniOBJ;

type
  PXLAT = ^TXLAT;
  TXLAT = array [0..255] of char;

const
  MaxDir = 32;
  tSep = ':';
  dSep = '.';
  LinkSep = ':';
  CfgSep = [' ',','];
  VarSep = '%';
  SortType:integer = 1;
  Share = $40;
  DirFirst:boolean = True;
  MainXLAT:PXLAT = NIL;
  TmpName='BBS2HTML.$$$';
  {$IFDEF SysUtils}DosError:integer=0;
  {$ELSE}faDirectory=Directory;
  {$ENDIF}

var
  {$IFDEF SysUtils}
  FHome:string;
  {$ELSE}
  FHome:PathStr; FName:NameStr; FExt:ExtStr;
  {$ENDIF}
  DescFiles,Tpl:TCollection;
  IndexName,HeaderName,FooterName,TimeFormat,CfgName:PString;

type
  {$IFnDEF SysUtils}TSearchRec = SearchRec;{$ENDIF}
  u_int={$IFDEF BIT32}longint{$ELSE}integer{$ENDIF};
  u_ofs={$IFDEF BIT32}longint{$ELSE}word{$ENDIF};
  string_=string[32];

  PIndex = ^TIndex;

  TAnsiStringCollection = object(TStringCollection)
    function Compare(Key1,Key2:Pointer):integer; virtual;
  end;

  PIndexItem = ^TIndexItem;
  TIndexItem = object(TObject)
      Des:PChar;
      Mark:boolean;
    destructor done; virtual;
  end;

  PSearch = ^TSearch;
  TSearch = object(TIndexItem)
      Attr:byte;
      Time,Size:longint;
      Name:PString;
  {$IFDEF W32LFN}
      AltName:PString;
    constructor initLFN(var AR:TWin32FindData);
  {$ENDIF}
    constructor init(var AR:TSearchRec);
    destructor done; virtual;
  end;

  PDesSrc = ^TDesSrc;

  PDescriptions = ^TDescriptions;
  TDescriptions = object(TObject)
      DesSrc:PDesSrc;
      Src:PIndex;
      CarryStr:PString;
    constructor init(ADesSrc:PDesSrc; ASrc:PIndex);
    function Open:boolean; virtual;
    function Get(var FName:array of string; var s:string):integer;
    function GetSrc(var FName:array of string; var s:string):integer; virtual;
    function isEOF:boolean; virtual;
    function GetName:string; virtual;
    procedure Filter(var s:string); virtual;
    function GetCarry(var s:string):boolean;
    procedure ToOEM(var s:string);
  end;

  TDesSrc = object(TObject)
      Master:boolean;
      Filter:boolean;
      XLAT:PXLAT;
      OEM:boolean;
    function Open(Src:PIndex):PDescriptions; virtual;
    function GetName:string; virtual;
    procedure XLATStr(var s:string);
  end;

  PFileDescriptions = ^TFileDescriptions;
  TFileDescriptions = object(TDescriptions)
      f:text;
      WillDes:boolean;
    function Open:boolean; virtual;
    destructor done; virtual;
    function GetSrc(var FName:array of string; var s:string):integer; virtual;
    function isEOF:boolean; virtual;
    function isDescription(var s:string):boolean;
  end;

  PFileDesSrc = ^TFileDesSrc;
  TFileDesSrc = object(TDesSrc)
      Name:PString;
      SpaceDesc:boolean;
      Skip1,Skip2:integer;
      Strs:TCollection;
    constructor init(const AName:string);
    destructor done; virtual;
    function Open(Src:PIndex):PDescriptions; virtual;
    function GetName:string; virtual;
    procedure AddStrDes(const s:string);
  end;

  {$IFDEF EA}
  PEADescriptions = ^TEADescriptions;
  TEADescriptions = object(TDescriptions)
      Cur:u_int;
      Data:PChar;
      DataSize:longint;
      Buf:pointer;
      BufSize:longint;
    function Open:boolean; virtual;
    destructor done; virtual;
    function GetSrc(var FName:array of string; var s:string):integer; virtual;
    function isEOF:boolean; virtual;
  end;

  PEADesSrc = ^TEADesSrc;
  TEADesSrc = object(TDesSrc)
      EAName:PChar;
      EABufSize:u_ofs;
    constructor init(const AEAName:string);
    destructor done; virtual;
    function Open(Src:PIndex):PDescriptions; virtual;
  end;
  {$ENDIF}

  PSortedSearch = ^TSortedSearch;
  TSortedSearch = object(TSortedCollection)
    function Compare(Key1,Key2:pointer):integer; virtual;
  end;

  TIndex = object(TObject)
      Des:PDescriptions;
      FH:text;
      Prev,Dir,Root,RootHTML:PString;
      SR:PSearch;
      Res,isDesc:boolean;
      DD:PIndex;
      s:string;
      MainScanned:boolean;
      L:TCollection;
      L2:TSortedSearch;
      Cur:u_int;
      ListAll:boolean;
      Phase:integer;
      DescSrc:u_int;
      NoList:TAnsiStringCollection;
      PostWrite:boolean;
      LastLinkType:byte;
      SizeSum:longint;
      NLink:integer;
    constructor init(const APrev,ADir,ARoot,ARootHTML:string; AListAll:boolean);
    function Go:boolean;
    destructor done; virtual;
    procedure CopyFile(const Name:string);
    procedure CreateNdx;
    procedure CloseNdx;
    procedure WriteSorted;
    procedure CloseLine;
    procedure WriteDesc(ss:string);
    procedure WrNdx(const Path,Lnk,Desc:string; LinkType:byte);
      { LinkType: 0 - none, 1 - SR^ record, 2 - link}
    procedure WrNdxR;
    procedure WrNdxR_(R:PSearch);
    procedure FindFile(Name:string);
    procedure FindFirst_;
    procedure FindNext_;
    procedure AddNoList(const ss:string);
    procedure Path2HTML(var ss:string);
  end;


procedure Err(const s:string);
begin
     writeln('ERROR: ',s,#7);
     halt(1);
end;

function StrNZ(s:PString):string;
begin
     if s<>NIL then StrNZ:=s^ else StrNZ:='';
end;

function DirSlash(const s:string):string;
begin
     if (s<>'') and not (s[length(s)] in [':','\','/']) then DirSlash:=s+'\'
     else DirSlash:=s;
end;

procedure StrUpdateBuf(var s1:PChar; s2:pointer; Size:u_ofs);
var i,sz1:u_ofs;
    s:PChar;
begin
     if s1=NIL then sz1:=0 else sz1:=StrLen(s1);
     i:=sz1+Size;
     GetMem(s,i+1);
     if s1<>NIL then begin
        if sz1<>0 then move(s1^,s^,sz1);
        FreeMem(s1,sz1+1);
     end;
     if Size<>0 then move(s2^,(s+sz1)^,Size);
     s[i]:=#0;
     s1:=s;
end;

procedure StrUpdate(var s1:PChar; s2:PChar);
begin
     StrUpdateBuf(s1,s2,StrLen(s2));
end;

procedure StrUpdateS(var s1:PChar; const s2:string);
var s:PChar;
    n,i:u_ofs;
    cc:array [0..256] of char;
begin
     StrUpdateBuf(s1,@s2[1],length(s2));
end;

procedure StrReplace(var s1:PChar; s2:PChar);
begin
     if s1<>NIL then StrDispose(s1);
     s1:=NIL;
     if s2<>NIL then s1:=StrNew(s2);
end;

function FirstSpace(var s:string):boolean;
begin
     FirstSpace:=(length(s)<>0) and ((s[1]=' ') or (s[1]=#9));
end;

function DelSpace(var s:string):boolean;
begin
     DelSpace:=False;
     while FirstSpace(s) do begin
           delete(s,1,1);
           DelSpace:=True;
     end;
end;

procedure Replace(const StrFrom,StrTo:string; var s:string);
var i,n:u_int;
begin
     i:=pos(StrFrom,s);
     n:=length(StrFrom);
     while i<>0 do begin
           delete(s,i,n);
           insert(StrTo,s,i);
           i:=pos(StrFrom,s);
     end;
end;

function ValSz(i,n:word):string_;
var s:string_;
begin
     str(i:n,s);
     for i:=1 to length(s) do if s[i]=' ' then s[i]:='0';
     ValSz:=s;
end;


{$IFDEF SysUtils}
type
   DateTime = record
      hour,
      min,
      sec,
      msec,
      day,
      month,
      year : system.word;
    end;
procedure UnpackTime(p:longint; var d:DateTime);
var dt:TDateTime;
begin
     dt:=FileDateToDateTime(p);
     DecodeTime(dt,d.Hour,d.Min,d.Sec,d.mSec);
     DecodeDate(dt,d.Year,d.Month,d.Day);
end;
{$ENDIF}

function TimeStr(t:longint):string;
{begin
     TimeStr:=FormatDateTime(TimeFormat^,FileDateToDateTime(t));
end;}
var D:DateTime;
    s:string;
    p:u_int;
    t12:boolean;
procedure NCh(c:char; x:word);
var p,i,n:u_int;
begin
     p:=pos(c,s);
     if p=0 then exit;
     n:=1;
     for i:=p+1 to length(s) do if s[i]=c then inc(n);
     delete(s,p,n);
     insert(ValSz(x,n),s,p);
end;
begin
     UnpackTime(t,D);
     s:=TimeFormat^;
     p:=pos('AM/PM',s);
     if p<>0 then begin
        delete(s,p,5);
        if D.Hour<12 then begin
           insert('am',s,p);
        end else begin
            insert('pm',s,p);
            dec(D.Hour,12);
        end;
     end;
     NCh('Y',D.Year);
     NCh('M',D.Month);
     NCh('H',D.Hour);
     NCh('N',D.Min);
     NCh('S',D.Sec);
     NCh('D',D.Day);
     TimeStr:=s;
end;

type SetOfChar = set of char;
function GetWord(var s:string; const Sep:SetOfChar; var CurSep:char):string;
var i:u_int;
    nq:boolean;
begin
     i:=1; nq:=True;
     while i<=length(s) do begin
           if s[i]='"' then begin
              delete(s,i,1);
              if copy(s,i,1)='"' then inc(i) else  nq:=not nq;
           end else if nq and (s[i] in Sep) then begin
               GetWord:=copy(s,1,i-1);
               CurSep:=s[i];
               delete(s,1,i);
               exit;
           end else inc(i);
     end;
     GetWord:=s;
     CurSep:=' ';
     s:='';
end;

function isDir(S:PSearch):boolean;
begin
     isDir:=(S^.Attr and faDirectory)<>0;
end;

{ TAnsiStringCollection }

function TAnsiStringCollection.Compare(Key1,Key2:Pointer):Integer;
begin
     Compare:=AnsiCompareStr(PString(Key1)^,PString(Key2)^);
end;

{ TIndexItem }

destructor TIndexItem.done;
begin
     if Des<>NIL then StrDispose(Des);
     inherited done;
end;

{ TDesSrc }

function TDesSrc.GetName:string;
begin
     GetName:='';
end;

function TDesSrc.Open(Src:PIndex):PDescriptions;
begin Abstract;
end;

procedure XLATStr_(x:PXLAT; var s:string);
var i:u_int;
begin
     if X<>NIL then for i:=1 to length(s) do s[i]:=X^[byte(s[i])];
end;

procedure TDesSrc.XLATStr(var s:string);
begin
     XLATStr_(MainXLAT,s);
     XLATStr_(XLAT,s);
end;

{ TFileDesSrc }

constructor TFileDesSrc.init(const AName:string);
begin
     inherited init;
     Name:=NewStr(AName);
     Strs.init(4,4);
     Filter:=True;
end;

destructor TFileDesSrc.done;
var i:u_int;
begin
     for i:=1 to Strs.Count do DisposeStr(Strs.At(i-1));
     Strs.DeleteAll;
     Strs.Done;
     DisposeStr(Name);
     inherited done;
end;

function TFileDesSrc.GetName:string;
begin
     if Name=NIL then GetName:='' else GetName:=Name^;
end;

function TFileDesSrc.Open(Src:PIndex):PDescriptions;
var p:PFileDescriptions;
begin
     new(p);
     Open:=p;
     if not p^.init(@Self,Src) then begin
        Dispose(p);
        Open:=NIL;
     end else Open:=p;;
end;

procedure TFileDesSrc.AddStrDes(const s:string);
begin
     if AnsiUpperCase(s)='SPACE' then SpaceDesc:=True
     else Strs.Insert(NewStr(s));
end;

{ TDescription }

constructor TDescriptions.init(ADesSrc:PDesSrc; ASrc:PIndex);
begin
     inherited init;
     DesSrc:=ADesSrc;
     Src:=ASrc;
     if not Open then Fail;
end;

function TDescriptions.GetSrc(var FName:array of string; var s:string):integer;
begin Abstract;
end;

procedure TDescriptions.ToOEM(var s:string);
begin
     {$IFDEF WIN32}
     OemToAnsiBuff(@s[1],@s[1],length(s));
     {$ENDIF}
end;

procedure FName0(var FName:array of string);
var i:integer;
begin
     for i:=low(FName) to high(FName) do FName[i]:='';
end;

function TDescriptions.Get(var FName:array of string; var s:string):integer;
var i:integer;
begin
     FName0(FName);
     s:='';
     if GetCarry(s) then Get:=0
     else begin
          Get:=GetSrc(FName,s);
          {$IFDEF WIN32}
          if not DesSrc^.OEM then begin
             for i:=low(FName) to high(FName) do ToOEM(FName[i]);
             ToOEM(s);
          end;
          {$ENDIF}
     end;

     Filter(s);
     DesSrc^.XLATStr(s);
end;

function TDescriptions.GetName:string;
begin
     GetName:=Src^.Dir^+DesSrc^.GetName;
end;

function TDescriptions.isEOF:boolean;
begin
     isEOF:=True;
end;

function TDescriptions.Open:boolean;
begin
     Open:=True;
end;

function TDescriptions.GetCarry(var s:string):boolean;
begin
     GetCarry:=False;
     if CarryStr<>NIL then begin
        s:=CarryStr^;
        DisposeStr(CarryStr);
        CarryStr:=NIL;
        GetCarry:=True;
     end;
end;

procedure TDescriptions.Filter(var s:string);
var i:u_int;
    Overflow:boolean;
    s1:string;
procedure ChkOver;
begin
     if (255-length(s1))<=10 then Overflow:=True;
end;
procedure ChTo(const ss:string);
var p:u_int;
begin
     {$IFnDEF LongStr}
     p:=255-length(ss);
     if i-1>p then begin
        dec(i);
        p:=length(s)-i;
        s1:=copy(s,i,p);
        delete(s,i,p);
        Overflow:=True;
        exit;
     end;
     {$ENDIF}
     delete(s,i,1);
     {$IFnDEF LongStr}
     if length(s)>p then begin
        s1:=copy(s,p,length(s)-p)+s1;
        delete(s,p,length(s)-p);
        ChkOver;
        if Overflow then exit;
     end;
     {$ENDIF}
     insert(ss,s,i);
     inc(i,length(ss));
end;
begin
     if not DesSrc^.Filter then exit;
     i:=1;
     s1:='';
     Overflow:=False;
     while i<=length(s) do if s[i] in [#13,#10,'>','<','&','"'] then begin
           case s[i] of
                #13:begin
                    ChTo('<br>');
                    if copy(s,i,1)=#10 then delete(s,i,1);
                end;
                #10:ChTo('<br>');
                '<':ChTo('&lt;');
                '>':ChTo('&gt;');
                '&':ChTo('&amp;');
                '"':ChTo('&quot;');
                else ChTo('&#'+ValSz(byte(s[i]),1)+';');
           end;
           if Overflow then Break;
     end else inc(i);
     if s1<>'' then CarryStr:=NewStr(s1);
end;

{ TFileDescription }

function TFileDescriptions.Open:boolean;
begin
     {$i-}
     FileMode:=0+Share;
     assign(f,GetName); reset(f);
     Open:=ioresult=0;
     {$i+}
end;

destructor TFileDescriptions.Done;
begin
     inherited done;
     close(f);
end;


function TFileDescriptions.isDescription(var s:string):boolean;
var i,n:u_int;
    ss:PString;
function SW(var SubS:string):boolean;
begin
     if copy(s,1,length(SubS))=SubS then begin
        delete(s,1,length(SubS));
        SW:=True;
        exit;
     end;
     SW:=False;
end;
begin
     isDescription:=False;
     n:=PFileDesSrc(DesSrc)^.Strs.Count;
     for i:=0 to n-1 do begin
         ss:=PFileDesSrc(DesSrc)^.Strs.At(i);
         if copy(s,1,length(ss^))=ss^ then begin
            delete(s,1,length(ss^));
            isDescription:=True;
            exit;
         end;
     end;
     if PFileDesSrc(DesSrc)^.SpaceDesc then isDescription:=DelSpace(s);
end;

function TFileDescriptions.GetSrc(var FName:array of string; var s:string):integer;
var c:char;
    i,n:u_int;
begin
     read(f,s);
     FName0(FName);
     if WillDes then GetSrc:=0
     else if isDescription(s) then begin
          insert(#13,s,1); { safe - space or substring was deleted }
          GetSrc:=0
     end else begin
          for i:=1 to PFileDesSrc(DesSrc)^.Skip1 do GetWord(s,[' '],c);
          i:=low(FName);
          n:=0;
          repeat
                GetSrc:=i;
                FName[i]:=GetWord(s,[' ',LinkSep],c);
                inc(i);
                inc(n);
          until (c<>LinkSep) or (i>high(FName));
          GetSrc:=n;
          for i:=1 to PFileDesSrc(DesSrc)^.Skip2 do GetWord(s,[' '],c);
     end;
     if eoln(f) then begin
        WillDes:=False;
        readln(f);
     end else WillDes:=True;
end;

function TFileDescriptions.isEOF:boolean;
begin
     isEOF:=eof(f);
end;

{$IFDEF EA}

{ TEADescriptions }

function TEADescriptions.Open:boolean;
begin
     BufSize:=1024;
     GetMem(Buf,BufSize);
     Open:=True;
end;

destructor TEADescriptions.Done;
begin
     inherited done;
     FreeMem(Buf,BufSize);
end;

function TEADescriptions.GetSrc(var FName:array of string; var s:string):integer;
var p:PChar;
    sr:PSearch;
    n:longint;
begin
     FName0(FName); s:='';
     if DataSize=0 then begin
        p:=NIL;
        StrUpdateS(p,Src^.Dir^);
        SR:=PSearch(Src^.L.At(Cur));
        FName[low(FName)]:=SR^.Name^;
        StrUpdateS(p,FName[low(FName)]);

        DataSize:=OS2Get1EA(p,PEADesSrc(DesSrc)^.EAName,Buf,BufSize,Data);

        StrDispose(p);
        inc(Cur);
        GetSrc:=1;
     end else GetSrc:=0;
     if DataSize=0 then begin
        FName[low(FName)]:='';
        exit;
     end;
     n:=255;

     if DataSize<n then n:=DataSize;
     move(Data^,s[1],n);
     s[0]:=char(n);
     dec(DataSize,n);
     inc(Data,n);
end;

function TEADescriptions.isEOF:boolean;
begin
     isEOF:=Cur>=Src^.L.Count;
end;

{ TEADesSrc }

constructor TEADesSrc.init(const AEAName:string);
begin
     inherited init;
     StrUpdateS(EAName,AEAName);
     EABufSize:=512;
end;

destructor TEADesSrc.done;
begin
     inherited done;
     StrDispose(EAName);
end;


function TEADesSrc.Open(Src:PIndex):PDescriptions;
var p:PEADescriptions;
begin
     new(p);
     if not p^.init(@Self,Src) then begin
        dispose(p);
        p:=NIL;
     end;
     Open:=p;
end;

{$ENDIF}

{ TSearch }

constructor TSearch.init(var AR:TSearchRec);
begin
     inherited init;
     Attr:=AR.Attr;
     Size:=AR.Size;
     Time:=AR.Time;
     Name:=NewStr(AR.Name);
end;

{$IFDEF W32LFN}
constructor TSearch.initLFN(var AR:TWin32FindData);
var s:array [0..max_path] of char;
{$IFDEF WIN32} LocalTime:TFileTime;{$ENDIF}
function SNew(c:array of char):PString;
var i:u_ofs;
begin
     i:=high(c);
     {$IFnDEF LongStr}if i>255 then i:=255;{$ENDIF}
     StrLCopy(s,@c,i);
     SNew:=NewStr(StrPas(s));
end;
begin
     inherited init;
     Attr:=AR.dwFileAttributes;
     Size:=AR.nFileSizeLow;
     {$IFDEF WIN32}
     FileTimeToLocalFileTime(AR.ftLastWriteTime,LocalTime);
     FileTimeToDosDateTime(LocalTime,LongRec(Time).Hi,LongRec(Time).Lo);
     {$ELSE}
     Time:=AR.ftLastWriteTime.dwLowDateTime;
     {$ENDIF}
     Name:=SNew(AR.cFileName);
     AltName:=SNew(AR.cAlternateFileName);
end;
{$ENDIF}

destructor TSearch.done;
begin
     inherited done;
     DisposeStr(Name);
     {$IFDEF W32LFN}
     DisposeStr(AltName);
     {$ENDIF}
end;

{ TSortedSearch }

function CompInt(var x1,x2:longint):integer;
begin
     if x1<x2 then CompInt:=-1
     else if x1=x2 then CompInt:=0
     else CompInt:=1;
end;

function TSortedSearch.Compare(Key1,Key2:pointer):integer;
begin
     if DirFirst then begin
        if isDir(Key1) then begin
           if not isDir(Key2) then begin
              Compare:=-1;
              exit
           end;
        end else if isDir(Key2) then begin
            Compare:=1;
            exit
        end;
     end;
     case SortType of
          1:Compare:=AnsiCompareStr(PSearch(Key1)^.Name^,PSearch(Key2)^.Name^);
          2:Compare:=CompInt(PSearch(Key1)^.Size,PSearch(Key2)^.Size);
          3:Compare:=CompInt(PSearch(Key1)^.Time,PSearch(Key2)^.Time);
     end;
end;


{ TIndex }

constructor TIndex.init(const APrev,ADir,ARoot,ARootHTML:string; AListAll:boolean);
var i:u_int;
    R:TSearchRec;
    s1:string;
    {$IFDEF W32LFN}p:PChar; h:THandle; LR:TWin32FindData;{$ENDIF}
begin
     inherited init;
     ListAll:=AListAll;
     Prev:=NewStr(APrev);
     Dir:=NewStr(DirSlash(ADir));
     RootHTML:=NewStr(ARootHTML);
     Root:=NewStr(DirSlash(ARoot));
     NoList.init(DescFiles.Count+1,4);
     for i:=1 to DescFiles.Count do AddNoList(PDesSrc(DescFiles.At(i-1))^.GetName);
     AddNoList(IndexName^);
     AddNoList('..');
     AddNoList('.');
     AddNoList(TmpName);
     if SortType<>0 then L2.Init(10,10);

     L.Init(10,10);
     {$IFDEF W32LFN}
     p:=NIL;
     StrUpdateS(p,Dir^+'*');
     h:=FindFirstFile(p,LR);
     if h<>-1 then begin
        repeat
           if not (((LR.dwFileAttributes and faDirectory)<>0)
              and ((StrComp(LR.cFileName,'..')=0)
              or (StrComp(LR.cFileName,'.')=0))) then
              L.Insert(new(PSearch,initLFN(LR)));
        until not FindNextFile(h,LR);
        FindClose(h);
     end;
     {$IFDEF DOS}
     if LFNError<>$7100 then exit;
     {$ENDIF}
     {$IFnDEF WIN32}
     FindFirst(Dir^+'*.*',faDirectory,R);
     while DosError=0 do begin
           L.Insert(new(PSearch,init(R)));
           FindNext(R);
     end;
     {$ENDIF}
     {$ELSE}
     {$IFDEF SysUtils}
     if FindFirst(Dir^+'*.*',faDirectory,R)=0 then repeat
        L.Insert(new(PSearch,init(R)));
     until FindNext(R)<>0;
     SysUtils.FindClose(R);
     {$ELSE}
     FindFirst(Dir^+'*.*',faDirectory,R);
     while DosError=0 do begin
           L.Insert(new(PSearch,init(R)));
           FindNext(R);
     end;
     FindClose(R);
     {$ENDIF}
     {$ENDIF}
end;

procedure TIndex.AddNoList(const ss:string);
begin
     if ss<>'' then NoList.Insert(NewStr(ss));
end;

destructor TIndex.Done;
begin
     if SortType<>0 then begin
        L2.DeleteAll;
        L2.Done;
     end;
     L.Done;
     NoList.Done;
     DisposeStr(Prev);
     DisposeStr(Dir);
     inherited done;
end;

function ZStr(p:PString):boolean;
begin
     if p=NIL then ZStr:=True else ZStr:=p^='';
end;

procedure TIndex.CopyFile(const Name:string);
var f:text;
    ss:string;
begin
     FileMode:=0+Share;
     assign(f,Dir^+name); {$i-}reset(f);
     if ioresult<>0 then begin
        assign(f,FHome+name);
        reset(f);
        if ioresult<>0 then exit
     end;
     {$i+}
     while not eof(f) do if eoln(f) then begin
           readln(f);
           writeln(fh);
     end else begin
         read(f,ss);
         write(fh,ss);
     end;
     close(f);
end;

procedure TIndex.CreateNdx;
begin
     if Res then exit;
     Res:=True;
     FileMode:=2+Share;
     assign(fh,Dir^+TmpName); rewrite(fh);
     CopyFile(HeaderName^);
     writeln(fh,'<TABLE cellspacing=3>');
     writeln(fh,'<TR valign=top><TH>file</TH><TH>size</TH><TH>time</TH><TH>description</TH></TR>');
     if not ZStr(Prev) then
        WrNdx(Prev^,'[..]','Up',0);
end;

procedure TIndex.Path2HTML;
var i:u_int;
begin
     if pos(Root^,ss)=1 then begin
        delete(ss,1,length(Root^));
        ss:=StrNZ(RootHTML)+ss;
     end;
     for i:=1 to length(ss) do if ss[i]='\' then ss[i]:='/';
end;

procedure TIndex.WrNdx(const Path,Lnk,Desc:string; LinkType:byte);
var s1:string;
begin
     CreateNdx;
     CloseLine;
     LastLinkType:=LinkType;
     s1:=Path;
     Path2HTML(s1);

     if s1='' then s1:=Lnk;
     write(fh,'<tr valign="top"><td><A HREF="',s1,'">');
     if Lnk<>'' then s1:=Lnk;
     if pos(' ',s1)=0 then write(fh,s1,'</A></td>')
     else write(fh,'<pre>',s1,'</pre></A></td>');

     case LinkType of
       1:begin
         if isDir(SR) then write(fh,'<td>SUB-DIR</td>')
         else write(fh,'<td align=right>',SR^.Size,'</td>');
         write(fh,'<td>',TimeStr(SR^.Time),'</td><td>');
       end;
       2:write(fh,'<td>---></td><td></td><td>');
       else write(fh,'<td></td><td></td><td>');
     end;
     if PostWrite and (LinkType=1) then begin
        if SR^.Des<>NIL then write(fh,SR^.Des);
     end else write(fh,Desc);
     isDesc:=True;
end;

procedure TIndex.WriteSorted;
var i:u_int;
begin
     PostWrite:=True;
     for i:=1 to L2.Count do begin
         WrNdxR_(L2.At(i-1));
         CloseLine;
     end;
end;

procedure TIndex.WrNdxR_(R:PSearch);
begin
     SR:=R;
     if isDir(R) then WrNdx(R^.Name^+'/'+IndexName^,'['+R^.Name^+']','',1)
     else WrNdx(R^.Name^,R^.Name^,'',1);
end;

procedure TIndex.WrNdxR;
begin
     SR^.Mark:=True;
     if SortType<>0 then begin
        CreateNdx;
        isDesc:=True;
        LastLinkType:=1;
        L2.Insert(SR);
        exit;
     end;
     WrNdxR_(SR);
end;


const Cnt:word = 32;
var s_:array [0..4] of string;

function TIndex.Go:boolean;
begin
     Res:=False;
     Go:=False;
     if ZStr(Dir) then exit;
     dec(Cnt); if Cnt=0 then exit;

     DescSrc:=0;
     while DescSrc<DescFiles.Count do begin
           inc(DescSrc);
           Des:=PDesSrc(DescFiles.At(DescSrc-1))^.Open(@Self);
           if Des=NIL then Continue;
           if PDesSrc(DescFiles.At(DescSrc-1))^.Master then MainScanned:=True;
           while not Des^.isEOF do begin
                 NLink:=Des^.Get(s_,s);
                 case NLink of
                   0:if Res then WriteDesc(s);
                   1:begin
                          if s_[0]='*' then begin
                             ListAll:=True;
                             DosError:=2;
                          end else FindFile(s_[0]);
                          if DosError=0 then begin
                             if SR^.Des<>NIL then begin
                                StrDispose(SR^.Des);
                                SR^.Des:=NIL;
                             end;
                             if isDir(SR) then begin
                                DD:=new(PIndex,init(Dir^+IndexName^,Dir^+SR^.Name^+'\',Root^,StrNZ(RootHTML),ListAll));
                                if DD^.Go then WrNdxR;
                                DD^.Free;
                             end else WrNdxR;
                             WriteDesc(s);
                          end;
                   end;
                   2:WrNdx(s_[1],s_[0],s,2);
                   else begin
                        if NLink<4 then s_[3]:=StrNZ(RootHTML);
                        if NLink<5 then begin
                           s_[4]:=Dir^+IndexName^;
                           Path2HTML(s_[4]);
                        end else if s_[4]='!' then s_[4]:='';
                        WrNdx(s_[1],s_[0],s,2);
                        DD:=new(PIndex,init(s_[4],s_[2],s_[2],s_[3],ListAll));
                        DD^.Go;
                        DD^.Free;
                   end;
                 end;
           end;
           DosError:=0;

           if Des<>NIL then begin
              Des^.Free;
              Des:=NIL;
           end;
     end;

     if ListAll or not MainScanned then begin
        MainScanned:=True;
        FindFirst_;
        while DosError=0 do begin
              if (not SR^.Mark) and (NoList.IndexOf(SR^.Name)=-1) then begin
                 if isDir(SR) then begin
                    DD:=new(PIndex,init(Dir^+IndexName^,Dir^+SR^.Name^+'\',Root^,StrNZ(RootHTML),ListAll));
                    if DD^.Go then WrNdxR;
                    DD^.Free;
                 end else if ListAll then WrNdxR;
              end;
              FindNext_;
        end;
     end;

     inc(Cnt);
     WriteSorted;
     if Res then begin
        writeln(Dir^);
        CloseNdx;
     end;
     Go:=Res;
     DosError:=0;
end;


procedure TIndex.FindFile(Name:string);
begin
     Name:=AnsiUpperCase(Name);
     FindFirst_;
     while DosError=0 do begin
           if Name=AnsiUpperCase(SR^.Name^) then exit;
           {$IFDEF W32LFN}
           if SR^.AltName<>NIL then if Name=AnsiUpperCase(SR^.AltName^) then exit;
           {$ENDIF}
           FindNext_;
     end;
end;

procedure TIndex.FindFirst_;
begin
     Cur:=0;
     FindNext_;
end;

procedure TIndex.FindNext_;
begin
     if Cur<L.Count then begin
        SR:=L.At(Cur);
        DosError:=0;
     end else DosError:=2;
     inc(Cur);
end;

procedure TIndex.CloseNdx;
var f:file;
    ss:string;
    i:integer;
begin
     CloseLine;
     write(fh,'</TABLE>');
     CopyFile(FooterName^);
     close(fh);
     ss:=Dir^+IndexName^;
     assign(f,ss);
     {$i-}erase(f);i:=ioresult;{$i+}
     rename(fh,ss);
end;

procedure TIndex.CloseLine;
begin
     if isDesc then begin
        if (SortType=0) or (LastLinkType<>1) or PostWrite then writeln(fh,'</td></tr>');
        isDesc:=False;
     end;
end;

procedure TIndex.WriteDesc(ss:string);
begin
     if isDesc then begin
        if (SortType=0) or (LastLinkType<>1) then write(fh,ss)
        else if SR<>NIL then begin
                StrUpdateS(SR^.Des,ss);
        end;
     end;
end;


function GetInt(var s:string; var x:integer):boolean;
var s1:string;
    e:integer;
    c:char;
begin
     GetInt:=True;
     s1:=GetWord(s,CfgSep,c);
     if s1='' then e:=0 else
        val(s1,x,e);
     GetInt:=e=0;
end;

function GetBool(var s:string; var x:boolean):boolean;
var s1:string;
    e:u_int;
    c:char;
begin
     GetBool:=True;
     s1:=AnsiUpperCase(GetWord(s,CfgSep,c));
     if (s1='Y') or (s1='YES') or (s1='TRUE') or (s1='ON') or (s1='1') then x:=True
     else if (s1='N') or (s1='NO') or (s1='FALSE') or (s1='OFF') or (s1='0') then x:=False
     else if s1<>'' then GetBool:=False;
end;

procedure ReadCFG;
var f:text;
    s,s1:string;
    l:longint;
    i,p,p1:u_int;
    ff:file;
    c:char;
    b:boolean;
    DF:PFileDesSrc;
    DD:PDesSrc;
procedure CfgErr_(const s:string);
begin
     Err(CfgName^+' error in line #'+ValSz(l,1)+s);
end;
procedure CfgErr;
begin
     CfgErr_('');
end;
function GW:string;
begin
     GW:=GetWord(s,CfgSep,c);
end;
procedure ChkDF;
begin
     if DF=NIL then CfgErr_(' - directive '+s1+' must be after DESCRIPTIONS');
end;
procedure ChkDD;
begin
     if DD=NIL then CfgErr_(' - directive '+s1+' must be after some descriptions source');
end;
procedure LoadXLAT(var X:PXLAT);
var i:byte;
    XLAT:TXLAT;
begin
     for i:=0 to 255 do XLAT[i]:=char(i);
     if X<>NIL then Dispose(X);
     new(X);
     X^:=XLAT;
     FileMode:=0+Share;
     assign(ff,FHome+GW); {$i-}reset(ff,1);
     if ioresult=0 then begin
        blockread(ff,XLAT,SizeOf(XLAT));
        close(ff);
        {$i+}
     end else CfgErr;
     if GW='!' then for i:=255 downto 0 do X^[byte(XLAT[i])]:=char(i)
     else X^:=XLAT;
end;
begin
     FileMode:=0+Share;
     assign(f,FHome+CfgName^); {$i-}reset(f);
     if ioresult<>0 then Err('Error open config file '+CfgName^);
     {$i+}
     l:=0; DF:=NIL; DD:=NIL;
     while not eof(f) do begin
           inc(l);
           readln(f,s);
           DelSpace(s);
           if (copy(s,1,1)=';') or (s='') then Continue;
           s1:=AnsiUpperCase(GetWord(s,['='],c));
           if s1='DESCRIPTIONS' then begin
              DD:=New(PFileDesSrc,init(GW));
              DF:=PFileDesSrc(DD);
              DescFiles.Insert(DD);
           end else if s1='SKIPFIELS' then begin
               ChkDF;
               if not GetInt(s,DF^.Skip1) then CfgErr;
               if not GetInt(s,DF^.Skip2) then CfgErr;
           end else if s1='TRANSLATE' then begin
               ChkDD;
               if not GetBool(s,DD^.Filter) then CfgErr;
           end else if s1='OS2EA' then begin
               {$IFDEF EA}
               DD:=New(PEADesSrc,init(GW));
               DF:=NIL;
               DescFiles.Insert(DD);
               {$ELSE}
               writeln('WARNING: OS2EA not supported by platform');
               {$ENDIF}
           end else if s1='MULTILINE' then begin
               ChkDF;
               while s<>'' do DF^.AddStrDes(GW);
           end else if s1='MASTER' then begin
               ChkDD;
               GetBool(s,DD^.Master);
           end else if s1='OEM' then begin
               ChkDD;
               GetBool(s,DD^.OEM);
           end else if s1='TIMEFORMAT' then begin
               TimeFormat:=NewStr(s);
           end else if s1='SORT' then begin
               s1:=AnsiUpperCase(GW);
               if s1='NONE' then SortType:=0
               else if s1='NAME' then SortType:=1
               else if s1='SIZE' then SortType:=2
               else if s1='TIME' then SortType:=3
               else CfgErr;
               s1:=AnsiUpperCase(GW);
               if s1='NODIRFIRST' then DirFirst:=False
               else if s1='DIRFIRST' then DirFirst:=True
               else CfgErr;
           end else if s1='INDEXFILE' then begin
               IndexName:=NewStr(GW);
               HeaderName:=NewStr(GW);
               FooterName:=NewStr(GW);
           end else if s1='XLAT' then begin
               if DD<>NIL then LoadXLAT(DD^.XLAT) else LoadXLAT(MainXLAT);
           end else CfgErr;
     end;
     close(f);
     if (IndexName=NIL) or (FooterName=NIL) or (HeaderName=NIL) then
        Err('Not defined file name! Please set "IndexName=<index> <header> <footer>"');
     if TimeFormat=NIL then TimeFormat:=NewStr('HH:NN-DD.MM.YY');
     TimeFormat^:=AnsiUpperCase(TimeFormat^);
end;

var DD:TIndex;
{$IFDEF TestTime} hour1,hour2,min1,min2,sec1,sec2,sec1001,sec1002:word; {$ENDIF}

BEGIN
     {$IFDEF TestTime} GetTime(hour1,min1,sec1,sec1001); {$ENDIF}
     writeln('BBS2HTML v1.4.3 (c) mahatma E-Mail: mahatma_d@usa.net AKA 2:450/144@fidonet.org');
     if paramcount=0 then begin
        writeln('Usage: BBS2HTML <ROOT_DIR> [<ROOT_HTML_DIR> [<CONFIG_FILE>]]');
        halt(1);
     end;
     {$IFDEF SysUtils}
     FHome:=ExtractFileDir(paramstr(0))+'\';
     {$ELSE}
     FSplit(paramstr(0),FHome,FName,FExt);
     {$ENDIF}

     if paramcount>=3 then CfgName:=NewStr(paramstr(3))
     else CfgName:=NewStr('BBS2HTML.CFG');

     DescFiles.Init(4,4);
     Tpl.Init(4,4);
     ReadCfg;

     DD.Init('',paramstr(1),paramstr(1),paramstr(2),False);
     DD.Go;
     DD.Done;
     Tpl.Done;
     DescFiles.Done;
     DisposeStr(IndexName);
     DisposeStr(FooterName);
     DisposeStr(HeaderName);
     DisposeStr(TimeFormat);
     {$IFDEF TestTime}
     GetTime(hour2,min2,sec2,sec1002);
     writeln('Time: ',(((Hour2-Hour1)*60+min2-min1)*60+sec2-sec1)*100+sec1002-sec1001);
     {$ENDIF}
END.

