/* $Id: strings.c,v 1.4 1997/05/07 22:36:20 dps Exp $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */
#include <stddef.h>

#include <ctype.h>
#ifdef __cplusplus
extern "C" {
#endif

#ifndef HAVE_STRCASECMP
int strcasecmp(const char *s, const char *t)
{
    register unsigned char a,b;

    while (*s && *t)
    {
	a=tolower(*s);
	b=tolower(*t);
	if (a<b)
	    return -1;
	if (a>b)
	    return 1;
	s++;
	t++;
    }
    if (*s!='\0')
	return -1;
    if (*t!='\0')
	return 1;
    return 0;
}
#endif

#ifndef HAVE_STRNCASECMP
int strncasecmp(const char *s, const char *t, size_t ss_size)
{
    register unsigned char a,b;
    int ii_size=0;
    while (*s && *t && ii_size<ss_size)
    {
	a=tolower(*s);
	b=tolower(*t);
	if (a<b)
	    return -1;
	if (a>b)
	    return 1;
	s++;
	t++;
        ii_size++;
    }
    if (*s!='\0')
	return -1;
    if (*t!='\0')
	return 1;
    return 0;
}
#endif

#ifdef __cplusplus
}
#endif
