/* $Id: lib.h,v 1.21 1998/02/17 12:27:18 dps Exp $ */

#ifndef __word2x_lib_h__
#define __word2x_lib_h__
#include "config.h"
#include <stdio.h>
#include <stddef.h>

#ifdef __cplusplus
#include "tblock.h"
#include "interface.h"
#endif /* __cplusplus */


/* Maximum section number */
#define MAX_START_NUM 100

typedef struct
{
    int wd[2];
    int dot_pos;
    int has_sign;
} num_info;

typedef enum { ALIGN_LEFT, ALIGN_CENTER, ALIGN_RIGHT, ALIGN_DP } align_t;

struct wd_info
{
    int width;
    int dp_col;
    int has_sign;
    align_t align;
};

/* Unit information */
struct unit_info
{
    int unit_type;
    int unit_number[NUNITS];
};

/* Numbered unit probing */
struct unit_number
{
    int unit_num;
    int offset;
};

#ifndef N
#define N(a) (sizeof(a)/sizeof(a[0]))
#endif


/*
 * Functions that need only C stuff are declared as C linkage here
 */
#ifdef __cplusplus
extern "C" {
#endif

extern struct wd_info find_width(int, const char *const *);
extern num_info scan_num(const char *);
extern struct unit_number n_unit_probe(const char *, struct unit_info *);
extern int get_part_num(const char *, const char *);

/* Date formats */
#include <time.h>
extern char *uk_date(time_t);
extern char *us_date(time_t);

/* Basic stuff for reading numbers from files */
extern unsigned long read_ulong(FILE *);
extern long read_long(FILE *);
extern short read_ushort(FILE *);
extern unsigned short read_short(FILE *);

#ifdef __cplusplus
}
#endif

#ifdef __cplusplus

#ifndef N
#define N(x) (sizeof(x)/sizeof(x[0]))
#endif /* N */
#include "tblock.h"
#include "reader.h"

#ifndef __EXCLUDE_READER_CLASSES
extern void null_proc(const tok_seq::tok *, const docfmt *, FILE *, void *);
extern void error_proc(const tok_seq::tok *, const docfmt *, FILE *, void *);
#endif /* __EXCLUDE_READER_CLASSES */
extern tblock *word_wrap(const char *, const char *,const char *, const int,
			 const int=0);
extern tblock *__map_string(const char *, const cmap *, int);
#define map_string(a,b) __map_string(a, b, N(b));
#endif /* __cplusplus */

#endif /* __word2x_lib_h__ */
