/* viewrdi.c */

/*
    Nut nutrition software 
    Copyright (C) 1998 Jim Jozwiak.

    Source code OS/2 adaptation by Michele Della Guardia
    E-mail : mikedg@ghostbbs.ml.org
    Team OS/2 Italy

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "viewrdi.h"
#include "food.h"
#include "util.h"
#include <stdio.h>
#include <string.h>

void view_rdis(int opt)
{
int count, num;
int intdiv = NutrientCount / 2 + (NutrientCount % 2 == 0 ? 0 : 1);
for ( ; ; )
 {
 if (opt == 2) header("NUT:  View RDI and Rank Foods by Nutrients per Serving");
 if (opt == 1) header("NUT:  View RDI and Rank Foods by Nutrients per 100 Grams");
 if (opt == 0) header("NUT:  View RDI and Rank Foods by Nutrients per 100 Calories");
 for ( count = 0 ; count <= NutrientCount / 2; count++)
  {
  printf("     %2d. %-13s  %7.1f %-3s      ",count+1,Nutrient[count],Rdi[count],RdiUnit[count]);
  if (count+intdiv < NutrientCount) printf("%2d. %-13s  %7.1f %-3s    \n",count+1+intdiv,Nutrient[count+intdiv],Rdi[count+intdiv],RdiUnit[count+intdiv]);
  else printf("\n");
  }
 if (opt == 2) printf("\n\n\n Serving sizes are the arbitrary serving sizes in the USDA Nutrient Database.\n"); 
 if (opt == 1) printf("\n\n\n The rankings per 100 grams are the most compact good sources of the nutrient.\n"); 
 if (opt == 0) printf("\n\n\n  The rankings per 100 calories are the bulkiest good sources of the nutrient.\n"); 
 spacer(count + 4);
 printf("\nType number of Nutrient to see food rankings (or <enter> to quit):  ");
 num = get_int();
 if (num < 1 || num > NutrientCount) return;
 rank_foods(num - 1,opt);
 }
}

void rank_foods(int num, int opt)
{
int count, max, junk, displayed = 0;
float abacus[FoodCount];
struct food *food_ptr = &food_root;
char head[80] = "NUT:  Foods Ranked by Percentage of ";
char thisname[63];
float theseounces;
strncat(head,Nutrient[num],strlen(Nutrient[num])-1);
if (opt == 0) strcat(head," RDI per 100 Calories");
if (opt == 1) strcat(head," RDI per 100 Grams (3.5 oz)");
if (opt == 2) strcat(head," RDI per Serving");
if (num == 0 && opt == 0)
 {
 header(head); 
 printf("These rankings are percentages of the RDI per 100 calories, to identify the\n");
 printf("foods which provide a high daily percentage of a nutrient with a low daily\n");
 printf("percentage of calories.  Thus, calories are not ranked.\n");
 spacer(3);
 printf("\nPress <enter> to continue...  ");
 junk = get_int();
 return;
 } 
if (opt == 0) for (count = 0 ; count < FoodCount ; count++) 
 {
 food_ptr = food_ptr->next;
 if (food_ptr->nutrient[0] != 0) abacus[count] = (10000 * food_ptr->nutrient[num]) / (food_ptr->nutrient[0] * Rdi[num]);
 else abacus[count] = 0;
 }
if (opt == 1) for (count = 0 ; count < FoodCount ; count++) 
 {
 food_ptr = food_ptr->next;
 abacus[count] = (10000 * food_ptr->nutrient[num]) / (food_ptr->grams * Rdi[num]);
 }
if (opt == 2) for (count = 0 ; count < FoodCount ; count++) 
 {
 food_ptr = food_ptr->next;
 abacus[count] = 100 * food_ptr->nutrient[num] / Rdi[num];
 }
junk = 'm';
while (displayed <= (FoodCount - 20) && (junk == 'm' || junk == 'M'))
 {
 header(head); 
 for (count = 0; count < 20; count++)
  {
  max = max_array(abacus);
  food_ptr = food_number(max);
  strncpy(thisname,food_ptr->name,60); thisname[60] = '\0';
  if (opt == 0)
   {
   theseounces = 100 * food_ptr->grams / food_ptr->nutrient[0] / 28.35 ; 
   printf("%-60s    %6.1f oz %5.0f%%\r",thisname,theseounces,abacus[max]);
   }
  if (opt == 1) printf("%-60s              %5.0f%%\r",thisname,abacus[max]);
  if (opt == 2) printf("%-60s    %6.1f oz %5.0f%%\r",thisname,food_ptr->grams / 28.35,abacus[max]);
  abacus[max] = 0;
  }
 displayed += 20;
 printf("\nPress \"m\" for more (or just <enter> to quit)...  ");
 junk = get_char();
 }
}

int max_array(float abacus[])
{
int count, i = 1;
for ( count = 2 ; count <= FoodCount ; count++ ) if (abacus[count] > abacus[i]) i = count;
return i;
}
