/* prtmenu.c */

/*
    Nut nutrition software 
    Copyright (C) 1998 Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "prtmenu.h"
#include "food.h"
#include "util.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void print_menus()
{
FILE *fp;
struct food *meal_ptr = &meal_root;
int firstpage = 1;
char last_meal_date[7], last_meal = '0';
if (meal_ptr->next == NULL)
 {
 header("NUT:  Print Menus from Meal Database");
 spacer(0);
 printf("\nThere are no meals in database.  Press <enter> to continue..."); 
 firstpage = get_int();
 return;
 }
if ((fp = fopen("nut.menus","w")) == NULL)
 {
 printf("Can't open file \"nut.menus\" to write.\n");
 printf("Press <enter> to continue...");
 firstpage = get_int();
 return;
 }
strcpy(last_meal_date,"");
while (meal_ptr->next != NULL)
 {
 meal_ptr = meal_ptr->next;
 if (strcmp(last_meal_date,meal_ptr->meal_date) != 0 || last_meal != meal_ptr->meal)
  {
  strcpy(last_meal_date,meal_ptr->meal_date);
  last_meal = meal_ptr->meal;
  if (firstpage == 1)
   {
   firstpage = 0;
   fprintf(fp,"Meal Date:  %s                                               Meal Number:  %d\n\n",last_meal_date,last_meal);
   } 
  else fprintf(fp,"\nMeal Date:  %s                                               Meal Number:  %d\n\n",last_meal_date,last_meal);
  }
 fprintf(fp,"%4.0f gm or %4.1f oz %-60s\n",meal_ptr->grams,meal_ptr->grams / 28.35,meal_ptr->name);
 }
fclose(fp);
header("NUT:  Print Menus from Meal Database");
spacer(0);
printf("\nMenus printed to \"nut.menus\".  Press <enter> to continue..."); 
firstpage = get_int();
return;
}
