/* options.c */

/*
    Nut nutrition software 
    Copyright (C) 1998 Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "options.h"
#include "food.h"
#include "util.h"
#include "db.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

struct opt options = {2000,-1};

void personal_cal()
{
float buf = 0;
int junk;
header("NUT:  Set Personal Calorie Level");
spacer(0);
printf("\nCalorie level is set to %0.0f.  Type new level (just <enter> for default):  ",Rdi[0]);
get_cals(&buf);
if (buf <= 0)
 {
 buf = 2000;
 Rdi[0] = RdiBase[0];
 Rdi[2] = RdiBase[2];
 Rdi[3] = RdiBase[3];
 Rdi[4] = RdiBase[4];
 Rdi[25] = RdiBase[25];
 Rdi[26] = RdiBase[26];
 Rdi[27] = RdiBase[27];
 Rdi[29] = RdiBase[29];
 Rdi[30] = RdiBase[30];
 options.calopt = RdiBase[0];
 }
else if (buf > 0 && buf <= 100) buf = 100;
else if (buf > 9999) buf = 9999;
buf /= RdiBase[0];
Rdi[0] = buf * RdiBase[0];
Rdi[2] = buf * RdiBase[2];
Rdi[3] = buf * RdiBase[3];
Rdi[4] = buf * RdiBase[4];
Rdi[25] = buf * RdiBase[25];
Rdi[26] = buf * RdiBase[26];
Rdi[27] = buf * RdiBase[27];
Rdi[29] = buf * RdiBase[29];
Rdi[30] = buf * RdiBase[30];
options.calopt = Rdi[0];
write_options_db();
header("NUT:  Set Personal Calorie Level");
printf("\n      New Nutrient Levels:    %-13s %6.1f %-s\n",Nutrient[0],Rdi[0],RdiUnit[0]);
printf("                              %-13s %6.1f %-s\n",Nutrient[3],Rdi[3],RdiUnit[3]);
printf("                              %-13s %6.1f %-s\n",Nutrient[4],Rdi[4],RdiUnit[4]);
printf("                              %-13s %6.1f %-s\n",Nutrient[2],Rdi[2],RdiUnit[2]);
printf("                              %-13s %6.1f %-s\n",Nutrient[25],Rdi[25],RdiUnit[25]);
printf("                              %-13s %6.1f %-s\n",Nutrient[26],Rdi[26],RdiUnit[26]);
printf("                              %-13s %6.1f %-s\n",Nutrient[27],Rdi[27],RdiUnit[27]);
printf("                              %-13s %6.1f %-s\n",Nutrient[29],Rdi[29],RdiUnit[29]);
printf("                              %-13s %6.1f %-s\n",Nutrient[30],Rdi[30],RdiUnit[30]);
spacer(10);
printf("\nPress <enter> to continue...");
junk = get_int();
}

void get_cals(float *cals)
{
char buff[128];
gets(buff);
*cals = (float) atof(buff);
}

void auto_del()
{
char buf[128];
int junk;
header("NUT:  Automatic Deletion of Meals");
spacer(0);
printf("\nDo you want to have meals deleted automatically from database?  (y/n):  ");
junk = get_char();
if (junk != 'Y' && junk != 'y' && junk != 'N' && junk != 'n') return;
if (junk != 'Y' && junk != 'y')
 {
 header("NUT:  Automatic Deletion of Meals");
 spacer(0);
 options.delopt = -1;
 write_options_db();
 printf("\nMeals will not be deleted automatically.  Press <enter> to continue...");
 junk = get_int();
 return;
 }
junk = 0;
header("NUT:  Automatic Deletion of Meals");
spacer(0);
printf("\nHow many meals should be kept in database?  "); 
while (junk < 1)
 {
 get_string(buf,127);
 junk = atoi(buf);
 if (junk > 0)
  {
  options.delopt = junk;
  write_options_db();
  delete_meals(options.delopt);
  write_meal_db();
  header("NUT:  Automatic Deletion of Meals");
  spacer(0);
  if (junk == 1) printf("\n%d meal will be kept in database.  Press <enter> to continue...",junk); 
  else printf("\n%d meals will be kept in database.  Press <enter> to continue...",junk); 
  junk = get_int();
  return;
  }
 header("NUT:  Automatic Deletion of Meals");
 spacer(0);
 printf("\nMust keep at least one meal in database.  How many?  ");
 }
}
