/*
   FreeLaunch InstallationDll header (c) Thomas Blummer 1995
   $Id: frldll.h 1.2 1995/03/09 22:28:22 thomas Exp $
*/
#ifndef _FRLDLL_
#define _FRLDLL_

#define INCL_WIN
#include <os2.h>

/*
**      This entry is called by FreeLaunch
**      Parameters :
**                hab : Anchor Block
**                frame : Window handle of the top level frame
**                state : one of the FLST_ macros below
**                dir : installation directory
**                param : additional parameter to the state if required.
**      Return Values :
**              TRUE : all right.
**              FALSE : see per state below.
*/ 

BOOL _System frlentry (HAB hab, HWND frame, ULONG state, const char *dir, ULONG param);

typedef BOOL (_System FRLENTRY)(HAB, HWND, ULONG, const char *, ULONG);
typedef FRLENTRY *PFRLENTRY;

/* 
** frlentry is called with this state AFTER FreeLaunch completed
** the installation procedure.
** This entry is NOT called if FreeLaunch failed to install the product.
** const char *dir : ASCIZ destination directory
** ULONG param : combination of the FLP_ macros below
** Return value : no matter.
*/
#define FLST_INSTALLDONE 1


/*
** flrentry is called with this state BEFORE FreeLaunch attempts to remove the product. 
** const char *dir : ASCIZ installation directory
** ULONG param : combination of the FLDONE_ macros
** return value : FALSE stop removal.
*/
#define FLST_REMOVESTART 2

/*
** Macros for param
** they represent the options the user requested.
*/
#define FLP_CONFIG     0x00000001
#define FLP_DESKTOP    0x00000002
#define FLP_INI        0x00000004
#define FLP_ALLFILES   0x00000008
#define FLP_OLDERFILES 0x00000010
#define FLP_KEEPFILES  0x00000020

#endif /* _FRLDLL_ */
