# Makefile for FreeLaunch 1.2
# (c) Thomas Blummer 1995
#

# destination old creates the Tester and the runtime Moduls
# with and without Info-Unzip
# The executables frltest.exe frlrun.exe and frlsrun.exe are
# runnable on every OS/2 Versions >= 2.0 including Warp 3.0
old : frltest.exe frlrun.exe frlsrun.exe

all : old warp dll

# executables created by this destination frlwrun.exe frlswrun.exe
# are runnable ONLY on OS/2 Warp 3.0 (and hopefully above)
warp : frlwrun.exe frlswrun.exe

dll : frldll.dll

frldll.dll : frldll.c frldll.def
	icc /Q /Gm /Ge- frldll.c /B/BATCH frldll.def

frltest.exe : frl.rc dialog.dlg resource.h dialog.h
	rc -x frl.rc $@

frlrun.exe : install.res
	rc -x $? $@ >nul

frlsrun.exe : install.res
	rc -x $? $@ >nul

# for Warp I am using the new -x2 flag of the resource compiler
# distributed in warp. It does a better compression than the older
# versions. 
frlwrun.exe : install.res
	rc -x2 $? $@ >nul

frlswrun.exe : install.res
	rc -x2 $? $@ >nul

install.res : install.rc frl.rc dialog.dlg resource.h dialog.h
	rc -r install.rc >nul

install.rc : install.scr
	frlcomp

