Public MustInherit Class WaveStream
    'Clase Base Abstracta para la definicin de cualquier Stream de onda de sonido
    'Se supone que en todas las clases derivadas podemos leer y escribir como si de un
    'Stream cualquiera se tratara.

    Inherits System.IO.Stream

    'Formatos soportados por el momento
    Public Enum Format
        WAV = 0
        VOC = 1
    End Enum

    'Gracias a esta funcin evitaremos tener que crear cada instancia mirando formato por formato
    'Usamos siempre la misma funcin y trabajamos con la clase abstracta
    Public Shared Function CreateWaveStream(ByVal File As System.IO.Stream, ByVal FileMode As System.IO.FileMode, ByVal Format As Format) As WaveStream
        If (Format = Format.VOC) Then
            Return New VOCStream(File, FileMode)
        ElseIf (Format = Format.WAV) Then
            Return New WavStream(File, FileMode)
        End If
    End Function
End Class
