Public Class WavStream
    Inherits WaveStream

    Private Structure WaveFragment
        Dim Begin As Long
        Dim BeginInOrigin As Long
        Dim Length_Position As Long
        Dim Length As Long
        Dim Format As Byte
        Dim Channels As Byte
        Dim Rate As Integer
    End Structure

    Public GLobalChunkSize As Integer
    Private _Length As Long = 0
    Private _Position As Long = 0

    Public Class WaveException
        Inherits System.Exception
        Private _inner As System.Exception
        Private _m As String
        Public Sub New(ByVal m As String, ByVal Inner As System.Exception)
            'Me.InnerExcepti()
            _inner = Inner
            _m = m
        End Sub

        Public Overrides Function GetBaseException() As Exception
            Return _inner
        End Function

        Public Overrides Function ToString() As String
            Return _m
        End Function

    End Class

    Private OS As System.IO.Stream = Nothing
    Private Readable As Boolean = False
    Private Writable As Boolean = False
    Private Fragments As ArrayList

    Public Sub New(ByVal OrigStream As System.IO.Stream, ByVal Mode As System.IO.FileMode)
        OS = OrigStream
        If Not OS.CanSeek Then
            Throw New System.IO.IOException("VocStream requires seekable stream")
        End If
        If OS.CanRead Then
            Readable = True
        End If
        If OS.CanWrite And Not Mode = IO.FileMode.Open Then
            Writable = True
        End If

        '----------------------------------------------
        Readable = False
        If OS.Length <> 0 Then Writable = False

        'TODO: An no tengo soporte de escritura en VOC
        'Tan solo puedo crear archivos nuevos

        If Not Readable And Not Writable Then
            Throw New System.IO.IOException("VocStream requires readable or writable stream")
        End If


        Try
            StartWaveStructure()
        Catch e As Exception
            Throw New WaveException("Bad Voc Stream", e)
        End Try
    End Sub

    Private PositionTotalCount As Long = 0
    Private GlobalAudioFormat As Short = 1 'Por defecto PCM
    Private GlobalNumChannels As Short = 1 'Por defecto mono
    Public BitsPerSample As Short = 8 'Por defecto, 8 bits
    Public SampleRate As Integer = 44100 'Por defecto, calidad CD

    Private Sub StartWaveStructure()
        Dim a As Integer
        Dim Frag As WaveFragment
        'OS.Read(Description, 0, VOCHeader.Length)
        If (OS.Length = 0) Then
            'Archivo nuevo
            'Creamos la estructura de 0

            'CABECERA INICIAL
            UtilStream.WriteString(OS, "RIFF")
            PositionTotalCount = OS.Position
            UtilStream.WriteInteger(OS, 0)
            UtilStream.WriteString(OS, "WAVE")
            'CABECERA INICIAL

            'Primer (y nico soportado) bloque
            'Primer subloque "format"
            UtilStream.WriteString(OS, "fmt ")
            UtilStream.WriteInteger(OS, 16)
            UtilStream.WriteShort(OS, GlobalAudioFormat)
            UtilStream.WriteShort(OS, GlobalNumChannels)
            UtilStream.WriteInteger(OS, Me.SampleRate)
            'Byte Rate
            UtilStream.WriteInteger(OS, Me.SampleRate * Me.GlobalNumChannels * Me.BitsPerSample / 8)
            UtilStream.WriteShort(OS, GlobalNumChannels * Me.BitsPerSample / 8)
            UtilStream.WriteShort(OS, Me.BitsPerSample)
            'Primer subloque "format" finalizado

            'Subloque "data"
            UtilStream.WriteString(OS, "data")
            Frag.Length_Position = OS.Position
            UtilStream.WriteInteger(OS, 0)
            'Posicin. De momento 0
            Fragments = New ArrayList()
            Fragments.Add(Frag)

        Else

        End If
    End Sub



    Public Overrides Sub Flush()

    End Sub

    Public Overrides Function Read(ByVal buffer() As Byte, ByVal offset As Integer, ByVal count As Integer) As Integer
        Throw New WaveException("Read not implemented", Nothing)
    End Function

    Public Overrides Function Seek(ByVal offset As Long, ByVal origin As System.IO.SeekOrigin) As Long
        Throw New WaveException("TODO Seek ", Nothing)
    End Function

    Public ActualFragment As Integer = 0

    Public Overrides Sub Write(ByVal buffer() As Byte, ByVal offset As Integer, ByVal count As Integer)
        OS.Write(buffer, offset, count)
        _Length += count
        _Position += count
        Dim Frag As WaveFragment = Fragments.Item(ActualFragment)
        Frag.Length += count
    End Sub

    Public Overrides ReadOnly Property CanRead() As Boolean
        Get
            Return False
        End Get
    End Property

    Public Overrides ReadOnly Property CanWrite() As Boolean
        Get
            Return True
        End Get
    End Property

    Public Overrides ReadOnly Property CanSeek() As Boolean
        Get
            Return True
        End Get
    End Property

    Public Overrides ReadOnly Property Length() As Long
        Get
            Return _Length
        End Get
    End Property

    Public Overrides Property Position() As Long
        Get
            Return _Position
        End Get
        Set(ByVal Value As Long)
            Me.Seek(Value, IO.SeekOrigin.Begin)
        End Set
    End Property

    Public Overrides Sub SetLength(ByVal value As Long)
        Throw New WaveException("Truncate not implemented", Nothing)
    End Sub

    Public Overrides Sub Close()
        Dim frag As WaveFragment = Fragments.Item(ActualFragment)
        OS.Seek(frag.Length_Position, IO.SeekOrigin.Begin)
        UtilStream.WriteInteger(OS, _Length)
        OS.Seek(PositionTotalCount, IO.SeekOrigin.Begin)
        UtilStream.WriteInteger(OS, _Length + 36)
        OS.Close()
    End Sub
End Class