Public Class VOCStream
    Inherits WaveStream

    Private Structure VocFragment
        Dim Begin As Long
        Dim BeginInOrigin As Long
        Dim Length As Long
        Dim Format As Byte
        Dim Channels As Byte
        Dim Rate As Integer
    End Structure

    Public Class VocException
        Inherits System.Exception
        Private _inner As System.Exception
        Private _m As String
        Public Sub New(ByVal m As String, ByVal Inner As System.Exception)
            'Me.InnerExcepti()
            _inner = Inner
            _m = m
        End Sub

        Public Overrides Function GetBaseException() As Exception
            Return _inner
        End Function

        Public Overrides Function ToString() As String
            Return _m
        End Function

    End Class

    Private OS As System.IO.Stream = Nothing
    Private Readable As Boolean = False
    Private Writable As Boolean = False

    Public Sub New(ByVal OrigStream As System.IO.Stream, ByVal Mode As System.IO.FileMode)
        OS = OrigStream
        If Not OS.CanSeek Then
            Throw New System.IO.IOException("VocStream requires seekable stream")
        End If
        If OS.CanRead Then
            Readable = True
        End If
        If OS.CanWrite And Not Mode = IO.FileMode.Open Then
            Writable = True
        End If
        '----------------------------------------------
        Writable = False
        'TODO: An no tengo soporte de escritura en VOC

        If Not Readable And Not Writable Then
            Throw New System.IO.IOException("VocStream requires readable or writable stream")
        End If
        Try
            StartVocStructure()
            _Position = 0
        Catch e As Exception
            OS = Nothing
            Throw New VocException("Bad Voc Stream", e)
        End Try
    End Sub

    Private Description As String
    Private DataBlockOffset As Short
    Private Version As Short
    Private IDCode As Short
    Private Fragments As ArrayList
    Private _Length As Long
    Private _Position As Long

    Private Const VOCHeader = "Creative Voice File" & Chr(&H1A)

    Private Function UnifiedFormat(ByVal Format As Integer, ByVal BlockType As Integer, Optional ByVal BitsPerSample As Integer = -1) As Integer
        'Se supone que esta funcin estandarza la representacin de formato
        'De momento la uso para limitar a format PCM 8 bit
        If (Format = 0) And (BlockType = 1) Then
            Return 0
        ElseIf (Format = 0) And (BlockType = 9) And (BitsPerSample = 8) Then
            Return 0
        Else
            Throw New VocException("Unimplemented block format", Nothing)
        End If
    End Function


    Private Sub StartVocStructure()
        Dim a As Integer
        Dim Frag As VocFragment
        'OS.Read(Description, 0, VOCHeader.Length)
        Description = UtilStream.ReadString(OS, VOCHeader.Length)
        If (Description <> VOCHeader) Then
            Throw New VocException("Bad Voc File", Nothing)
        End If
        DataBlockOffset = UtilStream.ReadShort(OS)
        Version = UtilStream.ReadShort(OS)
        IDCode = UtilStream.ReadShort(OS)
        If ((Version <> &H10A) And (Version <> &H114)) Then
            Throw New VocException("Unknown Version", Nothing)
        ElseIf ((((Version Xor 65535) + &H1234) Mod 65536) <> IDCode) Then
            Throw New VocException("Bad Header", Nothing)
        End If
        OS.Seek(DataBlockOffset, IO.SeekOrigin.Begin)

        Dim BlockType As Integer
        Dim Length As Long
        Dim SampleRate As Long
        Dim BitsPerSample As Byte
        Dim Channel As Byte
        Fragments = New ArrayList()
        _Length = 0
        Do While (OS.Position < OS.Length)
            BlockType = 0
            BlockType = UtilStream.ReadByte(OS)
            Dim Format As Byte
            Dim Tc As Byte

            If (BlockType = 0) Then
                Exit Do
            ElseIf (BlockType = 1) Then
                Length = UtilStream.ReadInt24(OS)
                Tc = UtilStream.ReadByte(OS)
                Format = UtilStream.ReadByte(OS)
                SampleRate = 1000000 / (256 - Tc)
                Length = Length - 2
                Channel = 1
            ElseIf (BlockType = 2) Then
                Length = UtilStream.ReadInt24(OS)
                'Length = Length - 2
                'Channel = 1
            ElseIf (BlockType = 9) Then
                Length = UtilStream.ReadInt24(OS)
                SampleRate = UtilStream.ReadInteger(OS)
                BitsPerSample = UtilStream.ReadByte(OS)
                Channel = UtilStream.ReadByte(OS)
                Format = UtilStream.ReadShort(OS)
                Length = Length - 12
            Else
                Throw New VocException("Unsupported Block Format", Nothing)
            End If
            Frag.BeginInOrigin = OS.Position
            Frag.Begin = _Length
            Frag.Length = Length
            _Length = _Length + Length
            Frag.Format = Format
            Frag.Rate = SampleRate
            Frag.Channels = Channel
            Fragments.Add(Frag)
            OS.Seek(Length, IO.SeekOrigin.Current)
        Loop
        Frag = Fragments.Item(0)
        OS.Seek(Frag.BeginInOrigin, IO.SeekOrigin.Begin)
        _Position = 0
    End Sub

    Public Overrides Sub Flush()
        OS.Flush()
    End Sub

    Public Overrides Function Read(ByVal buffer() As Byte, ByVal offset As Integer, ByVal count As Integer) As Integer
        If (Not Readable) Then Throw New System.IO.IOException("Not readable stream")
        If _Position >= _Length Then Return 0 'Estamos al final del Stream
        'El STream est marcado como no legible
        Dim FragPosition As Integer = SearchFragment(OS.Position, True)
        'Contiene el ndice del fragmento en el que estamos
        If (FragPosition = -1) Then Return 0
        'Ups. Ya llegamos al final. Lo siento. No hay datos a leer.
        Dim Frag As VocFragment = Fragments.Item(FragPosition)
        'Fragmento del VOC en el que estamos
        Dim Readed As Integer = 0 'Cuanto hemos leido?
        Dim Desplaz As Integer = OS.Position - Frag.BeginInOrigin
        'Posicin dentro del bloque a leer
        Dim BloqSize As Integer 'Variable para guardar el tamao de bloque
        Do  'Otro bucle con salida al medio ;-)
            BloqSize = Frag.Length - Desplaz
            If BloqSize > count Then BloqSize = count
            'Puede que nos queden ms bytes por contar que los que
            'dispone el bloque
            OS.Read(buffer, offset, BloqSize)
            'Copiamos lo que tenemos
            count -= BloqSize      'Nos queda menos por copiar
            offset += BloqSize     'Avanzamos el offset para la siguiente copia
            _Position += BloqSize  'Avanzamos la posicin virtual en nuestro Stream
            Readed += BloqSize     'Incrementamos el contador de lo leido
            If (Desplaz + BloqSize) = Frag.Length Then 'Si estamos al final de un bloque
                FragPosition += 1 'Avanzamos al siguiente bloque
                If FragPosition = Fragments.Count Then Exit Do
                'Ups. ltimo bloque. Salidos. Hemos hecho lo que hemos podido
                Frag = Fragments.Item(FragPosition)
                'Sigamos al siguiente bloque
                OS.Seek(Frag.BeginInOrigin, IO.SeekOrigin.Begin)
                'Avanzamos de posicin en el Stream real.
                Desplaz = 0
                'El desplazamiento dentro del nuevo fragmento es 0
            End If
            If (count = 0) Then Exit Do 'Genial. Hemos leido lo que nos han pedido
        Loop
        Return Readed
    End Function

    Private Function SearchFragment(ByVal Position As Long, ByVal Original As Boolean) As Integer
        'Dada una posicin en el VOC buscamos el fragmento que 
        'lo contiene.
        'Podemos buscar segun la posicin en el Stream Origen o por
        'la posicion en nuestro Stream
        'Retornamos -1 en caso de no encontrarlo

        Dim Frag As VocFragment
        Dim FragPosition As Integer = 0
        Do 'Bucle con salida al medio
            Frag = Fragments.Item(FragPosition)
            If (Original) Then
                If (Frag.BeginInOrigin <= Position) And ((Frag.BeginInOrigin + Frag.Length) > Position) Then
                    'Si cumple esta condicin es que estamos en el bloque actual
                    Exit Do 'Y salimos
                End If
            Else
                If (Frag.Begin >= Position) And ((Frag.Begin + Frag.Length) < Position) Then
                    'Si cumple esta condicin es que estamos en el bloque actual
                    Exit Do 'Y salimos
                End If
            End If

            FragPosition += 1 'A ver que tal el siguiente
            If FragPosition = Fragments.Count Then Return -1
            'Ups. Ya llegamos al final. Lo siento. No hay datos a leer.
        Loop
        Return FragPosition
    End Function

    Public Overrides Function Seek(ByVal offset As Long, ByVal origin As System.IO.SeekOrigin) As Long
        Dim Position As Long
        If (origin = IO.SeekOrigin.Begin) Then
            Position = 0
        ElseIf (origin = IO.SeekOrigin.Current) Then
            Position = _Position
        Else
            Position = _Length
        End If
        Position += offset
        If (Position > _Length) Or (Position < 0) Then
            Throw New VocException("Bad Seek", Nothing)
        End If

        Dim Frag As VocFragment
        If (Position = _Length) Then
            'Estamos justo al final del stream
            Frag = Fragments.Item(Fragments.Count - 1)
            OS.Seek(Frag.BeginInOrigin + Frag.Length, IO.SeekOrigin.End)
        Else
            Frag = Fragments.Item(SearchFragment(Position, False))
            OS.Seek(Frag.BeginInOrigin + (Position - Frag.Begin), IO.SeekOrigin.Begin)
        End If

        _Position = Position 'Guardamos la posicin actual
        Return _Position
    End Function

    Public Overrides Sub Write(ByVal buffer() As Byte, ByVal offset As Integer, ByVal count As Integer)
        If (Not Writable) Then Throw New System.IO.IOException("Not writable stream")
    End Sub

    Public Overrides ReadOnly Property CanRead() As Boolean
        Get
            Return Readable
        End Get
    End Property

    Public Overrides ReadOnly Property CanWrite() As Boolean
        Get
            Return Writable
        End Get
    End Property

    Public Overrides ReadOnly Property CanSeek() As Boolean
        Get
            Return True
        End Get
    End Property

    Public Overrides ReadOnly Property Length() As Long
        Get
            Return _Length
        End Get
    End Property

    Public Overrides Property Position() As Long
        Get
            Return _Position
        End Get
        Set(ByVal Value As Long)
            Seek(Value, IO.SeekOrigin.Begin)
        End Set
    End Property

    Public Overrides Sub SetLength(ByVal value As Long)
        If (Not Writable) Then Throw New System.IO.IOException("Not readable stream")
        'Futuro cdigo para truncar
    End Sub

    Public Overrides Sub Close()
        If (IsNothing(OS)) Then Return
        OS.Close()
        OS = Nothing
    End Sub
End Class