Public Class UtilStream

    Public Shared Function ReadByte(ByVal S As System.IO.Stream) As Byte
        Dim d(1) As Byte
        S.Read(d, 0, 1)
        Return d(0)
    End Function

    Public Shared Function ReadChar(ByVal S As System.IO.Stream) As Char
        Dim d(1) As Byte
        S.Read(d, 0, 1)
        Return Chr(d(0))
    End Function

    Public Shared Function ReadShort(ByVal S As System.IO.Stream) As Short
        Dim d(2) As Byte
        S.Read(d, 0, 2)
        Return d(0) + d(1) * 256
    End Function

    Public Shared Function ReadInt24(ByVal S As System.IO.Stream) As Integer
        Dim d(3) As Byte
        S.Read(d, 0, 3)
        Return d(0) + d(1) * 256 + d(2) * 256 * 256
    End Function

    Public Shared Function ReadInteger(ByVal S As System.IO.Stream) As Integer
        Dim d(4) As Byte
        S.Read(d, 0, 4)
        Return d(0) + d(1) * 256 + d(2) * 256 * 256 + d(3) * 256 * 256 * 256
    End Function

    Public Shared Function ReadLong(ByVal S As System.IO.Stream) As Long
        Dim d(8) As Byte
        S.Read(d, 0, 8)
        Return d(0) + d(1) * 256 + d(2) * 256 * 256 + d(3) * 256 * 256 * 256 + d(4) * 256 * 256 * 256 * 256 + _
        d(5) * 256 * 256 * 256 * 256 * 256 + d(6) * 256 * 256 * 256 * 256 * 256 * 256 + d(7) * 256 * 256 * 256 * 256 * 256 * 256 * 256
    End Function

    Public Shared Function ReadString(ByVal S As System.IO.Stream, Optional ByVal Size As Integer = -1) As String
        Dim d() As Byte
        Dim a As Integer
        Dim st As String
        If (Size > 0) Then
            d = Array.CreateInstance(GetType(Byte), Size)
            S.Read(d, 0, Size)
            For a = 0 To Size - 1
                st = st + Chr(d(a))
            Next
        Else
            Array.CreateInstance(GetType(Byte), 1)
            Do
                S.Read(d, 0, 1)
                If d(0) = 0 Then Exit Do
                st = st + Chr(d(0))
            Loop
        End If
        Return st
    End Function

    Public Shared Function ReadData(ByVal S As System.IO.Stream, ByVal Length As Integer) As Byte()
        Dim d() As Byte
        d.CreateInstance(GetType(Byte), Length)
        ReadData(S, Length, d)
        Return d
    End Function

    Public Shared Sub ReadData(ByVal S As System.IO.Stream, ByVal Length As Integer, ByVal data As Byte())
        S.Read(data, 0, Length)
    End Sub

    Public Shared Sub WriteString(ByVal S As System.IO.Stream, ByVal Str As String)
        Dim d() As Byte
        Dim a As Integer
        Dim st As String
        If (Str.Length > 0) Then
            d = Array.CreateInstance(GetType(Byte), Str.Length)
            For a = 0 To Str.Length - 1
                d(a) = Asc(Str.Chars(a))
            Next
            S.Write(d, 0, d.Length)
        End If
    End Sub

    Public Shared Sub WriteShort(ByVal S As System.IO.Stream, ByVal I As Short)
        S.WriteByte(I Mod 256)
        S.WriteByte(I \ 256)
    End Sub

    Public Shared Sub WriteInteger(ByVal S As System.IO.Stream, ByVal I As Integer)
        S.WriteByte(I Mod 256)
        S.WriteByte((I \ 256) Mod 256)
        S.WriteByte((I \ (256 * 256)) Mod 256)
        S.WriteByte(I \ (256 * 256 * 256))
    End Sub
End Class
