Public Class WavePerfect
    Inherits System.Windows.Forms.Form

#Region " Cdigo generado por el Diseador de Windows Forms "

    Public Sub New()
        MyBase.New()

        'El Diseador de Windows Forms requiere esta llamada.
        InitializeComponent()

        'Agregar cualquier inicializacin despus de la llamada a InitializeComponent()

    End Sub

    'Form reemplaza a Dispose para limpiar la lista de componentes.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Requerido por el Diseador de Windows Forms
    Private components As System.ComponentModel.IContainer

    'NOTA: el Diseador de Windows Forms requiere el siguiente procedimiento
    'Puede modificarse utilizando el Diseador de Windows Forms. 
    'No lo modifique con el editor de cdigo.
    Friend WithEvents TextBox1 As System.Windows.Forms.TextBox
    Friend WithEvents Button1 As System.Windows.Forms.Button
    Friend WithEvents TextBox2 As System.Windows.Forms.TextBox
    Friend WithEvents Button2 As System.Windows.Forms.Button
    Friend WithEvents OK As System.Windows.Forms.Button
    Friend WithEvents Label1 As System.Windows.Forms.Label
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.TextBox1 = New System.Windows.Forms.TextBox()
        Me.Button1 = New System.Windows.Forms.Button()
        Me.TextBox2 = New System.Windows.Forms.TextBox()
        Me.Button2 = New System.Windows.Forms.Button()
        Me.OK = New System.Windows.Forms.Button()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.SuspendLayout()
        '
        'TextBox1
        '
        Me.TextBox1.Location = New System.Drawing.Point(40, 56)
        Me.TextBox1.Name = "TextBox1"
        Me.TextBox1.Size = New System.Drawing.Size(280, 22)
        Me.TextBox1.TabIndex = 0
        Me.TextBox1.Text = ""
        '
        'Button1
        '
        Me.Button1.Location = New System.Drawing.Point(336, 56)
        Me.Button1.Name = "Button1"
        Me.Button1.Size = New System.Drawing.Size(24, 24)
        Me.Button1.TabIndex = 1
        Me.Button1.Text = "..."
        '
        'TextBox2
        '
        Me.TextBox2.Location = New System.Drawing.Point(40, 112)
        Me.TextBox2.Name = "TextBox2"
        Me.TextBox2.Size = New System.Drawing.Size(280, 22)
        Me.TextBox2.TabIndex = 2
        Me.TextBox2.Text = ""
        '
        'Button2
        '
        Me.Button2.Location = New System.Drawing.Point(336, 112)
        Me.Button2.Name = "Button2"
        Me.Button2.Size = New System.Drawing.Size(24, 24)
        Me.Button2.TabIndex = 3
        Me.Button2.Text = "..."
        '
        'OK
        '
        Me.OK.Location = New System.Drawing.Point(112, 168)
        Me.OK.Name = "OK"
        Me.OK.Size = New System.Drawing.Size(160, 24)
        Me.OK.TabIndex = 4
        Me.OK.Text = "&Convertir"
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(80, 144)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(232, 16)
        Me.Label1.TabIndex = 5
        '
        'WavePerfect
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(6, 15)
        Me.ClientSize = New System.Drawing.Size(408, 215)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.Label1, Me.OK, Me.Button2, Me.TextBox2, Me.Button1, Me.TextBox1})
        Me.Name = "WavePerfect"
        Me.Text = "WavePerfect"
        Me.ResumeLayout(False)

    End Sub

#End Region

    Public FileIn As String = ""
    Public FileOut As String = ""

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim OF As OpenFileDialog = New OpenFileDialog()
        Dim Res As DialogResult
        OF.AddExtension = True
        OF.DefaultExt = "voc"
        OF.Filter = "Formatos de sonido(*.VOC)|*.VOC"
        'OF.
        Res = OF.ShowDialog()
        If (Res <> DialogResult.OK) Then Return
        TextBox1.Text = OF.FileName
    End Sub


    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Dim OF As SaveFileDialog = New SaveFileDialog()
        Dim Res As DialogResult
        OF.AddExtension = True
        OF.DefaultExt = "wav"
        OF.Filter = "Formatos de sonido(*.WAV)|*.WAV"
        Res = OF.ShowDialog()
        If (Res <> DialogResult.OK) Then Return
        TextBox2.Text = OF.FileName
    End Sub


    Private SoundIn As WaveStream
    Private SoundOut As WaveStream

    Private TotalReaded As Long = 0

    Public Sub OnBackGround()
        Try
            SoundIn = WaveStream.CreateWaveStream(New System.IO.FileStream(TextBox1.Text, IO.FileMode.Open), IO.FileMode.Open, WaveStream.Format.VOC)
            SoundOut = WaveStream.CreateWaveStream(New System.IO.FileStream(TextBox2.Text, IO.FileMode.Create), IO.FileMode.Create, WaveStream.Format.WAV)
            Dim Buffer() As Byte
            Buffer = Array.CreateInstance(GetType(Byte), 4096)
            Dim Readed As Integer

            Dim InExit As Boolean = False
            Dim c1 As Integer
            Dim count As Integer = 0
            Dim mode As Integer = 1
            Dim b As Integer
            Do

                If (((c1 >= 128) And (mode = 1)) Or ((c1 < 128) And (mode = -1))) And Not InExit Then
                    count += 1
                ElseIf ((c1 < 128) And (mode = 1)) Or ((c1 >= 128) And (mode = -1)) Or InExit Then
                    If count > 200 Then
                        For b = 0 To count - 1
                            SoundOut.WriteByte(128)
                        Next
                    Else
                        For b = 0 To count - 1
                            SoundOut.WriteByte((120 * Math.Sin(Math.PI * b / count) * mode) + 128)
                        Next
                    End If
                    count = 1
                    mode *= -1
                End If
                If InExit Then Exit Do
                c1 = SoundIn.ReadByte()
                If (c1 < 0) Then InExit = True
                'SoundOut.WriteByte(c1)
                TotalReaded += 1
                If (TotalReaded Mod 10000) = 0 Then
                    h.CallMain(Me, "UpdatePercent", Nothing)
                End If
                'MsgBox(Buffer(0).ToString & Buffer(1).ToString & Buffer(2).ToString & Buffer(3).ToString)
            Loop
            SoundIn.Close()
            SoundOut.Close()
            MsgBox("Se leyeron " & TotalReaded.ToString & " bytes")
            MsgBox("Se escribieron " & SoundOut.Length & " bytes")
        Catch e As Exception
            MsgBox(e.Message)
        End Try

    End Sub

    Private LastValue As Integer = 0
    Public Sub UpdatePercent()
        Dim f As Integer = TotalReaded * 100 / SoundIn.Length
        If f <> LastValue Then
            Label1.Text = "Completado " & f.ToString() & "% "
            Label1.Refresh()
            LastValue = f
        End If

    End Sub

    Public Sub OnFinish()
        Button1.Enabled = True
    End Sub

    Dim h As MiHilo.Hilo

    Private Sub OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK.Click
        Button1.Enabled = False
        h = New MiHilo.Hilo(Me, "OnBackground", Nothing, Me, "OnFinish", Nothing)
        'OnBackGround()
    End Sub

End Class
