Imports System.Threading

Public Class Hilo

    Public Delegate Sub CallbackThread()

    Private Class GrupoLlamador
        Public Caller As Hilo = Nothing
        Public IsDelegate As Boolean = False
        Public CbT As CallbackThread = Nothing
        Public CallObject As Object
        Public CallNameMethod As String = ""
        Public CallParams() As Object
    End Class

    Private Shared HT As New Hashtable()
    Private Shared CallMainHT As New Hashtable()

    Private Shared WithEvents Temporizador As New Windows.Forms.Timer()
    Private Shared HTSem As New Semaphore(1)
    Private Shared TempSem As New Semaphore(1)
    Private CallMainLock As New Semaphore(0)
    Public Thread As Thread

    Private Shared Function CallMethod(ByVal ObjStart As Object, ByVal NameStart As String, ByVal StartArgs() As Object) As Boolean
        Try
            If IsNothing(StartArgs) Then
                CallByName(ObjStart, NameStart, CallType.Method)
            Else
                CallByName(ObjStart, NameStart, CallType.Method, StartArgs)
            End If
            'MsgBox("Retorno de llamada con xito")
            Return True
        Catch ex As System.MissingMemberException
            MsgBox("Error en parmetros de llamada a la hebra. (" & ex.Message & ")")
            Return False
        Catch ex As System.Reflection.TargetInvocationException
            MsgBox("Error en destino de llamada. (" & ex.Message & ")")
            Return False
        End Try

    End Function

    Private Shared Sub Monitor(ByVal sender As Object, ByVal e As System.EventArgs) Handles Temporizador.Tick
        Dim Hebra As Thread
        Dim Hilo As Hilo
        Dim d As GrupoLlamador

        HTSem.Decrement()

        TempSem.Decrement()
        Temporizador.Enabled = False
        TempSem.Increment()
        'AddHandler Temporizador.Tick, AddressOf Monitor
        'For Each permite realizar un bucle para cada elemento de
        ' una coleccin
        Dim ParaEliminar As New Collection()
        For Each Hebra In HT.Keys
            If (Hebra.ThreadState = ThreadState.Stopped Or Hebra.ThreadState = ThreadState.Aborted) Then
                d = HT.Item(Hebra)
                If d.IsDelegate Then
                    d.CbT.Invoke()
                Else
                    CallMethod(d.CallObject, d.CallNameMethod, d.CallParams)
                End If
                ParaEliminar.Add(Hebra) 'Retrasamos el borrado para que
                'no falle el "For Each"
            End If
        Next
        For Each Hebra In ParaEliminar
            HT.Remove(Hebra)
        Next
        ParaEliminar = New Collection()
        For Each Hilo In CallMainHT.Keys
            d = CallMainHT.Item(Hilo)
            If d.IsDelegate Then
                Try
                    d.CbT.Invoke()
                Catch
                End Try
            Else
                CallMethod(d.CallObject, d.CallNameMethod, d.CallParams)
            End If
            ParaEliminar.Add(Hilo) 'Retrasamos el borrado para que
            'no falle el "For Each"
        Next
        For Each Hilo In ParaEliminar
            CallMainHT.Remove(Hilo)
            Hilo.CallMainLock.Increment()
        Next
        If (HT.Count > 0) Then
            TempSem.Decrement()
            Temporizador.Enabled = True
            TempSem.Increment()
        End If
        HTSem.Increment()
    End Sub


    Public Shared Sub IniciarHilo(ByVal inicio As ThreadStart, ByVal Fin As CallbackThread)
        Dim NuevoHilo As Hilo

    End Sub


    Protected Shared Sub CopyArrayString(ByRef a() As String, ByRef b() As String)
        If Not IsNothing(a) Then
            b = Array.CreateInstance(GetType(String), a.Length())
            Array.Copy(a, b, a.Length)
        End If
    End Sub

    Private StartArgs() As String
    Private NameStart As String
    Private ObjectStart As Object

    Protected Sub StartNewThread()
        CopyArrayString(PassStartArgs, StartArgs)
        NameStart = PassNameStart
        ObjectStart = PassObjectStart
        SParams.Increment()

        CallMethod(ObjectStart, NameStart, StartArgs)
    End Sub

    Public Shared SEnter As New Semaphore(1)
    Public Shared SParams As New Semaphore()
    Private Shared PassStartArgs() As String
    Private Shared PassFinishArgs() As String
    Private Shared PassNameStart As String
    Private Shared PassNameFinish As String
    Private Shared PassObjectStart As Object
    Private Shared PassObjectFinish As Object

    Public Overloads Shared Sub CallMain(ByVal ObjectCall As Object, ByVal Name As String, ByVal Params() As Object)
        Dim MiHilo As Hilo
        Dim d As GrupoLlamador
        Dim NuevaLlamada As GrupoLlamador
        HTSem.Decrement()
        d = HT.Item(System.Threading.Thread.CurrentThread)
        MiHilo = d.Caller
        NuevaLlamada = New GrupoLlamador()
        NuevaLlamada.Caller = MiHilo
        NuevaLlamada.CallObject = ObjectCall
        NuevaLlamada.CallNameMethod = Name
        NuevaLlamada.CallParams = Params
        CallMainHT.Add(MiHilo, NuevaLlamada)
        HTSem.Increment()
        MiHilo.CallMainLock.Decrement()
    End Sub

    Public Overloads Shared Sub CallMain(ByVal CallM As CallbackThread)
        Dim MiHilo As Hilo
        Dim d As GrupoLlamador
        Dim NuevaLlamada As GrupoLlamador
        HTSem.Decrement()
        d = HT.Item(System.Threading.Thread.CurrentThread)
        MiHilo = d.Caller
        NuevaLlamada = New GrupoLlamador()
        NuevaLlamada.Caller = MiHilo
        NuevaLlamada.CbT = CallM
        NuevaLlamada.IsDelegate = True
        CallMainHT.Add(MiHilo, NuevaLlamada)
        HTSem.Increment()
        MiHilo.CallMainLock.Decrement()
    End Sub

    Private Sub NewPrivate(ByVal StartPair As GrupoLlamador, ByVal FinishPair As GrupoLlamador)
        Dim t As Threading.Thread
        If (Not Init) Then Initializate()
        TempSem.Decrement() 'Otro tanto con el temporizador
        Temporizador.Enabled = False
        Temporizador.Interval = 10
        'Temporizador.Interval = 100
        TempSem.Increment()

        '*******Zona de inicio de nueva hebra*********
        SEnter.Decrement() 'Puesto que se usan paso de parmetros estticos necesitamos
        'hacer una zona exclusiva

        CopyArrayString(StartPair.CallParams, PassStartArgs)
        PassNameStart = StartPair.CallNameMethod
        PassObjectStart = StartPair.CallObject
        
        t = New Thread(AddressOf StartNewThread)
        t.Start()
        SParams.Decrement() 'Esto nos sirve para esperar hasta que la nueva hebra lea los
        'parmetros antes de salir de la zona exclusiva
        SEnter.Increment()  'Ya hemos acabado con esos parmetros. Podemos dejar a otro
        'hilo lanzar ms hilos si fueran necesarios.
        Me.Thread = t

        HTSem.Decrement()  'HTSem es compartido. Necesitamos acceso exclusivo
        HT.Add(t, FinishPair)
        HTSem.Increment() 'Ya terminamos con HT
        TempSem.Decrement() 'Otro tanto con el temporizador
        Temporizador.Enabled = True
        TempSem.Increment()
    End Sub

    Public Sub New(ByVal ObjectStart As Object, ByVal NameStart As String, ByVal StartArgs() As String, ByVal ObjectFinish As Object, ByVal NameFinish As String, ByVal FinishArgs() As String)

        Dim StartPair As New GrupoLlamador()
        Dim FinishPair As New GrupoLlamador()
        StartPair.Caller = Me
        StartPair.IsDelegate = False
        StartPair.CallObject = ObjectStart
        StartPair.CallNameMethod = NameStart
        StartPair.CallParams = StartArgs
        FinishPair.Caller = Me
        FinishPair.IsDelegate = False
        FinishPair.CallObject = ObjectFinish
        FinishPair.CallNameMethod = NameFinish
        FinishPair.CallParams = FinishArgs
        NewPrivate(StartPair, FinishPair)
    End Sub


    Public Sub New(ByVal Start As CallbackThread, ByVal Finish As CallbackThread)

        Dim StartPair As New GrupoLlamador()
        StartPair.Caller = Me
        StartPair.IsDelegate = True
        StartPair.CbT = Start
        Dim FinishPair As New GrupoLlamador()
        FinishPair.Caller = Me
        FinishPair.IsDelegate = True
        FinishPair.CbT = Finish
        NewPrivate(StartPair, FinishPair)
    End Sub
    Private Shared Sub CloseAll(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim Hebra As Threading.Thread
        Dim Hilo As Hilo
        HTSem.Decrement()
        'For Each Hebra In HT.Keys
        'Hebra.Suspend()
        'Next
        For Each Hilo In CallMainHT.Keys
            Hilo.CallMainLock.Increment()
        Next
        For Each Hebra In HT.Keys
            Hebra.Abort()
        Next
        HTSem.Increment()
    End Sub
    Private Shared Init As Boolean = False
    Private Shared Sub Initializate()
        AddHandler System.Windows.Forms.Application.ThreadExit, AddressOf CloseAll
        Init = True
        'AddHandler Threading.Thread.CurrentThread.Temporizador
    End Sub
End Class