; Version 1.0
;   first release

; use AT Keyboard with Amstrad CPC
; software for interface board EPROM
; assembled with asl-1.41r7

; Copyright (C) 1998 by Soeren Gust, sgust@ithh.informationstheater.de

; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

; You can always get the latest version at http://soeren.informationstheater.de

	cpu	z80

; variable definitions in RAM
modeflag	equ	08010h		; bit0: press/release
					; bit1: E0 prefix

	; initialise stack
	ld	sp,0ffffh

	; initialise variables
	xor	a
	ld	(modeflag),a

	; initialise keyboard matrix registers and RAM
	ld	a,0ffh
	ld	bc,08010h
initloop
	dec	c
	out	(c),a
	ld	(bc),a
	jr	nz,initloop	; Z-flag from dec c

readkey
	; prepare to read keyboard data
	ld	e,9
	; wait for keyboard bit
waitkeybit
	ld	a,(08009h)	; get last row
	out	(09h),a		; trigger joystick-register1
	in	a,(0)		; read keyboard/joy2 register
	push	af		; store for later use
	rla			; shift left
	or	3		; mask out joy2 bits
	ld	b,a		; put joy2 in b
	ld	a,(08006h)	; get keyboard row
	and	b		; combine joy2 and keyboard row
	out	(6),a		; put in port
	pop	af		; get register
	bit	0,a		; keyboard CLK
	jr	nz,waitkeybit	; wait until 1->0
	and	080h		; mask out keyboard data
	rr	d		; shift old value
	or	d		; put new bit to old value
	ld	d,a		; store in d
	; wait until keyboard clock returns to 1
waitkeyclock
	in	a,(0)
	bit	0,a		; keyboard CLK
	jr	z,waitkeyclock	; wait until 0->1
	dec	e		; count no of bits
	jr	nz,waitkeybit	; next bit, please

	; read parity and stop bit
waitparity1
	in	a,(0)
	bit	0,a
	jr	nz,waitparity1
waitparity2
	in	a,(0)
	bit	0,a
	jr	z,waitparity2
waitstop1
	in	a,(0)
	bit	0,a
	jr	nz,waitstop1
waitstop2
	in	a,(0)
	bit	0,a
	jr	z,waitstop2

	ld	a,d		; get scancode

	; process prefix bytes
	cp	0e0h		; special prefix
	jr	nz,process2
	ld	a,(modeflag)
	set	1,a
	ld	(modeflag),a
	jp	readkey
process2

	cp	0f0h		; key release
	jr	nz,process3
	ld	a,(modeflag)
	set	0,a
	ld	(modeflag),a
	jp	readkey
process3

	; translate scancode to cpc matrix
	ld	hl,keytable
	; test which keytable to use
	push	af		; put scancode onto stack
	ld	a,(modeflag)	; get flags
	bit	1,a		; E0 prefix ?
	jr	z,normaltable	; no
	res	1,a		; reset E0 flag
	ld	(modeflag),a	; and store in variable
	ld	hl,keytablee0	; use table for E0 prefix
normaltable
	pop	af		; get scancode from stack
	ld	d,0
	ld	e,a
	add	hl,de
	ld	a,(hl)

	; test,if 0
	or	a
	jr	z,readkey	; unused key
	push	af
	rra
	rra
	rra
	rra
	and	00fh		; mask out portnumber
	ld	c,a		; store in c
	pop	af
	and	00fh		; mask out bitnumber

	; convert bitnumber into bitmask
	ld	d,0feh
bitloop
	dec	a
	jr	z,bitend
	rlc	d
	jr	bitloop
bitend
	; d now contains a bitmask with all bits set except one
	; c contains the portnumber (column)

	; get old row value
	ld	h,080h		; row values are stored in RAM
	ld	l,c		; in the first 010h bytes (only 00ah used)
	ld	e,(hl)		; old row-value

	ld	a,(modeflag)	; get flags
	bit	0,a		; key press or release?
	jr	nz,releasekey	; released

	; key is pressed
	ld	a,e		; get row
	and	d		; clear bit in row
	jr	setrow		; continue

releasekey
	; key is released
	ld	a,d		; get mask
	xor	0ffh		; now only 1 bit is set
	or	e		; set bit in row
	push	af		; put new value onto stack
	ld	a,(modeflag)	; get mode
	res	0,a		; clear release flag
	ld	(modeflag),a	; set mode
	pop	af		; get new value from stack
setrow
	ld	(hl),a		; store row
	out	(c),a		; set row-register

	jp	readkey		; start again

wait
	push	af
	push	bc
	ld	bc,8000h
loop1
	dec	bc		; 8
	ld	a,b		; 4
	or	c		; 4
	jr	nz,loop1	; 12=28
	pop	bc
	pop	af
	ret

keytable
	; format: high-nibble = port, low-nibble = bit (1-8)
	; 00-07 xx    F8    xx    F5    F3    F1    F2    F12
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 08-0f xx    F9    F8    F6    F4    TAB   ^     xx
	db	000h, 000h, 000h, 000h, 000h, 084h, 028h, 000h
	; 10-17 xx    ALTL  SHIL  xx    CTRL  q     1     xx
	db	000h, 017h, 023h, 000h, 021h, 085h, 088h, 000h
	; 18-1f xx    xx    z     s     a     w     2     xx
	db	000h, 000h, 081h, 074h, 083h, 075h, 087h, 000h
	; 20-27 xx    c     x     d     e     4     3     xx
	db	000h, 072h, 071h, 073h, 076h, 078h, 077h, 000h
	; 28-2f xx    SPC   v     f     t     r     5     xx
	db	000h, 051h, 061h, 063h, 065h, 066h, 067h, 000h
	; 30-37 xx    n     b     h     g     y     6     xx
	db	000h, 052h, 062h, 054h, 064h, 055h, 068h, 000h
	; 38-3f xx    xx    m     j     u     7     8     xx
	db	000h, 000h, 042h, 053h, 056h, 057h, 058h, 000h
	; 40-47 xx    ,     k     i     o     0     9     xx
	db	000h, 041h, 043h, 045h, 046h, 048h, 047h, 000h
	; 48-4f xx    .     -     l          p          xx
	db	000h, 031h, 032h, 044h, 033h, 035h, 037h, 000h
	; 50-57 xx    xx         xx         `    xx    xx
	db	000h, 000h, 034h, 000h, 036h, 038h, 000h, 000h
	; 58-5f CAPS  SHIR  ENT   +     xx    #     xx    xx
	db	082h, 023h, 026h, 027h, 000h, 025h, 000h, 000h
	; 60-67 xx    <     xx    xx    xx    xx    BS    xx
	db	000h, 022h, 000h, 000h, 000h, 000h, 091h, 000h
	; 68-6f xx    NK1   xx    NK4   NK7   xx    xx    xx
	db	000h, 013h, 000h, 024h, 016h, 000h, 000h, 000h
	; 70-77 NK0   NK,   NK2   NK5   NK6   NK8   ESC   NUM
	db	011h, 001h, 012h, 014h, 004h, 015h, 086h, 000h
	; 78-7f F11   NK+   NK3   NK-   NK*   NK9   SCR   xx
	db	000h, 000h, 003h, 000h, 000h, 005h, 000h, 000h
	; 80-87                   F7
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 88-8f
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 90-97
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 98-9f
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; a0-a7
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; a8-af
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; b0-b7
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; b8-bf
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; c0-c7
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; c8-cf
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; d0-d7
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; d8-df
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; e0-e7
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; e8-ef
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; f0-f7
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; f8-ff
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h

keytablee0
	; format: high-nibble = port, low-nibble = bit (1-8)
	; 00-07 
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 08-0f 
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 10-17       ALTR              CTRR
	db	000h, 017h, 000h, 000h, 021h, 000h, 000h, 000h
	; 18-1f                                           WINL
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 017h
	; 20-27                                           WINR 
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 017h
	; 28-2f                                           PMAN
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 017h
	; 30-37 
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 38-3f 
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 40-47 
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 48-4f 
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 50-57 
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 58-5f             NKENT
	db	000h, 000h, 002h, 000h, 000h, 000h, 000h, 000h
	; 60-67 
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 68-6f                   CSRL
	db	000h, 000h, 000h, 018h, 000h, 000h, 000h, 000h
	; 70-77       ENTF  CSRD        CSRR  CSRU
	db	000h, 028h, 006h, 000h, 007h, 008h, 000h, 000h
	; 78-7f 
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 80-87 
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 88-8f
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 90-97
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; 98-9f
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; a0-a7
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; a8-af
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; b0-b7
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; b8-bf
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; c0-c7
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; c8-cf
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; d0-d7
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; d8-df
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; e0-e7
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; e8-ef
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; f0-f7
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	; f8-ff
	db	000h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	
	end
