//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop
#include <stdio.h>

#include "CPCTape.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TCPCTape_form *CPCTape_form;
//---------------------------------------------------------------------------
__fastcall TCPCTape_form::TCPCTape_form(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TCPCTape_form::exit_btnClick(TObject *Sender)
{
  this->Close();
}
//---------------------------------------------------------------------------
void __fastcall TCPCTape_form::convert_btnClick(TObject *Sender)
{
  strcpy(tzxfile,cdtfile->Text.c_str());
  strimpath(tzxfile);
  for (int i=0;i<strlen(tzxfile);i++)
  {
    if (tzxfile[i] == '.')
    {
      tzxfile[i+1] = '\0';
      strcat(tzxfile,"tzx");
      break;
    }
  }

  if (convert_it( get_params( Sender != final_btn ) ))
  {
    FILE *o=0;
    char buf[160] ;
    o = fopen("output.txt","r");
    output_win->Lines->Clear();

    output_win->Lines->Add(params);
    output_win->Lines->Add("");
    if ( o )
    {
      while (fgets(buf,100,o) != NULL)
      {
        int l = strlen(buf);
        if (l>=1) buf[l-1] = 0;
        output_win->Lines->Add(buf);
      }

      fclose(o);
    }
  }
  if ( Sender == final_btn)
  {
    // Final, rename to CDT
    if (FileExists(tzxfile))
      CopyFile(tzxfile,cdtfile->Text.c_str(),0);
    if (FileExists(tzxfile))
      DeleteFile(tzxfile);
  }
  else if ( Sender == convert_btn)
  {
    // Just convert, so delete
    if (FileExists(tzxfile))
      DeleteFile(tzxfile);
  }
}

bool TCPCTape_form::strimpath(char *p)
{
  char tmp[256];
  int i = 0;
  int l = strlen(p);
  for (int a=0;a<l;a++)
  {
    if (p[a] == '\\')
      i = a;
  }
  if ((i>0) && (i<(l-1)))
  {
    strcpy(tmp,&p[i+1]);
    strcpy(p,tmp);
  }
  return true;
}

bool TCPCTape_form::convert_it(char *params)
{
    STARTUPINFO si;
    PROCESS_INFORMATION pi;
    char cmdline[200] = "\0";

    ZeroMemory( &si, sizeof(si) );
    si.cb = sizeof(si);
    ZeroMemory( &pi, sizeof(pi) );


    si.dwFlags = STARTF_USESHOWWINDOW ;
    si.wShowWindow = SW_MINIMIZE;

    strcpy(cmdline,"VOC2TZX.exe ");
    strcat(cmdline, params);
    strcat(cmdline," > output.txt");

    // Start the child process.
    if( !CreateProcess( NULL, // No module name (use command line).
        cmdline         , // Command line.
        NULL,             // Process handle not inheritable.
        NULL,             // Thread handle not inheritable. 
        FALSE,            // Set handle inheritance to FALSE. 
        0,                // No creation flags. 
        NULL,             // Use parent's environment block. 
        NULL,             // Use parent's starting directory. 
        &si,              // Pointer to STARTUPINFO structure.
        &pi )             // Pointer to PROCESS_INFORMATION structure.
    )
    {
        return false;
    }

    // Wait until child process exits.
    WaitForSingleObject( pi.hProcess, INFINITE );

    // Close process and thread handles.
    CloseHandle( pi.hProcess );
    CloseHandle( pi.hThread );

    return true;
}
//---------------------------------------------------------------------------
void __fastcall TCPCTape_form::SpeedButton3Click(TObject *Sender)
{
  char *path;
  if (OpenDlg->Execute())
  {
    if (FileExists(OpenDlg->FileName))
    {
      path = OpenDlg->FileName.c_str();
      strimpath(path);
      vocfile->Text = path;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TCPCTape_form::SpeedButton5Click(TObject *Sender)
{
  char *path;
  if (SaveDlg->Execute())
  {
    path = SaveDlg->FileName.c_str();
    strimpath(path);
    cdtfile->Text = path;

  }
}

char* TCPCTape_form::get_params(bool cpc_switch)
{
  params[0] = '\0';
  char tmp[256];
  int sl;

  sprintf(tmp,"/maxp %i /diff %i /pilot %i /std %i "
  , maxp->Text.ToInt()
  , diff->Text.ToInt()
  , pilot->Text.ToInt()
  , std_v->Text.ToInt());
  strcat(params,tmp);

  if (slockoff->Checked == false)
  {
         if (slock1->Checked == true) sl = 1;
    else if (slock2->Checked == true) sl = 2;
    else if (slock3->Checked == true) sl = 3;
    else if (slock4->Checked == true) sl = 4;

    sprintf(tmp,"/slock%i ", sl);
    strcat(params,tmp);

    if (sl == 1)
    {
      sprintf(tmp,"%i ", slock1val->Text.ToInt());
      strcat(params,tmp);
    }
    else if (sl == 3)
    {
      sprintf(tmp,"%i ", slock3val->Text.ToInt());
      strcat(params,tmp);
    }

    sl = slskip->Text.ToInt();

    if ( sl > 0)
    {
      sprintf(tmp,"/slskip %i ", sl);
      strcat(params,tmp);
    }
  }

  if (cpc_switch)
    strcat(params, "/cpc ");

  strcat(params, vocfile->Text.c_str());
  strcat(params, " ");
  strcat(params, tzxfile);
  return params;
}
//---------------------------------------------------------------------------
