/*
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *
 *  Copyright 1999 Michael Klein <michael.klein@puffin.lb.shuttle.de>
*/

#include "cbm.h"

#include <unistd.h>
#include <fcntl.h>

static unsigned char flash[] = {
#include "flash.inc"
};

int main(int argc, char *argv[])
{
    int fd;
    
    fd = open(cbm_dev, O_RDWR);
    if(fd >= 0) {
        cbm_upload(fd, 8, 0x0500, flash, sizeof(flash));
        cbm_exec_command(fd, 8, "U3:", 0);
        close(fd);
        return 0;
    }
    return 1;
}
