/*
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *
 *  Copyright 1999 Michael Klein <michael.klein@puffin.lb.shuttle.de>
*/

#include "cbm.h"
#include "d64copy.h"

#include <stdlib.h>

#include <unistd.h>

static unsigned char s1_drive_prog[] = {
#include "s1.inc"
};

static int s1_write_byte(int fd, unsigned char c)
{
    int b, i;
    for(i=7; i>=0; i--) {
        b=(c >> i) & 1;
        if(b) cbm_iec_set(fd, IEC_DATA); else cbm_iec_release(fd, IEC_DATA);
        cbm_iec_release(fd, IEC_CLOCK);
        while(!cbm_iec_get(fd, IEC_CLOCK));
        if(b) cbm_iec_release(fd, IEC_DATA); else cbm_iec_set(fd, IEC_DATA);
        while(cbm_iec_get(fd, IEC_CLOCK));
        cbm_iec_release(fd, IEC_DATA);
        cbm_iec_set(fd, IEC_CLOCK);
        while(!cbm_iec_get(fd, IEC_DATA));
    }
    return 0;
}

static int s1_read_byte(int fd, unsigned char *c)
{
    int b=0, i;
    *c = 0;
    for(i=7; i>=0; i--) {
        while(cbm_iec_get(fd, IEC_DATA));
        cbm_iec_release(fd, IEC_CLOCK);
        b = cbm_iec_get(fd, IEC_CLOCK);
        *c = (*c >> 1) | (b ? 0x80 : 0);
        cbm_iec_set(fd, IEC_DATA);
        while(b == cbm_iec_get(fd, IEC_CLOCK));
        cbm_iec_release(fd, IEC_DATA);
        while(!cbm_iec_get(fd, IEC_DATA));
        cbm_iec_set(fd, IEC_CLOCK);
    }
    return 0;
}

static int read_block(int tr, int se, char *block)
{
    int  i;
    char status;

    s1_write_byte(fd_cbm, tr);
    s1_write_byte(fd_cbm, se);
    usleep(20000);
    s1_read_byte(fd_cbm, &status);
    for(i=0;i<256;i++) s1_read_byte(fd_cbm, &block[i]);
    cbm_iec_release(fd_cbm, IEC_DATA);

    return status;
}

static int write_block(int tr, int se, char *block, int size)
{
    int  i;
    char status;

    s1_write_byte(fd_cbm, tr);
    s1_write_byte(fd_cbm, se);
    for(i=0;i<size;i++) s1_write_byte(fd_cbm, block[i]);
    if(size == BLOCKSIZE) {
        usleep(20000);
    }
    s1_read_byte(fd_cbm, &status);
    cbm_iec_release(fd_cbm, IEC_DATA);

    return status;
}

static int open_disk(char *name, int for_writing)
{
    int d = atoi(name);

    cbm_upload(fd_cbm, d, 0x700, s1_drive_prog, sizeof(s1_drive_prog));
    cbm_exec_command(fd_cbm, d, "U4:", 3);
    while(!cbm_iec_get(fd_cbm, IEC_DATA));
    return 0;
}

static void close_disk(void)
{
    s1_write_byte(fd_cbm, 0);
    s1_write_byte(fd_cbm, 0);
}

static int send_track_map(int tr, char *trackmap, int count)
{
    int i;
    s1_write_byte(fd_cbm, tr);
    s1_write_byte(fd_cbm, count);
    for(i = 0; i < sector_map[(int)tr]; i++) {
        s1_write_byte(fd_cbm, trackmap[i] != '-');
    }
    return 0;
}

static int read_gcr_block(int *se, unsigned char *gcrbuf)
{
    int i;
    unsigned char s;

    s1_read_byte(fd_cbm, &s);
    *se = s;
    s1_read_byte(fd_cbm,  &s);

    if(s) {
        return s;
    }

    for(i = 0; i < GCRBUFSIZE; i++) {
        s1_read_byte(fd_cbm, &gcrbuf[i]);
    }
    return 0;
}

DECLARE_TRANSFER_FUNCS_EX(s1_transfer, 1);
