/*
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *
 *  Copyright 1999 Michael Klein <michael.klein@puffin.lb.shuttle.de>
*/

#include "cbm.h"
#include "d64copy.h"

#include <stdlib.h>

#include <unistd.h>

static unsigned char pp_drive_prog[] = {
#include "pp.inc"
};

static int pp_write(int fd, char c1, char c2)
{
    cbm_pp_write(fd, c1);
    cbm_iec_release(fd, IEC_CLOCK);
    while(cbm_iec_get(fd, IEC_DATA));

    cbm_pp_write(fd, c2);
    cbm_iec_set(fd, IEC_CLOCK);
    while(!cbm_iec_get(fd, IEC_DATA));

    return 0;
}

static int pp_read(int fd, unsigned char *c1, unsigned char *c2)
{
    while(cbm_iec_get(fd, IEC_DATA));
    *c1 = cbm_pp_read(fd);
    cbm_iec_release(fd, IEC_CLOCK);

    while(!cbm_iec_get(fd, IEC_DATA));
    *c2 = cbm_pp_read(fd);
    cbm_iec_set(fd, IEC_CLOCK);

    return 0;
}

static int read_block(int tr, int se, char *block)
{
    int  i;
    unsigned char status;

    pp_write(fd_cbm, tr, se);
    usleep(20000);
    pp_read(fd_cbm, &status, &status);

    for(i=0;i<BLOCKSIZE;i+=2) pp_read(fd_cbm, &block[i], &block[i+1]);

    return status;
}

static int write_block(int tr, int se, char *block, int size)
{
    int i = 0;
    unsigned char status;

    pp_write(fd_cbm, tr, se);

    if(size % 2) {
        pp_write(fd_cbm, *block, *block);
        i = 1;
    }

    for(;i<size;i+=2) pp_write(fd_cbm, block[i], block[i+1]);

    if(size == BLOCKSIZE) {
        usleep(20000);
    }
    pp_read(fd_cbm, &status, &status);

    return status;
}

static int open_disk(char *name, int for_writing)
{
    int d = atoi(name);

    cbm_upload(fd_cbm, d, 0x700, pp_drive_prog, sizeof(pp_drive_prog));
    cbm_exec_command(fd_cbm, d, "U4:", 3);
    while(!cbm_iec_get(fd_cbm, IEC_DATA));
    return 0;
}

static void close_disk(void)
{
    pp_write(fd_cbm, 0, 0);
}

static int send_track_map(int tr, char *trackmap, int count)
{
    int i;
    unsigned char c;
    pp_write(fd_cbm, tr, count);
    for(i = 0; i < sector_map[(int)tr]; i++) {
        c = trackmap[i] != '-';
        pp_write(fd_cbm, c, c);
    }
    return 0;
}

static int read_gcr_block(int *se, unsigned char *gcrbuf)
{
    int i;
    unsigned char s;

    pp_read(fd_cbm, &s, &s);
    *se = s;
    pp_read(fd_cbm, &s, &s);

    if(s) {
        return s;
    }

    for(i = 0; i < GCRBUFSIZE; i += 2) {
        pp_read(fd_cbm, &gcrbuf[i], &gcrbuf[i+1]);
    }

    return 0;
}

DECLARE_TRANSFER_FUNCS_EX(pp_transfer, 1);
