/*
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *
 *  Copyright 1999 Michael Klein <michael.klein@puffin.lb.shuttle.de>
*/

#include "d64copy.h"

#include <errno.h>
#include <error.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/stat.h>
#include <unistd.h>

FILE *the_file;

static int block_offset(int tr, int se)
{
    int sectors = 0, i;
    for(i = 1; i < tr; i++) {
        sectors += sector_map[i];
    }
    return (sectors + se) * BLOCKSIZE;
}

static int read_block(int tr, int se, char *block)
{
    if(fseek(the_file, block_offset(tr, se), SEEK_SET) == 0) {
        return fread(block, BLOCKSIZE, 1, the_file) != 1;
    }
    return 1;
}

static int write_block(int tr, int se, char *block, int size)
{
    if(fseek(the_file, block_offset(tr, se), SEEK_SET) == 0) {
        return fwrite(block, size, 1, the_file) != 1;
    }
    return 1;
}

static int open_disk(char *name, int for_writing)
{
    struct stat statrec;
    int stat_ok, is_d64;

    the_file = NULL;

    stat_ok = stat(name, &statrec) == 0;
    is_d64  = stat_ok && (statrec.st_size == NR_BLOCKS * BLOCKSIZE);

    if(!for_writing) {
        if(stat_ok) {
            if(is_d64) {
                the_file = fopen(name, "rb");
                if(the_file == NULL) {
                    error(0, errno, "could not open %s", name);
                }
            } else {
                fprintf(stderr, "not a .d64 file: %s\n", name);
            }
        } else {
            error(0, errno, "could not stat %s", name);
        }
    } else {
        the_file = fopen(name, is_d64 ? "r+b" : "wb");
        if(the_file) {
            if(!is_d64) {
                int i;
                char block[BLOCKSIZE];
                memset(block, '\0', BLOCKSIZE);
                for(i = 0; the_file && (i < NR_BLOCKS);i++) {
                    if(fwrite(block, BLOCKSIZE, 1, the_file) != 1) {
                        error(0, errno, "could not write %s", name);
                        fclose(the_file);
                        unlink(name);
                        the_file = NULL;
                    }
                }
            }
        } else {
            error(0, errno, "could not open %s", name);
        }
    }
    return the_file == NULL;
}

static void close_disk(void)
{
    if(the_file) {
        fclose(the_file);
        the_file = NULL;
    }
}

DECLARE_TRANSFER_FUNCS(fs_transfer, 0);
