/*
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *
 *  Copyright 1999 Michael Klein <michael.klein@puffin.lb.shuttle.de>
*/

#ifndef __D64COPY_H
#define __D64COPY_H

#define NR_BLOCKS   683
#define BLOCKSIZE   256
#define GCRBUFSIZE  326

#define NR_TRACKS    35
#define MAX_SECTORS  21

struct transfer_funcs {
    int  (*open_disk)(char*,int);
    int  (*read_block)(int,int,char*);
    int  (*write_block)(int,int,char*,int);
    void (*close_disk)(void);
    int  needs_turbo;
    int  (*send_track_map)(int,char*,int);
    int  (*read_gcr_block)(int*,unsigned char*);
};

#define DECLARE_TRANSFER_FUNCS(x,t) \
    struct transfer_funcs x = {open_disk, \
                               read_block, \
                               write_block, \
                               close_disk, \
                               t, \
                               NULL, \
                               NULL}

#define DECLARE_TRANSFER_FUNCS_EX(x,t) \
    struct transfer_funcs x = {open_disk, \
                               read_block, \
                               write_block, \
                               close_disk, \
                               t, \
                               send_track_map, \
                               read_gcr_block}
    
extern char sector_map[36];
extern int  fd_cbm;

#endif
