#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef BSD
#include "cpufunc.h"
#endif /* BSD */

#ifdef AMIGA
#include "my_exec_types.h"
#include <exec/semaphores.h>
#include <clib/exec_protos.h>
#include <clib/misc_protos.h>
#include <hardware/cia.h>
#include <resources/misc.h>
#endif

#define uchar unsigned char

/* sync time tolerance */
#define synctolerance 1000

#ifdef AMIGA
#include "my_exec_types.h"
#include <exec/semaphores.h>
#include <clib/exec_protos.h>
#include <clib/misc_protos.h>
#include <hardware/cia.h>
#include <resources/misc.h>

extern volatile struct CIA ciaa;
extern volatile struct CIA ciab;

#define PAROUT ciaa.ciaddrb = 0xFF
#define PARIN ciaa.ciaddrb = 0x00
#define POUTHIGH ciab.ciapra = ((ciab.ciapra & 0xFD) | 0x02)
#define POUTLOW ciab.ciapra = ciab.ciapra & 0xFD
#define BUSY (!(ciab.ciapra & 0x01)) /* Inverted 'cause BUSY is active low on PC(!) */
#define PARW(x) ciaa.ciaprb = (x)
#define PARR ciaa.ciaprb
#define SETINITDDR ciab.ciaddra = (ciab.ciaddra & 0xF8) | 0x02
#endif

/*
  Linux/PC stuff 
*/

#ifdef LINUX
/* Size of spare stack space for when in real-time portions (ie iec serial) */
#define RT_STACK_SIZE 256*1024

void MicroSleep(int usec);
#endif

/* output */
/* ATN is read only with 64net/2 - but map it to the right bit to be sure,
   since otherwise it sometimes thinks its ATN time anyway */
#define ATN_BIT         6
#define CLOCK_BIT       1
#define DATA_BIT        3
#define ATN             (1 << ATN_BIT) 
#define CLOCK           (1 << CLOCK_BIT)
#define DATA            (1 << DATA_BIT)

/* input */
#define ATN_in_VALUE 0x40
/* atn is active low */
#define isATN (!(inb(outport+1)&ATN_in_VALUE))
#define CLK_in_VALUE 0x20
#define isCLK (inb(outport+1)&CLK_in_VALUE)
#define DTA_in_VALUE 0x10
#define isDTA (inb(outport+1)&DTA_in_VALUE)



void init_hw();
void starthw();

int syncchar();
int sendchar();
int charget();
int fastsendblock(int addr,int size,uchar *the_block);
int fastgetblock(int addr,int size,uchar *the_block);

/* critical session delimiters */
int criticalSession();
int endCritical();
