#include <stdio.h>

int mallocList[128]={-1};
int sizeList[128];

int initDebug()
{
  int i;

  for(i=0;i<128;i++) mallocList[i]=-1;
}

void *trap_malloc(int size)
{
  int i,j;
  char *p;

  for(i=0;i<128;i++)
    if (mallocList[i]==-1)
      break;
  
  if (i==128)
    {
      printf("DEBUG: malloc debug table full\n");
      return(0);
    }

  mallocList[i]=malloc(size+32);
  sizeList[i]=size;
  
  p=(char *)mallocList[i];
  for(j=0;j<16;j++) p[j]=0xbd;
  for(j=0;j<16;j++) p[size+16+j]=0xbd;

  printf("malloc(%d) called.  Returning %08x (with 16byte buffers each end)\n",
	 size,mallocList[i]+16);
  fflush(stdout);
  sleep(1);

  return(mallocList[i]+16);

}

void trap_free(int addr)
{
  int i,j;
  unsigned char *p;

  printf("free(%08x) called.\n",
	 addr);
  fflush(stdout);
  sleep(1);

  for(i=0;i<128;i++)
    if (addr==mallocList[i]+16) break;

  if (i==128)
    {
      printf("DEBUG: free() attempted on illegal value (%08x)\n",
	     addr);
      return;
    }

  /* test for corruption */
  p=addr-16;
  for(j=0;j<16;j++)
    {
      if (p[j]!=0xbd)
	printf("DEBUG: free() show memory corruption at (-) %d (%08x)\n",16-j);
      if (p[sizeList[i]+16+j]!=0xbd)
	printf("DEBUG: free() show memory corruption at (+) %d (%08x)\n",j);
    }

  sleep(1);

  free(addr-16);
  return;
}

int trap_fclose(FILE *f)
{
  printf("fclosing %08x\n",f);

  if (!f)
    printf("Attempting to fclose null.\n");
  else
    fclose(f);
  printf("Fclose'd okay\n");
    
}
