#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef BSD
#include "cpufunc.h"
#endif /* BSD */

#ifdef AMIGA
#include "my_exec_types.h"
#include <exec/semaphores.h>
#include <clib/exec_protos.h>
#include <clib/misc_protos.h>
#include <hardware/cia.h>
#include <resources/misc.h>
#endif

#define uchar unsigned char

/* sync time tolerance */
#define synctolerance 1000

#ifdef AMIGA
#include "my_exec_types.h"
#include <exec/semaphores.h>
#include <clib/exec_protos.h>
#include <clib/misc_protos.h>
#include <hardware/cia.h>
#include <resources/misc.h>

extern volatile struct CIA ciaa;
extern volatile struct CIA ciab;

#define PAROUT ciaa.ciaddrb = 0xFF
#define PARIN ciaa.ciaddrb = 0x00
#define POUTHIGH ciab.ciapra = ((ciab.ciapra & 0xFD) | 0x02)
#define POUTLOW ciab.ciapra = ciab.ciapra & 0xFD
#define BUSY (!(ciab.ciapra & 0x01)) /* Inverted 'cause BUSY is active low on PC(!) */
#define PARW(x) ciaa.ciaprb = (x)
#define PARR ciaa.ciaprb
#define SETINITDDR ciab.ciaddra = (ciab.ciaddra & 0xF8) | 0x02
#endif

void init_hw();
void starthw();

int syncchar();
int sendchar();
int charget();
int fastsendblock(int addr,int size,uchar *the_block);
int fastgetblock(int addr,int size,uchar *the_block);
