#ifdef LINUX
#include <asm/io.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "fs.h"
#include "machdep.h"

extern int steal_parallel_port;
struct Library *MiscBase;

#ifdef SOLARIS
  /* Faxe port access XXX */
int outb(int p,int v)
{ return 0; 
}

int inb(int p)
{
return 255;
}
#endif /* SOLARIS */
/* Printer port transfer routines ----------------------------------------- */

/* receive synchronised character (begining of hand shake) */

void
init_hw (void)
{
#ifdef BSD
 if ((f = fopen ("/dev/io", "rw")) == NULL)
  {
    fatal_error ("Cannot get chip-bash privelige.\
                 \nPlease setgid to kmem (or similar)\n");
    exit (1);
  }
#endif /* BSD */

#ifdef LINUX
 /* Enable port access to the range 0x0 to 0x3ff */
 printf("LINUX: Asking for chip-bash priveliges\n");
 printf("ioperm returned = %d\n",ioperm(0x200,0x1ff,3));
 fflush(stdout);
 sleep(0);

#endif /* LINUX */

#ifdef AMIGA
  const char *user;
  char myname[] = "64NET/2 - Parallel";

  if (steal_parallel_port == 0)
  {
#ifdef DEBUG
    printf ("Opening misc resource\n");
#endif /* DEBUG */

    if ((MiscBase = OpenResource ("misc.resource")) == NULL)
    {
      printf ("Can't open misc.resource\n");
      exit (10);
    }

#ifdef DEBUG
    printf ("Allocatin parallel port\n");
#endif /* DEBUG */
    user = AllocMiscResource (MR_PARALLELPORT, myname);
    if (user != NULL && user != myname)
    {
      printf ("Printer data lines already in use by %s.\n", user);
      printf ("Unable to lock parallel port\n");
      exit (10);
    }
  }
#ifdef DEBUG
  printf ("Setting DDRs\n");
#endif /* DEBUG */
  PAROUT;			/* Set data lines for output initially */
  /* Set following control line DDR stuff
     Bit 2 - Sel - Input
     Bit 1 - Pout - Out
     Bit 0 - Busy - Input
   */

  SETINITDDR;

#endif /* AMIGA */
}

void
starthw(void)
{
#ifdef AMIGA
  /* Parallel=in, Pout=high */
  PARIN;
  POUTHIGH;
#else
  /* ddr = in, strobe = high */
#ifdef LINUX
  outb(0xa0,outport + 2);
#else
  outb(outport + 2, 0xa0);
#endif
#endif /* AMIGA */
}

int
syncchar ()
{
  int value;
  long c;

  c = 0;

#ifdef AMIGA
  /* Set parallel port DDR = in, POUT=high */
  PARIN;
  POUTHIGH;
#ifdef DEBUG2
  printf ("syncchar - Waiting for 64 ACK (!BUSY)\n");
  fflush (stdout);
#endif
  /* Wait for 64 ACK */
  while (!(BUSY))
  {
    c++;
    if (c > synctolerance)
    {
      value = -1;
      return (-1);
    }
  }
  /* read value */
  value = PARR;
  /* Set POUT low, Parallel port DDR = in */
  POUTLOW;
  PARIN;
#ifdef DEBUG2
  printf ("syncchar - Waiting for 64 ACK (BUSY)\n");
  fflush (stdout);
#endif
  /* Wait for 64 ACK */
  while (BUSY)
  {
    c++;
    if (c > synctolerance)
    {
      value = -1;
      return (-1);
    }
  }
  /* second toggle */
  POUTHIGH;
  POUTLOW;
#else
  /* ddr = in, strobe = high */
#ifdef LINUX
  outb(0xa0,outport + 2);
#else
  outb(outport + 2, 0xa0);
#endif
  /* wait for 64 ready (64=93) */
  while (!(inb(inport)&0x80))
  {
    c++;
    if (c > synctolerance)
    {
      value = -1;
      return (-1);
    }
  }
  /* read value */
  value = inb(outport);
  /* toggle strobe low, ddr=in */
#ifdef LINUX
  outb (0xa1,outport + 2);
#else
  outb (outport + 2, 0xa1);
#endif
  /* wait for 64 done (64= 97) */
  while ((inb (inport) & 0x80))
  {
    c++;
    if (c > synctolerance)
    {
      value = -1;
      return (-1);
    }
  }
  /* second toggle */
#ifdef LINUX
  outb (0xa0,outport + 2);
  outb (0xa1,outport + 2);
#else
  outb (outport + 2, 0xa0);
  outb (outport + 2, 0xa1);
#endif
#endif

  return (value);
}

/* receive a character after a connection has been established */

int
charget ()
{
  int value;

#ifdef DEBUG2
  printf ("Trying to get char...");
  fflush (stdout);
#endif

#ifdef AMIGA
  /* Parallel port DDR = in , POUT = high */
  PARIN;
  POUTHIGH;
#ifdef DEBUG2
  printf ("getchar - Waiting for 64 ACK (!BUSY)\n");
  fflush (stdout);
#endif
  /* Wait for 64 ACK */
  while (!(BUSY));
  /* read value */
  value = PARR;
  /* Toggle POUT low, Parallel port DDR = in */
  POUTLOW;
  PARIN;
#ifdef DEBUG2
  printf ("getchar - Waiting for 64 ACK (BUSY)\n");
  fflush (stdout);
#endif
  /* Wait for 64 ACK */
  while (BUSY);
  /* Second toggle */
  POUTHIGH;
  POUTLOW;
#else
  /* ddr = in */
#ifdef LINUX
  outb (0xa0,outport + 2);
#else
  outb (outport + 2, 0xa0);
#endif
  /* wait for 64 ready (93) */
  while (!(inb (inport) & 0x80));
  /* read value */
  value = inb (outport);
  /* toggle strobe low, ddr=in */
#ifdef LINUX
  outb (0xa1,outport + 2);
#else
  outb (outport + 2,0xa1);
#endif
  /* wait for 64 done (97) */
  while (inb (inport) & 0x80);
  /* second toggle */
#ifdef LINUX
  outb (0xa0,outport + 2);
  outb (0xa1,outport + 2);
#else
  outb (outport + 2,0xa0);
  outb (outport + 2, 0xa1);
#endif
#endif

#ifdef DEBUG2
  printf ("Got %02x\n", value);
  fflush (stdout);
#endif

  return (value);
}


/* send a single character back over the link */

int
sendchar (int byte)
{
#ifdef DEBUG2
  printf ("Trying to send %02x...", byte);
  fflush (stdout);
#endif
#ifdef AMIGA
#ifdef DEBUG2
  printf ("sendchar - Waiting for 64 ACK (!BUSY)\n");
  fflush (stdout);
#endif
  /* wait for 64 ready (93) */
  while (!(BUSY));
  /* POUT = high, Parallel port DDR = Out */
  POUTHIGH;
  PAROUT;
  /* Write byte */
  PARW (byte);
  /* wait for 64 ready (97) */
  /* Bring POUT low */
  POUTLOW;
#ifdef DEBUG2
  printf ("sebdchar - Waiting for 64 ACK (BUSY)\n");
  fflush (stdout);
#endif
  while (BUSY);
  /* Parallel port DDR = In , POUT = high */
  PARIN;
  POUTHIGH;
  POUTLOW;
  POUTHIGH;
#else
  /* wait for 64 ready (93) */
  while (!(inb (inport) & 0x80));
  /* strobe = high, ddr=out */
#ifdef LINUX
  outb (0x40,outport + 2);
#else
  outb (outport + 2,0x40);
#endif
  /* write byte */
#ifdef LINUX
  outb (byte,outport);
#else
  outb (outport,byte);
#endif
  /* wait for 64 ready (97) */
  /* Bring strobe low */
#ifdef LINUX
  outb (0x41,outport + 2);
#else
  outb (outport + 2,0x41);
#endif
  while ((inb (inport) & 0x80));
  /* ddr =in, strobe = high */
#ifdef LINUX
  outb (0xa0,outport + 2);
  outb (0xa1,outport + 2);
  outb (0xa0,outport + 2);
#else
  outb (outport + 2,0xa0);
  outb (outport + 2, 0xa1);
  outb (outport + 2, 0xa0);
#endif
/*  while(inb(outport)!=0xff) ; */
#endif
#ifdef DEBUG2
  printf ("Sent\n");
#endif
  return (0);
}

int
fastsendblock (int addr, int size, uchar * the_block)
{
  /* send a block of data *super* fast */
  /* Algorithm:
     - Send block backwards (easier for 64 to receive!) 
     using much less handshaking due to mono-directionality.
     1) Send command
     2) send address
     3) send 254 bytes of data using minimal hand shaking
   */

#ifdef DEBUG2
  printf ("Inside fastsendblock\n");
  fflush (stdout);
#endif
  sendchar (0xf5);
  sendchar (addr & 0xff);
  sendchar (addr / 256);

#ifdef DEBUG2
  printf ("Outside fastsendblock\n");
  fflush (stdout);
#endif
  return (fishsendblock (254, the_block));

}

int
fastgetblock (int addr, int size, uchar * the_block)
{
  /* send a block of data *super* fast */
  /* Algorithm:
     - Send block backwards (easier for 64 to receive!) 
     using much less handshaking due to mono-directionality.
     1) Send command
     2) send address
     3) send 254 bytes of data using minimal hand shaking
   */

#ifdef DEBUG2
  printf ("Inside fastgetblock\n");
  fflush (stdout);
#endif
  sendchar (0xf4);
  sendchar (addr & 0xff);
  sendchar (addr / 256);

#ifdef DEBUG2
  printf ("Outside fastgetblock\n");
  fflush (stdout);
#endif
  return (fishgetblock (254, the_block));

}

int
fishsendblock (int size, uchar * block)
{
  int n = 0;

#ifdef AMIGA
  /* Parallel Port DDR = out */
  PAROUT;

  while (n < size)
  {
    /* wait for 64 ACK */
    while (!(BUSY));
    /* send char & toggle strobe */
    PARW (block[n]);
    POUTLOW;
    POUTHIGH;			/* raise here before busy loop to reduce port accesses */
    n++;
    /* wait for 64 NACK */
    while (BUSY);
    PARW (block[n]);
    POUTLOW;
    POUTHIGH;
    n++;
  }
  /* close off */
  while (!(BUSY));
  /* send ack */
  /* Parallel port DDR = in, POUT = low */
  PARIN;
  POUTLOW;
#else

  /* dir = out */
#ifdef LINUX
  outb (0x40,outport + 2);
#else
  outb (outport + 2,0x40);
#endif

  while (n < size)
  {
    /* wait for 127 */
    while (!(inb (inport) & 0x80));
    /* send char & toggle strobe */
#ifdef LINUX
    outb (block[n],outport);
    outb (0x41,outport + 2);
    outb (0x40,outport + 2);	/* raise here before busy loop to reduce port accesses */
#else
    outb (outport,block[n]);
    outb (outport + 2, 0x41);
    outb (outport + 2, 0x40);	/* raise here before busy loop to reduce port accesses */
#endif
    n++;
    /* wait for 255 */
    while ((inb (inport) & 0x80));
    /* send char & toggle strobe */
#ifdef LINUX
    outb (block[n],outport);
    outb (0x41,outport + 2);
    outb (0x40,outport + 2);
#else
    outb (outport,block[n]);
    outb (outport + 2, 0x41);
    outb (outport + 2, 0x40);
#endif
    n++;
  }

  /* close off */
  while (!(inb (inport) & 0x80));
  /* send ack */
  /* dir = in, strobe = low */
#ifdef LINUX
  outb (0xa1,outport + 2);
#else
  outb (outport + 2,0xa1);
#endif
#endif

  return (0);

}

int
fishgetblock (int size, uchar * block)
{
  int n = 0;

#ifdef AMIGA
  /* Parallel port DDR = in */
  PARIN;

  while (n < size)
  {
    /* wait for 64 NACK */
    while (!(BUSY));
    /* get char & toggle POUT */
    block[n] = PARR;
    n++;
    POUTHIGH;
    POUTLOW;			/* raise here before busy loop to reduce port accesses */
    /* wait for ACK */
    while (BUSY);
    /* get char & toggle POUT */
    block[n] = PARR;
    n++;
    POUTHIGH;
    POUTLOW;
  }

  /* close off */
  while (!(BUSY));
  /* send ack */
  /* Parallel port DDR = in, POUT = low */
  PARIN;
  POUTLOW;
#else
  /* dir = in */
#ifdef LINUX
  outb (0xa0,outport + 2);
#else
  outb (outport + 2,0xa0);
#endif

  while (n < size)
  {
    /* wait for 127 */
    while (!(inb (inport) & 0x80));
    /* get char & toggle strobe */
    block[n] = inb (outport);
    n++;
#ifdef LINUX
    outb (0xa1,outport + 2);
    outb (0xa0,outport + 2);	/* raise here before busy loop to reduce port accesses */
#else
    outb (outport + 2, 0xa1);
    outb (outport + 2, 0xa0);	/* raise here before busy loop to reduce port accesses */
#endif
    /* wait for 255 */
    while ((inb (inport) & 0x80));
    /* get char & toggle strobe */
    block[n] = inb (outport);
    n++;
#ifdef LINUX
    outb (0xa1,outport + 2);
    outb (0xa1,outport + 2);
#else
    outb (outport + 2,0xa1);
    outb (outport + 2, 0xa0);
#endif
  }

  /* close off */
  while (!(inb (inport) & 0x80));
  /* send ack */
  /* dir = in, strobe = low */
#ifdef LINUX
  outb (0xa1,outport + 2);
#else
  outb (outport + 2,0xa1);
#endif

#endif
  return (0);

}
