/* 
    64net-bsd include file - 64NET virtual filesystem constants and
    definitions 
    (C)opyright Paul Gardner-Stephen 1995,1996
    Modified 6 July 1996 (and later)
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <errno.h>
/* #include <malloc.h> */
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#ifdef DEBUG

/* malloc() and free() watching */
#define malloc trap_malloc
#define free   trap_free

/* fclose() monitoring */
#define fclose trap_fclose

#endif


#define PADDING 1

#ifndef AMIGA
#ifndef LINUX
#include <sys/filio.h>
#else
#include <sys/vfs.h>
#endif
#include <sys/wait.h>
#include <varargs.h>
#endif /* AMIGA */

#include <sys/param.h>
#include <netdb.h>
#include <errno.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <string.h>
#include <signal.h>
#include <arpa/inet.h>
#include <ctype.h>

/* for fseek */
#define SEEK_SET 0

/* save lots of typing */
#define uchar unsigned char

/* 64NET filesystem structure */
struct fs64_filesystemstructure {
  int media;          /* type of filesystem */
  int arctype;        /* filesystem variant */
  FILE *fsfile;       /* file which hosts file system */
  char fspath[1024];  /* full path & name of filesystem base */
  int dirtrack;       /* track where directory starts */
  int dirsector;     /* sector where directory starts */
};
#define fs64_filesystem struct fs64_filesystemstructure

/* the longest that a filename & path may be in characters.
   This makes a significant impact on the amount of memory 64NET/2 requires
   at runtime. 78 should be more than adequate under MS-DOS, and 256 should
   be reasonable under UNIX & AMIGA-DOS, although 1024 would be preferable
   (memory permitting)
*/
#define MAX_FS_LEN 256

/* maximum number of 64net devices */
/* anything over 32 is useless, as the IEC bus only handles 32 devices! */
/* note also parallel versions (typically) only support one device, but 
   can possibly handle 255 devices (if such support were implemented!) */
#define MAX_NET_DEVS 1

/* 64NET directory search structure */
struct fs64_direntrystructure {
   uchar fs64name[17];     /* C64 name of file, 0xa0 padded (must be 17 not 16!) */ 
   uchar realname[MAX_FS_LEN];/* full pathname and filename of real file/fs object */
   uchar path[MAX_FS_LEN]; /* pathname from original fs64_findfirst */
   uchar glob[17][32]; /* glob mask for use in fs64_findfirst_g */
   int active; /* is this structure active, or spent, 1= active,0= spent */
   int invisible;  /* is this file "invisible", ie ignore if in a dir search */
   long blocks;
   long realsize;
   fs64_filesystem filesys;
   DIR *dir;
   int filetype;
   int track;
   int sector;
   long binbase;
   int first_track;
   int first_sector;
   char fs[1024];  /* file system source for such types */
   int intcount; /* internal directory entry in sector for such types,
		    or counter for "synthesised" directories, like the 
		    internet file system ones */
   int fileposs; /* position in stream based files for searches */
   int dirtype;  /* type of directory being searched (used by media_net 
		    searches */
} ;
#define fs64_direntry struct fs64_direntrystructure

/* 64NET file structure - fs64_openfile returns */
struct fs64_filestructure {
    int open; /* file open flag */
    uchar fs64name[16]; /* C64 filename, 0xa0 padded */
    uchar realname[MAX_FS_LEN];/* full pathname and filename of realfile/fs object */
    int first_track;  /* First block of file in object */
    int first_sector; /*                               */
    long first_poss; /* first byte of real file which is the body of the file */
    fs64_filesystem filesys;
    int mode;  /* mode of openness - ie, is it read or write */
    int curr_track;
    int curr_sector;
    long curr_poss;
    long blocks;  /* # of blocks in the file */
    long realsize; /* # of bytes in the real file which are part of the file */
    int filetype;
    
    /* block buffer */
    int bp; /* buffer pointer */
    int be; /* buffer end, when bp==be, the buffer is empty */
    int lastblock;
    uchar buffer[256]; /* sector buffer */
    
    /* things for if it is a directory */
    int isdir;
    fs64_direntry de;
    /* blocks free on filesystem */
    long blocksfree;
    
    /* for if its a buffer */
    int isbuff;

    /* for network streams */
    int socket;
    int msocket;
    int ip;
    int port;
    int sockmode;
    struct sockaddr_in sockaddr;
};
#define fs64_file struct fs64_filestructure

/* shared variables accross modules */
extern int debug_mode;

/* appropriate define for debug messages */
/* its hacky, but it works fine :) */
#define debug_msg if (debug_mode) printf

extern int     last_drive,last_unit;
extern uchar   dos_status[MAX_NET_DEVS][256];
extern uchar dos_stat_len[MAX_NET_DEVS];
extern uchar  dos_command[MAX_NET_DEVS][256];
extern uchar dos_comm_len[MAX_NET_DEVS];
extern uchar  *partn_dirs[MAX_NET_DEVS][256];
extern int partn_dirtracks[MAX_NET_DEVS][256];
extern int partn_dirsectors[MAX_NET_DEVS][256];
extern int curr_dirtracks[MAX_NET_DEVS][256];
extern int curr_dirsectors[MAX_NET_DEVS][256];
extern int       curr_par[MAX_NET_DEVS];
extern uchar    *curr_dir[MAX_NET_DEVS][256];
extern int pathdir;
extern fs64_file logical_files[MAX_NET_DEVS][16];
extern int georam_size;
extern uchar *georam;

/* defines for fs64direntry.media */
#define media_UFS 1
#define media_D64 2 
#define media_D71 3 
#define media_D81 4 
#define media_DHD 5
#define media_T64 6 
#define media_NET 7
#define media_LNX 8
#define media_BUF 9
/* invalid media types */
#define media_NOTFS 256
#define media_BAD  257

/* defines for cbm file types */
#define cbm_DEL 0
#define cbm_SEQ 1
#define cbm_PRG 2
#define cbm_USR 3
#define cbm_REL 4
#define cbm_CBM 5
#define cbm_DIR 6
#define cbm_UFS 7
#define cbm_NET 8
#define cbm_invalid 15 /* bad filetype - or missing */
#define cbm_CLOSED 0x80
#define cbm_LOCKED 0x40

/* file type masks */
/* = 2**cbm_XXX    */
#define DEL_mask 1
#define SEQ_mask 2
#define PRG_mask 4
#define USR_mask 8
#define REL_mask 16 
#define CBM_mask 32 
#define DIR_mask 64 
#define UFS_mask 128 
#define NET_mask 256

/* archive types for file if in UFS media */
#define arc_UFS 0
#define arc_RAW 1
#define arc_P00 2
#define arc_N64 3

/* file access modes */
#define mode_READ 1
#define mode_WRITE 2
#define mode_BAD 0

/* some commonly used functions */
int set_error(int en,int t,int s);
int fs64_writechar(fs64_file *f,unsigned char c);
int fs64_readchar(fs64_file *f,unsigned char *c);
int fs64_parse_filespec(unsigned char *filespec,unsigned char *path,
			unsigned char *glob,int *dirflag,int *mode,
			int *replace,int *par,int *dirtrack,int *dirsect);
int fs64_parse_path(unsigned char *filespec,unsigned char *path,
			int *par,int *dirtrack,int *dirsect);
int fs64_openfile_g(unsigned char *curdir,unsigned char *filespec,fs64_file *f);
int fs64_closefile_g(fs64_file *f);
int fs64_blocksfree(fs64_filesystem *fs);
int fs64_findfreeblock(fs64_filesystem *fs,int *track,int *sector);
int fs64_isblockfree(fs64_filesystem *fs,int track,int sector);
int fs64_deallocateblock(fs64_filesystem *fs,int track,int sector);
int fs64_allocateblock(fs64_filesystem *fs,int track,int sector);
int parse_glob(unsigned char glob_array[17][32],unsigned char *pattern);
int glob_comp(unsigned char *pattern,unsigned char *test,int filetype);
int glob_match(unsigned char *glob,unsigned char *pattern);
int glob_p_comp(unsigned char glob_array[17][32],unsigned char *pattern);
int fs64_closefile(fs64_file *f);
int fs64_openfile(fs64_direntry *de,fs64_file *f);
int fs64_readblock(fs64_file *f);
int fs64_writeblock(fs64_file *f);
int fs64_findfirst(char *path,fs64_direntry *de,int *dirtrack,int *dirsect);
int fs64_findnext(fs64_direntry *de);
int fs64_getinfo(fs64_direntry *de);
int readts(fs64_filesystem *fs,int track,int sector,unsigned char *buffer);
int writets(fs64_filesystem *fs,int track,int sector,unsigned char *buffer);
long fs_resolve_ts(int media,int track,int sector);
int fs64_mediatype(char *path);
int fs64_openfind_g(unsigned char *path,unsigned char *glob,fs64_direntry *de,int *dirtrack,int *dirsect);
int fs64_findfirst_g(unsigned char *path,unsigned char *glob,fs64_direntry *de,int *dirtrack,int *dirsect);
int fs64_findnext_g(fs64_direntry *de);
int fs64_readts(fs64_filesystem *fs,int track,int sector,unsigned char *sb);
int fs64_writets(fs64_filesystem *fs,int track,int sector,unsigned char *sb);
long real_size(char *path,char *name,int mediatype);
long fs_resolve_ts(int media,int track,int sector);
int fs64_resolve_partition(unsigned char *partition,unsigned char *path,int *track,int *sector);
int fs64_closefind_g(fs64_direntry *fe);
int shortname(unsigned char *path,unsigned char *lname,
	      unsigned char *sname,unsigned char *ext);
int fs_pathtofilesystem(fs64_filesystem *fs,char *path);

int fishsendblock(int size, unsigned char *block);
int fishgetblock(int size, unsigned char *block);

/* functins from dosemu.c */
int do_dos_command();
void init_dos();
void reset_drive();
void set_current_dir(unsigned char *foo);

/* functions from commune.c */
int set_drive_status(unsigned char *string,int len);
int which_unit(int dev);
int fatal_error(unsigned char *message);

/* functions from version.c */
char *server_version();
int server_hversion();
int server_lversion();

/* datestamp functions */
int gettimestamp(int *year,int *month,int *day,int *hour,int *minute,int *second);

/* client communications function */
int client_init(char *ledfile);
int client_error(int yesno);
int client_activity(int yesno);

/* commonly used system functions */
int fclose();
int fgetc();
int printf();
int fseek(FILE *, long, int);

/* media_NET #defines 
   These defines are used in the fs64_file structure to define the type
   of the directory
*/
#define net_ROOTDIR      1
#define net_BYTEDIR      2
#define net_HOSTSDIR     3
#define net_SERVERDIR    4
#define net_SERVICESDIR  5
#define net_SERVICE      6
#define net_PORT         7
#define net_PORTDIR      8

/* 
   resource manager defines 
   */
/* limit of resource library size */
#define MAX_RES_COUNT 32
#define RES_DESC_LEN    80
/* resource types */
#define RES_none -1
#define RES_file 1
#define RES_dir 2


#ifdef DEBUG
/* file open and close logging */

FILE *res_fopen(char *a,char *b);
int res_fclose(FILE *f);
DIR *res_opendir(char *a);
int res_closedir(DIR *d);

#define fopen res_fopen
#define fclose res_fclose
#define opendir res_opendir
#define closedir res_closedir

#endif /* #ifdef DEBUG */

/* No net flag */
extern int no_net;

/* port addresses */
extern int outport,inport;
