/*
   Commune.H for 64NET/2 (C)Copyright Paul Gardner-Stephen 1995,
   All rights reserved.
   
   Commune.H - Constants and structures for communicating to the C64/C65/C128
*/

#include "fs.h"
#ifdef BSD
#include "cpufunc.h"
#endif /* BSD */
#include <unistd.h>
#include <stdio.h>

extern char KEYCustomer[1024];
extern float KEYDealerNum;
extern char KEYDealerID[1024],KEYSerial[16],MakeDate[80];

/* debug messages flag */
int debug_mode=0;

/* sync time tolerance */
#define synctolerance 1000
/* ports */
int inport  = 0x3bd;
int outport = 0x3bc;

/* command enumeration */
#define OPEN 'O'
#define CLOSE 'C'
#define SETTALKER 'D'
#define TALK 'R'
#define SETLISTENER 'A'
#define LISTEN 'W'
#define BOOT 'B'
#define LOAD 'L'
#define SAVE 'S'
#define DEVCHECK '?'
/* old exteneded commands */
#define XTENDED 'X'
/* `File System Accelerator' commands */
#define FSACCEL 'F'

#ifdef UNIX
/* file handler for chip-bash permissions */
FILE *f;
#endif /* UNIX */

#ifndef NULL
#define NULL 0
#endif

/* nitty gritty communications variables */

/* Current talk & listen logical files */
int talklf=-1;
int listenlf=-1;
int secaddr=0;

/* Temprary variables used to store filenames and things for
   fs_openfile_g etc 
   */
int fnlen;
unsigned char filename[256];

/* device to communicate over */
unsigned char port[256]={0};

/* structures for redirected devices */

int devices[MAX_NET_DEVS]={0};

/* ** DRIVE and PARTITION resolution: */
/* Partition base directories for each drive */
unsigned char *partn_dirs[MAX_NET_DEVS][256];

/* ** current directories & partitions: */
/* current partition on each drive */
int curr_par[MAX_NET_DEVS];
/* current subdirectory (absolute) for each partition on each
   drive */
unsigned char *curr_dir[MAX_NET_DEVS][256];

/* ** CBM DOS emulation stuff: */
/* DOS Statii */
unsigned char dos_status[MAX_NET_DEVS][256];
/* length of DOS statii */
unsigned char dos_stat_len[MAX_NET_DEVS];
/* DOS commands */
unsigned char dos_command[MAX_NET_DEVS][256];
/* length of DOS command */
unsigned char dos_comm_len[MAX_NET_DEVS]={0};

/* file readable flags (set when first character is read) */
int lf_flags[MAX_NET_DEVS][16];

/* Logical files */
fs64_file logical_files[MAX_NET_DEVS][16];

/* file that points to our communications device */
fs64_file file;

/* dir blocks for partitions */
int partn_dirtracks[MAX_NET_DEVS][256];
int partn_dirsectors[MAX_NET_DEVS][256];
int curr_dirtracks[MAX_NET_DEVS][256];
int curr_dirsectors[MAX_NET_DEVS][256];

int pathdir;

/* Last accessed drive, for the purposes of error channels etc */
int last_drive=-1; /* none */
int last_unit=-1; /* none */

/* number of times we should try to poll before snoozing */
int max_tries=10;
int tries;

/* simulated RAM expander */
int georam_size=0;
uchar *georam;

/* snooz_time */
int snooz_time=70000; /* 70ms - ie "twitch delay" to appear instantaneous */

/* function prototypes */
int syncchar();
int sendchar();
int charget();
int turntoget();
int c64peek (long location);
int c64poke (long location,int val);
int c64print(char *text);
int read_device(FILE *cf);
int c64jsr(int addr,int a,int x, int y);
int sendblock(uchar block[256]);
int gettimer(int *sec,int *ms); /* from datestamp.c */
int fastsendblock(int addr,int size,uchar *the_block);
int fastgetblock(int addr,int size,uchar *the_block);
int fs_accel(); /* from fs_accel.c */
