#ifndef EMULATOR_H
#define EMULATOR_H 1

#include <stdio.h>
#include <limits.h>

/* UBYTE and UWORD must be 8 resp. 16 bits for 100% comp. with 6510 CPU */
/* and ULONG must be 32 bits */

#if SCHAR_MAX == 127 && SCHAR_MIN == -128 && UCHAR_MAX == 255
typedef signed char BYTE;
typedef unsigned char UBYTE;
#else
#  error "No type for 8-bit values!"
#endif

#if SHRT_MAX == 32767 && SHRT_MIN == -32768 && USHRT_MAX == 65535
typedef short int WORD;
typedef unsigned short int UWORD;
#else
#  error "No type for 16-bit values!"
#endif

#if INT_MAX >= 2147483647 && INT_MIN <= -2147483648 && UINT_MAX >= 4294967295U
typedef int LONG;
typedef unsigned int ULONG;
#elif LONG_MAX >= 2147483647 && LONG_MIN <= -2147483648 && ULONG_MAX >= 4294967295U
typedef long int LONG;
typedef unsigned long int ULONG;
#else
#  error "No type with at least 32 bits!"
#endif

#define CYCLESPAL (UWORD)0x4cc8 /* Exactly */

enum EVENTS {
    EV_DMA=0,EV_STOP,
    EV_EXCEPTION,EV_INPUT,
    EV_VIC_SPRITE,EV_VIC_SPRINDEX,
    EV_VIC_CHAR,EV_VIC_BORDER,
    EV_VIC_CHRDMA,
    EV_VIC_CHRINDEX,EV_VIC_GFXREAD,
    EV_CIA1_TIMERA,EV_CIA1_TIMERB,
    EV_CIA1_TOD,EV_CIA1_CHECKIRQ,
    EV_CIA1_ACTIONA,EV_CIA1_ACTIONB,
    EV_CIA1_CLRPB6,EV_CIA1_CLRPB7,
    EV_CIA2_TIMERA,EV_CIA2_TIMERB,
    EV_CIA2_TOD,EV_CIA2_CHECKNMI,
    EV_CIA2_ACTIONA,EV_CIA2_ACTIONB,
    EV_CIA2_CLRPB6,EV_CIA2_CLRPB7,
    EV_NR_EVENTS
};

enum VIC_GFX_EVENTS {EV_VIC_GFXDSCROLL=0,EV_VIC_GFXDMODE
		    ,EV_VIC_GFXDENABLE,EV_VIC_GFXMBORDER
		    ,EV_VIC_GFXMODE,EV_VIC_GFXSCROLL
		    ,EV_VIC_GFXVIDEO,EV_VIC_GFXCOLBOR
		    ,EV_VIC_GFXCOLBG,EV_VIC_GFXCOLBG1
		    ,EV_VIC_GFXCOLBG2,EV_VIC_GFXCOLBG3
		    ,EV_VIC_GFXDMA,EV_VIC_GFXIDXEND
		    ,EV_VIC_GFXENABLE,EV_VIC_GFXIDLE
		    ,EV_VIC_GFXDIDLE};
enum VIC_SPR_EVENTS {EV_VIC_SPRX0=0,EV_VIC_SPRX1
		    ,EV_VIC_SPRX2,EV_VIC_SPRX3
		    ,EV_VIC_SPRX4,EV_VIC_SPRX5
		    ,EV_VIC_SPRX6,EV_VIC_SPRX7
		    ,EV_VIC_SPRXHI,EV_VIC_SPRPRI
		    ,EV_VIC_SPRMUL,EV_VIC_SPREXP
		    ,EV_VIC_SPRCOLM0,EV_VIC_SPRCOLM1
		    ,EV_VIC_SPRCOL0,EV_VIC_SPRCOL1
		    ,EV_VIC_SPRCOL2,EV_VIC_SPRCOL3
		    ,EV_VIC_SPRCOL4,EV_VIC_SPRCOL5
		    ,EV_VIC_SPRCOL6,EV_VIC_SPRCOL7};
enum SID_EVENTS {EV_SID_V1FREQL=0,EV_SID_V1FREQH
		,EV_SID_V1PULSEL,EV_SID_V1PULSEH
		,EV_SID_V1CONTROL,EV_SID_V1ATTDEC
		,EV_SID_V1SUSREL,EV_SID_V2FREQL
		,EV_SID_V2FREQH,EV_SID_V2PULSEL
		,EV_SID_V2PULSEH,EV_SID_V2CONTROL
		,EV_SID_V2ATTDEC,EV_SID_V2SUSREL
		,EV_SID_V3FREQL,EV_SID_V3FREQH
		,EV_SID_V3PULSEL,EV_SID_V3PULSEH
		,EV_SID_V3CONTROL,EV_SID_V3ATTDEC
		,EV_SID_V3SUSREL,EV_SID_FILFREQL
		,EV_SID_FILFREQH,EV_SID_FILRES
		,EV_SID_VOLUME};
enum INPUT_EVENTS {EV_INP_TAPE=0,EV_INP_LIGHTPEN};

class Regs6510
{
  public:
    UWORD pc;
    UBYTE a,x,y,sp,sr;
};

struct InEvent
{
  UWORD cycle;
  UBYTE type;
  UBYTE data;
};

struct SidEvent
{
  unsigned int cycle;
  unsigned int type;
  unsigned int data;
};

struct GfxEvent
{
  unsigned int cycle;
  unsigned int type;
  unsigned int data;
};

struct SpriteEvent
{
  ULONG pixel;
  unsigned int next;
  unsigned int type;
  ULONG data;
};

struct GfxReadSave
{
  unsigned int cy;
  unsigned int type;
  unsigned int data;
  unsigned int *addr1;
  unsigned int *addr2;
};

class SID;
class VIC;
class C1541;
class SerialBus;
class C64 {
    public:
	C64();
	~C64();
	void Reset();
	void SoftReset();
	void EnableCartridge(const int);
	int CartridgeIsEnabled();
	void EnableC1541(const int);
        int C1541IsEnabled();
	UWORD Run6510(UWORD);
	void SetKey(const int);
        void SetKeys(const UBYTE *keys);
	void SetRestoreKey();
	void SetJoystick(const int,int);
	void SetPaddles(const int,const int,const int);
	void SetIO(const unsigned int,const unsigned int,UBYTE*);
	void SetRom(const unsigned int,const unsigned int,UBYTE*);
	void SetRam(const unsigned int,const unsigned int,UBYTE*);
	void GetIO(const unsigned int,const unsigned int,UBYTE*);
	void GetRom(const unsigned int,const unsigned int,UBYTE*);
	void GetRam(const unsigned int,const unsigned int,UBYTE*);
	void GetMemory(unsigned int addr,unsigned int length
	  ,UBYTE* buffer,int bank);
	void SetMemory(unsigned int addr,unsigned int length
	  ,UBYTE* buffer,int bank);
	unsigned int * UpdateNextRaster(void);
	unsigned int UpdateNextWave(WORD *);
	void SetSampleFreq(unsigned int);
	void Set6510Status(const Regs6510& regs);
	Regs6510 Get6510Status();
	void LoadTurboTape(unsigned char *data,LONG len);
	void LoadOriginalTape(unsigned char *data,LONG len);
	void SaveFreeze(FILE *file);
	void LoadFreeze(FILE *file);
	UWORD GetC64Cycle();
	UWORD Get1541Cycle();
	UBYTE GetC64MemoryBank();
    private:
	void InitMMU();
	unsigned int ReadIO00(const unsigned int);
	unsigned int ReadIO80(const unsigned int);
	unsigned int ReadIO81(const unsigned int);
	unsigned int ReadIO82(const unsigned int);
	unsigned int ReadIO83(const unsigned int);
	unsigned int ReadIO84(const unsigned int);
	unsigned int ReadIO85(const unsigned int);
	unsigned int ReadIO86(const unsigned int);
	unsigned int ReadIO87(const unsigned int);
	unsigned int ReadIO88(const unsigned int);
	unsigned int ReadIO89(const unsigned int);
	unsigned int ReadIO8A(const unsigned int);
	unsigned int ReadIO8B(const unsigned int);
	unsigned int ReadIO8C(const unsigned int);
	unsigned int ReadIO8D(const unsigned int);
	unsigned int ReadIO8E(const unsigned int);
	unsigned int ReadIO8F(const unsigned int);
	unsigned int ReadIO90(const unsigned int);
	unsigned int ReadIO91(const unsigned int);
	unsigned int ReadIO92(const unsigned int);
	unsigned int ReadIO93(const unsigned int);
	unsigned int ReadIO94(const unsigned int);
	unsigned int ReadIO95(const unsigned int);
	unsigned int ReadIO96(const unsigned int);
	unsigned int ReadIO97(const unsigned int);
	unsigned int ReadIO98(const unsigned int);
	unsigned int ReadIO99(const unsigned int);
	unsigned int ReadIO9A(const unsigned int);
	unsigned int ReadIO9B(const unsigned int);
	unsigned int ReadIO9C(const unsigned int);
	unsigned int ReadIO9D(const unsigned int);
	unsigned int ReadIO9E(const unsigned int);
	unsigned int ReadIO9F(const unsigned int);
	unsigned int ReadIOA0(const unsigned int);
	unsigned int ReadIOA1(const unsigned int);
	unsigned int ReadIOA2(const unsigned int);
	unsigned int ReadIOA3(const unsigned int);
	unsigned int ReadIOA4(const unsigned int);
	unsigned int ReadIOA5(const unsigned int);
	unsigned int ReadIOA6(const unsigned int);
	unsigned int ReadIOA7(const unsigned int);
	unsigned int ReadIOA8(const unsigned int);
	unsigned int ReadIOA9(const unsigned int);
	unsigned int ReadIOAA(const unsigned int);
	unsigned int ReadIOAB(const unsigned int);
	unsigned int ReadIOAC(const unsigned int);
	unsigned int ReadIOAD(const unsigned int);
	unsigned int ReadIOAE(const unsigned int);
	unsigned int ReadIOAF(const unsigned int);
	unsigned int ReadIOB0(const unsigned int);
	unsigned int ReadIOB1(const unsigned int);
	unsigned int ReadIOB2(const unsigned int);
	unsigned int ReadIOB3(const unsigned int);
	unsigned int ReadIOB4(const unsigned int);
	unsigned int ReadIOB5(const unsigned int);
	unsigned int ReadIOB6(const unsigned int);
	unsigned int ReadIOB7(const unsigned int);
	unsigned int ReadIOB8(const unsigned int);
	unsigned int ReadIOB9(const unsigned int);
	unsigned int ReadIOBA(const unsigned int);
	unsigned int ReadIOBB(const unsigned int);
	unsigned int ReadIOBC(const unsigned int);
	unsigned int ReadIOBD(const unsigned int);
	unsigned int ReadIOBE(const unsigned int);
	unsigned int ReadIOBF(const unsigned int);
	unsigned int ReadIOC0(const unsigned int);
	unsigned int ReadIOC1(const unsigned int);
	unsigned int ReadIOC2(const unsigned int);
	unsigned int ReadIOC3(const unsigned int);
	unsigned int ReadIOC4(const unsigned int);
	unsigned int ReadIOC5(const unsigned int);
	unsigned int ReadIOC6(const unsigned int);
	unsigned int ReadIOC7(const unsigned int);
	unsigned int ReadIOC8(const unsigned int);
	unsigned int ReadIOC9(const unsigned int);
	unsigned int ReadIOCA(const unsigned int);
	unsigned int ReadIOCB(const unsigned int);
	unsigned int ReadIOCC(const unsigned int);
	unsigned int ReadIOCD(const unsigned int);
	unsigned int ReadIOCE(const unsigned int);
	unsigned int ReadIOCF(const unsigned int);
	unsigned int ReadIOD0(const unsigned int);
	unsigned int ReadIOD1(const unsigned int);
	unsigned int ReadIOD2(const unsigned int);
	unsigned int ReadIOD3(const unsigned int);
	unsigned int ReadIOD4(const unsigned int);
	unsigned int ReadIOD5(const unsigned int);
	unsigned int ReadIOD6(const unsigned int);
	unsigned int ReadIOD7(const unsigned int);
	unsigned int ReadIOD8(const unsigned int);
	unsigned int ReadIOD9(const unsigned int);
	unsigned int ReadIODA(const unsigned int);
	unsigned int ReadIODB(const unsigned int);
	unsigned int ReadIODC(const unsigned int);
	unsigned int ReadIODD(const unsigned int);
	unsigned int ReadIODE(const unsigned int);
	unsigned int ReadIODF(const unsigned int);
	unsigned int ReadIOE0(const unsigned int);
	unsigned int ReadIOE0_2(const unsigned int);
	unsigned int ReadIOE1(const unsigned int);
	unsigned int ReadIOE2(const unsigned int);
	unsigned int ReadIOE3(const unsigned int);
	unsigned int ReadIOE4(const unsigned int);
	unsigned int ReadIOE5(const unsigned int);
	unsigned int ReadIOE6(const unsigned int);
	unsigned int ReadIOE7(const unsigned int);
	unsigned int ReadIOE8(const unsigned int);
	unsigned int ReadIOE9(const unsigned int);
	unsigned int ReadIOEA(const unsigned int);
	unsigned int ReadIOEB(const unsigned int);
	unsigned int ReadIOEC(const unsigned int);
	unsigned int ReadIOED(const unsigned int);
	unsigned int ReadIOEE(const unsigned int);
	unsigned int ReadIOEF(const unsigned int);
	unsigned int ReadIOF0(const unsigned int);
	unsigned int ReadIOF1(const unsigned int);
	unsigned int ReadIOF2(const unsigned int);
	unsigned int ReadIOF3(const unsigned int);
	unsigned int ReadIOF4(const unsigned int);
	unsigned int ReadIOF5(const unsigned int);
	unsigned int ReadIOF6(const unsigned int);
	unsigned int ReadIOF7(const unsigned int);
	unsigned int ReadIOF8(const unsigned int);
	unsigned int ReadIOF9(const unsigned int);
	unsigned int ReadIOFA(const unsigned int);
	unsigned int ReadIOFB(const unsigned int);
	unsigned int ReadIOFC(const unsigned int);
	unsigned int ReadIOFD(const unsigned int);
	unsigned int ReadIOFE(const unsigned int);
	unsigned int ReadIOFF(const unsigned int);

	unsigned int WriteIO00(const unsigned int,const unsigned int);
	unsigned int WriteIO80(const unsigned int,const unsigned int);
	unsigned int WriteIO81(const unsigned int,const unsigned int);
	unsigned int WriteIO82(const unsigned int,const unsigned int);
	unsigned int WriteIO83(const unsigned int,const unsigned int);
	unsigned int WriteIO84(const unsigned int,const unsigned int);
	unsigned int WriteIO85(const unsigned int,const unsigned int);
	unsigned int WriteIO86(const unsigned int,const unsigned int);
	unsigned int WriteIO87(const unsigned int,const unsigned int);
	unsigned int WriteIO88(const unsigned int,const unsigned int);
	unsigned int WriteIO89(const unsigned int,const unsigned int);
	unsigned int WriteIO8A(const unsigned int,const unsigned int);
	unsigned int WriteIO8B(const unsigned int,const unsigned int);
	unsigned int WriteIO8C(const unsigned int,const unsigned int);
	unsigned int WriteIO8D(const unsigned int,const unsigned int);
	unsigned int WriteIO8E(const unsigned int,const unsigned int);
	unsigned int WriteIO8F(const unsigned int,const unsigned int);
	unsigned int WriteIO90(const unsigned int,const unsigned int);
	unsigned int WriteIO91(const unsigned int,const unsigned int);
	unsigned int WriteIO92(const unsigned int,const unsigned int);
	unsigned int WriteIO93(const unsigned int,const unsigned int);
	unsigned int WriteIO94(const unsigned int,const unsigned int);
	unsigned int WriteIO95(const unsigned int,const unsigned int);
	unsigned int WriteIO96(const unsigned int,const unsigned int);
	unsigned int WriteIO97(const unsigned int,const unsigned int);
	unsigned int WriteIO98(const unsigned int,const unsigned int);
	unsigned int WriteIO99(const unsigned int,const unsigned int);
	unsigned int WriteIO9A(const unsigned int,const unsigned int);
	unsigned int WriteIO9B(const unsigned int,const unsigned int);
	unsigned int WriteIO9C(const unsigned int,const unsigned int);
	unsigned int WriteIO9D(const unsigned int,const unsigned int);
	unsigned int WriteIO9E(const unsigned int,const unsigned int);
	unsigned int WriteIO9F(const unsigned int,const unsigned int);
	unsigned int WriteIOA0(const unsigned int,const unsigned int);
	unsigned int WriteIOA1(const unsigned int,const unsigned int);
	unsigned int WriteIOA2(const unsigned int,const unsigned int);
	unsigned int WriteIOA3(const unsigned int,const unsigned int);
	unsigned int WriteIOA4(const unsigned int,const unsigned int);
	unsigned int WriteIOA5(const unsigned int,const unsigned int);
	unsigned int WriteIOA6(const unsigned int,const unsigned int);
	unsigned int WriteIOA7(const unsigned int,const unsigned int);
	unsigned int WriteIOA8(const unsigned int,const unsigned int);
	unsigned int WriteIOA9(const unsigned int,const unsigned int);
	unsigned int WriteIOAA(const unsigned int,const unsigned int);
	unsigned int WriteIOAB(const unsigned int,const unsigned int);
	unsigned int WriteIOAC(const unsigned int,const unsigned int);
	unsigned int WriteIOAD(const unsigned int,const unsigned int);
	unsigned int WriteIOAE(const unsigned int,const unsigned int);
	unsigned int WriteIOAF(const unsigned int,const unsigned int);
	unsigned int WriteIOB0(const unsigned int,const unsigned int);
	unsigned int WriteIOB1(const unsigned int,const unsigned int);
	unsigned int WriteIOB2(const unsigned int,const unsigned int);
	unsigned int WriteIOB3(const unsigned int,const unsigned int);
	unsigned int WriteIOB4(const unsigned int,const unsigned int);
	unsigned int WriteIOB5(const unsigned int,const unsigned int);
	unsigned int WriteIOB6(const unsigned int,const unsigned int);
	unsigned int WriteIOB7(const unsigned int,const unsigned int);
	unsigned int WriteIOB8(const unsigned int,const unsigned int);
	unsigned int WriteIOB9(const unsigned int,const unsigned int);
	unsigned int WriteIOBA(const unsigned int,const unsigned int);
	unsigned int WriteIOBB(const unsigned int,const unsigned int);
	unsigned int WriteIOBC(const unsigned int,const unsigned int);
	unsigned int WriteIOBD(const unsigned int,const unsigned int);
	unsigned int WriteIOBE(const unsigned int,const unsigned int);
	unsigned int WriteIOBF(const unsigned int,const unsigned int);
	unsigned int WriteIOC0(const unsigned int,const unsigned int);
	unsigned int WriteIOC1(const unsigned int,const unsigned int);
	unsigned int WriteIOC2(const unsigned int,const unsigned int);
	unsigned int WriteIOC3(const unsigned int,const unsigned int);
	unsigned int WriteIOC4(const unsigned int,const unsigned int);
	unsigned int WriteIOC5(const unsigned int,const unsigned int);
	unsigned int WriteIOC6(const unsigned int,const unsigned int);
	unsigned int WriteIOC7(const unsigned int,const unsigned int);
	unsigned int WriteIOC8(const unsigned int,const unsigned int);
	unsigned int WriteIOC9(const unsigned int,const unsigned int);
	unsigned int WriteIOCA(const unsigned int,const unsigned int);
	unsigned int WriteIOCB(const unsigned int,const unsigned int);
	unsigned int WriteIOCC(const unsigned int,const unsigned int);
	unsigned int WriteIOCD(const unsigned int,const unsigned int);
	unsigned int WriteIOCE(const unsigned int,const unsigned int);
	unsigned int WriteIOCF(const unsigned int,const unsigned int);
	unsigned int WriteIOD0(const unsigned int,const unsigned int);
	unsigned int WriteIOD1(const unsigned int,const unsigned int);
	unsigned int WriteIOD2(const unsigned int,const unsigned int);
	unsigned int WriteIOD3(const unsigned int,const unsigned int);
	unsigned int WriteIOD4(const unsigned int,const unsigned int);
	unsigned int WriteIOD5(const unsigned int,const unsigned int);
	unsigned int WriteIOD6(const unsigned int,const unsigned int);
	unsigned int WriteIOD7(const unsigned int,const unsigned int);
	unsigned int WriteIOD8(const unsigned int,const unsigned int);
	unsigned int WriteIOD9(const unsigned int,const unsigned int);
	unsigned int WriteIODA(const unsigned int,const unsigned int);
	unsigned int WriteIODB(const unsigned int,const unsigned int);
	unsigned int WriteIODC(const unsigned int,const unsigned int);
	unsigned int WriteIODD(const unsigned int,const unsigned int);
	unsigned int WriteIODE(const unsigned int,const unsigned int);
	unsigned int WriteIODF(const unsigned int,const unsigned int);
	unsigned int WriteIOE0(const unsigned int,const unsigned int);
	unsigned int WriteIOE0_2(const unsigned int,const unsigned int);
	unsigned int WriteIOE1(const unsigned int,const unsigned int);
	unsigned int WriteIOE2(const unsigned int,const unsigned int);
	unsigned int WriteIOE3(const unsigned int,const unsigned int);
	unsigned int WriteIOE4(const unsigned int,const unsigned int);
	unsigned int WriteIOE5(const unsigned int,const unsigned int);
	unsigned int WriteIOE6(const unsigned int,const unsigned int);
	unsigned int WriteIOE7(const unsigned int,const unsigned int);
	unsigned int WriteIOE8(const unsigned int,const unsigned int);
	unsigned int WriteIOE9(const unsigned int,const unsigned int);
	unsigned int WriteIOEA(const unsigned int,const unsigned int);
	unsigned int WriteIOEB(const unsigned int,const unsigned int);
	unsigned int WriteIOEC(const unsigned int,const unsigned int);
	unsigned int WriteIOED(const unsigned int,const unsigned int);
	unsigned int WriteIOEE(const unsigned int,const unsigned int);
	unsigned int WriteIOEF(const unsigned int,const unsigned int);
	unsigned int WriteIOF0(const unsigned int,const unsigned int);
	unsigned int WriteIOF1(const unsigned int,const unsigned int);
	unsigned int WriteIOF2(const unsigned int,const unsigned int);
	unsigned int WriteIOF3(const unsigned int,const unsigned int);
	unsigned int WriteIOF4(const unsigned int,const unsigned int);
	unsigned int WriteIOF5(const unsigned int,const unsigned int);
	unsigned int WriteIOF6(const unsigned int,const unsigned int);
	unsigned int WriteIOF7(const unsigned int,const unsigned int);
	unsigned int WriteIOF8(const unsigned int,const unsigned int);
	unsigned int WriteIOF9(const unsigned int,const unsigned int);
	unsigned int WriteIOFA(const unsigned int,const unsigned int);
	unsigned int WriteIOFB(const unsigned int,const unsigned int);
	unsigned int WriteIOFC(const unsigned int,const unsigned int);
	unsigned int WriteIOFD(const unsigned int,const unsigned int);
	unsigned int WriteIOFE(const unsigned int,const unsigned int);
	unsigned int WriteIOFF(const unsigned int,const unsigned int);

	unsigned int WannaRead();
	unsigned int WannaWrite();
	void SetExceptionNextCycle(unsigned int);
	unsigned int CheckEventStop();
	unsigned int CheckEventException();
	unsigned int CheckEventInput();
	unsigned int CheckEventVicSprite();
	unsigned int CheckEventVicSpriteIndex();
	unsigned int CheckEventVicChar();
	unsigned int CheckEventVicBorder();
	unsigned int CheckEventVicChrDma();
	unsigned int CheckEventVicChrIndex();
	unsigned int CheckEventVicGfxRead();
	unsigned int CheckEventCia1TimerA();
	unsigned int CheckEventCia1TimerB();
	unsigned int CheckEventCia1Tod();
	unsigned int CheckEventCia1ActionA();
	unsigned int CheckEventCia1ActionB();
	unsigned int CheckEventCia1CheckIrq();
	unsigned int CheckEventCia1ClrPB6();
	unsigned int CheckEventCia1ClrPB7();
	unsigned int CheckEventCia2TimerA();
	unsigned int CheckEventCia2TimerB();
	unsigned int CheckEventCia2Tod();
	unsigned int CheckEventCia2ActionA();
	unsigned int CheckEventCia2ActionB();
	unsigned int CheckEventCia2CheckNmi();
	unsigned int CheckEventCia2ClrPB6();
	unsigned int CheckEventCia2ClrPB7();

	void SortSpriteDma(const unsigned int);
	void SortSpriteDma(const unsigned int,const unsigned int
			  ,unsigned int);
	void UpdateTape(void);
	void SortEvents();
	unsigned int SortEvents(unsigned int);
	void SortInEvents(void);
	void SortVicEvents();
	void SortVicEvents(const unsigned int,const unsigned int);
	void SortCia1Events();
	void SortCia1Events(const unsigned int,const unsigned int);
	void SortCia2Events();
	void SortCia2Events(const unsigned int,const unsigned int);
	unsigned int FixEvents(unsigned int);
	void SaveSpriteData(const unsigned int);
	void CheckSpriteCollision(const unsigned int);
	void CheckSpriteColSpr(const unsigned int);
	ULONG CheckSpriteColBg1(const int);
	void CheckSpriteColBg2(const int);
	void ReadGfxDmaData(const int);
	void ReadGfxRowData(void);
	void ReadGfxRowDataSpec(void);
	unsigned int * ReadRowMode01(unsigned int *,unsigned int
				    ,unsigned int);
	unsigned int * ReadRowMode23(unsigned int *,unsigned int
				    ,unsigned int);
	unsigned int * ReadRowMode4(unsigned int *,unsigned int
				   ,unsigned int);
	unsigned int GetVicPhase1Read(unsigned int x);
	unsigned int GetIO(int io,unsigned int addr);
	void SetIO(int io,unsigned int addr,unsigned int data);

	friend class CPU;

	unsigned int rastercy;
	unsigned int eventcy;
	unsigned int eventtype;
	unsigned int notdmaeventcy;

	unsigned int notdmaeventtype;
	unsigned int dmacy;
	unsigned int stopcy;
	unsigned int exceptioncy;

	unsigned int incy;
	unsigned int indata;
	unsigned int viccy;
	unsigned int vicdata;

	unsigned int cia1cy;
	unsigned int cia1data;
	unsigned int cia2cy;
	unsigned int cia2data;

	unsigned int vicSpriteOncy;
	unsigned int vicCharcy;
	unsigned int vicDmacy;
	unsigned int vicCharIndexcy;

	unsigned int vicBordercy;
	unsigned int vicGfxReadcy;
	unsigned int vicSpriteIndexcy;

	unsigned int lightPency;

	unsigned int (C64::*eventPtr)();
	unsigned int (C64::*eventPtrTable[EV_NR_EVENTS])();

	unsigned int cycle;
	CPU *cpu;
	SID *sid;
    public:
	VIC *vic;
	C1541 *c1541;
    private:
	SerialBus *serialBus;

	unsigned int* c64Ram;
	unsigned int* colorRam; /* 1k nybbles of colorram - $d800-$dbff I/O */
	unsigned int* c64Rom;

	unsigned int cia1TodCounter;
	unsigned int cia1Tod[4];
	unsigned int cia1TodLatch[4];
	unsigned int cia1TodAlarm[4];
	unsigned int cia1TodLatchOn;
	unsigned int cia2TodCounter;
	unsigned int cia2Tod[4];
	unsigned int cia2TodAlarm[4];
	unsigned int cia2TodLatch[4];
	unsigned int cia2TodLatchOn;
	unsigned int cia1Todcy;
	unsigned int cia2Todcy;
	unsigned int cia1ShiftCounter;
	unsigned int cia2ShiftCounter;
	unsigned int cia1TimerAActioncy;
	unsigned int cia1TimerBActioncy;
	unsigned int cia2TimerAActioncy;
	unsigned int cia2TimerBActioncy;
	unsigned int cia1TimerAActiondata;
	unsigned int cia1TimerBActiondata;
	unsigned int cia2TimerAActiondata;
	unsigned int cia2TimerBActiondata;

	unsigned int cia1TimerAActionState;
	unsigned int cia1TimerBActionState;
	unsigned int cia2TimerAActionState;
	unsigned int cia2TimerBActionState;

	unsigned int cia1TimerAState;
	unsigned int cia1TimerBState;
	unsigned int cia2TimerAState;
	unsigned int cia2TimerBState;

	unsigned int cia1TimerALoad;
	unsigned int cia1TimerBLoad;
	unsigned int cia2TimerALoad;
	unsigned int cia2TimerBLoad;

	unsigned int cia1TimerBAgain;
	unsigned int cia2TimerBAgain;

	unsigned int cia1CheckIrqcy;
	unsigned int cia2CheckNmicy;

	unsigned int cia1ClrPB6cy;
	unsigned int cia1ClrPB7cy;
	unsigned int cia2ClrPB6cy;
	unsigned int cia2ClrPB7cy;

	unsigned int vicSpriteOndata;
	unsigned int vicSpriteLowest;
	unsigned int vicRaster;
	unsigned int vicRasterCycle;
        unsigned int vicRasterCompare;
	unsigned int vicgfxenable;
	unsigned int viccharindex;
	unsigned int viccharindexadd;
	unsigned int vicBlank;
	unsigned int vicMiddleBorder;
	unsigned int vicIdleGfxAddr;
	unsigned int sidcy;
	unsigned int irqvic;
	unsigned int irqcia1;
	unsigned int nmicia2;
	unsigned int nmirestore;
	unsigned int saveVicMiddleBorder[2];
	unsigned int nochardma;
	unsigned int spritedma;	/* Bit x => Sprite x active */
	unsigned int mmuind;
	unsigned int mos6510ddr;
	unsigned int mos6510in;
	unsigned int mos6510out;
	int enableCart8000;
	int enableC1541;
	unsigned int keymatrix1[8];
	unsigned int keymatrix2[8];
	unsigned int keylshift;
	unsigned int joystick1;
	unsigned int joystick2;
	unsigned int cia1PBAnd;
	unsigned int cia1PBOr;
	unsigned int cia1PBToggle;
	unsigned int cia2PBAnd;
	unsigned int cia2PBOr;
	unsigned int cia2PBToggle;
	unsigned int paddleX1;
	unsigned int paddleY1;
	unsigned int paddleX2;
	unsigned int paddleY2;
	int lightPenEnable;
	int keyReadPortB;
	int keyReadPortA;

	unsigned int tapeSaveCy;
	LONG tapeSaveCounter;
	unsigned char *tapeSaveData;
	unsigned int tapecy;
	int tapeBit;
	LONG tapeCounter;
	LONG tapeLen;
	unsigned char *tapeData;
	int tapeMode;

	unsigned int cia1TimerALatch;
	unsigned int cia1TimerBLatch;
	unsigned int cia2TimerALatch;
	unsigned int cia2TimerBLatch;
	unsigned int cia1TimerACounter;
	unsigned int cia1TimerBCounter;
	unsigned int cia2TimerACounter;
	unsigned int cia2TimerBCounter;
	ULONG cia1TimerAIrqL;
	ULONG cia1TimerBIrqL;
	ULONG cia2TimerAIrqL;
	ULONG cia2TimerBIrqL;
	int cia1TimerANullRun;
	int cia1TimerBNullRun;
	int cia2TimerANullRun;
	int cia2TimerBNullRun;
	UBYTE memMmuTable[7][65792];
	unsigned int mos6566VIC[64]; /* 64 bytes of I/Oreg - $d000-$d03f */
	unsigned int mos6581SID[32]; /* 32 bytes of I/Oreg - $d400-$d41f */
	unsigned int mos6526CIA1[32]; /* 32 bytes of I/Oreg - $dc00-$dc0f */
	unsigned int mos6526CIA2[32]; /* 32 bytes of I/Oreg - $dd00-$dd0f */
	unsigned int mos6566VICcopy[2][64]; /* 64 bytes of I/Oreg - $d000-$d03f */
	unsigned int mos6581SIDcopy[2][32]; /* 32 bytes of I/Oreg - $d400-$d41f */
	unsigned int mos6526CIA1copy[2][32]; /* 32 bytes of I/Oreg - $dc00-$dc0f */
	unsigned int mos6526CIA2copy[2][32]; /* 32 bytes of I/Oreg - $dd00-$dd0f */
	UBYTE *mmuTables[256]; /* 7 * 64k of mmudata */

	GfxEvent memGfxSaveData[2][0x1400];
	SidEvent memSidSaveData[2][0x1400];
	SpriteEvent memSpriteSaveData[2][0x1400];
	unsigned int memVicCharDmaData[2][0x3e80];
	unsigned int *charDmaData;
	unsigned int *colorDmaData;
	unsigned int gfxDmaDataMem[2][0x0138][0x28];
	unsigned int *gfxDmaData[0x0138];
	ULONG spriteDmaDataMem[2][0x0138][0x08];
	ULONG *spriteDmaData[0x0138];
	unsigned int memSpriteActiveSave[2][0x0138];
	unsigned int *spriteActiveSave;
	GfxReadSave gfxReadSaveMem[0x10];
	GfxReadSave *gfxReadSave;
	unsigned int gfxDmaRow;
	unsigned int gfxDmaMode;
	unsigned int *gfxDmaDotBase;
	unsigned int *gfxDmaVideoBase;
	unsigned int gfxCharIndex;
	unsigned int *vicAddrDotBase;
	unsigned int *vicAddrVideoBase;

	GfxEvent *gfxsavedata;
	SidEvent *sidsavedata;
	SpriteEvent *spriteSaveData;
	unsigned int spriteSaveIndexMax;
	unsigned int spriteSaveIndex[9];
	unsigned int spriteSaveIndexcopy[2][9];
	unsigned int *vicCharDmaData;
	int saveVicDataIndex;
	int saveSidDataIndex;
        unsigned int lastVicFrame;
	unsigned int spriteindex[8];
        unsigned int spriteIndexNext;
        unsigned int spriteIndexOldNext;
	int spriteStart[8];
	ULONG spritepixels[8][2];
	int spriteValid;
    	int spriteSprSprNextPos;
	int spriteSprSprPossible;
	int spriteirq2trg;
	int spriteirq4trg;
    	int spriteLen[8];
	unsigned int vic16Kbase;
	unsigned int vicvideobase;
	unsigned int viccharbase;
	static unsigned int rasterConvert[0x0200];
	static unsigned int spriteConvertX[0x200];
	static unsigned int spriteConvertExp[0x100];
	static unsigned int spriteConvertExpHi[0x100];
	static unsigned int spriteConvertMul[0x0100];
        static unsigned int extendedColorTable[0x0100];
        static ULONG bitMask[32];
	static const unsigned int spriteIndexIncTable[0x40];
    public:
        ULONG frameCounter;
};

#endif

