#ifndef C1541_H
#define C1541_H 1

#include "emulator.h"

#define CYCLES1541 (UWORD)0x4dee /* Exactly */

class Regs6502
{
  public:
    UWORD pc;
    UBYTE a,x,y,sp,sr;
};

class SerialBus
{
  public:
    unsigned int c64Out;
    unsigned int c64In;
};

class C1541 {
	enum C1541_EVENTS {
	  EV_STOP,EV_EXCEPTION,
	  EV_VIA1_TIMERA,EV_VIA1_TIMERB,
	  EV_VIA2_TIMERA,EV_VIA2_TIMERB,
	  EV_WRAP,EV_SYNC,
	  EV_DATA,EV_C64OUT,
	  EV_NR_EVENTS
	};
    public:
	C1541();
	~C1541();
	void Reset();
	void SoftReset();
	void Run6502(unsigned int cy,ULONG frame,SerialBus *bus);
	void Run6502SerialRead(unsigned int cy,ULONG frame,SerialBus *bus);
	void Run6502SerialWrite(unsigned int cy,ULONG frame,SerialBus *bus);
	void SetIO(const unsigned int,const unsigned int,UBYTE*);
	void SetRom(const unsigned int,const unsigned int,UBYTE*);
	void SetRam(const unsigned int,const unsigned int,UBYTE*);
	void GetIO(const unsigned int,const unsigned int,UBYTE*);
	void GetRom(const unsigned int,const unsigned int,UBYTE*);
	void GetRam(const unsigned int,const unsigned int,UBYTE*);
	void GetMemory(unsigned int addr,unsigned int length
	  ,UBYTE* buffer);
	void SetMemory(unsigned int addr,unsigned int length
	  ,UBYTE* buffer);
	void Set6502Status(const Regs6502& regs);
	Regs6502 Get6502Status();
	void LoadImageD64(UBYTE *src,int nr);
	void SaveImageD64(UBYTE *dst,int nr=35);
	void SaveFreeze(FILE *file);
	void LoadFreeze(FILE *file);
	void InitializeDisk();
	int LedStatus();
	int DiskNeedSave();
	int Inactive();
	void Accessed();
        UWORD GetCycle();
    private:
	void InitMMU();
	unsigned int ReadIO00(const unsigned int);
	unsigned int ReadIO80(const unsigned int);
	unsigned int ReadIO81(const unsigned int);
	unsigned int ReadIO82(const unsigned int);
	unsigned int ReadIO83(const unsigned int);
	unsigned int ReadIO84(const unsigned int);
	unsigned int ReadIO85(const unsigned int);
	unsigned int ReadIO86(const unsigned int);
	unsigned int ReadIO87(const unsigned int);
	unsigned int ReadIO88(const unsigned int);
	unsigned int ReadIO89(const unsigned int);
	unsigned int ReadIO8A(const unsigned int);
	unsigned int ReadIO8B(const unsigned int);
	unsigned int ReadIO8C(const unsigned int);
	unsigned int ReadIO8D(const unsigned int);
	unsigned int ReadIO8E(const unsigned int);
	unsigned int ReadIO8F(const unsigned int);
	unsigned int ReadIO90(const unsigned int);
	unsigned int ReadIO91(const unsigned int);
	unsigned int ReadIO92(const unsigned int);
	unsigned int ReadIO93(const unsigned int);
	unsigned int ReadIO94(const unsigned int);
	unsigned int ReadIO95(const unsigned int);
	unsigned int ReadIO96(const unsigned int);
	unsigned int ReadIO97(const unsigned int);
	unsigned int ReadIO98(const unsigned int);
	unsigned int ReadIO99(const unsigned int);
	unsigned int ReadIO9A(const unsigned int);
	unsigned int ReadIO9B(const unsigned int);
	unsigned int ReadIO9C(const unsigned int);
	unsigned int ReadIO9D(const unsigned int);
	unsigned int ReadIO9E(const unsigned int);
	unsigned int ReadIO9F(const unsigned int);
	unsigned int ReadIOA0(const unsigned int);
	unsigned int ReadIOA1(const unsigned int);
	unsigned int ReadIOA2(const unsigned int);
	unsigned int ReadIOA3(const unsigned int);
	unsigned int ReadIOA4(const unsigned int);
	unsigned int ReadIOA5(const unsigned int);
	unsigned int ReadIOA6(const unsigned int);
	unsigned int ReadIOA7(const unsigned int);
	unsigned int ReadIOA8(const unsigned int);
	unsigned int ReadIOA9(const unsigned int);
	unsigned int ReadIOAA(const unsigned int);
	unsigned int ReadIOAB(const unsigned int);
	unsigned int ReadIOAC(const unsigned int);
	unsigned int ReadIOAD(const unsigned int);
	unsigned int ReadIOAE(const unsigned int);
	unsigned int ReadIOAF(const unsigned int);
	unsigned int ReadIOB0(const unsigned int);
	unsigned int ReadIOB1(const unsigned int);
	unsigned int ReadIOB2(const unsigned int);
	unsigned int ReadIOB3(const unsigned int);
	unsigned int ReadIOB4(const unsigned int);
	unsigned int ReadIOB5(const unsigned int);
	unsigned int ReadIOB6(const unsigned int);
	unsigned int ReadIOB7(const unsigned int);
	unsigned int ReadIOB8(const unsigned int);
	unsigned int ReadIOB9(const unsigned int);
	unsigned int ReadIOBA(const unsigned int);
	unsigned int ReadIOBB(const unsigned int);
	unsigned int ReadIOBC(const unsigned int);
	unsigned int ReadIOBD(const unsigned int);
	unsigned int ReadIOBE(const unsigned int);
	unsigned int ReadIOBF(const unsigned int);
	unsigned int ReadIOC0(const unsigned int);
	unsigned int ReadIOC1(const unsigned int);
	unsigned int ReadIOC2(const unsigned int);
	unsigned int ReadIOC3(const unsigned int);
	unsigned int ReadIOC4(const unsigned int);
	unsigned int ReadIOC5(const unsigned int);
	unsigned int ReadIOC6(const unsigned int);
	unsigned int ReadIOC7(const unsigned int);
	unsigned int ReadIOC8(const unsigned int);
	unsigned int ReadIOC9(const unsigned int);
	unsigned int ReadIOCA(const unsigned int);
	unsigned int ReadIOCB(const unsigned int);
	unsigned int ReadIOCC(const unsigned int);
	unsigned int ReadIOCD(const unsigned int);
	unsigned int ReadIOCE(const unsigned int);
	unsigned int ReadIOCF(const unsigned int);
	unsigned int ReadIOD0(const unsigned int);
	unsigned int ReadIOD1(const unsigned int);
	unsigned int ReadIOD2(const unsigned int);
	unsigned int ReadIOD3(const unsigned int);
	unsigned int ReadIOD4(const unsigned int);
	unsigned int ReadIOD5(const unsigned int);
	unsigned int ReadIOD6(const unsigned int);
	unsigned int ReadIOD7(const unsigned int);
	unsigned int ReadIOD8(const unsigned int);
	unsigned int ReadIOD9(const unsigned int);
	unsigned int ReadIODA(const unsigned int);
	unsigned int ReadIODB(const unsigned int);
	unsigned int ReadIODC(const unsigned int);
	unsigned int ReadIODD(const unsigned int);
	unsigned int ReadIODE(const unsigned int);
	unsigned int ReadIODF(const unsigned int);
	unsigned int ReadIOE0(const unsigned int);
	unsigned int ReadIOE1(const unsigned int);
	unsigned int ReadIOE2(const unsigned int);
	unsigned int ReadIOE3(const unsigned int);
	unsigned int ReadIOE4(const unsigned int);
	unsigned int ReadIOE5(const unsigned int);
	unsigned int ReadIOE6(const unsigned int);
	unsigned int ReadIOE7(const unsigned int);
	unsigned int ReadIOE8(const unsigned int);
	unsigned int ReadIOE9(const unsigned int);
	unsigned int ReadIOEA(const unsigned int);
	unsigned int ReadIOEB(const unsigned int);
	unsigned int ReadIOEC(const unsigned int);
	unsigned int ReadIOED(const unsigned int);
	unsigned int ReadIOEE(const unsigned int);
	unsigned int ReadIOEF(const unsigned int);
	unsigned int ReadIOF0(const unsigned int);
	unsigned int ReadIOF1(const unsigned int);
	unsigned int ReadIOF2(const unsigned int);
	unsigned int ReadIOF3(const unsigned int);
	unsigned int ReadIOF4(const unsigned int);
	unsigned int ReadIOF5(const unsigned int);
	unsigned int ReadIOF6(const unsigned int);
	unsigned int ReadIOF7(const unsigned int);
	unsigned int ReadIOF8(const unsigned int);
	unsigned int ReadIOF9(const unsigned int);
	unsigned int ReadIOFA(const unsigned int);
	unsigned int ReadIOFB(const unsigned int);
	unsigned int ReadIOFC(const unsigned int);
	unsigned int ReadIOFD(const unsigned int);
	unsigned int ReadIOFE(const unsigned int);
	unsigned int ReadIOFF(const unsigned int);

	unsigned int WriteIO00(const unsigned int,const unsigned int);
	unsigned int WriteIO80(const unsigned int,const unsigned int);
	unsigned int WriteIO81(const unsigned int,const unsigned int);
	unsigned int WriteIO82(const unsigned int,const unsigned int);
	unsigned int WriteIO83(const unsigned int,const unsigned int);
	unsigned int WriteIO84(const unsigned int,const unsigned int);
	unsigned int WriteIO85(const unsigned int,const unsigned int);
	unsigned int WriteIO86(const unsigned int,const unsigned int);
	unsigned int WriteIO87(const unsigned int,const unsigned int);
	unsigned int WriteIO88(const unsigned int,const unsigned int);
	unsigned int WriteIO89(const unsigned int,const unsigned int);
	unsigned int WriteIO8A(const unsigned int,const unsigned int);
	unsigned int WriteIO8B(const unsigned int,const unsigned int);
	unsigned int WriteIO8C(const unsigned int,const unsigned int);
	unsigned int WriteIO8D(const unsigned int,const unsigned int);
	unsigned int WriteIO8E(const unsigned int,const unsigned int);
	unsigned int WriteIO8F(const unsigned int,const unsigned int);
	unsigned int WriteIO90(const unsigned int,const unsigned int);
	unsigned int WriteIO91(const unsigned int,const unsigned int);
	unsigned int WriteIO92(const unsigned int,const unsigned int);
	unsigned int WriteIO93(const unsigned int,const unsigned int);
	unsigned int WriteIO94(const unsigned int,const unsigned int);
	unsigned int WriteIO95(const unsigned int,const unsigned int);
	unsigned int WriteIO96(const unsigned int,const unsigned int);
	unsigned int WriteIO97(const unsigned int,const unsigned int);
	unsigned int WriteIO98(const unsigned int,const unsigned int);
	unsigned int WriteIO99(const unsigned int,const unsigned int);
	unsigned int WriteIO9A(const unsigned int,const unsigned int);
	unsigned int WriteIO9B(const unsigned int,const unsigned int);
	unsigned int WriteIO9C(const unsigned int,const unsigned int);
	unsigned int WriteIO9D(const unsigned int,const unsigned int);
	unsigned int WriteIO9E(const unsigned int,const unsigned int);
	unsigned int WriteIO9F(const unsigned int,const unsigned int);
	unsigned int WriteIOA0(const unsigned int,const unsigned int);
	unsigned int WriteIOA1(const unsigned int,const unsigned int);
	unsigned int WriteIOA2(const unsigned int,const unsigned int);
	unsigned int WriteIOA3(const unsigned int,const unsigned int);
	unsigned int WriteIOA4(const unsigned int,const unsigned int);
	unsigned int WriteIOA5(const unsigned int,const unsigned int);
	unsigned int WriteIOA6(const unsigned int,const unsigned int);
	unsigned int WriteIOA7(const unsigned int,const unsigned int);
	unsigned int WriteIOA8(const unsigned int,const unsigned int);
	unsigned int WriteIOA9(const unsigned int,const unsigned int);
	unsigned int WriteIOAA(const unsigned int,const unsigned int);
	unsigned int WriteIOAB(const unsigned int,const unsigned int);
	unsigned int WriteIOAC(const unsigned int,const unsigned int);
	unsigned int WriteIOAD(const unsigned int,const unsigned int);
	unsigned int WriteIOAE(const unsigned int,const unsigned int);
	unsigned int WriteIOAF(const unsigned int,const unsigned int);
	unsigned int WriteIOB0(const unsigned int,const unsigned int);
	unsigned int WriteIOB1(const unsigned int,const unsigned int);
	unsigned int WriteIOB2(const unsigned int,const unsigned int);
	unsigned int WriteIOB3(const unsigned int,const unsigned int);
	unsigned int WriteIOB4(const unsigned int,const unsigned int);
	unsigned int WriteIOB5(const unsigned int,const unsigned int);
	unsigned int WriteIOB6(const unsigned int,const unsigned int);
	unsigned int WriteIOB7(const unsigned int,const unsigned int);
	unsigned int WriteIOB8(const unsigned int,const unsigned int);
	unsigned int WriteIOB9(const unsigned int,const unsigned int);
	unsigned int WriteIOBA(const unsigned int,const unsigned int);
	unsigned int WriteIOBB(const unsigned int,const unsigned int);
	unsigned int WriteIOBC(const unsigned int,const unsigned int);
	unsigned int WriteIOBD(const unsigned int,const unsigned int);
	unsigned int WriteIOBE(const unsigned int,const unsigned int);
	unsigned int WriteIOBF(const unsigned int,const unsigned int);
	unsigned int WriteIOC0(const unsigned int,const unsigned int);
	unsigned int WriteIOC1(const unsigned int,const unsigned int);
	unsigned int WriteIOC2(const unsigned int,const unsigned int);
	unsigned int WriteIOC3(const unsigned int,const unsigned int);
	unsigned int WriteIOC4(const unsigned int,const unsigned int);
	unsigned int WriteIOC5(const unsigned int,const unsigned int);
	unsigned int WriteIOC6(const unsigned int,const unsigned int);
	unsigned int WriteIOC7(const unsigned int,const unsigned int);
	unsigned int WriteIOC8(const unsigned int,const unsigned int);
	unsigned int WriteIOC9(const unsigned int,const unsigned int);
	unsigned int WriteIOCA(const unsigned int,const unsigned int);
	unsigned int WriteIOCB(const unsigned int,const unsigned int);
	unsigned int WriteIOCC(const unsigned int,const unsigned int);
	unsigned int WriteIOCD(const unsigned int,const unsigned int);
	unsigned int WriteIOCE(const unsigned int,const unsigned int);
	unsigned int WriteIOCF(const unsigned int,const unsigned int);
	unsigned int WriteIOD0(const unsigned int,const unsigned int);
	unsigned int WriteIOD1(const unsigned int,const unsigned int);
	unsigned int WriteIOD2(const unsigned int,const unsigned int);
	unsigned int WriteIOD3(const unsigned int,const unsigned int);
	unsigned int WriteIOD4(const unsigned int,const unsigned int);
	unsigned int WriteIOD5(const unsigned int,const unsigned int);
	unsigned int WriteIOD6(const unsigned int,const unsigned int);
	unsigned int WriteIOD7(const unsigned int,const unsigned int);
	unsigned int WriteIOD8(const unsigned int,const unsigned int);
	unsigned int WriteIOD9(const unsigned int,const unsigned int);
	unsigned int WriteIODA(const unsigned int,const unsigned int);
	unsigned int WriteIODB(const unsigned int,const unsigned int);
	unsigned int WriteIODC(const unsigned int,const unsigned int);
	unsigned int WriteIODD(const unsigned int,const unsigned int);
	unsigned int WriteIODE(const unsigned int,const unsigned int);
	unsigned int WriteIODF(const unsigned int,const unsigned int);
	unsigned int WriteIOE0(const unsigned int,const unsigned int);
	unsigned int WriteIOE1(const unsigned int,const unsigned int);
	unsigned int WriteIOE2(const unsigned int,const unsigned int);
	unsigned int WriteIOE3(const unsigned int,const unsigned int);
	unsigned int WriteIOE4(const unsigned int,const unsigned int);
	unsigned int WriteIOE5(const unsigned int,const unsigned int);
	unsigned int WriteIOE6(const unsigned int,const unsigned int);
	unsigned int WriteIOE7(const unsigned int,const unsigned int);
	unsigned int WriteIOE8(const unsigned int,const unsigned int);
	unsigned int WriteIOE9(const unsigned int,const unsigned int);
	unsigned int WriteIOEA(const unsigned int,const unsigned int);
	unsigned int WriteIOEB(const unsigned int,const unsigned int);
	unsigned int WriteIOEC(const unsigned int,const unsigned int);
	unsigned int WriteIOED(const unsigned int,const unsigned int);
	unsigned int WriteIOEE(const unsigned int,const unsigned int);
	unsigned int WriteIOEF(const unsigned int,const unsigned int);
	unsigned int WriteIOF0(const unsigned int,const unsigned int);
	unsigned int WriteIOF1(const unsigned int,const unsigned int);
	unsigned int WriteIOF2(const unsigned int,const unsigned int);
	unsigned int WriteIOF3(const unsigned int,const unsigned int);
	unsigned int WriteIOF4(const unsigned int,const unsigned int);
	unsigned int WriteIOF5(const unsigned int,const unsigned int);
	unsigned int WriteIOF6(const unsigned int,const unsigned int);
	unsigned int WriteIOF7(const unsigned int,const unsigned int);
	unsigned int WriteIOF8(const unsigned int,const unsigned int);
	unsigned int WriteIOF9(const unsigned int,const unsigned int);
	unsigned int WriteIOFA(const unsigned int,const unsigned int);
	unsigned int WriteIOFB(const unsigned int,const unsigned int);
	unsigned int WriteIOFC(const unsigned int,const unsigned int);
	unsigned int WriteIOFD(const unsigned int,const unsigned int);
	unsigned int WriteIOFE(const unsigned int,const unsigned int);
	unsigned int WriteIOFF(const unsigned int,const unsigned int);

	unsigned int WannaRead();
	unsigned int WannaWrite();
	void SetExceptionNextCycle(unsigned int);
	unsigned int CheckEventStop();
	unsigned int CheckEventException();
	unsigned int CheckEventVia1TimerA();
	unsigned int CheckEventVia1TimerB();
	unsigned int CheckEventVia2TimerA();
	unsigned int CheckEventVia2TimerB();
	unsigned int CheckEventWrap();
	unsigned int CheckEventSync();
	unsigned int CheckEventData();
	unsigned int CheckEventC64BusOut();

	void SortEvents();
	unsigned int SortEvents(unsigned int);
	void SortVia1Events();
	void SortVia2Events();
	unsigned int FixEvents(unsigned int);

	void ConvertBinGcr(UBYTE *src,UBYTE *dst);
        void ConvertGcrBin(UBYTE *src,UBYTE *dst);
	int MakeSectorBin(int track,int sector,UBYTE *dst);
	int MakeSectorGcr(int track,int sector,int id1,int id2
	  ,UBYTE *src,UBYTE *dst);
	void FindNextSync(unsigned int cy);

	friend class CPU1541;

	unsigned int eventcy;

	unsigned int stopcy;
	unsigned int exceptioncy;

	unsigned int via1cy;
	unsigned int via1data;
	unsigned int via2cy;
	unsigned int via2data;

	unsigned int wrapcy;
	unsigned int synccy;
	unsigned int datacy;

	unsigned int (C1541::*eventPtr)();
	unsigned int (C1541::*eventPtrTable[EV_NR_EVENTS])();
	unsigned int cycle;

	CPU1541 *cpu;

	unsigned int* c1541Mem;

	unsigned int irqvia1;
	unsigned int irqvia2;
	unsigned int nmirestore;

	int via1TimerARunning;
	int via1TimerBRunning;
	int via2TimerARunning;
	int via2TimerBRunning;
	ULONG via1TimerAIrqL;
	ULONG via1TimerBIrqL;
	ULONG via2TimerAIrqL;
	ULONG via2TimerBIrqL;
	unsigned int via1TimerALatch;
	unsigned int via1TimerBLatch;
	unsigned int via2TimerALatch;
	unsigned int via2TimerBLatch;
	unsigned int via1TimerACounter;
	unsigned int via1TimerBCounter;
	unsigned int via2TimerACounter;
	unsigned int via2TimerBCounter;

	unsigned int c64busout;
	unsigned int c64busin;
	unsigned int c64businold;

	unsigned int mos6522VIA1[0x20];
	unsigned int mos6522VIA2[0x20];
	int stepMotor;
	int trackIndex;
	UBYTE *tracks[40];
	int tracksLen[40];
	int tracksSector[40];
	int tracksCyclesData[40];
	int track;
	int trackLen;
	int trackCyclesData;
	int syncIndex;
	int syncLength;
	int syncShift;
	int headRW;
	int headEnable;

	int id1;
	int id2;

	int diskChangeCount;
	int diskInserted;
	int diskNeedSave;

        int inactiveTimer;

	unsigned int lastSerialIn;
	ULONG lastSerialInFrame;

	unsigned int c64busoutList[0x1000];
	unsigned int c64busoutListCy[0x1000];
	unsigned int c64busoutListIndex1;
	unsigned int c64busoutListIndex2;

	UBYTE mmuTable[65792];

	static UWORD cyclesC64C1541[CYCLESPAL+0x100];
	static unsigned int convertC64out[0x100];
	static unsigned int convertC64in[0x100];

	static const int convBinGcr[16];
	static const int convGcrBin[32];
    public:
    	ULONG frameCounter;
};

#endif /* C1541_H */

