(********************************************************)
(* pctools.pas    version 0.1  1995-07-25  		*)
(*                                                      *)
(* Accessing C=128 CP/M disk images    			*)
(*                                                      *)
(* Copyright (C) 1995  Jochen Metzinger			*)
(*                                                      *)
(* This file is distributed WITHOUT ANY WARRANTY;	*)
(* without even the implied warranty of MERCHANTABILITY *)
(* or FITNESS FOR A PARTICULAR PURPOSE.        		*)
(********************************************************)

PROGRAM CTOOLS; 

USES Cerrors, Cdevice, Cdirectory, Cfiles;

VAR ComStr: STRING;

FUNCTION UpCaseString(s: STRING): STRING;
 VAR i: BYTE;
BEGIN
 FOR i := 1 TO Length(s) DO
  s[i] := UpCase(s[i]);
 UpCaseString := s;
END; (* UpCaseString *)

BEGIN
 ComStr := UpCaseString(ParamStr(1));
 err_s := ParamStr(1);
 IF Length(ComStr) <> 1 THEN
  FATAL(E_COMMAND);
 IF NOT(ComStr[1] IN ['C','D','E','R','T','W','X']) THEN
  FATAL(E_COMMAND);
 (* Files *)
 IF ParamStr(2) = '' THEN
  FATAL(E_NOFILE);
 dev_open(ParamStr(2));
 dir_load;
 CASE ComStr[1] OF
  'C': (* Checks done *);
  'D': dir_print(ParamStr(3));
  'E': dir_erase(ParamStr(3));
  'R': file_read(ParamStr(3));
  'T': file_type(ParamStr(3));
  'W': file_write(ParamStr(3));
  'X': dir_rename(ParamStr(3), ParamStr(4));
  ELSE FATAL(E_COMMAND);
 END; (* case *)
 dev_close;
END. (* CTOOLS *)
