(********************************************************)
(* cfiles.pas    			    1995-07-25  *)
(*                                                      *)
(* Accessing files for CTOOLS          			*)
(*                                                      *)
(* Copyright (C) 1995  Jochen Metzinger			*)
(*                                                      *)
(* This file is distributed WITHOUT ANY WARRANTY;	*)
(* without even the implied warranty of MERCHANTABILITY *)
(* or FITNESS FOR A PARTICULAR PURPOSE.        		*)
(********************************************************)

UNIT Cfiles;

INTERFACE

USES Cdevice, Cdirectory;

TYPE
 BLOCK = ARRAY [0..REC_SIZE-1] OF BYTE;

PROCEDURE in_open(fn: STRING);
(* open input *)
PROCEDURE in_close;
(* close input *)
FUNCTION  in_eof: BOOLEAN;
(* test end of file *)
PROCEDURE in_read(VAR b: BLOCK);
(* read a CP/M record *)

PROCEDURE out_open(fn: STRING);
(* open output *)
PROCEDURE out_close;
(* close output *)
PROCEDURE out_write(VAR b: BLOCK);
(* write a CP/M record *)
PROCEDURE file_type(fn: STRING);
(* output files *)
PROCEDURE file_read(fn: STRING);
(* CP/M -> DOS *)
PROCEDURE file_write(fn: STRING);
(* DOS -> CP/M *)

IMPLEMENTATION

USES DOS, Cerrors;

VAR
 file_using, reading: BOOLEAN;
 dirpos: BYTE; (* dir. position *)
 secpos: BYTE;  (* position in d[] *)
 sec: SECTOR;  (* buffer *)
 recs: ARRAY [0..REC_SECTOR-1] OF BLOCK ABSOLUTE sec;
 recpos: BYTE;  (* position in sec *)
 recnr: BYTE; (* max. pos. in this dir entry *)

PROCEDURE in_open(fn: STRING);
 VAR i: BYTE; sr: dir_search;
BEGIN
 IF file_using THEN BEGIN
  err_p1 := 1;
  FATAL(E_INTERN);
 END; (* if *)
 error(E_NONE);
 dir_first(fn,sr);
 FOR i := 1 TO 13 DO
  IF sr.pattern[i] = '?' THEN
   FATAL(E_FILEWILD);
 IF NOT sr.found THEN BEGIN
  error(E_NOFILE);
  EXIT;
 END; (* if *)
 file_using := TRUE;
 reading := TRUE;
 dirpos := sr.dirpos;
 secpos := 0;
 recpos := 0;
 recnr  := cpm_dir[dirpos].rc;
END; (* in_open *)

PROCEDURE in_close;
BEGIN
 IF NOT(file_using AND reading) THEN BEGIN
  err_p1 := 2;
  FATAL(E_INTERN);
 END; (* if *)
 file_using := FALSE;
END; (* in_close *)

FUNCTION in_eof: BOOLEAN;
BEGIN
 IF NOT(file_using AND reading) THEN BEGIN
  err_p1 := 3;
  FATAL(E_INTERN);
 END; (* if *)
 in_eof := (recnr = 0);
END; (* in_eof *)

PROCEDURE in_read(VAR b: BLOCK);
BEGIN
 IF NOT(file_using AND reading) THEN BEGIN
  err_p1 := 4;
  FATAL(E_INTERN);
 END; (* if *)
 IF recnr = 0 THEN BEGIN
  err_p1 := 5;
  FATAL(E_INTERN);
 END; (* if *)
 IF recpos = 0 THEN BEGIN
  dev_read(cpm_dir[dirpos].d[secpos], sec);
  err_stop;
 END; (* if *)
 b := recs[recpos];
 Inc(recpos); Dec(recnr);
 IF recpos = REC_SECTOR THEN BEGIN
  recpos := 0; Inc(secpos);
  IF secpos = 16 THEN BEGIN
   secpos := 0; Inc(dirpos);
   recnr := cpm_dir[dirpos].rc;
  END; (* if *)
 END; (* if *)
END; (* in_read *)

PROCEDURE out_open(fn: STRING);
 VAR i: BYTE; sr: dir_search;
BEGIN
 error(E_NONE);
 IF file_using THEN BEGIN
  err_p1 := 6;
  FATAL(E_INTERN);
 END; (* if *)
 dir_first(fn,sr);
 fn := sr.pattern;
 FOR i := 1 TO 13 DO
  IF fn[i] = '?' THEN
   FATAL(E_FILEWILD);
 IF sr.found THEN BEGIN
  error(E_FILE);
  EXIT;
 END; (* if *)
 file_using := TRUE;
 reading := FALSE;
 dirpos := dir_new_entry(fn);
 secpos := 0;
 recpos := 0;
 recnr := 0;
END; (* out_open *)

PROCEDURE out_close;
 VAR i: BYTE;
BEGIN
 IF file_using <= reading THEN BEGIN
  err_p1 := 8;
  FATAL(E_INTERN);
 END; (* if *)
 dev_write(cpm_dir[dirpos].d[secpos], sec);
 err_stop;
 cpm_dir[dirpos].rc := recnr;
 dir_save;
 err_stop;
 file_using := FALSE;
END; (* out_close *)

PROCEDURE out_write(VAR b: BLOCK);
 VAR i: BYTE; place, j: WORD;
BEGIN
 IF file_using <= reading THEN BEGIN
  err_p1 := 7;
  FATAL(E_INTERN);
 END; (* if *)
 IF recpos = 0 THEN BEGIN
  (* alloc sector *)
  place := dir_new_sector;
  err_stop;
  FOR j := 0 TO SECTOR_SIZE-1 DO
   sec[j] := ORD(^Z);
  IF secpos = 16 THEN BEGIN
   (* alloc & install cont. dir entry *)
   cpm_dir[dirpos].rc := $80;
   IF dirpos = DIR_ENTRIES THEN FATAL(E_DIRFULL);
   Inc(dirpos);
   cpm_dir[dirpos] := cpm_dir[dirpos-1];
   WITH cpm_dir[dirpos] DO BEGIN
    Inc(ex);
    rc := 0; recnr := 0;
    FOR i := 0 TO 15 DO d[i] := 0;
   END; (* with *)
   secpos := 0;
  END; (* if *)
  cpm_dir[dirpos].d[secpos] := place;
 END; (* if *)
 recs[recpos] := b;
 Inc(recpos); Inc(recnr);
 IF recpos = REC_SECTOR THEN BEGIN
  place := cpm_dir[dirpos].d[secpos];
  dev_write(place, sec);
  err_stop;
  recpos := 0; Inc(secpos);
 END; (* if *)
END; (* out_write *)

PROCEDURE file_type(fn: STRING);
 LABEL done;
 VAR sr: dir_search;
  bl: BLOCK; i: BYTE;
  with_name: BOOLEAN;
BEGIN
 IF fn = '' THEN BEGIN
  err_p1 := 1;
  FATAL(E_PARAM);
 END; (* if *)
 dir_first(fn,sr);
 err_stop;
 with_name := FALSE;
 FOR i := 1 TO 13 DO
  IF sr.pattern[i] = '?' THEN
   with_name := TRUE;
 REPEAT
  IF with_name THEN BEGIN
   WriteLn;
   WriteLn(sr.name,':');
  END; (* if *)
  in_open(sr.name);
  WHILE NOT in_eof DO BEGIN
   in_read(bl);
   FOR i := 0 TO REC_SIZE-1 DO BEGIN
    IF bl[i] = ORD(^Z) THEN GOTO done;
    Write(CHR(bl[i]));
   END; (* for *)
  END; (* while *)
  done:
  in_close;
  dir_next(sr);
 UNTIL NOT sr.found;
END; (* file_type *)

FUNCTION DosFileExists(name: STRING): BOOLEAN;
 VAR f: FILE;
BEGIN
 {$I-}
 Assign(f,name);
 Reset(f);
 {$I+}
 DosFileExists := (IoResult = 0);
END (* DosFileExists *);

FUNCTION CpmFileExists(fn: STRING): BOOLEAN;
 VAR sr: dir_search;
BEGIN
 dir_first(fn,sr);
 CpmFileExists := is_err OR sr.found;
END; (* CpmFileExists *)

PROCEDURE file_read(fn: STRING);
 VAR sr: dir_search; bl: BLOCK;
  f: FILE OF BLOCK;
BEGIN
 IF fn = '' THEN BEGIN
  err_p1 := 1;
  FATAL(E_PARAM);
 END; (* if *)
 dir_first(fn,sr);
 IF NOT sr.found THEN FATAL(E_NOFILE);
 WHILE sr.found DO BEGIN
  in_open(sr.name);
  WriteLn('READING ',sr.name);
  fn := sr.name;
  WHILE DosFileExists(fn) AND (fn <> '') DO BEGIN
   Write(' File exist, write to: ');
   ReadLn(fn);
  END; (* while *)
  IF fn <> '' THEN BEGIN
   {$I-}
   Assign(f,fn);
   Rewrite(f);
   {$I+}
   IF IOResult <> 0 THEN FATAL(E_OPEN);
   WHILE NOT in_eof DO BEGIN
    in_read(bl);
    err_stop;
    {$I-}
    Write(f,bl);
    {$I+}
    IF IOResult <> 0 THEN FATAL(E_WRITE);
   END; (* while *)
   Close(f);
  END; (* if *)
  in_close;
  dir_next(sr);
 END; (* while *)
END; (* file_read *)

PROCEDURE file_write(fn: STRING);
 VAR sr: SearchRec; bl: BLOCK;
  f: FILE; res: WORD;
BEGIN
 IF fn = '' THEN BEGIN
  err_p1 := 1;
  FATAL(E_PARAM);
 END; (* if *)
 FindFirst(fn, 0, sr);
 IF DosError <> 0 THEN FATAL(E_NOFILE);
 WHILE DosError = 0 DO BEGIN
  fn := sr.Name;
  {$I-}
  Assign(f,fn);
  Reset(f,1);
  {$I+}
  IF IOResult <> 0 THEN FATAL(E_OPEN);
  WriteLn('WRITTING ',sr.Name);
  WHILE CpmFileExists(fn) AND (fn <> '') DO BEGIN
   Write(' File exist, write to: ');
   ReadLn(fn);
  END; (* while *)
  IF fn <> '' THEN BEGIN
   out_open(fn);
   err_stop;
   BlockRead(f,bl,REC_SIZE,res);
   WHILE res > 0 DO BEGIN
    WHILE res < REC_SIZE DO BEGIN
     bl[res] := ORD(^Z);
     Inc(res);
    END; (* while *)
    out_write(bl);
    err_stop;
    BlockRead(f,bl,REC_SIZE,res);
   END; (* while *)
   out_close;
  END; (* if *)
  Close(f);
  FindNext(sr);
 END; (* while *)
END; (* file_write *)

BEGIN
 file_using := FALSE;
 reading := FALSE;
END. (* Cfiles *)